/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.codegen.Expression;
import io.fury.memory.MemoryBuffer;
import io.fury.memory.MemoryUtils;
import io.fury.serializer.Serializer;
import io.fury.serializer.StringUTF16;
import io.fury.type.Type;
import io.fury.type.TypeUtils;
import io.fury.util.MathUtils;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import io.fury.util.unsafe._JDKAccess;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class StringSerializer
extends Serializer<String> {
    private static final long STRING_CODER_FIELD_OFFSET;
    private static final long STRING_VALUE_FIELD_OFFSET;
    private static final boolean STRING_VALUE_FIELD_IS_CHARS;
    private static final boolean STRING_VALUE_FIELD_IS_BYTES;
    private static final long STRING_OFFSET_FIELD_OFFSET;
    private static final long STRING_COUNT_FIELD_OFFSET;
    private static final byte LATIN1 = 0;
    private static final Byte LATIN1_BOXED;
    private static final byte UTF16 = 1;
    private static final Byte UTF16_BOXED;
    private static final byte UTF8 = 2;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final long MULTI_CHARS_NON_LATIN_MASK;
    private final boolean compressString;
    private byte[] byteArray = new byte[1024];
    private int smoothByteArrayLength = 1024;
    private static final MethodHandles.Lookup STRING_LOOK_UP;
    private static final BiFunction<char[], Boolean, String> CHARS_STRING_ZERO_COPY_CTR;
    private static final BiFunction<byte[], Byte, String> BYTES_STRING_ZERO_COPY_CTR;
    private static final Function<byte[], String> LATIN_BYTES_STRING_ZERO_COPY_CTR;

    public StringSerializer(Fury fury) {
        super(fury, String.class, fury.trackingRef() && !fury.isStringRefIgnored());
        this.compressString = fury.compressString();
    }

    @Override
    public short getXtypeId() {
        return Type.STRING.getId();
    }

    @Override
    public void write(MemoryBuffer buffer, String value) {
        this.writeJavaString(buffer, value);
    }

    @Override
    public void xwrite(MemoryBuffer buffer, String value) {
        this.writeUTF8String(buffer, value);
    }

    @Override
    public String read(MemoryBuffer buffer) {
        return this.readJavaString(buffer);
    }

    @Override
    public String xread(MemoryBuffer buffer) {
        return this.readUTF8String(buffer);
    }

    public void writeString(MemoryBuffer buffer, String value) {
        if (this.isJava) {
            this.writeJavaString(buffer, value);
        } else {
            this.writeUTF8String(buffer, value);
        }
    }

    public Expression writeStringExpr(Expression strSerializer, Expression buffer, Expression str) {
        if (this.isJava) {
            if (STRING_VALUE_FIELD_IS_BYTES) {
                return new Expression.StaticInvoke(StringSerializer.class, "writeBytesString", buffer, str);
            }
            if (!STRING_VALUE_FIELD_IS_CHARS) {
                throw new UnsupportedOperationException();
            }
            if (this.compressString) {
                return new Expression.Invoke(strSerializer, "writeCharsStringCompressed", buffer, str);
            }
            return new Expression.Invoke(strSerializer, "writeCharsStringUncompressed", buffer, str);
        }
        return new Expression.Invoke(strSerializer, "writeUTF8String", buffer, str);
    }

    public void writeCharsStringCompressed(MemoryBuffer buffer, String value) {
        char[] chars = (char[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        if (StringSerializer.isLatin(chars)) {
            this.writeCharsLatin(buffer, chars, chars.length);
        } else {
            this.writeCharsUTF16(buffer, chars, chars.length);
        }
    }

    public void writeCharsStringUncompressed(MemoryBuffer buffer, String value) {
        int numBytes = MathUtils.doubleExact(value.length());
        char[] chars = (char[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        buffer.writePrimitiveArrayWithSizeEmbedded(chars, Platform.CHAR_ARRAY_OFFSET, numBytes);
    }

    public String readString(MemoryBuffer buffer) {
        if (this.isJava) {
            return this.readJavaString(buffer);
        }
        return this.readUTF8String(buffer);
    }

    public Expression readStringExpr(Expression strSerializer, Expression buffer) {
        if (this.isJava) {
            if (STRING_VALUE_FIELD_IS_BYTES) {
                return new Expression.Invoke(strSerializer, "readBytesString", TypeUtils.STRING_TYPE, buffer);
            }
            if (!STRING_VALUE_FIELD_IS_CHARS) {
                throw new UnsupportedOperationException();
            }
            if (this.compressString) {
                return new Expression.Invoke(strSerializer, "readCompressedCharsString", TypeUtils.STRING_TYPE, buffer);
            }
            Expression.Invoke chars = new Expression.Invoke(buffer, "readCharsWithSizeEmbedded", TypeUtils.PRIMITIVE_CHAR_ARRAY_TYPE);
            return new Expression.StaticInvoke(StringSerializer.class, "newCharsStringZeroCopy", TypeUtils.STRING_TYPE, chars);
        }
        return new Expression.Invoke(strSerializer, "readUTF8String", TypeUtils.STRING_TYPE, buffer);
    }

    public String readBytesString(MemoryBuffer buffer) {
        byte[] heapMemory = buffer.getHeapMemory();
        if (heapMemory != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer.unsafeHeapReaderIndex();
            byte coder = heapMemory[arrIndex++];
            byte b = heapMemory[arrIndex++];
            int numBytes = b & 0x7F;
            if ((b & 0x80) != 0) {
                b = heapMemory[arrIndex++];
                numBytes |= (b & 0x7F) << 7;
                if ((b & 0x80) != 0) {
                    b = heapMemory[arrIndex++];
                    numBytes |= (b & 0x7F) << 14;
                    if ((b & 0x80) != 0) {
                        b = heapMemory[arrIndex++];
                        numBytes |= (b & 0x7F) << 21;
                        if ((b & 0x80) != 0) {
                            b = heapMemory[arrIndex];
                            numBytes |= (b & 0x7F) << 28;
                        }
                    }
                }
            }
            if (coder == 2) {
                String str = new String(heapMemory, arrIndex, numBytes, StandardCharsets.UTF_8);
                buffer.increaseReaderIndexUnsafe(arrIndex - targetIndex + numBytes);
                return str;
            }
            byte[] bytes = new byte[numBytes];
            System.arraycopy(heapMemory, arrIndex, bytes, 0, numBytes);
            buffer.increaseReaderIndexUnsafe(arrIndex - targetIndex + numBytes);
            return StringSerializer.newBytesStringZeroCopy(coder, bytes);
        }
        byte coder = buffer.readByte();
        int numBytes = buffer.readPositiveVarInt();
        byte[] bytes = buffer.readBytes(numBytes);
        if (coder == 2) {
            return new String(bytes, 0, numBytes, StandardCharsets.UTF_8);
        }
        return StringSerializer.newBytesStringZeroCopy(coder, bytes);
    }

    public String readCompressedCharsString(MemoryBuffer buffer) {
        byte coder = buffer.readByte();
        if (coder == 0) {
            return StringSerializer.newCharsStringZeroCopy(this.readLatinChars(buffer));
        }
        return StringSerializer.newCharsStringZeroCopy(this.readUTF16Chars(buffer, coder));
    }

    private byte[] getByteArray(int numElements) {
        byte[] byteArray = this.byteArray;
        if (byteArray.length < numElements) {
            this.byteArray = byteArray = new byte[numElements];
        }
        if (byteArray.length > 1024) {
            this.smoothByteArrayLength = Math.max((int)((double)this.smoothByteArrayLength * 0.9 + (double)numElements * 0.1), 1024);
            if (this.smoothByteArrayLength <= 1024) {
                this.byteArray = new byte[1024];
            }
        }
        return byteArray;
    }

    public void writeJavaString(MemoryBuffer buffer, String value) {
        if (STRING_VALUE_FIELD_IS_BYTES) {
            StringSerializer.writeBytesString(buffer, value);
        } else {
            if (!STRING_VALUE_FIELD_IS_CHARS) {
                throw new UnsupportedOperationException();
            }
            char[] chars = (char[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
            if (this.compressString) {
                if (StringSerializer.isLatin(chars)) {
                    this.writeCharsLatin(buffer, chars, chars.length);
                } else {
                    this.writeCharsUTF16(buffer, chars, chars.length);
                }
            } else {
                int numBytes = MathUtils.doubleExact(value.length());
                buffer.writePrimitiveArrayWithSizeEmbedded(chars, Platform.CHAR_ARRAY_OFFSET, numBytes);
            }
        }
    }

    public static boolean isLatin(char[] chars) {
        int numChars = chars.length;
        int vectorizedLen = numChars >> 2;
        int vectorizedChars = vectorizedLen << 2;
        int endOffset = Platform.CHAR_ARRAY_OFFSET + (vectorizedChars << 1);
        boolean isLatin = true;
        for (int offset = Platform.CHAR_ARRAY_OFFSET; offset < endOffset; offset += 8) {
            long multiChars = Platform.getLong(chars, offset);
            if ((multiChars & MULTI_CHARS_NON_LATIN_MASK) == 0L) continue;
            isLatin = false;
            break;
        }
        if (isLatin) {
            for (int i = vectorizedChars; i < numChars; ++i) {
                if (chars[i] <= '\u00ff') continue;
                isLatin = false;
                break;
            }
        }
        return isLatin;
    }

    public String readJavaString(MemoryBuffer buffer) {
        if (STRING_VALUE_FIELD_IS_BYTES) {
            return this.readBytesString(buffer);
        }
        if (!STRING_VALUE_FIELD_IS_CHARS) {
            throw new UnsupportedOperationException();
        }
        if (this.compressString) {
            byte coder = buffer.readByte();
            if (coder == 0) {
                return StringSerializer.newCharsStringZeroCopy(this.readLatinChars(buffer));
            }
            if (coder == 1) {
                return StringSerializer.newCharsStringZeroCopy(this.readUTF16Chars(buffer, coder));
            }
            if (coder != 2) {
                throw new UnsupportedOperationException("Unsupported encoding: " + coder);
            }
            return this.readUTF8String(buffer);
        }
        return StringSerializer.newCharsStringZeroCopy(buffer.readCharsWithSizeEmbedded());
    }

    public static void writeBytesString(MemoryBuffer buffer, String value) {
        byte[] bytes = (byte[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        byte coder = Platform.getByte(value, STRING_CODER_FIELD_OFFSET);
        int bytesLen = bytes.length;
        int writerIndex = buffer.writerIndex();
        buffer.ensure(writerIndex + 9 + bytesLen);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer.unsafeHeapWriterIndex();
            targetArray[arrIndex++] = coder;
            arrIndex += MemoryUtils.writePositiveVarInt(targetArray, arrIndex, bytesLen);
            writerIndex += arrIndex - targetIndex;
            System.arraycopy(bytes, 0, targetArray, arrIndex, bytesLen);
            writerIndex += bytesLen;
        } else {
            buffer.unsafePut(writerIndex++, coder);
            writerIndex += buffer.unsafePutPositiveVarInt(writerIndex, bytesLen);
            long offHeapAddress = buffer.getUnsafeAddress();
            Platform.copyMemory(bytes, Platform.BYTE_ARRAY_OFFSET, null, offHeapAddress + (long)writerIndex, bytesLen);
            writerIndex += bytesLen;
        }
        buffer.unsafeWriterIndex(writerIndex);
    }

    public void writeCharsLatin(MemoryBuffer buffer, char[] chars, int strLen) {
        int writerIndex = buffer.writerIndex();
        buffer.ensure(writerIndex + 9 + strLen);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer.unsafeHeapWriterIndex();
            targetArray[arrIndex++] = 0;
            arrIndex += MemoryUtils.writePositiveVarInt(targetArray, arrIndex, strLen);
            writerIndex += arrIndex - targetIndex + strLen;
            for (int i = 0; i < strLen; ++i) {
                targetArray[arrIndex + i] = (byte)chars[i];
            }
            buffer.unsafeWriterIndex(writerIndex);
        } else {
            buffer.unsafePut(writerIndex++, (byte)0);
            writerIndex += buffer.unsafePutPositiveVarInt(writerIndex, strLen);
            byte[] tmpArray = this.getByteArray(strLen);
            for (int i = 0; i < strLen; ++i) {
                tmpArray[i] = (byte)chars[i];
            }
            buffer.put(writerIndex, tmpArray, 0, strLen);
            buffer.unsafeWriterIndex(writerIndex += strLen);
        }
    }

    public void writeCharsUTF16(MemoryBuffer buffer, char[] chars, int strLen) {
        int numBytes = MathUtils.doubleExact(strLen);
        if (Platform.IS_LITTLE_ENDIAN) {
            buffer.writeByte((byte)1);
            buffer.writePrimitiveArrayWithSizeEmbedded(chars, Platform.CHAR_ARRAY_OFFSET, numBytes);
        } else {
            int writerIndex = buffer.writerIndex();
            buffer.ensure(writerIndex + 9 + numBytes);
            byte[] targetArray = buffer.getHeapMemory();
            if (targetArray != null) {
                int i;
                int targetIndex;
                int arrIndex = targetIndex = buffer.unsafeHeapWriterIndex();
                targetArray[arrIndex++] = 1;
                arrIndex += MemoryUtils.writePositiveVarInt(targetArray, arrIndex, strLen);
                int charIndex = 0;
                int end = i + numBytes;
                for (i = arrIndex; i < end; i += 2) {
                    char c = chars[charIndex++];
                    targetArray[i] = (byte)(c >> StringUTF16.HI_BYTE_SHIFT);
                    targetArray[i + 1] = (byte)(c >> StringUTF16.LO_BYTE_SHIFT);
                }
                writerIndex += arrIndex - targetIndex + numBytes;
            } else {
                buffer.unsafePut(writerIndex++, (byte)1);
                writerIndex += buffer.unsafePutPositiveVarInt(writerIndex, numBytes);
                byte[] tmpArray = this.getByteArray(strLen);
                int charIndex = 0;
                for (int i = 0; i < numBytes; i += 2) {
                    char c = chars[charIndex++];
                    tmpArray[i] = (byte)(c >> StringUTF16.HI_BYTE_SHIFT);
                    tmpArray[i + 1] = (byte)(c >> StringUTF16.LO_BYTE_SHIFT);
                }
                buffer.put(writerIndex, tmpArray, 0, numBytes);
                writerIndex += numBytes;
            }
            buffer.unsafeWriterIndex(writerIndex);
        }
    }

    private char[] readLatinChars(MemoryBuffer buffer) {
        int numBytes = buffer.readPositiveVarInt();
        char[] chars = new char[numBytes];
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int srcIndex = buffer.unsafeHeapReaderIndex();
            for (int i = 0; i < numBytes; ++i) {
                chars[i] = (char)(targetArray[srcIndex++] & 0xFF);
            }
            buffer.increaseReaderIndexUnsafe(numBytes);
        } else {
            byte[] byteArray = this.getByteArray(numBytes);
            buffer.readBytes(byteArray, 0, numBytes);
            for (int i = 0; i < numBytes; ++i) {
                chars[i] = (char)(byteArray[i] & 0xFF);
            }
        }
        return chars;
    }

    private char[] readUTF16Chars(MemoryBuffer buffer, byte coder) {
        if (coder != 1) {
            throw new UnsupportedOperationException(String.format("Unsupported coder %s", coder));
        }
        int numBytes = buffer.readPositiveVarInt();
        int strLen = numBytes >> 1;
        char[] chars = new char[strLen];
        if (Platform.IS_LITTLE_ENDIAN) {
            buffer.readChars(chars, Platform.CHAR_ARRAY_OFFSET, numBytes);
        } else {
            byte[] targetArray = buffer.getHeapMemory();
            if (targetArray != null) {
                int i;
                buffer.checkReadableBytes(numBytes);
                int charIndex = 0;
                int end = i + numBytes;
                for (i = buffer.unsafeHeapReaderIndex(); i < end; i += 2) {
                    char c = (char)(targetArray[i] & 255 << StringUTF16.HI_BYTE_SHIFT | (targetArray[i + 1] & 0xFF) << StringUTF16.LO_BYTE_SHIFT);
                    chars[charIndex++] = c;
                }
                buffer.increaseReaderIndexUnsafe(numBytes);
            } else {
                byte[] tmpArray = this.getByteArray(numBytes);
                buffer.readBytes(tmpArray, 0, numBytes);
                int charIndex = 0;
                for (int i = 0; i < numBytes; i += 2) {
                    char c = (char)(tmpArray[i] & 255 << StringUTF16.HI_BYTE_SHIFT | (tmpArray[i + 1] & 0xFF) << StringUTF16.LO_BYTE_SHIFT);
                    chars[charIndex++] = c;
                }
            }
        }
        return chars;
    }

    public static String newCharsStringZeroCopy(char[] data) {
        if (!STRING_VALUE_FIELD_IS_CHARS) {
            throw new IllegalStateException(String.format("String value isn't char[], current java %s isn't supported", Platform.JAVA_VERSION));
        }
        try {
            if (CHARS_STRING_ZERO_COPY_CTR == null) {
                String str = Platform.newInstance(String.class);
                Platform.putObject(str, STRING_VALUE_FIELD_OFFSET, data);
                return str;
            }
            return CHARS_STRING_ZERO_COPY_CTR.apply(data, Boolean.TRUE);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String newBytesStringZeroCopy(byte coder, byte[] data) {
        if (!STRING_VALUE_FIELD_IS_BYTES) {
            throw new IllegalStateException(String.format("String value isn't byte[], current java %s isn't supported", Platform.JAVA_VERSION));
        }
        if (coder == 0) {
            if (LATIN_BYTES_STRING_ZERO_COPY_CTR != null) {
                return LATIN_BYTES_STRING_ZERO_COPY_CTR.apply(data);
            }
            return BYTES_STRING_ZERO_COPY_CTR.apply(data, LATIN1_BOXED);
        }
        if (coder == 1) {
            return BYTES_STRING_ZERO_COPY_CTR.apply(data, UTF16_BOXED);
        }
        return BYTES_STRING_ZERO_COPY_CTR.apply(data, coder);
    }

    private static BiFunction<char[], Boolean, String> getCharsStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_CHARS) {
            return null;
        }
        MethodHandle handle = StringSerializer.getJavaStringZeroCopyCtrHandle();
        if (handle == null) {
            return null;
        }
        try {
            CallSite callSite = LambdaMetafactory.metafactory(STRING_LOOK_UP, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, handle.type());
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static BiFunction<byte[], Byte, String> getBytesStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_BYTES) {
            return null;
        }
        MethodHandle handle = StringSerializer.getJavaStringZeroCopyCtrHandle();
        if (handle == null) {
            return null;
        }
        try {
            MethodType instantiatedMethodType = MethodType.methodType(handle.type().returnType(), new Class[]{byte[].class, Byte.class});
            CallSite callSite = LambdaMetafactory.metafactory(STRING_LOOK_UP, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, instantiatedMethodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Function<byte[], String> getLatinBytesStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_BYTES) {
            return null;
        }
        if (STRING_LOOK_UP == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("java.lang.StringCoding");
            MethodHandles.Lookup caller = STRING_LOOK_UP.in(clazz);
            MethodHandle handle = caller.findStatic(clazz, "newStringLatin1", MethodType.methodType(String.class, byte[].class));
            return _JDKAccess.makeFunction(caller, handle, Function.class);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static MethodHandle getJavaStringZeroCopyCtrHandle() {
        Preconditions.checkArgument((Platform.JAVA_VERSION >= 8 ? 1 : 0) != 0);
        if (STRING_LOOK_UP == null) {
            return null;
        }
        try {
            if (STRING_VALUE_FIELD_IS_CHARS) {
                return STRING_LOOK_UP.findConstructor(String.class, MethodType.methodType(Void.TYPE, char[].class, Boolean.TYPE));
            }
            return STRING_LOOK_UP.findConstructor(String.class, MethodType.methodType(Void.TYPE, byte[].class, Byte.TYPE));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandles.Lookup getLookup() throws Exception {
        MethodHandles.Lookup lookup = ReflectionUtils.unsafeCopy(MethodHandles.lookup());
        long lookupClassOffset = ReflectionUtils.getFieldOffset(MethodHandles.Lookup.class.getDeclaredField("lookupClass"));
        long allowedModesOffset = ReflectionUtils.getFieldOffset(MethodHandles.Lookup.class.getDeclaredField("allowedModes"));
        Platform.putObject(lookup, lookupClassOffset, String.class);
        Platform.putObject(lookup, allowedModesOffset, -1);
        return lookup;
    }

    public void writeUTF8String(MemoryBuffer buffer, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.writePositiveVarInt(bytes.length);
        buffer.writeBytes(bytes);
    }

    public String readUTF8String(MemoryBuffer buffer) {
        int numBytes = buffer.readPositiveVarInt();
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            String str = new String(targetArray, buffer.unsafeHeapReaderIndex(), numBytes, StandardCharsets.UTF_8);
            buffer.increaseReaderIndex(numBytes);
            return str;
        }
        byte[] tmpArray = this.getByteArray(numBytes);
        buffer.readBytes(tmpArray, 0, numBytes);
        return new String(tmpArray, 0, numBytes, StandardCharsets.UTF_8);
    }

    static {
        LATIN1_BOXED = 0;
        UTF16_BOXED = 1;
        Field valueField = ReflectionUtils.getFieldNullable(String.class, "value");
        STRING_VALUE_FIELD_IS_CHARS = valueField != null && valueField.getType() == char[].class;
        STRING_VALUE_FIELD_IS_BYTES = valueField != null && valueField.getType() == byte[].class;
        STRING_VALUE_FIELD_OFFSET = ReflectionUtils.getFieldOffset(String.class, "value");
        STRING_CODER_FIELD_OFFSET = ReflectionUtils.getFieldOffset(String.class, "coder");
        STRING_OFFSET_FIELD_OFFSET = ReflectionUtils.getFieldOffset(String.class, "offset");
        STRING_COUNT_FIELD_OFFSET = ReflectionUtils.getFieldOffset(String.class, "count");
        Preconditions.checkArgument((STRING_OFFSET_FIELD_OFFSET == -1L ? 1 : 0) != 0, (Object)"Current jdk not supported");
        Preconditions.checkArgument((STRING_COUNT_FIELD_OFFSET == -1L ? 1 : 0) != 0, (Object)"Current jdk not supported");
        MULTI_CHARS_NON_LATIN_MASK = Platform.IS_LITTLE_ENDIAN ? -71777214294589696L : 0xFF00FF00FF00FFL;
        STRING_LOOK_UP = _JDKAccess._trustedLookup(String.class);
        CHARS_STRING_ZERO_COPY_CTR = StringSerializer.getCharsStringZeroCopyCtr();
        BYTES_STRING_ZERO_COPY_CTR = StringSerializer.getBytesStringZeroCopyCtr();
        LATIN_BYTES_STRING_ZERO_COPY_CTR = StringSerializer.getLatinBytesStringZeroCopyCtr();
    }
}

