/*
 * Decompiled with CFR 0.152.
 */
package io.fury.codegen;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import io.fury.codegen.ClosureVisitable;
import io.fury.codegen.Code;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.CodegenException;
import io.fury.codegen.ExprState;
import io.fury.codegen.ExpressionUtils;
import io.fury.type.TypeUtils;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import io.fury.util.StringUtils;
import io.fury.util.Utils;
import io.fury.util.function.Functions;
import io.fury.util.function.SerializableBiFunction;
import io.fury.util.function.SerializableFunction;
import io.fury.util.function.SerializableSupplier;
import io.fury.util.function.SerializableTriFunction;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Expression {
    public TypeToken<?> type();

    default public Code.ExprCode genCode(CodegenContext ctx) {
        ExprState exprState = ctx.exprState.get(this);
        if (exprState != null) {
            exprState.incAccessCount();
            return exprState.getExprCode();
        }
        Code.ExprCode genCode = this.doGenCode(ctx);
        ctx.exprState.put(this, new ExprState(new Code.ExprCode(genCode.isNull(), genCode.value())));
        return genCode;
    }

    public Code.ExprCode doGenCode(CodegenContext var1);

    default public boolean nullable() {
        return false;
    }

    public static class Assign
    implements Expression {
        private Expression from;
        private Expression to;

        public Assign(Expression from, Expression to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode fromExprCode = this.from.genCode(ctx);
            Code.ExprCode toExprCode = this.to.genCode(ctx);
            Stream.of(fromExprCode, toExprCode).forEach(exprCode -> {
                if (StringUtils.isNotBlank(exprCode.code())) {
                    codeBuilder.append(exprCode.code()).append('\n');
                }
            });
            String assign = StringUtils.format("${from} = ${to};", "from", fromExprCode.value(), "to", toExprCode.value());
            codeBuilder.append(assign);
            return new Code.ExprCode(codeBuilder.toString(), null, null);
        }

        public String toString() {
            return String.format("%s = %s", this.from, this.to);
        }
    }

    public static class Return
    implements Expression {
        private Expression expression;

        public Return(Expression expression) {
            this.expression = expression;
        }

        @Override
        public TypeToken<?> type() {
            return this.expression.type();
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode targetExprCode = this.expression.genCode(ctx);
            if (StringUtils.isNotBlank(targetExprCode.code())) {
                codeBuilder.append(targetExprCode.code()).append('\n');
            }
            codeBuilder.append("return ").append(targetExprCode.value()).append(';');
            return new Code.ExprCode(codeBuilder.toString(), null, null);
        }

        public String toString() {
            return String.format("return %s", this.expression);
        }
    }

    public static class ListFromIterable
    implements Expression {
        private final TypeToken elementType;
        private Expression inputObject;
        private final TypeToken<?> type;

        public ListFromIterable(Expression inputObject) {
            this.inputObject = inputObject;
            Preconditions.checkArgument((TypeUtils.getRawType(inputObject.type()) == Iterable.class ? 1 : 0) != 0, (Object)("wrong type of inputObject, get " + inputObject.type()));
            this.elementType = TypeUtils.getElementType(inputObject.type());
            this.type = inputObject.type().getSubtype(List.class);
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode targetExprCode = this.inputObject.genCode(ctx);
            if (StringUtils.isNotBlank(targetExprCode.code())) {
                codeBuilder.append(targetExprCode.code()).append("\n");
            }
            String iter = ctx.newName("iter");
            String list = ctx.newName("list");
            String elemValue = ctx.newName("elemValue");
            Class<?> rawType = TypeUtils.getRawType(this.elementType);
            String code = StringUtils.format("java.util.List<${className}> ${list} = new java.util.ArrayList<${className}>();\njava.util.Iterator ${iter} = ${iterable}.iterator();\nwhile (${iter}.hasNext()) {\n   ${className} ${elemValue} = (${className})${iter}.next();\n   ${list}.add(${elemValue});\n}", "className", ctx.type(rawType), "list", list, "iter", iter, "iterable", targetExprCode.value(), "elemValue", elemValue);
            codeBuilder.append(code);
            return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, Code.variable(rawType, list));
        }

        public String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.inputObject);
        }
    }

    public static class ForLoop
    implements Expression {
        public Expression start;
        public Expression end;
        public Expression step;
        @ClosureVisitable
        public final SerializableFunction<Expression, Expression> action;

        public ForLoop(Expression start, Expression end, Expression step, SerializableFunction<Expression, Expression> action) {
            this.start = start;
            this.end = end;
            this.step = step;
            this.action = action;
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            Class<?> maxType = TypeUtils.maxType(TypeUtils.getRawType(this.start.type()), TypeUtils.getRawType(this.end.type()));
            Preconditions.checkArgument((boolean)maxType.isPrimitive());
            StringBuilder codeBuilder = new StringBuilder();
            String i = ctx.newName("i");
            Reference iref = new Reference(i, TypeToken.of(maxType));
            Expression loopAction = (Expression)this.action.apply(iref);
            Code.ExprCode startExprCode = this.start.genCode(ctx);
            Code.ExprCode endExprCode = this.end.genCode(ctx);
            Code.ExprCode stepExprCode = this.step.genCode(ctx);
            Code.ExprCode actionExprCode = loopAction.genCode(ctx);
            Stream.of(startExprCode, endExprCode, stepExprCode).forEach(exprCode -> {
                if (StringUtils.isNotBlank(exprCode.code())) {
                    codeBuilder.append(exprCode.code()).append('\n');
                }
            });
            String forCode = StringUtils.format("for (${type} ${i} = ${start}; ${i} < ${end}; ${i}+=${step}) {\n${actionCode}\n}", "type", maxType.toString(), "i", i, "start", startExprCode.value(), "end", endExprCode.value(), "step", stepExprCode.value(), "actionCode", CodeGenerator.indent(actionExprCode.code()));
            codeBuilder.append(forCode);
            return new Code.ExprCode(codeBuilder.toString(), null, null);
        }
    }

    public static class ZipForEach
    implements Expression {
        private Expression left;
        private Expression right;
        @ClosureVisitable
        private final SerializableTriFunction<Expression, Expression, Expression, Expression> action;

        public ZipForEach(Expression left, Expression right, SerializableTriFunction<Expression, Expression, Expression, Expression> action) {
            this.left = left;
            this.right = right;
            this.action = action;
            Preconditions.checkArgument((left.type().isArray() || TypeToken.of(Collection.class).isSupertypeOf(left.type()) ? 1 : 0) != 0);
            Preconditions.checkArgument((right.type().isArray() || TypeToken.of(Collection.class).isSupertypeOf(right.type()) ? 1 : 0) != 0);
            if (left.type().isArray()) {
                Preconditions.checkArgument((boolean)right.type().isArray(), (Object)"Should both be array or neither be array");
            }
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode leftExprCode = this.left.genCode(ctx);
            Code.ExprCode rightExprCode = this.right.genCode(ctx);
            Stream.of(leftExprCode, rightExprCode).forEach(exprCode -> {
                if (StringUtils.isNotBlank(exprCode.code())) {
                    codeBuilder.append(exprCode.code()).append('\n');
                }
            });
            String i = ctx.newName("i");
            String leftElemValue = ctx.newName("leftElemValue");
            String rightElemValue = ctx.newName("rightElemValue");
            TypeToken leftElemType = this.left.type().isArray() ? this.left.type().getComponentType() : TypeUtils.getElementType(this.left.type());
            leftElemType = ReflectionUtils.getPublicSuperType(leftElemType);
            TypeToken rightElemType = this.right.type().isArray() ? this.right.type().getComponentType() : TypeUtils.getElementType(this.right.type());
            rightElemType = ReflectionUtils.getPublicSuperType(rightElemType);
            Expression elemExpr = (Expression)this.action.apply(new Reference(i), new Reference(leftElemValue, leftElemType, true), new Reference(rightElemValue, rightElemType, false));
            Code.ExprCode elementExprCode = elemExpr.genCode(ctx);
            if (this.left.type().isArray()) {
                String code = StringUtils.format("int ${len} = ${leftArr}.length;\nint ${i} = 0;\nwhile (${i} < ${len}) {\n    ${leftElemType} ${leftElemValue} = ${leftArr}[${i}];\n    ${rightElemType} ${rightElemValue} = ${rightArr}[${i}];\n    ${elementExprCode}\n    ${i}++;\n}", "leftArr", leftExprCode.value(), "len", ctx.newName("len"), "i", i, "leftElemType", ctx.type(leftElemType), "leftElemValue", leftElemValue, "rightElemType", ctx.type(rightElemType), "rightElemValue", rightElemValue, "rightArr", rightExprCode.value(), "elementExprCode", CodeGenerator.alignIndent(elementExprCode.code()));
                codeBuilder.append(code);
                return new Code.ExprCode(codeBuilder.toString(), null, null);
            }
            String code = StringUtils.format("java.util.Iterator ${leftIter} = ${leftInput}.iterator();\njava.util.Iterator ${rightIter} = ${rightInput}.iterator();\nint ${i} = 0;\nwhile (${leftIter}.hasNext() && ${rightIter}.hasNext()) {\n    ${leftElemType} ${leftElemValue} = (${leftElemType})${leftIter}.next();\n    ${rightElemType} ${rightElemValue} = (${rightElemType})${rightIter}.next();\n    ${elementExprCode}\n    ${i}++;\n}", "leftIter", ctx.newName("leftIter"), "leftInput", leftExprCode.value(), "rightIter", ctx.newName("rightIter"), "rightInput", rightExprCode.value(), "i", i, "leftElemType", ctx.type(leftElemType), "leftElemValue", leftElemValue, "rightElemType", ctx.type(rightElemType), "rightElemValue", rightElemValue, "elementExprCode", CodeGenerator.alignIndent(elementExprCode.code()));
            codeBuilder.append(code);
            return new Code.ExprCode(codeBuilder.toString(), null, null);
        }
    }

    public static class ForEach
    implements Expression {
        private Expression inputObject;
        @ClosureVisitable
        private final SerializableBiFunction<Expression, Expression, Expression> action;
        private final TypeToken<?> elementType;

        public ForEach(Expression inputObject, SerializableBiFunction<Expression, Expression, Expression> action) {
            this.inputObject = inputObject;
            this.action = action;
            TypeToken<?> elementType = inputObject.type().isArray() ? inputObject.type().getComponentType() : TypeUtils.getElementType(inputObject.type());
            this.elementType = ReflectionUtils.getPublicSuperType(elementType);
        }

        public ForEach(Expression inputObject, TypeToken<?> beanType, SerializableBiFunction<Expression, Expression, Expression> action) {
            this.inputObject = inputObject;
            this.action = action;
            this.elementType = beanType;
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode targetExprCode = this.inputObject.genCode(ctx);
            if (StringUtils.isNotBlank(targetExprCode.code())) {
                codeBuilder.append(targetExprCode.code()).append("\n");
            }
            String i = ctx.newName("i");
            String elemValue = ctx.newName("elemValue");
            Expression elementExpr = (Expression)this.action.apply(new Reference(i), new Reference(elemValue, this.elementType, false));
            Code.ExprCode elementExprCode = elementExpr.genCode(ctx);
            if (this.inputObject.type().isArray()) {
                String code = StringUtils.format("int ${len} = ${arr}.length;\nint ${i} = 0;\nwhile (${i} < ${len}) {\n    ${elemType} ${elemValue} = ${arr}[${i}];\n    ${elementExprCode}\n    ${i}++;\n}", "arr", targetExprCode.value(), "len", ctx.newName("len"), "i", i, "elemType", ctx.type(this.elementType), "elemValue", elemValue, "i", i, "elementExprCode", CodeGenerator.alignIndent(elementExprCode.code()));
                codeBuilder.append(code);
                return new Code.ExprCode(codeBuilder.toString(), null, null);
            }
            Preconditions.checkArgument((boolean)TypeUtils.ITERABLE_TYPE.isSupertypeOf(this.inputObject.type()), (Object)("Unsupported type " + this.inputObject.type()));
            String elemTypeCast = "";
            if (TypeUtils.getRawType(this.elementType) != Object.class) {
                elemTypeCast = "(" + ctx.type(this.elementType) + ")";
            }
            String code = StringUtils.format("java.util.Iterator ${iter} = ${input}.iterator();\nint ${i} = 0;\nwhile (${iter}.hasNext()) {\n    ${elemType} ${elemValue} = ${elemTypeCast}${iter}.next();\n    ${elementExprCode}\n    ${i}++;\n}", "iter", ctx.newName("iter"), "i", i, "input", targetExprCode.value().code(), "elemType", ctx.type(this.elementType), "elemTypeCast", elemTypeCast, "elemValue", elemValue, "elementExprCode", CodeGenerator.alignIndent(elementExprCode.code()));
            codeBuilder.append(code);
            return new Code.ExprCode(codeBuilder.toString(), null, null);
        }

        public String toString() {
            return String.format("ForEach(%s, %s)", this.inputObject, this.action);
        }
    }

    public static class While
    implements Expression {
        private final BinaryOperator predicate;
        private Expression action;
        private Expression[] cutPoints;

        public While(BinaryOperator predicate, Expression action) {
            this(predicate, action, new Expression[0]);
        }

        public While(BinaryOperator predicate, SerializableSupplier<Expression> action) {
            this(predicate, (Expression)action.get(), Functions.extractCapturedVariables(action, o -> o instanceof Expression).toArray(new Expression[0]));
        }

        public While(BinaryOperator predicate, Expression action, Expression[] cutPoints) {
            this.predicate = predicate;
            this.action = action;
            this.cutPoints = cutPoints;
            Preconditions.checkArgument((boolean)predicate.inline, (Object)predicate);
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            for (Expression cutPoint : this.cutPoints) {
                Code.ExprCode code = cutPoint.genCode(ctx);
                if (!StringUtils.isNotBlank(code.code())) continue;
                CodeGenerator.appendNewlineIfNeeded(codeBuilder);
                codeBuilder.append(code.code()).append("\n");
            }
            Code.ExprCode predicateExprCode = this.predicate.genCode(ctx);
            if (StringUtils.isNotBlank(predicateExprCode.code())) {
                codeBuilder.append(predicateExprCode.code());
                CodeGenerator.appendNewlineIfNeeded(codeBuilder);
            }
            Code.ExprCode actionExprCode = this.action.genCode(ctx);
            String whileCode = StringUtils.format("while (${predicate}) {\n${action}\n}", "predicate", predicateExprCode.value(), "action", CodeGenerator.indent(actionExprCode.code()));
            codeBuilder.append(whileCode);
            return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, null);
        }

        public String toString() {
            return String.format("while(%s) {%s}", this.predicate, this.action);
        }
    }

    public static class LogicalAnd
    extends LogicalOperator {
        public LogicalAnd(Expression left, Expression right) {
            super(true, "&&", left, right);
        }

        public LogicalAnd(boolean inline, Expression left, Expression right) {
            super(inline, "&", left, right);
        }
    }

    public static class LogicalOperator
    extends BinaryOperator {
        public LogicalOperator(String operator, Expression left, Expression right) {
            super(operator, left, right);
        }

        public LogicalOperator(boolean inline, String operator, Expression left, Expression right) {
            super(inline, operator, left, right);
        }
    }

    public static class BitShift
    extends Arithmetic {
        public BitShift(String operator, Expression operand, int numBits) {
            this(true, operator, operand, new Literal(numBits, TypeUtils.PRIMITIVE_INT_TYPE));
        }

        public BitShift(boolean inline, String operator, Expression left, Expression right) {
            super(inline, operator, left, right);
        }
    }

    public static class BitOr
    extends Arithmetic {
        public BitOr(Expression left, Expression right) {
            this(true, left, right);
        }

        public BitOr(boolean inline, Expression left, Expression right) {
            super(inline, "|", left, right);
        }
    }

    public static class BitAnd
    extends Arithmetic {
        public BitAnd(Expression left, Expression right) {
            super(true, "&", left, right);
        }

        public BitAnd(boolean inline, Expression left, Expression right) {
            super(inline, "&", left, right);
        }
    }

    public static class Subtract
    extends Arithmetic {
        public Subtract(Expression left, Expression right) {
            super("-", left, right);
        }

        public Subtract(boolean inline, Expression left, Expression right) {
            super(inline, "-", left, right);
        }
    }

    public static class Add
    extends Arithmetic {
        public Add(Expression left, Expression right) {
            super("+", left, right);
        }

        public Add(boolean inline, Expression left, Expression right) {
            super(inline, "+", left, right);
        }
    }

    public static class Arithmetic
    extends BinaryOperator {
        public Arithmetic(String operator, Expression left, Expression right) {
            super(operator, left, right);
        }

        public Arithmetic(boolean inline, String operator, Expression left, Expression right) {
            super(inline, operator, left, right);
        }
    }

    public static class Comparator
    extends BinaryOperator {
        public Comparator(String operator, Expression left, Expression right, boolean inline) {
            super(inline, operator, left, right, TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
        }
    }

    public static class BinaryOperator
    extends ValueExpression {
        private final boolean inline;
        private final String operator;
        private final TypeToken<?> type;
        private Expression left;
        private Expression right;

        public BinaryOperator(String operator, Expression left, Expression right) {
            this(false, operator, left, right);
        }

        public BinaryOperator(boolean inline, String operator, Expression left, Expression right) {
            this(inline, operator, left, right, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected BinaryOperator(boolean inline, String operator, Expression left, Expression right, TypeToken<?> t) {
            this.inline = inline;
            this.operator = operator;
            this.left = left;
            this.right = right;
            if (t == null) {
                if (TypeUtils.isPrimitive(TypeUtils.getRawType(left.type()))) {
                    Preconditions.checkArgument((boolean)TypeUtils.isPrimitive(TypeUtils.getRawType(right.type())));
                    this.type = TypeUtils.getSizeOfPrimitiveType(left.type()) > TypeUtils.getSizeOfPrimitiveType(right.type()) ? left.type() : right.type();
                    return;
                } else if (left.type().isSupertypeOf(right.type())) {
                    this.type = left.type();
                    return;
                } else {
                    if (!left.type().isSubtypeOf(right.type())) throw new IllegalArgumentException(String.format("Arguments type %s vs %s inconsistent", left.type(), right.type()));
                    this.type = right.type();
                }
                return;
            } else {
                this.type = t;
            }
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            StringBuilder arith = new StringBuilder();
            Expression[] operands = new Expression[]{this.left, this.right};
            for (int i = 0; i < operands.length; ++i) {
                Expression operand = operands[i];
                Code.ExprCode code = operand.genCode(ctx);
                if (StringUtils.isNotBlank(code.code())) {
                    CodeGenerator.appendNewlineIfNeeded(codeBuilder);
                    codeBuilder.append(code.code());
                }
                if (i != operands.length - 1) {
                    arith.append(code.value()).append(' ').append(this.operator).append(' ');
                    continue;
                }
                arith.append(code.value());
            }
            if (this.inline) {
                String value = String.format("(%s)", arith);
                String code = StringUtils.isBlank(codeBuilder) ? null : codeBuilder.toString();
                return new Code.ExprCode(code, Code.LiteralValue.FalseLiteral, Code.variable(TypeUtils.getRawType(this.type), value));
            }
            CodeGenerator.appendNewlineIfNeeded(codeBuilder);
            String value = ctx.newName(this.valuePrefix);
            String valueExpr = StringUtils.format("${type} ${value} = ${arith};", "type", ctx.type(this.type), "value", value, "arith", arith);
            codeBuilder.append(valueExpr);
            return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, Code.variable(TypeUtils.getRawType(this.type), value));
        }

        public String toString() {
            return String.format("%s %s %s", this.left, this.operator, this.right);
        }
    }

    public static class Not
    implements Expression {
        private Expression target;

        public Not(Expression target) {
            this.target = target;
            Preconditions.checkArgument((target.type() == TypeUtils.PRIMITIVE_BOOLEAN_TYPE || target.type() == TypeUtils.BOOLEAN_TYPE ? 1 : 0) != 0);
        }

        @Override
        public TypeToken<?> type() {
            return this.target.type();
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            Code.ExprCode targetExprCode = this.target.genCode(ctx);
            String value = String.format("(!%s)", targetExprCode.value());
            return new Code.ExprCode(targetExprCode.code(), Code.LiteralValue.FalseLiteral, Code.variable(Boolean.TYPE, value));
        }

        @Override
        public boolean nullable() {
            return false;
        }

        public String toString() {
            return String.format("!(%s)", this.target);
        }
    }

    public static class IsNull
    implements Expression {
        private Expression expr;

        public IsNull(Expression expr) {
            this.expr = expr;
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_BOOLEAN_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            Code.ExprCode targetExprCode = this.expr.genCode(ctx);
            Preconditions.checkNotNull((Object)targetExprCode.isNull());
            return new Code.ExprCode(targetExprCode.code(), Code.LiteralValue.FalseLiteral, targetExprCode.isNull());
        }

        @Override
        public boolean nullable() {
            return false;
        }

        public String toString() {
            return String.format("IsNull(%s)", this.expr);
        }
    }

    public static class If
    implements Expression {
        private Expression predicate;
        private Expression trueExpr;
        private Expression falseExpr;
        private TypeToken<?> type;
        private boolean nullable;

        public If(Expression predicate, Expression trueExpr) {
            this.predicate = predicate;
            this.trueExpr = trueExpr;
            this.nullable = false;
            this.type = TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        public If(Expression predicate, Expression trueExpr, Expression falseExpr, boolean nullable, TypeToken<?> type) {
            this.predicate = predicate;
            this.trueExpr = trueExpr;
            this.falseExpr = falseExpr;
            this.nullable = nullable;
            this.type = type;
        }

        public If(Expression predicate, Expression trueExpr, Expression falseExpr, boolean nullable) {
            this(predicate, trueExpr, falseExpr);
            this.nullable = nullable;
        }

        public If(Expression predicate, Expression trueExpr, Expression falseExpr) {
            this.predicate = predicate;
            this.trueExpr = trueExpr;
            this.falseExpr = falseExpr;
            this.type = trueExpr.type() == falseExpr.type() ? (trueExpr.type() != null && !TypeUtils.PRIMITIVE_VOID_TYPE.equals(trueExpr.type()) ? trueExpr.type() : TypeUtils.PRIMITIVE_VOID_TYPE) : (trueExpr.type() != null && falseExpr.type() != null ? (Primitives.isWrapperType(TypeUtils.getRawType(trueExpr.type())) && trueExpr.type().equals((Object)falseExpr.type().wrap()) ? trueExpr.type() : (Primitives.isWrapperType(TypeUtils.getRawType(falseExpr.type())) && falseExpr.type().equals((Object)trueExpr.type().wrap()) ? falseExpr.type() : (trueExpr.type().isSupertypeOf(falseExpr.type()) ? trueExpr.type() : (falseExpr.type().isSupertypeOf(trueExpr.type()) ? falseExpr.type() : (TypeUtils.PRIMITIVE_VOID_TYPE.equals(trueExpr.type()) || TypeUtils.PRIMITIVE_VOID_TYPE.equals(falseExpr.type()) ? TypeUtils.PRIMITIVE_VOID_TYPE : TypeUtils.OBJECT_TYPE))))) : TypeUtils.PRIMITIVE_VOID_TYPE);
            this.nullable = !TypeUtils.PRIMITIVE_VOID_TYPE.equals(this.type) && !this.type.isPrimitive();
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            String ifCode;
            Code.ExprCode condEval = this.predicate.genCode(ctx);
            Code.ExprCode trueEval = this.trueExpr.doGenCode(ctx);
            StringBuilder codeBuilder = new StringBuilder();
            if (StringUtils.isNotBlank(condEval.code())) {
                codeBuilder.append(condEval.code()).append('\n');
            }
            String cond = condEval.isNull() != null && !"false".equals(condEval.isNull().code()) ? StringUtils.format("!${condEvalIsNull} && ${condEvalValue}", "condEvalIsNull", condEval.isNull(), "condEvalValue", condEval.value()) : StringUtils.format("${condEvalValue}", "condEvalValue", condEval.value());
            TypeToken<?> type = this.type;
            if (!TypeUtils.PRIMITIVE_VOID_TYPE.equals((Object)type.unwrap()) && this.trueExpr instanceof Return && this.falseExpr instanceof Return) {
                type = TypeUtils.PRIMITIVE_VOID_TYPE;
            }
            if (!TypeUtils.PRIMITIVE_VOID_TYPE.equals((Object)type.unwrap())) {
                String ifCode2;
                Code.ExprCode falseEval = this.falseExpr.doGenCode(ctx);
                Preconditions.checkArgument((trueEval.isNull() != null || falseEval.isNull() != null ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)trueEval.value());
                Preconditions.checkNotNull((Object)falseEval.value());
                Class<?> rawType = TypeUtils.getRawType(type);
                String[] freshNames = ctx.newNames(rawType, "isNull");
                String value = freshNames[0];
                String isNull = freshNames[1];
                codeBuilder.append(String.format("%s %s;\n", ctx.type(type), value));
                if (this.nullable) {
                    codeBuilder.append(String.format("boolean %s = false;\n", isNull));
                    String trueEvalIsNull = trueEval.isNull() == null ? "false" : trueEval.isNull().code();
                    String falseEvalIsNull = falseEval.isNull() == null ? "false" : falseEval.isNull().code();
                    ifCode2 = StringUtils.format("if (${cond}) {\n    ${trueEvalCode}\n    ${isNull} = ${trueEvalIsNull};\n    ${value} = ${trueEvalValue};\n} else {\n    ${falseEvalCode}\n    ${isNull} = ${falseEvalIsNull};\n    ${value} = ${falseEvalValue};\n}", "isNull", isNull, "value", value, "cond", cond, "trueEvalCode", CodeGenerator.alignIndent(trueEval.code()), "trueEvalIsNull", trueEvalIsNull, "trueEvalValue", trueEval.value(), "falseEvalCode", CodeGenerator.alignIndent(falseEval.code()), "falseEvalIsNull", falseEvalIsNull, "falseEvalValue", falseEval.value());
                } else {
                    ifCode2 = StringUtils.format("if (${cond}) {\n    ${trueEvalCode}\n    ${value} = ${trueEvalValue};\n} else {\n    ${falseEvalCode}\n    ${value} = ${falseEvalValue};\n}", "cond", cond, "value", value, "trueEvalCode", CodeGenerator.alignIndent(trueEval.code()), "trueEvalValue", trueEval.value(), "falseEvalCode", CodeGenerator.alignIndent(falseEval.code()), "falseEvalValue", falseEval.value());
                }
                codeBuilder.append(StringUtils.stripBlankLines(ifCode2));
                return new Code.ExprCode(codeBuilder.toString(), Code.isNullVariable(isNull), Code.variable(rawType, value));
            }
            if (this.falseExpr != null) {
                Code.ExprCode falseEval = this.falseExpr.doGenCode(ctx);
                ifCode = StringUtils.format("if (${cond}) {\n    ${trueEvalCode}\n} else {\n    ${falseEvalCode}\n}", "cond", cond, "trueEvalCode", CodeGenerator.alignIndent(trueEval.code()), "falseEvalCode", CodeGenerator.alignIndent(falseEval.code()));
            } else {
                ifCode = StringUtils.format("if (${cond}) {\n    ${trueEvalCode}\n}", "cond", cond, "trueEvalCode", CodeGenerator.alignIndent(trueEval.code()));
            }
            codeBuilder.append(ifCode);
            return new Code.ExprCode(codeBuilder.toString());
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public String toString() {
            if (this.falseExpr != null) {
                return String.format("if (%s) %s else %s", this.predicate, this.trueExpr, this.falseExpr);
            }
            return String.format("if (%s) %s", this.predicate, this.trueExpr);
        }
    }

    public static class AssignArrayElem
    implements Expression {
        private Expression targetArray;
        private Expression value;
        private Expression[] indexes;

        public AssignArrayElem(Expression targetArray, Expression value, Expression ... indexes) {
            this.targetArray = targetArray;
            this.value = value;
            this.indexes = indexes;
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            int i;
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode targetExprCode = this.targetArray.genCode(ctx);
            Code.ExprCode valueCode = this.value.genCode(ctx);
            Stream.of(targetExprCode, valueCode).forEach(exprCode -> {
                if (StringUtils.isNotBlank(exprCode.code())) {
                    codeBuilder.append(exprCode.code()).append('\n');
                }
            });
            Code.ExprCode[] indexExprCodes = new Code.ExprCode[this.indexes.length];
            for (i = 0; i < this.indexes.length; ++i) {
                Code.ExprCode indexExprCode;
                Expression indexExpr = this.indexes[i];
                indexExprCodes[i] = indexExprCode = indexExpr.genCode(ctx);
                if (!StringUtils.isNotBlank(indexExprCode.code())) continue;
                codeBuilder.append(indexExprCode.code()).append("\n");
            }
            codeBuilder.append(targetExprCode.value());
            for (i = 0; i < this.indexes.length; ++i) {
                codeBuilder.append('[').append(indexExprCodes[i].value()).append(']');
            }
            codeBuilder.append(" = ").append(valueCode.value()).append(";");
            return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, null);
        }
    }

    public static class NewArray
    implements Expression {
        private TypeToken<?> type;
        private Expression[] elements;
        private int numDimensions;
        private Class<?> elemType;
        private Expression dim;
        private Expression dims;

        public NewArray(Class<?> elemType, Expression dim) {
            this.numDimensions = 1;
            this.elemType = elemType;
            this.dim = dim;
            this.type = TypeToken.of(Array.newInstance(elemType, 1).getClass());
        }

        public NewArray(Class<?> elemType, int numDimensions, Expression dims) {
            this.numDimensions = numDimensions;
            this.elemType = elemType;
            this.dims = dims;
            int[] stubSizes = new int[numDimensions];
            for (int i = 0; i < numDimensions; ++i) {
                stubSizes[i] = 1;
            }
            this.type = TypeToken.of(Array.newInstance(elemType, stubSizes).getClass());
        }

        public NewArray(TypeToken<?> type, Expression ... elements) {
            this.type = type;
            this.elements = elements;
            this.numDimensions = 1;
        }

        public static NewArray newArrayWithFirstDim(Class<?> elemType, int numDimensions, Expression firstDim) {
            NewArray array = new NewArray(elemType, firstDim);
            array.numDimensions = numDimensions;
            return array;
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Class<?> rawType = TypeUtils.getRawType(this.type);
            String arrayType = TypeUtils.getArrayType(rawType);
            String value = ctx.newName("arr");
            if (this.dims != null) {
                Code.ExprCode dimsExprCode = this.dims.genCode(ctx);
                if (StringUtils.isNotBlank(dimsExprCode.code())) {
                    codeBuilder.append(dimsExprCode.code()).append('\n');
                }
                codeBuilder.append(arrayType).append(' ').append(value).append(" = new ").append(ctx.type(this.elemType));
                for (int i = 0; i < this.numDimensions; ++i) {
                    String idim = StringUtils.format("${dims}[${i}]", "dims", dimsExprCode.value(), "i", i);
                    codeBuilder.append('[').append(idim).append("]");
                }
                codeBuilder.append(';');
            } else if (this.dim != null) {
                Code.ExprCode dimExprCode = this.dim.genCode(ctx);
                if (StringUtils.isNotBlank(dimExprCode.code())) {
                    codeBuilder.append(dimExprCode.code()).append('\n');
                }
                if (this.numDimensions > 1) {
                    codeBuilder.append(arrayType).append(' ').append(value).append(" = new ").append(ctx.type(this.elemType));
                    codeBuilder.append('[').append(dimExprCode.value()).append(']');
                    for (int i = 1; i < this.numDimensions; ++i) {
                        codeBuilder.append('[').append("]");
                    }
                    codeBuilder.append(';');
                } else {
                    String code = StringUtils.format("${type} ${value} = new ${elemType}[${dim}];", "type", arrayType, "elemType", ctx.type(this.elemType), "value", value, "dim", dimExprCode.value());
                    codeBuilder.append(code);
                }
            } else {
                int len = this.elements.length;
                StringBuilder argsBuilder = new StringBuilder();
                if (len > 0) {
                    for (int i = 0; i < len; ++i) {
                        Expression argExpr = this.elements[i];
                        Code.ExprCode argExprCode = argExpr.genCode(ctx);
                        if (StringUtils.isNotBlank(argExprCode.code())) {
                            codeBuilder.append(argExprCode.code()).append("\n");
                        }
                        if (i != 0) {
                            argsBuilder.append(", ");
                        }
                        argsBuilder.append(argExprCode.value());
                    }
                }
                String code = StringUtils.format("${type} ${value} = new ${type} {${args}};", "type", arrayType, "value", value, "args", argsBuilder.toString());
                codeBuilder.append(code);
            }
            return new Code.ExprCode(codeBuilder.toString(), null, Code.variable(rawType, value));
        }
    }

    public static class NewInstance
    implements Expression {
        private TypeToken<?> type;
        private final Class<?> rawType;
        private String unknownClassName;
        private List<Expression> arguments;
        private Expression outerPointer;
        private final boolean needOuterPointer;

        public NewInstance(TypeToken<?> interfaceType, String unknownClassName, Expression ... arguments) {
            this(interfaceType, Arrays.asList(arguments), null);
            this.unknownClassName = unknownClassName;
            this.check();
        }

        public NewInstance(TypeToken<?> type, Expression ... arguments) {
            this(type, Arrays.asList(arguments), null);
            this.check();
        }

        private NewInstance(TypeToken<?> type, List<Expression> arguments, Expression outerPointer) {
            this.type = type;
            this.rawType = TypeUtils.getRawType(type);
            this.outerPointer = outerPointer;
            this.arguments = arguments;
            boolean bl = this.needOuterPointer = TypeUtils.getRawType(type).isMemberClass() && !Modifier.isStatic(TypeUtils.getRawType(type).getModifiers());
            if (this.needOuterPointer && outerPointer == null) {
                String msg = String.format("outerPointer can't be null when %s is instance inner class", type);
                throw new CodegenException(msg);
            }
        }

        private void check() {
            boolean anyMatchParamCount;
            Preconditions.checkArgument((!this.type.isArray() ? 1 : 0) != 0, (Object)("Please use " + NewArray.class + " to create array."));
            if (this.unknownClassName == null && !this.arguments.isEmpty() && !(anyMatchParamCount = Stream.of(TypeUtils.getRawType(this.type).getConstructors()).anyMatch(c -> c.getParameterCount() == this.arguments.size()))) {
                String msg = String.format("%s doesn't have a public constructor that take %d params", this.type, this.arguments.size());
                throw new IllegalArgumentException(msg);
            }
            Utils.checkArgument(this.rawType.getCanonicalName() != null, "Local/Anonymous type %s isn't supported.", this.type, new Object[0]);
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            int len = this.arguments.size();
            StringBuilder argsBuilder = new StringBuilder();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    Expression argExpr = this.arguments.get(i);
                    Code.ExprCode argExprCode = argExpr.genCode(ctx);
                    if (StringUtils.isNotBlank(argExprCode.code())) {
                        codeBuilder.append(argExprCode.code()).append("\n");
                    }
                    if (i != 0) {
                        argsBuilder.append(", ");
                    }
                    argsBuilder.append(argExprCode.value());
                }
            }
            Class<?> rawType = TypeUtils.getRawType(this.type);
            String type = ctx.type(rawType);
            String clzName = this.unknownClassName;
            if (clzName == null) {
                clzName = type;
            }
            if (this.needOuterPointer) {
                throw new UnsupportedOperationException();
            }
            String value = ctx.newName(rawType);
            if (this.arguments.isEmpty() && !ReflectionUtils.hasPublicNoArgConstructor(rawType)) {
                String instance = ctx.newName("instance");
                String code = ExpressionUtils.callFunc("Object", instance, ctx.type(Platform.class), "newInstance", clzName + ".class", false);
                codeBuilder.append(code).append('\n');
                String cast = StringUtils.format("${clzName} ${value} = (${clzName})${instance};", "clzName", clzName, "value", value, "instance", instance);
                codeBuilder.append(cast);
            } else {
                String code = StringUtils.format("${clzName} ${value} = new ${clzName}(${args});", "clzName", clzName, "value", value, "args", argsBuilder.toString());
                codeBuilder.append(code);
            }
            return new Code.ExprCode(codeBuilder.toString(), null, Code.variable(rawType, value));
        }

        @Override
        public boolean nullable() {
            return false;
        }

        public String toString() {
            return String.format("newInstance(%s)", this.type);
        }
    }

    public static class StaticInvoke
    extends Inlineable {
        private final boolean needTryCatch;
        private final Class<?> staticObject;
        private final String functionName;
        private String returnNamePrefix;
        private final TypeToken<?> type;
        private Expression[] arguments;
        private final boolean returnNullable;

        public StaticInvoke(Class<?> staticObject, String functionName, TypeToken<?> type) {
            this(staticObject, functionName, type, false, new Expression[0]);
        }

        public StaticInvoke(Class<?> staticObject, String functionName, Expression ... arguments) {
            this(staticObject, functionName, TypeUtils.PRIMITIVE_VOID_TYPE, false, arguments);
        }

        public StaticInvoke(Class<?> staticObject, String functionName, TypeToken<?> type, Expression ... arguments) {
            this(staticObject, functionName, "", type, false, arguments);
        }

        public StaticInvoke(Class<?> staticObject, String functionName, TypeToken<?> type, boolean returnNullable, Expression ... arguments) {
            this(staticObject, functionName, "", type, returnNullable, arguments);
        }

        public StaticInvoke(Class<?> staticObject, String functionName, String returnNamePrefix, TypeToken<?> type, boolean returnNullable, Expression ... arguments) {
            this(staticObject, functionName, returnNamePrefix, type, returnNullable, false, arguments);
        }

        public StaticInvoke(Class<?> staticObject, String functionName, String returnNamePrefix, TypeToken<?> type, boolean returnNullable, boolean inline, Expression ... arguments) {
            this.staticObject = staticObject;
            this.functionName = functionName;
            this.type = type;
            this.arguments = arguments;
            this.returnNullable = returnNullable;
            this.returnNamePrefix = returnNamePrefix;
            this.inlineCall = inline;
            this.needTryCatch = ReflectionUtils.hasException(staticObject, functionName);
            if (inline && this.needTryCatch) {
                throw new UnsupportedOperationException(String.format("Method %s in %s has exception signature and can't be inlined", functionName, staticObject));
            }
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            int len = this.arguments.length;
            StringBuilder argsBuilder = new StringBuilder();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    Expression argExpr = this.arguments[i];
                    Code.ExprCode argExprCode = argExpr.genCode(ctx);
                    if (StringUtils.isNotBlank(argExprCode.code())) {
                        codeBuilder.append(argExprCode.code()).append("\n");
                    }
                    if (i != 0) {
                        argsBuilder.append(", ");
                    }
                    argsBuilder.append(argExprCode.value());
                }
            }
            if (!this.inlineCall && StringUtils.isBlank(this.returnNamePrefix)) {
                this.returnNamePrefix = ctx.newName(TypeUtils.getRawType(this.type));
            }
            if (!this.inlineCall && this.type != null && !TypeUtils.PRIMITIVE_VOID_TYPE.equals(this.type)) {
                String callCode;
                Class<?> rawType = TypeUtils.getRawType(this.type);
                String[] freshNames = ctx.newNames(this.returnNamePrefix, "isNull");
                String value = freshNames[0];
                String isNull = freshNames[1];
                if (this.returnNullable) {
                    codeBuilder.append(String.format("boolean %s = false;\n", isNull));
                    callCode = ExpressionUtils.callFunc(ctx.type(this.type), value, ctx.type(this.staticObject), this.functionName, argsBuilder.toString(), this.needTryCatch);
                    codeBuilder.append(callCode).append('\n');
                } else {
                    callCode = ExpressionUtils.callFunc(ctx.type(this.type), value, ctx.type(this.staticObject), this.functionName, argsBuilder.toString(), this.needTryCatch);
                    codeBuilder.append(callCode);
                }
                if (this.returnNullable) {
                    String nullCode = StringUtils.format("if (${value} == null) {\n   ${isNull} = true;\n}", "value", value, "isNull", isNull);
                    codeBuilder.append(nullCode);
                    return new Code.ExprCode(codeBuilder.toString(), Code.isNullVariable(isNull), Code.variable(rawType, value));
                }
                return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, Code.variable(rawType, value));
            }
            if (this.inlineCall) {
                CodeGenerator.stripIfHasLastNewline(codeBuilder);
                String call = ExpressionUtils.callFunc(ctx.type(this.staticObject), this.functionName, argsBuilder.toString(), this.needTryCatch);
                call = call.substring(0, call.length() - 1);
                return new Code.ExprCode(codeBuilder.toString(), null, Code.variable(TypeUtils.getRawType(this.type), call));
            }
            String call = ExpressionUtils.callFunc(ctx.type(this.staticObject), this.functionName, argsBuilder.toString(), this.needTryCatch);
            codeBuilder.append(call);
            return new Code.ExprCode(codeBuilder.toString(), null, null);
        }

        @Override
        public boolean nullable() {
            return this.returnNullable;
        }

        public String toString() {
            return String.format("%s.%s", this.staticObject, this.functionName);
        }
    }

    public static class Invoke
    extends Inlineable {
        public Expression targetObject;
        public final String functionName;
        public final TypeToken<?> type;
        public Expression[] arguments;
        private String returnNamePrefix;
        private final boolean returnNullable;
        private final boolean needTryCatch;

        public Invoke(Expression targetObject, String functionName, Expression ... arguments) {
            this(targetObject, functionName, TypeUtils.PRIMITIVE_VOID_TYPE, false, arguments);
        }

        public Invoke(Expression targetObject, String functionName, TypeToken<?> type) {
            this(targetObject, functionName, type, false, new Expression[0]);
        }

        public Invoke(Expression targetObject, String functionName, String returnNamePrefix, TypeToken<?> type) {
            this(targetObject, functionName, returnNamePrefix, type, false, new Expression[0]);
        }

        public Invoke(Expression targetObject, String functionName, TypeToken<?> type, Expression ... arguments) {
            this(targetObject, functionName, "", type, false, arguments);
        }

        public Invoke(Expression targetObject, String functionName, TypeToken<?> type, boolean returnNullable, Expression ... arguments) {
            this(targetObject, functionName, "", type, returnNullable, arguments);
        }

        public Invoke(Expression targetObject, String functionName, String returnNamePrefix, TypeToken<?> type, boolean returnNullable, Expression ... arguments) {
            this(targetObject, functionName, returnNamePrefix, type, returnNullable, ReflectionUtils.hasException(TypeUtils.getRawType(targetObject.type()), functionName), arguments);
        }

        public Invoke(Expression targetObject, String functionName, String returnNamePrefix, TypeToken<?> type, boolean returnNullable, boolean needTryCatch, Expression ... arguments) {
            this.targetObject = targetObject;
            this.functionName = functionName;
            this.returnNamePrefix = returnNamePrefix;
            this.type = type;
            this.returnNullable = returnNullable;
            this.arguments = arguments;
            this.needTryCatch = needTryCatch;
        }

        public static Invoke inlineInvoke(Expression targetObject, String functionName, TypeToken<?> type, Expression ... arguments) {
            Invoke invoke = new Invoke(targetObject, functionName, type, false, arguments);
            invoke.inlineCall = true;
            return invoke;
        }

        public static Invoke inlineInvoke(Expression targetObject, String functionName, TypeToken<?> type, boolean needTryCatch, Expression ... arguments) {
            Invoke invoke = new Invoke(targetObject, functionName, "", type, false, needTryCatch, arguments);
            invoke.inlineCall = true;
            return invoke;
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode targetExprCode = this.targetObject.genCode(ctx);
            if (StringUtils.isNotBlank(targetExprCode.code())) {
                codeBuilder.append(targetExprCode.code());
                codeBuilder.append("\n");
            }
            int len = this.arguments.length;
            StringBuilder argsBuilder = new StringBuilder();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    Expression argExpr = this.arguments[i];
                    Code.ExprCode argExprCode = argExpr.genCode(ctx);
                    if (StringUtils.isNotBlank(argExprCode.code())) {
                        codeBuilder.append(argExprCode.code()).append("\n");
                    }
                    if (i != 0) {
                        argsBuilder.append(", ");
                    }
                    argsBuilder.append(argExprCode.value());
                }
            }
            if (!this.inlineCall && this.type != null && !TypeUtils.PRIMITIVE_VOID_TYPE.equals(this.type)) {
                String callCode;
                Class<?> rawType = TypeUtils.getRawType(this.type);
                if (StringUtils.isBlank(this.returnNamePrefix)) {
                    this.returnNamePrefix = ctx.namePrefix(TypeUtils.getRawType(this.type));
                }
                String[] freshNames = ctx.newNames(this.returnNamePrefix, this.returnNamePrefix + "IsNull");
                String value = freshNames[0];
                String isNull = freshNames[1];
                if (this.returnNullable) {
                    codeBuilder.append(String.format("boolean %s = false;\n", isNull));
                    callCode = ExpressionUtils.callFunc(ctx.type(this.type), value, targetExprCode.value().code(), this.functionName, argsBuilder.toString(), this.needTryCatch);
                    codeBuilder.append(callCode).append('\n');
                } else {
                    callCode = ExpressionUtils.callFunc(ctx.type(this.type), value, targetExprCode.value().code(), this.functionName, argsBuilder.toString(), this.needTryCatch);
                    codeBuilder.append(callCode);
                }
                if (this.returnNullable) {
                    String nullCode = StringUtils.format("if (${value} == null) {\n    ${isNull} = true;\n}", "value", value, "isNull", isNull);
                    codeBuilder.append(nullCode);
                    return new Code.ExprCode(codeBuilder.toString(), Code.isNullVariable(isNull), Code.variable(rawType, value));
                }
                return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, Code.variable(rawType, value));
            }
            if (this.inlineCall) {
                CodeGenerator.stripIfHasLastNewline(codeBuilder);
                String call = ExpressionUtils.callFunc(targetExprCode.value().code(), this.functionName, argsBuilder.toString(), this.needTryCatch);
                call = call.substring(0, call.length() - 1);
                return new Code.ExprCode(codeBuilder.toString(), null, Code.variable(TypeUtils.getRawType(this.type), call));
            }
            String call = ExpressionUtils.callFunc(targetExprCode.value().code(), this.functionName, argsBuilder.toString(), this.needTryCatch);
            codeBuilder.append(call);
            return new Code.ExprCode(codeBuilder.toString(), null, null);
        }

        @Override
        public boolean nullable() {
            return this.returnNullable;
        }

        public String toString() {
            return String.format("%s.%s", this.targetObject, this.functionName);
        }
    }

    public static class Cast
    extends Inlineable {
        private Expression targetObject;
        private final String castedValueNamePrefix;
        private final TypeToken<?> type;
        private final boolean ignoreUpcast;

        public Cast(Expression targetObject, TypeToken<?> type) {
            this(targetObject, type, "castedValue", true, true);
        }

        public Cast(Expression targetObject, TypeToken<?> type, String castedValueNamePrefix) {
            this(targetObject, type, castedValueNamePrefix, false, true);
        }

        public Cast(Expression targetObject, TypeToken<?> type, String castedValueNamePrefix, boolean inline, boolean ignoreUpcast) {
            this.targetObject = targetObject;
            this.type = type;
            this.castedValueNamePrefix = castedValueNamePrefix;
            this.inlineCall = inline;
            this.ignoreUpcast = ignoreUpcast;
            Utils.checkArgument(!ReflectionUtils.isPrivate(type), "Type %s is private", type, new Object[0]);
            Utils.checkArgument(TypeUtils.getRawType(type).getCanonicalName() != null, "Local/Anonymous type %s isn't supported.", type, new Object[0]);
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            if (this.ignoreUpcast && (this.targetObject.type().equals(this.type) || TypeUtils.getRawType(this.type).isAssignableFrom(TypeUtils.getRawType(this.targetObject.type())))) {
                return this.targetObject.genCode(ctx);
            }
            StringBuilder codeBuilder = new StringBuilder();
            Class<?> rawType = TypeUtils.getRawType(this.type);
            Code.ExprCode targetExprCode = this.targetObject.genCode(ctx);
            if (StringUtils.isNotBlank(targetExprCode.code())) {
                codeBuilder.append(targetExprCode.code());
            }
            String withCast = ctx.type(this.type);
            if (this.type.isPrimitive() && !this.targetObject.type().isPrimitive()) {
                withCast = ctx.type(TypeUtils.boxedType(TypeUtils.getRawType(this.type)));
            }
            if (this.inlineCall) {
                String value = StringUtils.format("((${withCast})${target})", "withCast", withCast, "target", targetExprCode.value());
                return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, Code.variable(rawType, value));
            }
            String castedValue = ctx.newName(this.castedValueNamePrefix);
            if (StringUtils.isNotBlank(targetExprCode.code())) {
                codeBuilder.append("\n");
            }
            String cast = StringUtils.format("${type} ${castedValue} = (${withCast})${target};", "type", ctx.type(this.type), "withCast", withCast, "castedValue", castedValue, "target", targetExprCode.value());
            codeBuilder.append(cast);
            return new Code.ExprCode(codeBuilder.toString(), targetExprCode.isNull(), Code.variable(rawType, castedValue));
        }

        @Override
        public boolean nullable() {
            return this.targetObject.nullable();
        }

        public String toString() {
            return String.format("(%s)%s", this.type, this.targetObject);
        }
    }

    public static class ReplaceStub
    implements Expression {
        private Expression targetObject;

        public ReplaceStub() {
        }

        public ReplaceStub(Expression targetObject) {
            this.targetObject = targetObject;
        }

        @Override
        public TypeToken<?> type() {
            return this.targetObject != null ? this.targetObject.type() : TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            return this.targetObject != null ? this.targetObject.doGenCode(ctx) : new Code.ExprCode("", null, null);
        }

        @Override
        public boolean nullable() {
            return this.targetObject != null && this.targetObject.nullable();
        }

        public void setTargetObject(Expression targetObject) {
            this.targetObject = targetObject;
        }
    }

    public static class SetField
    implements Expression {
        private Expression targetObject;
        private final String fieldName;
        private Expression fieldValue;

        public SetField(Expression targetObject, String fieldName, Expression fieldValue) {
            this.targetObject = targetObject;
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode targetExprCode = this.targetObject.genCode(ctx);
            Code.ExprCode fieldValueExprCode = this.fieldValue.genCode(ctx);
            Stream.of(targetExprCode, fieldValueExprCode).forEach(exprCode -> {
                if (StringUtils.isNotBlank(exprCode.code())) {
                    codeBuilder.append(exprCode.code()).append('\n');
                }
            });
            String assign = StringUtils.format("${target}.${fieldName} = ${fieldValue};", "target", targetExprCode.value(), "fieldName", this.fieldName, "fieldValue", fieldValueExprCode.value());
            codeBuilder.append(assign);
            return new Code.ExprCode(codeBuilder.toString(), null, null);
        }

        public String toString() {
            return String.format("SetField(%s, %s, %s)", this.targetObject, this.fieldName, this.fieldValue);
        }
    }

    public static class FieldValue
    extends Inlineable {
        private Expression targetObject;
        private final String fieldName;
        private final TypeToken<?> type;
        private final boolean fieldNullable;

        public FieldValue(Expression targetObject, String fieldName, TypeToken<?> type) {
            this(targetObject, fieldName, type, !type.isPrimitive(), false);
        }

        public FieldValue(Expression targetObject, String fieldName, TypeToken<?> type, boolean fieldNullable, boolean inline) {
            Preconditions.checkArgument((type != null ? 1 : 0) != 0);
            this.targetObject = targetObject;
            this.fieldName = fieldName;
            this.type = type;
            this.fieldNullable = fieldNullable;
            this.inlineCall = inline;
            if (inline) {
                Preconditions.checkArgument((!fieldNullable ? 1 : 0) != 0);
            }
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            StringBuilder codeBuilder = new StringBuilder();
            Code.ExprCode targetExprCode = this.targetObject.genCode(ctx);
            if (StringUtils.isNotBlank(targetExprCode.code())) {
                codeBuilder.append(targetExprCode.code()).append("\n");
            }
            Class<?> rawType = TypeUtils.getRawType(this.type);
            String[] freshNames = ctx.newNames(this.fieldName, "is" + StringUtils.capitalize(this.fieldName) + "Null");
            String value = freshNames[0];
            String isNull = freshNames[1];
            if (this.inlineCall) {
                String inlinedValue = StringUtils.format("${target}.${fieldName}", "target", targetExprCode.value(), "fieldName", this.fieldName);
                return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, Code.variable(rawType, inlinedValue));
            }
            if (this.fieldNullable) {
                codeBuilder.append(String.format("boolean %s = false;\n", isNull));
                String code = StringUtils.format("${type} ${value} = ${target}.${fieldName};\n", "type", ctx.type(this.type), "value", value, "defaultValue", TypeUtils.defaultValue(rawType), "target", targetExprCode.value(), "fieldName", this.fieldName);
                codeBuilder.append(code);
                String nullCode = StringUtils.format("if (${value} == null) {\n    ${isNull} = true;\n}", "value", value, "isNull", isNull);
                codeBuilder.append(nullCode);
                return new Code.ExprCode(codeBuilder.toString(), Code.isNullVariable(isNull), Code.variable(rawType, value));
            }
            String code = StringUtils.format("${type} ${value} = ${target}.${fieldName};", "type", ctx.type(this.type), "value", value, "target", targetExprCode.value(), "fieldName", this.fieldName);
            codeBuilder.append(code);
            return new Code.ExprCode(codeBuilder.toString(), Code.LiteralValue.FalseLiteral, Code.variable(rawType, value));
        }

        @Override
        public boolean nullable() {
            return this.fieldNullable;
        }

        public String toString() {
            return String.format("(%s).%s", this.targetObject, this.fieldName);
        }
    }

    public static class ForceEvaluate
    implements Expression {
        private Expression expression;

        public ForceEvaluate(Expression expression) {
            this.expression = expression;
        }

        @Override
        public TypeToken<?> type() {
            return this.expression.type();
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            return this.expression.doGenCode(ctx);
        }

        @Override
        public boolean nullable() {
            return this.expression.nullable();
        }

        public String toString() {
            return this.expression.toString();
        }
    }

    public static class Block
    implements Expression {
        private final String code;

        public Block(String code) {
            this.code = code;
        }

        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            return new Code.ExprCode(this.code, null, null);
        }
    }

    public static class Empty
    implements Expression {
        @Override
        public TypeToken<?> type() {
            return TypeUtils.PRIMITIVE_VOID_TYPE;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            return new Code.ExprCode("");
        }
    }

    public static class Reference
    implements Expression {
        private final String name;
        private final TypeToken<?> type;
        private final boolean nullable;
        private final boolean fieldRef;

        public Reference(String name) {
            this(name, TypeUtils.OBJECT_TYPE);
        }

        public Reference(String name, TypeToken<?> type) {
            this(name, type, false);
        }

        public Reference(String name, TypeToken<?> type, boolean nullable) {
            this(name, type, nullable, false);
        }

        public Reference(String name, TypeToken<?> type, boolean nullable, boolean fieldRef) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.fieldRef = fieldRef;
        }

        public static Reference fieldRef(String name, TypeToken<?> type) {
            return new Reference(name, type, false, true);
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            if (this.nullable) {
                String isNull = ctx.newName("isNull");
                String code = StringUtils.format("boolean ${isNull} = ${name} == null;", "isNull", isNull, "name", this.name);
                return new Code.ExprCode(code, Code.isNullVariable(isNull), Code.variable(TypeUtils.getRawType(this.type), this.name));
            }
            return new Code.ExprCode(Code.LiteralValue.FalseLiteral, Code.variable(TypeUtils.getRawType(this.type), this.name));
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        public String name() {
            return this.name;
        }

        public boolean isFieldRef() {
            return this.fieldRef;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Null
    implements Expression {
        private TypeToken<?> type;
        private final boolean typedNull;

        public Null(TypeToken<?> type) {
            this(type, false);
        }

        public Null(TypeToken<?> type, boolean typedNull) {
            this.type = type;
            this.typedNull = typedNull;
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            Class<?> javaType = TypeUtils.getRawType(this.type);
            Code.LiteralValue defaultLiteral = new Code.LiteralValue(javaType, this.typedNull ? String.format("((%s)null)", this.type) : "null");
            return new Code.ExprCode(null, Code.LiteralValue.TrueLiteral, defaultLiteral);
        }

        public String toString() {
            return String.format("(%s)(null)", TypeUtils.getRawType(this.type).getSimpleName());
        }
    }

    public static class Literal
    implements Expression {
        public static final Literal True = new Literal(true, TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
        public static final Literal False = new Literal(false, TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
        private final Object value;
        private final TypeToken<?> type;

        public Literal(String value) {
            this.value = value;
            this.type = TypeUtils.STRING_TYPE;
        }

        public Literal(Object value, TypeToken<?> type) {
            this.value = value;
            this.type = type;
        }

        public static Literal ofByte(short v) {
            return new Literal(v, TypeUtils.PRIMITIVE_BYTE_TYPE);
        }

        public static Literal ofShort(short v) {
            return new Literal(v, TypeUtils.PRIMITIVE_SHORT_TYPE);
        }

        public static Literal ofInt(int v) {
            return new Literal(v, TypeUtils.PRIMITIVE_INT_TYPE);
        }

        public static Literal ofLong(long v) {
            return new Literal(v, TypeUtils.PRIMITIVE_LONG_TYPE);
        }

        public static Literal ofClass(Class<?> v) {
            return new Literal(v, TypeUtils.CLASS_TYPE);
        }

        public static Literal ofString(String v) {
            return new Literal(v, TypeUtils.STRING_TYPE);
        }

        @Override
        public TypeToken<?> type() {
            return this.type;
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            Class<?> javaType = TypeUtils.getRawType(this.type);
            if (TypeUtils.isPrimitive(javaType)) {
                javaType = TypeUtils.boxedType(javaType);
            }
            if (this.value == null) {
                Code.LiteralValue defaultLiteral = new Code.LiteralValue(javaType, TypeUtils.defaultValue(javaType));
                return new Code.ExprCode(null, Code.LiteralValue.TrueLiteral, defaultLiteral);
            }
            if (javaType == String.class) {
                return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue("\"" + this.value + "\""));
            }
            if (javaType == Boolean.class || javaType == Integer.class) {
                return new Code.ExprCode(null, Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, this.value.toString()));
            }
            if (javaType == Float.class) {
                Float f = (Float)this.value;
                if (f.isNaN()) {
                    return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, "Float.NaN"));
                }
                if (f.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                    return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, "Float.POSITIVE_INFINITY"));
                }
                if (f.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                    return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, "Float.NEGATIVE_INFINITY"));
                }
                return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, String.format("%fF", f)));
            }
            if (javaType == Double.class) {
                Double d = (Double)this.value;
                if (d.isNaN()) {
                    return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, "Double.NaN"));
                }
                if (d.equals(Double.POSITIVE_INFINITY)) {
                    return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, "Double.POSITIVE_INFINITY"));
                }
                if (d.equals(Double.NEGATIVE_INFINITY)) {
                    return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, "Double.NEGATIVE_INFINITY"));
                }
                return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, String.format("%fD", d)));
            }
            if (javaType == Byte.class) {
                return new Code.ExprCode(Code.LiteralValue.FalseLiteral, Code.exprValue(javaType, String.format("(%s)%s", "byte", this.value)));
            }
            if (javaType == Short.class) {
                return new Code.ExprCode(Code.LiteralValue.FalseLiteral, Code.exprValue(javaType, String.format("(%s)%s", "short", this.value)));
            }
            if (javaType == Long.class) {
                return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, String.format("%dL", ((Number)this.value).longValue())));
            }
            if (TypeUtils.isPrimitive(javaType)) {
                return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, String.valueOf(this.value)));
            }
            if (javaType == Class.class) {
                Class valueClass = (Class)this.value;
                String v = valueClass.isArray() ? String.format("%s.class", TypeUtils.getArrayType((Class)this.value)) : String.format("%s.class", ReflectionUtils.getCanonicalName((Class)this.value));
                return new Code.ExprCode(Code.LiteralValue.FalseLiteral, new Code.LiteralValue(javaType, v));
            }
            throw new UnsupportedOperationException("Unsupported type " + javaType);
        }

        public String toString() {
            if (this.value == null) {
                return "null";
            }
            return this.value.toString();
        }
    }

    public static class ListExpression
    implements Expression {
        private final List<Expression> expressions;
        private Expression last;

        public ListExpression(Expression ... expressions) {
            this(new ArrayList<Expression>(Arrays.asList(expressions)));
        }

        public ListExpression(List<Expression> expressions) {
            this.expressions = expressions;
            if (!this.expressions.isEmpty()) {
                this.last = this.expressions.get(this.expressions.size() - 1);
            }
        }

        @Override
        public TypeToken<?> type() {
            Preconditions.checkNotNull((Object)this.last);
            return this.last.type();
        }

        @Override
        public Code.ExprCode doGenCode(CodegenContext ctx) {
            if (this.last == null) {
                return new Code.ExprCode(null, null, null);
            }
            StringBuilder codeBuilder = new StringBuilder();
            boolean hasCode = false;
            for (Expression expr : this.expressions) {
                Code.ExprCode code = expr.genCode(ctx);
                if (!StringUtils.isNotBlank(code.code())) continue;
                CodeGenerator.appendNewlineIfNeeded(codeBuilder);
                codeBuilder.append(code.code());
                hasCode = true;
            }
            Code.ExprCode lastExprCode = this.last.genCode(ctx);
            String code = codeBuilder.toString();
            if (!hasCode) {
                code = null;
            }
            return new Code.ExprCode(code, lastExprCode.isNull(), lastExprCode.value());
        }

        @Override
        public boolean nullable() {
            return this.last.nullable();
        }

        public List<Expression> expressions() {
            return this.expressions;
        }

        public ListExpression add(Expression expr) {
            Preconditions.checkNotNull((Object)expr);
            this.expressions.add(expr);
            this.last = expr;
            return this;
        }

        public ListExpression add(Expression expr, Expression ... exprs) {
            this.add(expr);
            return this.addAll(Arrays.asList(exprs));
        }

        public ListExpression addAll(List<Expression> exprs) {
            Preconditions.checkNotNull(exprs);
            this.expressions.addAll(exprs);
            if (!exprs.isEmpty()) {
                this.last = exprs.get(exprs.size() - 1);
            }
            return this;
        }

        public String toString() {
            return this.expressions.stream().map(Object::toString).collect(Collectors.joining(","));
        }
    }

    public static abstract class ValueExpression
    implements Expression {
        public String valuePrefix = "value";

        public String isNullPrefix() {
            return "is" + StringUtils.capitalize(this.valuePrefix) + "Null";
        }
    }

    public static abstract class Inlineable
    implements Expression {
        protected boolean inlineCall = false;

        public Inlineable inline() {
            return this.inline(true);
        }

        public Inlineable inline(boolean inlineCall) {
            this.inlineCall = inlineCall;
            return this;
        }
    }
}

