/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.builder.BaseObjectCodecBuilder;
import io.fury.builder.Generated;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.Expression;
import io.fury.codegen.ExpressionOptimizer;
import io.fury.codegen.ExpressionUtils;
import io.fury.collection.Tuple2;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.FieldResolver;
import io.fury.type.Descriptor;
import io.fury.type.TypeUtils;
import io.fury.util.Platform;
import io.fury.util.function.SerializableSupplier;
import io.fury.util.record.RecordUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CompatibleCodecBuilder
extends BaseObjectCodecBuilder {
    public static final String FIELD_RESOLVER_NAME = "fieldResolver";
    private final FieldResolver fieldResolver;
    private Map<String, Integer> recordReversedMapping;
    private final Expression.Reference fieldResolverRef;
    private final Expression.Literal endTagLiteral;
    private final Map<String, Expression> methodCache;

    public CompatibleCodecBuilder(TypeToken<?> beanType, Fury fury, FieldResolver fieldResolver, Class<?> superSerializerClass) {
        super(beanType, fury, superSerializerClass);
        this.fieldResolver = fieldResolver;
        if (this.isRecord) {
            List fieldNames = fieldResolver.getAllFieldsList().stream().map(FieldResolver.FieldInfo::getName).collect(Collectors.toList());
            this.recordReversedMapping = RecordUtils.buildFieldToComponentMapping(this.beanClass);
        }
        this.ctx.reserveName(FIELD_RESOLVER_NAME);
        this.endTagLiteral = new Expression.Literal(fieldResolver.getEndTag(), TypeUtils.PRIMITIVE_LONG_TYPE);
        TypeToken fieldResolverTypeToken = TypeToken.of(FieldResolver.class);
        this.fieldResolverRef = Expression.Reference.fieldRef(FIELD_RESOLVER_NAME, fieldResolverTypeToken);
        Expression.Invoke fieldResolverExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getFieldResolver", fieldResolverTypeToken, this.getClassExpr(TypeUtils.getRawType(beanType)));
        this.ctx.addField(this.ctx.type(fieldResolverTypeToken), FIELD_RESOLVER_NAME, (Expression)fieldResolverExpr);
        if (this.isRecord) {
            this.buildRecordComponentDefaultValues();
        }
        this.methodCache = new HashMap<String, Expression>();
    }

    @Override
    protected String codecSuffix() {
        return "Compatible";
    }

    @Override
    protected void addCommonImports() {
        super.addCommonImports();
        this.ctx.addImport(Generated.GeneratedCompatibleSerializer.class);
    }

    @Override
    protected boolean isFinal(Class<?> clz) {
        return Modifier.isFinal(clz.getModifiers());
    }

    private Descriptor createDescriptor(FieldResolver.FieldInfo fieldInfo) {
        TypeToken<Map<?, ?>> typeToken;
        Field field = fieldInfo.getField();
        if (fieldInfo instanceof FieldResolver.MapFieldInfo) {
            FieldResolver.MapFieldInfo mapFieldInfo = (FieldResolver.MapFieldInfo)fieldInfo;
            typeToken = TypeUtils.mapOf(mapFieldInfo.getType(), mapFieldInfo.getKeyType(), mapFieldInfo.getValueType());
        } else {
            typeToken = TypeToken.of((Type)field.getGenericType());
        }
        Method readerMethod = null;
        if (this.isRecord) {
            try {
                readerMethod = field.getDeclaringClass().getDeclaredMethod(field.getName(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                Platform.throwException(e);
            }
        }
        return new Descriptor(field, typeToken, readerMethod, null);
    }

    private Expression invokeGenerated(CodegenContext ctx, SerializableSupplier<Expression> expressionsGenerator, String methodPrefix, long fieldId) {
        return this.methodCache.computeIfAbsent(methodPrefix + fieldId, id -> ExpressionOptimizer.invokeGenerated(ctx, expressionsGenerator, methodPrefix));
    }

    @Override
    public Expression buildEncodeExpression() {
        Expression.Reference inputObject = new Expression.Reference("obj", TypeUtils.OBJECT_TYPE, false);
        Expression.Reference buffer = new Expression.Reference("buffer", bufferTypeToken, false);
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression bean = this.tryCastIfPublic((Expression)inputObject, this.beanType, this.ctx.newName(this.beanClass));
        expressions.add(bean);
        CompatibleCodecBuilder.groupFields(this.fieldResolver.getEmbedTypes4Fields(), 9).forEach(group -> {
            Expression invokeGeneratedWrite = ExpressionOptimizer.invokeGenerated(this.ctx, () -> {
                Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
                for (FieldResolver.FieldInfo fieldInfo : group) {
                    groupExpressions.add(new Expression.Invoke((Expression)buffer, "writeInt", new Expression.Literal((int)fieldInfo.getEncodedFieldInfo(), TypeUtils.PRIMITIVE_INT_TYPE)));
                    groupExpressions.add(this.writeEmbedTypeFieldValue(bean, buffer, fieldInfo));
                }
                return groupExpressions;
            }, "writeEmbedTypes4Fields");
            expressions.add(invokeGeneratedWrite);
        });
        CompatibleCodecBuilder.groupFields(this.fieldResolver.getEmbedTypes9Fields(), 9).forEach(group -> {
            Expression invokeGeneratedWrite = ExpressionOptimizer.invokeGenerated(this.ctx, () -> {
                Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
                for (FieldResolver.FieldInfo fieldInfo : group) {
                    groupExpressions.add(new Expression.Invoke((Expression)buffer, "writeLong", new Expression.Literal(fieldInfo.getEncodedFieldInfo(), TypeUtils.PRIMITIVE_LONG_TYPE)));
                    groupExpressions.add(this.writeEmbedTypeFieldValue(bean, buffer, fieldInfo));
                }
                return groupExpressions;
            }, "writeEmbedTypes9Fields");
            expressions.add(invokeGeneratedWrite);
        });
        CompatibleCodecBuilder.groupFields(this.fieldResolver.getEmbedTypesHashFields(), 9).forEach(group -> {
            Expression invokeGeneratedWrite = ExpressionOptimizer.invokeGenerated(this.ctx, () -> {
                Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
                for (FieldResolver.FieldInfo fieldInfo : group) {
                    groupExpressions.add(new Expression.Invoke((Expression)buffer, "writeLong", new Expression.Literal(fieldInfo.getEncodedFieldInfo(), TypeUtils.PRIMITIVE_LONG_TYPE)));
                    groupExpressions.add(this.writeEmbedTypeFieldValue(bean, buffer, fieldInfo));
                }
                return groupExpressions;
            }, "writeEmbedTypesHashFields");
            expressions.add(invokeGeneratedWrite);
        });
        CompatibleCodecBuilder.groupFields(this.fieldResolver.getSeparateTypesHashFields(), 9).forEach(group -> {
            Expression invokeGeneratedWrite = ExpressionOptimizer.invokeGenerated(this.ctx, () -> {
                Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
                for (FieldResolver.FieldInfo fieldInfo : group) {
                    groupExpressions.add(new Expression.Invoke((Expression)buffer, "writeLong", new Expression.Literal(fieldInfo.getEncodedFieldInfo(), TypeUtils.PRIMITIVE_LONG_TYPE)));
                    Descriptor descriptor = this.createDescriptor(fieldInfo);
                    this.walkPath.add(descriptor.getDeclaringClass() + descriptor.getName());
                    byte fieldType = fieldInfo.getFieldType();
                    Expression writeFieldAction = this.invokeGenerated(this.ctx, () -> {
                        Expression fieldValue = this.getFieldValue(bean, descriptor);
                        Expression.ListExpression writeFieldValue = new Expression.ListExpression(new Expression.Invoke((Expression)buffer, "writeByte", new Expression.Literal(fieldType, TypeUtils.PRIMITIVE_BYTE_TYPE)));
                        if (fieldType == 0) {
                            writeFieldValue.add(this.writeForNotNullNonFinalObject(fieldValue, buffer, descriptor.getTypeToken()));
                        } else {
                            FieldResolver.MapFieldInfo mapFieldInfo;
                            if (fieldType == 1) {
                                FieldResolver.CollectionFieldInfo collectionFieldInfo = (FieldResolver.CollectionFieldInfo)fieldInfo;
                                writeFieldValue.add(this.writeFinalClassInfo(buffer, collectionFieldInfo.getElementType()));
                            } else if (fieldType == 4) {
                                mapFieldInfo = (FieldResolver.MapFieldInfo)fieldInfo;
                                Expression keyClassInfo = this.getFinalClassInfo(mapFieldInfo.getKeyType());
                                Expression valueClassInfo = this.getFinalClassInfo(mapFieldInfo.getValueType());
                                writeFieldValue.add(keyClassInfo, valueClassInfo, this.writeFinalClassInfo(buffer, mapFieldInfo.getKeyType()), this.writeFinalClassInfo(buffer, mapFieldInfo.getValueType()));
                            } else if (fieldType == 2) {
                                mapFieldInfo = (FieldResolver.MapFieldInfo)fieldInfo;
                                writeFieldValue.add(this.writeFinalClassInfo(buffer, mapFieldInfo.getKeyType()));
                            } else {
                                Preconditions.checkArgument((fieldType == 3 ? 1 : 0) != 0, (Object)fieldInfo);
                                mapFieldInfo = (FieldResolver.MapFieldInfo)fieldInfo;
                                writeFieldValue.add(this.writeFinalClassInfo(buffer, mapFieldInfo.getValueType()));
                            }
                            Class<?> clz = descriptor.getRawType();
                            if (Modifier.isFinal(clz.getModifiers())) {
                                writeFieldValue.add(this.writeFinalClassInfo(buffer, clz));
                            }
                            writeFieldValue.add(this.serializeForNotNull(fieldValue, buffer, descriptor.getTypeToken()));
                        }
                        return new Expression.If(ExpressionUtils.not(this.writeRefOrNull(buffer, fieldValue)), writeFieldValue);
                    }, "writeField", fieldInfo.getEncodedFieldInfo());
                    this.walkPath.removeLast();
                    groupExpressions.add(writeFieldAction);
                }
                return groupExpressions;
            }, "writeSeparateTypesHashFields");
            expressions.add(invokeGeneratedWrite);
        });
        expressions.add(new Expression.Invoke((Expression)buffer, "writeLong", new Expression.Literal(this.fieldResolver.getEndTag(), TypeUtils.PRIMITIVE_LONG_TYPE)));
        return expressions;
    }

    private Expression writeEmbedTypeFieldValue(Expression bean, Expression buffer, FieldResolver.FieldInfo fieldInfo) {
        Descriptor descriptor = this.createDescriptor(fieldInfo);
        this.walkPath.add(descriptor.getDeclaringClass() + descriptor.getName());
        Expression fieldValue = this.getFieldValue(bean, descriptor);
        this.walkPath.removeLast();
        return this.serializeFor(fieldValue, buffer, descriptor.getTypeToken());
    }

    @Override
    public Expression buildDecodeExpression() {
        if (this.isRecord) {
            return this.buildRecordDecodeExpression();
        }
        Expression.Reference buffer = new Expression.Reference("buffer", bufferTypeToken, false);
        Expression.ListExpression expressionBuilder = new Expression.ListExpression(new Expression[0]);
        Expression bean = this.newBean();
        Expression.Invoke referenceObject = new Expression.Invoke((Expression)this.refResolverRef, "reference", TypeUtils.PRIMITIVE_VOID_TYPE, bean);
        expressionBuilder.add(bean);
        expressionBuilder.add(referenceObject);
        if (!Generated.GeneratedCompatibleSerializer.class.isAssignableFrom(this.parentSerializerClass)) {
            expressionBuilder.add(this.readAndSetFields(buffer, bean));
        } else {
            Expression.Cast target1 = new Expression.Cast(bean, TypeUtils.OBJECT_TYPE, "bean", false, false);
            Expression.Cast target2 = new Expression.Cast(target1, bean.type(), "bean", false, false);
            Expression.ListExpression readAndSetFieldsExpr = this.readAndSetFields(buffer, target2);
            readAndSetFieldsExpr.add(new Expression.Return(target2));
            expressionBuilder.add(ExpressionOptimizer.invokeGenerated(this.ctx, new LinkedHashSet<Expression>(Arrays.asList(buffer, target1)), readAndSetFieldsExpr, "public", "readAndSetFields", false));
        }
        expressionBuilder.add(new Expression.Return(bean));
        return expressionBuilder;
    }

    public Expression buildRecordDecodeExpression() {
        Expression.Reference buffer = new Expression.Reference("buffer", bufferTypeToken, false);
        Expression.StaticInvoke components = new Expression.StaticInvoke(Platform.class, "copyObjectArray", TypeUtils.OBJECT_ARRAY_TYPE, recordComponentDefaultValues);
        Expression.ListExpression readAndSetFieldsExpr = new Expression.ListExpression(new Expression[0]);
        Expression.Invoke partFieldInfo = new Expression.Invoke((Expression)buffer, "readInt", "partFieldInfo", TypeUtils.PRIMITIVE_LONG_TYPE);
        readAndSetFieldsExpr.add(partFieldInfo);
        this.readEmbedTypes4Fields(buffer, readAndSetFieldsExpr, components, partFieldInfo);
        Expression.BitOr newPartFieldInfo = new Expression.BitOr(new Expression.BitShift("<<", (Expression)new Expression.Invoke((Expression)buffer, "readInt", TypeUtils.PRIMITIVE_LONG_TYPE), 32), new Expression.BitAnd(partFieldInfo, new Expression.Literal(0xFFFFFFFFL, TypeUtils.PRIMITIVE_LONG_TYPE)));
        readAndSetFieldsExpr.add(new Expression.Assign(partFieldInfo, newPartFieldInfo));
        this.readEmbedTypes9Fields(buffer, readAndSetFieldsExpr, components, partFieldInfo);
        this.readEmbedTypesHashFields(buffer, readAndSetFieldsExpr, components, partFieldInfo);
        this.readSeparateTypesHashFields(buffer, readAndSetFieldsExpr, components, partFieldInfo);
        readAndSetFieldsExpr.add(new Expression.Return(components));
        Expression readActions = ExpressionOptimizer.invokeGenerated(this.ctx, new LinkedHashSet<Expression>(Arrays.asList(buffer, components)), readAndSetFieldsExpr.add(components), "private", "readFields", false);
        Expression.StaticInvoke record = new Expression.StaticInvoke(RecordUtils.class, "invokeRecordCtrHandle", TypeUtils.OBJECT_TYPE, this.getRecordCtrHandle(), components);
        return new Expression.ListExpression(buffer, components, readActions, new Expression.Return(record));
    }

    @Override
    protected Expression setFieldValue(Expression bean, Descriptor d, Expression value) {
        if (this.isRecord) {
            int index = this.recordReversedMapping.get(d.getName());
            return new Expression.AssignArrayElem(bean, value, Expression.Literal.ofInt(index));
        }
        return super.setFieldValue(bean, d, value);
    }

    private Expression.ListExpression readAndSetFields(Expression.Reference buffer, Expression bean) {
        Expression.ListExpression readAndSetFieldsExpr = new Expression.ListExpression(new Expression[0]);
        Expression.Invoke partFieldInfo = new Expression.Invoke((Expression)buffer, "readInt", "partFieldInfo", TypeUtils.PRIMITIVE_LONG_TYPE);
        readAndSetFieldsExpr.add(partFieldInfo);
        this.readEmbedTypes4Fields(buffer, readAndSetFieldsExpr, bean, partFieldInfo);
        Expression.BitOr newPartFieldInfo = new Expression.BitOr(new Expression.BitShift("<<", (Expression)new Expression.Invoke((Expression)buffer, "readInt", TypeUtils.PRIMITIVE_LONG_TYPE), 32), new Expression.BitAnd(partFieldInfo, new Expression.Literal(0xFFFFFFFFL, TypeUtils.PRIMITIVE_LONG_TYPE)));
        readAndSetFieldsExpr.add(new Expression.Assign(partFieldInfo, newPartFieldInfo));
        this.readEmbedTypes9Fields(buffer, readAndSetFieldsExpr, bean, partFieldInfo);
        this.readEmbedTypesHashFields(buffer, readAndSetFieldsExpr, bean, partFieldInfo);
        this.readSeparateTypesHashFields(buffer, readAndSetFieldsExpr, bean, partFieldInfo);
        return readAndSetFieldsExpr;
    }

    private void readEmbedTypes4Fields(Expression.Reference buffer, Expression.ListExpression expressionBuilder, Expression bean, Expression partFieldInfo) {
        FieldResolver.FieldInfo[] embedTypes4Fields = this.fieldResolver.getEmbedTypes4Fields();
        if (embedTypes4Fields.length > 0) {
            long minFieldInfo = embedTypes4Fields[0].getEncodedFieldInfo();
            expressionBuilder.add(this.skipDataBy4Until(bean, buffer, partFieldInfo, minFieldInfo, false));
            CompatibleCodecBuilder.groupFields(embedTypes4Fields, 3).forEach(group -> {
                Expression invokeGeneratedRead = ExpressionOptimizer.invokeGenerated(this.ctx, () -> {
                    Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
                    for (FieldResolver.FieldInfo fieldInfo : group) {
                        long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                        Descriptor descriptor = this.createDescriptor(fieldInfo);
                        this.walkPath.add(descriptor.getDeclaringClass() + descriptor.getName());
                        Expression readField = this.readEmbedTypes4(bean, buffer, descriptor, partFieldInfo);
                        Expression.ListExpression tryReadField = new Expression.ListExpression(this.skipDataBy4Until(bean, buffer, partFieldInfo, encodedFieldInfo, true), new Expression.If(ExpressionUtils.eq(partFieldInfo, new Expression.Literal(encodedFieldInfo, TypeUtils.PRIMITIVE_LONG_TYPE)), this.readEmbedTypes4(bean, buffer, descriptor, partFieldInfo)));
                        groupExpressions.add(new Expression.If(ExpressionUtils.eq(partFieldInfo, new Expression.Literal(encodedFieldInfo, TypeUtils.PRIMITIVE_LONG_TYPE)), readField, tryReadField, false, TypeUtils.PRIMITIVE_VOID_TYPE));
                        this.walkPath.removeLast();
                    }
                    groupExpressions.add(new Expression.Return(partFieldInfo));
                    return groupExpressions;
                }, "readEmbedTypes4Fields", true);
                expressionBuilder.add(new Expression.Assign(partFieldInfo, invokeGeneratedRead), new Expression.If(ExpressionUtils.eq(partFieldInfo, this.endTagLiteral), new Expression.Return(bean)));
            });
        }
        expressionBuilder.add(this.skipField4End(bean, buffer, partFieldInfo));
    }

    private Expression readEmbedTypes4(Expression bean, Expression buffer, Descriptor descriptor, Expression partFieldInfo) {
        Expression deserializeAction = this.deserializeFor(buffer, descriptor.getTypeToken(), expr -> this.setFieldValue(bean, descriptor, this.tryInlineCast((Expression)expr, descriptor.getTypeToken())));
        return new Expression.ListExpression(deserializeAction, new Expression.Assign(partFieldInfo, Expression.Invoke.inlineInvoke(buffer, "readInt", TypeUtils.PRIMITIVE_LONG_TYPE, new Expression[0])));
    }

    private Expression skipDataBy4Until(Expression bean, Expression buffer, Expression partFieldInfo, long targetFieldInfo, boolean returnEndTag) {
        Expression.Literal targetFieldInfoExpr = new Expression.Literal(targetFieldInfo, TypeUtils.PRIMITIVE_LONG_TYPE);
        Expression.LogicalAnd predicate = new Expression.LogicalAnd(this.isEmbedType(partFieldInfo, 3, (byte)1), ExpressionUtils.lessThan(partFieldInfo, targetFieldInfoExpr));
        return new Expression.While((Expression.BinaryOperator)predicate, () -> new Expression.ListExpression(new Expression.If(ExpressionUtils.eq(Expression.Invoke.inlineInvoke((Expression)this.fieldResolverRef, "skipDataBy4", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, ExpressionUtils.cast(partFieldInfo, TypeUtils.PRIMITIVE_INT_TYPE)), this.endTagLiteral), returnEndTag ? new Expression.Return(this.endTagLiteral) : new Expression.Return(bean)), new Expression.Assign(partFieldInfo, Expression.Invoke.inlineInvoke(buffer, "readInt", TypeUtils.PRIMITIVE_LONG_TYPE, new Expression[0]))));
    }

    private Expression skipField4End(Expression bean, Expression buffer, Expression partFieldInfo) {
        return new Expression.While((Expression.BinaryOperator)this.isEmbedType(partFieldInfo, 3, (byte)1), () -> new Expression.ListExpression(new Expression.If(ExpressionUtils.eq(Expression.Invoke.inlineInvoke((Expression)this.fieldResolverRef, "skipDataBy4", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, ExpressionUtils.cast(partFieldInfo, TypeUtils.PRIMITIVE_INT_TYPE)), this.endTagLiteral), new Expression.Return(bean)), new Expression.Assign(partFieldInfo, Expression.Invoke.inlineInvoke(buffer, "readInt", TypeUtils.PRIMITIVE_LONG_TYPE, new Expression[0]))));
    }

    private void readEmbedTypes9Fields(Expression buffer, Expression.ListExpression expressions, Expression bean, Expression partFieldInfo) {
        FieldResolver.FieldInfo[] embedTypes9Fields = this.fieldResolver.getEmbedTypes9Fields();
        if (embedTypes9Fields.length > 0) {
            long minFieldInfo = embedTypes9Fields[0].getEncodedFieldInfo();
            expressions.add(this.skipDataBy8Until(bean, buffer, partFieldInfo, minFieldInfo, 7, (byte)3, false));
            CompatibleCodecBuilder.groupFields(embedTypes9Fields, 3).forEach(group -> {
                Expression invokeGeneratedRead = ExpressionOptimizer.invokeGenerated(this.ctx, () -> {
                    Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
                    for (FieldResolver.FieldInfo fieldInfo : group) {
                        groupExpressions.add(this.processEmbedTypes8Field(buffer, bean, partFieldInfo, fieldInfo.getEncodedFieldInfo(), (byte)3, fieldInfo));
                    }
                    groupExpressions.add(new Expression.Return(partFieldInfo));
                    return groupExpressions;
                }, "readEmbedTypes9Fields", true);
                expressions.add(new Expression.Assign(partFieldInfo, invokeGeneratedRead), new Expression.If(ExpressionUtils.eq(partFieldInfo, this.endTagLiteral), new Expression.Return(bean)));
            });
        }
        expressions.add(this.skipField8End(bean, buffer, partFieldInfo, 7, (byte)3));
    }

    private void readEmbedTypesHashFields(Expression buffer, Expression.ListExpression expressions, Expression bean, Expression partFieldInfo) {
        FieldResolver.FieldInfo[] embedTypesHashFields = this.fieldResolver.getEmbedTypesHashFields();
        if (embedTypesHashFields.length > 0) {
            long minFieldInfo = embedTypesHashFields[0].getEncodedFieldInfo();
            expressions.add(this.skipDataBy8Until(bean, buffer, partFieldInfo, minFieldInfo, 7, (byte)7, false));
            CompatibleCodecBuilder.groupFields(embedTypesHashFields, 3).forEach(group -> {
                Expression invokeGeneratedRead = ExpressionOptimizer.invokeGenerated(this.ctx, () -> {
                    Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
                    for (FieldResolver.FieldInfo fieldInfo : group) {
                        groupExpressions.add(this.processEmbedTypes8Field(buffer, bean, partFieldInfo, fieldInfo.getEncodedFieldInfo(), (byte)7, fieldInfo));
                    }
                    groupExpressions.add(new Expression.Return(partFieldInfo));
                    return groupExpressions;
                }, "readEmbedTypesHashFields", true);
                expressions.add(new Expression.Assign(partFieldInfo, invokeGeneratedRead), new Expression.If(ExpressionUtils.eq(partFieldInfo, this.endTagLiteral), new Expression.Return(bean)));
            });
        }
        expressions.add(this.skipField8End(bean, buffer, partFieldInfo, 7, (byte)7));
    }

    private Expression processEmbedTypes8Field(Expression buffer, Expression bean, Expression partFieldInfo, long targetFieldInfo, byte flagValue, FieldResolver.FieldInfo fieldInfo) {
        long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
        Descriptor descriptor = this.createDescriptor(fieldInfo);
        this.walkPath.add(descriptor.getDeclaringClass() + descriptor.getName());
        Expression readField = this.readEmbedTypes8Field(bean, buffer, descriptor, partFieldInfo);
        Expression.ListExpression tryReadField = new Expression.ListExpression(this.skipDataBy8Until(bean, buffer, partFieldInfo, targetFieldInfo, 7, flagValue, true), new Expression.If(ExpressionUtils.eq(partFieldInfo, new Expression.Literal(encodedFieldInfo, TypeUtils.PRIMITIVE_LONG_TYPE)), this.readEmbedTypes8Field(bean, buffer, descriptor, partFieldInfo)));
        this.walkPath.removeLast();
        return new Expression.If(ExpressionUtils.eq(partFieldInfo, new Expression.Literal(encodedFieldInfo, TypeUtils.PRIMITIVE_LONG_TYPE)), readField, tryReadField);
    }

    private Expression readEmbedTypes8Field(Expression bean, Expression buffer, Descriptor descriptor, Expression partFieldInfo) {
        Expression deserializeAction = this.deserializeFor(buffer, descriptor.getTypeToken(), expr -> this.setFieldValue(bean, descriptor, this.tryInlineCast((Expression)expr, descriptor.getTypeToken())));
        return new Expression.ListExpression(deserializeAction, new Expression.Assign(partFieldInfo, Expression.Invoke.inlineInvoke(buffer, "readLong", TypeUtils.PRIMITIVE_LONG_TYPE, new Expression[0])));
    }

    private void readSeparateTypesHashFields(Expression buffer, Expression.ListExpression expressionBuilder, Expression bean, Expression partFieldInfo) {
        FieldResolver.FieldInfo[] separateTypesHashFields = this.fieldResolver.getSeparateTypesHashFields();
        if (separateTypesHashFields.length > 0) {
            long minFieldInfo = separateTypesHashFields[0].getEncodedFieldInfo();
            expressionBuilder.add(this.skipDataBy8Until(bean, buffer, partFieldInfo, minFieldInfo, 3, (byte)0, false));
            CompatibleCodecBuilder.groupFields(separateTypesHashFields, 3).forEach(group -> {
                Expression invokeGeneratedRead = ExpressionOptimizer.invokeGenerated(this.ctx, () -> {
                    Expression.ListExpression groupExpressions = new Expression.ListExpression(new Expression[0]);
                    for (FieldResolver.FieldInfo fieldInfo : group) {
                        long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                        Descriptor descriptor = this.createDescriptor(fieldInfo);
                        this.walkPath.add(descriptor.getDeclaringClass() + descriptor.getName());
                        Expression readField = this.readObjectField(fieldInfo, bean, buffer, descriptor, partFieldInfo);
                        Expression.ListExpression tryReadField = new Expression.ListExpression(this.skipDataBy8Until(bean, buffer, partFieldInfo, encodedFieldInfo, 3, (byte)0, true), new Expression.If(ExpressionUtils.eq(partFieldInfo, new Expression.Literal(encodedFieldInfo, TypeUtils.PRIMITIVE_LONG_TYPE)), this.readObjectField(fieldInfo, bean, buffer, descriptor, partFieldInfo)));
                        this.walkPath.removeLast();
                        groupExpressions.add(new Expression.If(ExpressionUtils.eq(partFieldInfo, new Expression.Literal(encodedFieldInfo, TypeUtils.PRIMITIVE_LONG_TYPE)), readField, tryReadField));
                    }
                    groupExpressions.add(new Expression.Return(partFieldInfo));
                    return groupExpressions;
                }, "readSeparateTypesHashFields", true);
                expressionBuilder.add(new Expression.Assign(partFieldInfo, invokeGeneratedRead), new Expression.If(ExpressionUtils.eq(partFieldInfo, this.endTagLiteral), new Expression.Return(bean)));
            });
        }
        expressionBuilder.add(new Expression.Invoke((Expression)this.fieldResolverRef, "skipEndFields", buffer, partFieldInfo));
    }

    private Expression readObjectField(FieldResolver.FieldInfo fieldInfo, Expression bean, Expression buffer, Descriptor descriptor, Expression partFieldInfo) {
        Expression readAction = this.invokeGenerated(this.ctx, () -> {
            TypeToken<?> typeToken = descriptor.getTypeToken();
            Expression refId = this.tryPreserveRefId(buffer);
            Expression.Comparator needDeserialize = ExpressionUtils.egt(refId, new Expression.Literal((byte)-1, TypeUtils.PRIMITIVE_BYTE_TYPE));
            byte type = fieldInfo.getFieldType();
            Expression.Literal expectType = new Expression.Literal(type, TypeUtils.PRIMITIVE_BYTE_TYPE);
            Expression.ListExpression deserializedValue = new Expression.ListExpression(new Expression.Invoke((Expression)this.fieldResolverRef, "checkFieldType", Expression.Invoke.inlineInvoke(buffer, "readByte", TypeUtils.PRIMITIVE_BYTE_TYPE, new Expression[0]), expectType));
            if (type == 0) {
                deserializedValue.add(this.readForNotNullNonFinal(buffer, typeToken, null));
            } else {
                if (type == 1) {
                    deserializedValue.add(this.skipFinalClassInfo(((FieldResolver.CollectionFieldInfo)fieldInfo).getElementType(), buffer));
                } else if (type == 4) {
                    deserializedValue.add(this.skipFinalClassInfo(((FieldResolver.MapFieldInfo)fieldInfo).getKeyType(), buffer));
                    deserializedValue.add(this.skipFinalClassInfo(((FieldResolver.MapFieldInfo)fieldInfo).getValueType(), buffer));
                } else if (type == 2) {
                    deserializedValue.add(this.skipFinalClassInfo(((FieldResolver.MapFieldInfo)fieldInfo).getKeyType(), buffer));
                } else {
                    Preconditions.checkArgument((type == 3 ? 1 : 0) != 0, (Object)fieldInfo);
                    deserializedValue.add(this.skipFinalClassInfo(((FieldResolver.MapFieldInfo)fieldInfo).getValueType(), buffer));
                }
                Class<?> clz = TypeUtils.getRawType(typeToken);
                if (Modifier.isFinal(clz.getModifiers())) {
                    deserializedValue.add(this.skipFinalClassInfo(clz, buffer));
                }
                deserializedValue.add(this.deserializeForNotNull(buffer, typeToken, null));
            }
            Expression.Invoke setReadObject = new Expression.Invoke((Expression)this.refResolverRef, "setReadObject", refId, deserializedValue);
            return new Expression.If(needDeserialize, new Expression.ListExpression(refId, deserializedValue, setReadObject, this.setFieldValue(bean, descriptor, this.tryInlineCast(deserializedValue, typeToken))), this.setFieldValue(bean, descriptor, this.tryInlineCast(new Expression.Invoke((Expression)this.refResolverRef, "getReadObject", TypeUtils.OBJECT_TYPE, false, new Expression[0]), typeToken)), false, TypeUtils.PRIMITIVE_VOID_TYPE);
        }, "readField", fieldInfo.getEncodedFieldInfo());
        return new Expression.ListExpression(new Expression.ForceEvaluate(readAction), new Expression.Assign(partFieldInfo, Expression.Invoke.inlineInvoke(buffer, "readLong", TypeUtils.PRIMITIVE_LONG_TYPE, new Expression[0])));
    }

    protected Expression getFinalClassInfo(Class<?> cls) {
        Preconditions.checkArgument((boolean)Modifier.isFinal(cls.getModifiers()));
        Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(cls);
        Preconditions.checkArgument(((Boolean)classInfoRef.f1 == false ? 1 : 0) != 0);
        return (Expression)classInfoRef.f0;
    }

    protected Expression writeFinalClassInfo(Expression buffer, Class<?> cls) {
        Preconditions.checkArgument((boolean)Modifier.isFinal(cls.getModifiers()));
        ClassInfo classInfo = this.visitFury(f -> f.getClassResolver().getClassInfo(cls, false));
        if (classInfo != null && classInfo.getClassId() != 0) {
            return this.fury.getClassResolver().writeClassExpr(buffer, classInfo.getClassId());
        }
        Expression classInfoExpr = this.getFinalClassInfo(cls);
        return new Expression.Invoke((Expression)this.classResolverRef, "writeClass", buffer, classInfoExpr);
    }

    protected Expression skipFinalClassInfo(Class<?> cls, Expression buffer) {
        Preconditions.checkArgument((boolean)Modifier.isFinal(cls.getModifiers()));
        ClassInfo classInfo = this.visitFury(f -> f.getClassResolver().getClassInfo(cls, false));
        if (classInfo != null && classInfo.getClassId() != 0) {
            return this.fury.getClassResolver().skipRegisteredClassExpr(buffer);
        }
        return this.readClassInfo(cls, buffer, false);
    }

    private Expression skipDataBy8Until(Expression bean, Expression buffer, Expression partFieldInfo, long targetFieldInfo, int flagBits, byte flagValue, boolean returnEndTag) {
        Expression.Literal targetFieldInfoExpr = new Expression.Literal(targetFieldInfo, TypeUtils.PRIMITIVE_LONG_TYPE);
        Expression.LogicalAnd predicate = new Expression.LogicalAnd(this.isEmbedType(partFieldInfo, flagBits, flagValue), ExpressionUtils.lessThan(partFieldInfo, targetFieldInfoExpr));
        return new Expression.While((Expression.BinaryOperator)predicate, () -> new Expression.ListExpression(new Expression.If(ExpressionUtils.eq(Expression.Invoke.inlineInvoke((Expression)this.fieldResolverRef, "skipDataBy8", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, partFieldInfo), this.endTagLiteral), returnEndTag ? new Expression.Return(this.endTagLiteral) : new Expression.Return(bean)), new Expression.Assign(partFieldInfo, Expression.Invoke.inlineInvoke(buffer, "readLong", TypeUtils.PRIMITIVE_LONG_TYPE, new Expression[0]))));
    }

    private Expression skipField8End(Expression bean, Expression buffer, Expression partFieldInfo, int flagBits, byte flagValue) {
        return new Expression.While((Expression.BinaryOperator)this.isEmbedType(partFieldInfo, flagBits, flagValue), () -> new Expression.ListExpression(new Expression.If(ExpressionUtils.eq(Expression.Invoke.inlineInvoke((Expression)this.fieldResolverRef, "skipDataBy8", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, partFieldInfo), this.endTagLiteral), new Expression.Return(bean)), new Expression.Assign(partFieldInfo, Expression.Invoke.inlineInvoke(buffer, "readLong", TypeUtils.PRIMITIVE_LONG_TYPE, new Expression[0]))));
    }

    private Expression.Comparator isEmbedType(Expression partFieldInfo, int flagBits, byte flagValue) {
        return ExpressionUtils.eq(new Expression.BitAnd(partFieldInfo, new Expression.Literal(flagBits, TypeUtils.PRIMITIVE_LONG_TYPE)), new Expression.Literal(flagValue, TypeUtils.PRIMITIVE_BYTE_TYPE));
    }

    private static List<List<FieldResolver.FieldInfo>> groupFields(FieldResolver.FieldInfo[] fieldsInfo, int groupSize) {
        ArrayList<List<FieldResolver.FieldInfo>> groups = new ArrayList<List<FieldResolver.FieldInfo>>();
        ArrayList<FieldResolver.FieldInfo> group = new ArrayList<FieldResolver.FieldInfo>();
        for (FieldResolver.FieldInfo fieldInfo : fieldsInfo) {
            if (group.size() == groupSize) {
                groups.add(group);
                group = new ArrayList();
            }
            group.add(fieldInfo);
        }
        if (!group.isEmpty()) {
            groups.add(group);
        }
        return groups;
    }
}

