/*
 * Decompiled with CFR 0.152.
 */
package io.fury.collection;

import io.fury.util.unsafe._Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Collections {
    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).stream() : StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> ArrayList<T> ofArrayList(T ... elements) {
        ArrayList list = new ArrayList(elements.length);
        _Collections.setArrayListElements(list, elements);
        return list;
    }

    public static <K, V> HashMap<K, V> ofHashMap(Object ... kv) {
        if (kv.length % 2 != 0) {
            throw new IllegalArgumentException(String.format("entries got %d objects, which aren't pairs", kv.length));
        }
        int size = kv.length / 2;
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < kv.length; i += 2) {
            map.put(kv[i], kv[i + 1]);
        }
        return map;
    }

    public static <E> HashSet<E> ofHashSet(E ... elements) {
        HashSet set = new HashSet(elements.length);
        java.util.Collections.addAll(set, elements);
        return set;
    }
}

