/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.io.FuryObjectInput;
import io.fury.io.FuryObjectOutput;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import io.fury.util.Platform;
import io.fury.util.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ExternalizableSerializer<T extends Externalizable>
extends Serializer<T> {
    private Constructor<T> constructor;
    private final FuryObjectInput objectInput;
    private final FuryObjectOutput objectOutput;

    public ExternalizableSerializer(Fury fury, Class<T> cls) {
        super(fury, cls);
        try {
            this.constructor = cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Utils.ignore(e);
        }
        this.objectInput = new FuryObjectInput(fury, null);
        this.objectOutput = new FuryObjectOutput(fury, null);
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        this.objectOutput.setBuffer(buffer);
        try {
            value.writeExternal(this.objectOutput);
        }
        catch (IOException e) {
            Platform.throwException(e);
        }
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException("Externalizable can only be used in java");
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Externalizable t;
        if (this.constructor != null) {
            try {
                t = (Externalizable)this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            t = (Externalizable)Platform.newInstance(this.type);
        }
        this.objectInput.setBuffer(buffer);
        try {
            t.readExternal(this.objectInput);
        }
        catch (IOException | ClassNotFoundException e) {
            Platform.throwException(e);
        }
        return (T)t;
    }
}

