/*
 * Decompiled with CFR 0.152.
 */
package io.fury.pool;

import io.fury.Fury;
import io.fury.util.LoggerFactory;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.slf4j.Logger;

public class ClassLoaderFuryPooled {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderFuryPooled.class);
    private final Function<ClassLoader, Fury> furyFactory;
    private final ClassLoader classLoader;
    private final Queue<Fury> idleCacheQueue;
    private final AtomicInteger activeCacheNumber = new AtomicInteger(0);
    private final int maxPoolSize;
    private final Lock lock = new ReentrantLock();
    private final Condition furyCondition = this.lock.newCondition();

    public ClassLoaderFuryPooled(ClassLoader classLoader, Function<ClassLoader, Fury> furyFactory, int minPoolSize, int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.furyFactory = furyFactory;
        this.classLoader = classLoader;
        this.idleCacheQueue = new ConcurrentLinkedQueue<Fury>();
        while (this.idleCacheQueue.size() < minPoolSize) {
            this.addFury();
        }
    }

    public Fury getFury() {
        try {
            this.lock.lock();
            Fury fury = this.idleCacheQueue.poll();
            while (fury == null) {
                if (this.activeCacheNumber.get() < this.maxPoolSize) {
                    this.addFury();
                } else {
                    this.furyCondition.await();
                }
                fury = this.idleCacheQueue.poll();
                if (fury == null) continue;
            }
            this.activeCacheNumber.incrementAndGet();
            Fury fury2 = fury;
            return fury2;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void returnFury(Fury fury) {
        try {
            this.lock.lock();
            this.idleCacheQueue.add(fury);
            this.activeCacheNumber.decrementAndGet();
            this.furyCondition.signalAll();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addFury() {
        Fury fury = this.furyFactory.apply(this.classLoader);
        this.idleCacheQueue.add(fury);
    }
}

