/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.builder.CodecBuilder;
import io.fury.builder.Generated;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.Expression;
import io.fury.codegen.ExpressionOptimizer;
import io.fury.codegen.ExpressionUtils;
import io.fury.codegen.ExpressionVisitor;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoCache;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.CodegenSerializer;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.CompatibleSerializer;
import io.fury.serializer.MapSerializers;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.serializer.StringSerializer;
import io.fury.type.FinalObjectTypeStub;
import io.fury.type.TypeUtils;
import io.fury.util.ReflectionUtils;
import io.fury.util.StringUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;

public abstract class BaseObjectCodecBuilder
extends CodecBuilder {
    public static final String BUFFER_NAME = "buffer";
    public static final String REF_RESOLVER_NAME = "refResolver";
    public static final String CLASS_RESOLVER_NAME = "classResolver";
    public static final String POJO_CLASS_TYPE_NAME = "classType";
    public static final String STRING_SERIALIZER_NAME = "strSerializer";
    private static final TypeToken<?> CLASS_RESOLVER_TYPE_TOKEN = TypeToken.of(ClassResolver.class);
    private static final TypeToken<?> STRING_SERIALIZER_TYPE_TOKEN = TypeToken.of(StringSerializer.class);
    private static final TypeToken<?> SERIALIZER_TYPE = TypeToken.of(Serializer.class);
    protected final Expression.Reference refResolverRef;
    protected final Expression.Reference classResolverRef = Expression.Reference.fieldRef("classResolver", CLASS_RESOLVER_TYPE_TOKEN);
    protected final Fury fury;
    protected final Expression.Reference stringSerializerRef;
    private final Map<Class<?>, Expression.Reference> serializerMap = new HashMap();
    private final Map<Class<?>, Expression.Reference> classInfoMap = new HashMap();
    protected final Class<?> parentSerializerClass;
    private final Map<String, String> jitCallbackUpdateFields;

    public BaseObjectCodecBuilder(TypeToken<?> beanType, Fury fury, Class<?> parentSerializerClass) {
        super(new CodegenContext(), beanType);
        this.fury = fury;
        this.parentSerializerClass = parentSerializerClass;
        this.addCommonImports();
        this.ctx.reserveName(REF_RESOLVER_NAME);
        this.ctx.reserveName(CLASS_RESOLVER_NAME);
        TypeToken refResolverTypeToken = TypeToken.of(fury.getRefResolver().getClass());
        this.refResolverRef = Expression.Reference.fieldRef(REF_RESOLVER_NAME, refResolverTypeToken);
        Expression.Invoke refResolverExpr = new Expression.Invoke((Expression)this.furyRef, "getRefResolver", TypeToken.of(RefResolver.class));
        this.ctx.addField(this.ctx.type(refResolverTypeToken), REF_RESOLVER_NAME, (Expression)new Expression.Cast(refResolverExpr, refResolverTypeToken));
        Expression.Invoke classResolverExpr = Expression.Invoke.inlineInvoke((Expression)this.furyRef, "getClassResolver", CLASS_RESOLVER_TYPE_TOKEN, new Expression[0]);
        this.ctx.addField(this.ctx.type(CLASS_RESOLVER_TYPE_TOKEN), CLASS_RESOLVER_NAME, (Expression)classResolverExpr);
        this.ctx.reserveName(STRING_SERIALIZER_NAME);
        this.stringSerializerRef = Expression.Reference.fieldRef(STRING_SERIALIZER_NAME, STRING_SERIALIZER_TYPE_TOKEN);
        this.ctx.addField(this.ctx.type(TypeToken.of(StringSerializer.class)), STRING_SERIALIZER_NAME, (Expression)Expression.Invoke.inlineInvoke((Expression)this.furyRef, "getStringSerializer", CLASS_RESOLVER_TYPE_TOKEN, new Expression[0]));
        this.jitCallbackUpdateFields = new HashMap<String, String>();
    }

    public String codecClassName(Class<?> beanClass) {
        String name = ReflectionUtils.getClassNameWithoutPackage(beanClass).replace("$", "_");
        StringBuilder nameBuilder = new StringBuilder(name);
        if (this.fury.trackingRef()) {
            nameBuilder.append("FuryRef");
        } else {
            nameBuilder.append("Fury");
        }
        nameBuilder.append(this.codecSuffix()).append("Codec");
        nameBuilder.append('_').append(this.fury.getConfig().getConfigHash());
        String classUniqueId = CodeGenerator.getClassUniqueId(beanClass);
        if (StringUtils.isNotBlank(classUniqueId)) {
            nameBuilder.append('_').append(classUniqueId);
        }
        return nameBuilder.toString();
    }

    public String codecQualifiedClassName(Class<?> beanClass) {
        String pkg = CodeGenerator.getPackage(beanClass);
        if (StringUtils.isNotBlank(pkg)) {
            return pkg + "." + this.codecClassName(beanClass);
        }
        return this.codecClassName(beanClass);
    }

    protected abstract String codecSuffix();

    <T> T visitFury(Function<Fury, T> function) {
        return this.fury.getJITContext().asyncVisitFury(function);
    }

    @Override
    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage(this.beanClass));
        String className = this.codecClassName(this.beanClass);
        this.ctx.setClassName(className);
        this.ctx.extendsClasses(this.ctx.type(this.parentSerializerClass));
        this.ctx.reserveName(POJO_CLASS_TYPE_NAME);
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        Expression encodeExpr = this.buildEncodeExpression();
        Expression decodeExpr = this.buildDecodeExpression();
        String constructorCode = StringUtils.format("super(${fury}, ${cls});\nthis.${fury} = ${fury};\n${fury}.getClassResolver().setSerializerIfAbsent(${cls}, this);\n", "fury", "fury", "cls", POJO_CLASS_TYPE_NAME);
        this.ctx.clearExprState();
        String encodeCode = encodeExpr.genCode(this.ctx).code();
        encodeCode = this.ctx.optimizeMethodCode(encodeCode);
        this.ctx.clearExprState();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        decodeCode = this.ctx.optimizeMethodCode(decodeCode);
        this.ctx.overrideMethod("write", encodeCode, Void.TYPE, MemoryBuffer.class, BUFFER_NAME, Object.class, "obj");
        this.ctx.overrideMethod("read", decodeCode, Object.class, MemoryBuffer.class, BUFFER_NAME);
        this.registerJITNotifyCallback();
        this.ctx.addConstructor(constructorCode, Fury.class, "fury", Class.class, POJO_CLASS_TYPE_NAME);
        return this.ctx.genCode();
    }

    protected void registerJITNotifyCallback() {
        if (!this.jitCallbackUpdateFields.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(", ", "registerJITNotifyCallback(this,", ");\n");
            for (Map.Entry<String, String> entry : this.jitCallbackUpdateFields.entrySet()) {
                stringJoiner.add("\"" + entry.getKey() + "\"");
                stringJoiner.add(entry.getValue());
            }
            this.ctx.addInitCode(stringJoiner.toString());
        }
    }

    protected void addCommonImports() {
        this.ctx.addImports(List.class, Map.class, Set.class);
        this.ctx.addImports(Fury.class, MemoryBuffer.class, this.fury.getRefResolver().getClass());
        this.ctx.addImports(ClassInfo.class, ClassInfoCache.class, ClassResolver.class);
        this.ctx.addImport(Generated.class);
        this.ctx.addImports(CodegenSerializer.LazyInitBeanSerializer.class, Serializers.EnumSerializer.class);
        this.ctx.addImports(Serializer.class, StringSerializer.class);
        this.ctx.addImports(ObjectSerializer.class, CompatibleSerializer.class);
        this.ctx.addImports(CollectionSerializers.CollectionSerializer.class, MapSerializers.MapSerializer.class, ObjectSerializer.class);
    }

    protected Expression serializeFor(Expression inputObject, Expression buffer, TypeToken<?> typeToken) {
        return this.serializeFor(inputObject, buffer, typeToken, false);
    }

    protected Expression serializeFor(Expression inputObject, Expression buffer, TypeToken<?> typeToken, boolean generateNewMethod) {
        Class<?> rawType = TypeUtils.getRawType(typeToken);
        if (this.visitFury(fury -> fury.getClassResolver().needToWriteRef(rawType)).booleanValue()) {
            return new Expression.If(ExpressionUtils.not(this.writeRefOrNull(buffer, inputObject)), this.serializeForNotNull(inputObject, buffer, typeToken, generateNewMethod));
        }
        if (typeToken.isPrimitive()) {
            return this.serializeForNotNull(inputObject, buffer, typeToken, generateNewMethod);
        }
        Expression.ListExpression action = new Expression.ListExpression(new Expression.Invoke(buffer, "writeByte", new Expression.Literal((byte)0, TypeUtils.PRIMITIVE_BYTE_TYPE)), this.serializeForNotNull(inputObject, buffer, typeToken, generateNewMethod));
        return new Expression.If(ExpressionUtils.eqNull(inputObject), new Expression.Invoke(buffer, "writeByte", new Expression.Literal((byte)-3, TypeUtils.PRIMITIVE_BYTE_TYPE)), action);
    }

    protected Expression writeRefOrNull(Expression buffer, Expression object) {
        return Expression.Invoke.inlineInvoke((Expression)this.refResolverRef, "writeRefOrNull", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, object);
    }

    protected Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeToken<?> typeToken) {
        return this.serializeForNotNull(inputObject, buffer, typeToken, false);
    }

    private Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeToken<?> typeToken, boolean generateNewMethod) {
        Class<?> clz = TypeUtils.getRawType(typeToken);
        if (TypeUtils.isPrimitive(clz) || TypeUtils.isBoxed(clz)) {
            if (clz == Byte.TYPE || clz == Byte.class) {
                return new Expression.Invoke(buffer, "writeByte", inputObject);
            }
            if (clz == Boolean.TYPE || clz == Boolean.class) {
                return new Expression.Invoke(buffer, "writeBoolean", inputObject);
            }
            if (clz == Character.TYPE || clz == Character.class) {
                return new Expression.Invoke(buffer, "writeChar", inputObject);
            }
            if (clz == Short.TYPE || clz == Short.class) {
                return new Expression.Invoke(buffer, "writeShort", inputObject);
            }
            if (clz == Integer.TYPE || clz == Integer.class) {
                String func = this.fury.compressNumber() ? "writeVarInt" : "writeInt";
                return new Expression.Invoke(buffer, func, inputObject);
            }
            if (clz == Long.TYPE || clz == Long.class) {
                String func = this.fury.compressNumber() ? "writeVarLong" : "writeLong";
                return new Expression.Invoke(buffer, func, inputObject);
            }
            if (clz == Float.TYPE || clz == Float.class) {
                return new Expression.Invoke(buffer, "writeFloat", inputObject);
            }
            if (clz == Double.TYPE || clz == Double.class) {
                return new Expression.Invoke(buffer, "writeDouble", inputObject);
            }
            throw new IllegalStateException("impossible");
        }
        if (clz == String.class) {
            return this.fury.getStringSerializer().writeStringExpr(this.stringSerializerRef, buffer, inputObject);
        }
        Expression action = this.useCollectionSerialization(typeToken) ? this.serializeForCollection(buffer, inputObject, typeToken, generateNewMethod) : (this.useMapSerialization(typeToken) ? this.serializeForMap(buffer, inputObject, typeToken, generateNewMethod) : this.serializeForNotNullObject(inputObject, buffer, typeToken));
        return action;
    }

    protected boolean useCollectionSerialization(TypeToken<?> typeToken) {
        return TypeUtils.COLLECTION_TYPE.isSupertypeOf(typeToken);
    }

    protected boolean useMapSerialization(TypeToken<?> typeToken) {
        return TypeUtils.MAP_TYPE.isSupertypeOf(typeToken);
    }

    protected abstract boolean isFinal(Class<?> var1);

    protected Expression serializeForNotNullObject(Expression inputObject, Expression buffer, TypeToken<?> typeToken) {
        Class<?> clz = TypeUtils.getRawType(typeToken);
        if (this.isFinal(clz)) {
            Expression serializer = this.getOrCreateSerializer(clz);
            return new Expression.Invoke(serializer, "write", buffer, inputObject);
        }
        return this.writeForNotNullNonFinalObject(inputObject, buffer, typeToken);
    }

    protected Expression writeForNotNullNonFinalObject(Expression inputObject, Expression buffer, TypeToken<?> typeToken) {
        Class<?> clz = TypeUtils.getRawType(typeToken);
        Expression.Invoke clsExpr = new Expression.Invoke(inputObject, "getClass", "cls", TypeUtils.CLASS_TYPE);
        Expression.ListExpression writeClassAndObject = new Expression.ListExpression(new Expression[0]);
        Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
        Expression classInfo = (Expression)classInfoRef.f0;
        if (((Boolean)classInfoRef.f1).booleanValue()) {
            writeClassAndObject.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeToken, clsExpr))));
        }
        writeClassAndObject.add(this.fury.getClassResolver().writeClassExpr(this.classResolverRef, buffer, classInfo));
        writeClassAndObject.add(new Expression.Invoke((Expression)Expression.Invoke.inlineInvoke(classInfo, "getSerializer", SERIALIZER_TYPE, new Expression[0]), "write", TypeUtils.PRIMITIVE_VOID_TYPE, buffer, inputObject));
        return ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)inputObject), writeClassAndObject, "writeClassAndObject", false);
    }

    protected Expression getOrCreateSerializer(Class<?> cls) {
        Preconditions.checkArgument((boolean)this.isFinal(cls), cls);
        Expression.Reference serializerRef = this.serializerMap.get(cls);
        if (serializerRef == null) {
            Class serializerClass = this.visitFury(f -> f.getClassResolver().getSerializerClass(cls));
            Preconditions.checkNotNull((Object)serializerClass, (Object)("Unsupported for class " + cls));
            ClassLoader beanClassClassLoader = this.beanClass.getClassLoader() == null ? Thread.currentThread().getContextClassLoader() : this.beanClass.getClassLoader();
            try {
                beanClassClassLoader.loadClass(serializerClass.getName());
            }
            catch (ClassNotFoundException e) {
                serializerClass = CodegenSerializer.LazyInitBeanSerializer.class;
            }
            if (serializerClass == CodegenSerializer.LazyInitBeanSerializer.class || serializerClass == ObjectSerializer.class || serializerClass == CompatibleSerializer.class) {
                serializerClass = Serializer.class;
            }
            TypeToken serializerTypeToken = TypeToken.of(serializerClass);
            Expression.Literal clzLiteral = new Expression.Literal(this.ctx.type(cls) + ".class");
            Expression.Invoke newSerializerExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getSerializer", SERIALIZER_TYPE, clzLiteral);
            String name = this.ctx.newName(StringUtils.uncapitalize(serializerClass.getSimpleName()));
            boolean hasJITResult = this.fury.getJITContext().hasJITResult(cls);
            if (hasJITResult) {
                this.jitCallbackUpdateFields.put(name, this.ctx.type(cls) + ".class");
                this.ctx.addField(this.ctx.type(Serializer.class), name, new Expression.Cast(newSerializerExpr, SERIALIZER_TYPE), false);
                serializerRef = new Expression.Reference(name, SERIALIZER_TYPE, false);
            } else {
                this.ctx.addField(this.ctx.type(serializerClass), name, new Expression.Cast(newSerializerExpr, serializerTypeToken), true);
                serializerRef = Expression.Reference.fieldRef(name, serializerTypeToken);
            }
            this.serializerMap.put(cls, serializerRef);
        }
        return serializerRef;
    }

    protected Tuple2<Expression.Reference, Boolean> addClassInfoField(Class<?> cls) {
        boolean needUpdate;
        boolean bl = needUpdate = !ReflectionUtils.isFinal(cls);
        if (!needUpdate) {
            Expression.Reference classInfoRef = this.classInfoMap.get(cls);
            if (classInfoRef != null) {
                return Tuple2.of(classInfoRef, false);
            }
            Expression.Literal clsExpr = new Expression.Literal(cls, TypeUtils.CLASS_TYPE);
            Expression.Invoke classInfoExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeToken, clsExpr);
            String name = this.ctx.newName(this.ctx.newName(cls) + "ClassInfo");
            this.ctx.addField(this.ctx.type(ClassInfo.class), name, classInfoExpr, true);
            classInfoRef = Expression.Reference.fieldRef(name, classInfoTypeToken);
            this.classInfoMap.put(cls, classInfoRef);
            return Tuple2.of(classInfoRef, false);
        }
        Expression.Invoke classInfoExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "nilClassInfo", classInfoTypeToken, new Expression[0]);
        String name = this.ctx.newName(StringUtils.uncapitalize(cls.getSimpleName()) + "ClassInfo");
        this.ctx.addField(this.ctx.type(ClassInfo.class), name, classInfoExpr, false);
        return Tuple2.of(new Expression.Reference(name, classInfoTypeToken), true);
    }

    protected Expression.Reference addClassInfoCacheField(Class<?> cls) {
        Preconditions.checkArgument((!Modifier.isFinal(cls.getModifiers()) ? 1 : 0) != 0, cls);
        Expression.Invoke classInfoCacheExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "nilClassInfoCache", classInfoCacheTypeToken, new Expression[0]);
        String name = this.ctx.newName(cls, "ClassInfoCache");
        this.ctx.addField(this.ctx.type(ClassInfoCache.class), name, classInfoCacheExpr, true);
        return new Expression.Reference(name, classInfoCacheTypeToken);
    }

    protected Expression readClassInfo(Class<?> cls, Expression buffer) {
        return this.readClassInfo(cls, buffer, true);
    }

    protected Expression readClassInfo(Class<?> cls, Expression buffer, boolean inlineReadClassInfo) {
        if (Modifier.isFinal(cls.getModifiers())) {
            Expression.Reference classInfoRef = (Expression.Reference)this.addClassInfoField(cls).f0;
            if (inlineReadClassInfo) {
                return Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeToken, buffer, classInfoRef);
            }
            return new Expression.Invoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeToken, buffer, classInfoRef);
        }
        Expression.Reference classInfoCacheRef = this.addClassInfoCacheField(cls);
        if (inlineReadClassInfo) {
            return Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeToken, buffer, classInfoCacheRef);
        }
        return new Expression.Invoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeToken, buffer, classInfoCacheRef);
    }

    protected Expression serializeForCollection(Expression buffer, Expression collection, TypeToken<?> typeToken, boolean generateNewMethod) {
        Expression clsExpr;
        Expression serializer;
        TypeToken<?> elementType = TypeUtils.getElementType(typeToken);
        Expression.ListExpression actions = new Expression.ListExpression(new Expression[0]);
        Class<?> clz = TypeUtils.getRawType(typeToken);
        if (this.isFinal(clz)) {
            serializer = this.getOrCreateSerializer(clz);
            clsExpr = new Expression.Literal(clz, TypeUtils.CLASS_TYPE);
        } else {
            Expression.ListExpression writeClassAction = new Expression.ListExpression(new Expression[0]);
            Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
            Expression classInfo = (Expression)classInfoRef.f0;
            clsExpr = new Expression.Invoke(collection, "getClass", "cls", TypeUtils.CLASS_TYPE);
            writeClassAction.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeToken, clsExpr))));
            writeClassAction.add(this.fury.getClassResolver().writeClassExpr(this.classResolverRef, buffer, classInfo));
            serializer = new Expression.Invoke(classInfo, "getSerializer", "serializer", SERIALIZER_TYPE, false, new Expression[0]);
            serializer = new Expression.Cast(serializer, TypeToken.of(CollectionSerializers.CollectionSerializer.class));
            writeClassAction.add(serializer, new Expression.Return(serializer));
            serializer = ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)clsExpr), writeClassAction, "writeCollectionClassInfo", false);
        }
        Expression hookWrite = TypeUtils.getRawType(collection.type()).isAssignableFrom(ArrayList.class) || ArrayList.class.isAssignableFrom(TypeUtils.getRawType(collection.type())) ? new Expression.If(ExpressionUtils.eq(clsExpr, new Expression.Literal(ArrayList.class, TypeUtils.CLASS_TYPE)), this.writeListCodegen(buffer, collection, serializer, elementType), this.writeCollectionCodegen(buffer, collection, serializer, elementType), false) : this.writeCollectionCodegen(buffer, collection, serializer, elementType);
        Expression.If write = new Expression.If(Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]), hookWrite, new Expression.Invoke(serializer, "write", buffer, collection));
        actions.add(write);
        if (generateNewMethod) {
            return ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)collection), actions, "writeCollection", false);
        }
        return actions;
    }

    protected Expression writeCollectionCodegen(Expression buffer, Expression collection, Expression serializer, TypeToken<?> elementType) {
        Expression.Invoke size = new Expression.Invoke(collection, "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke writeSize = new Expression.Invoke(buffer, "writePositiveVarInt", size);
        Expression.Invoke writeHeader = new Expression.Invoke(serializer, "writeHeader", buffer, collection);
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of(BUFFER_NAME, buffer);
        Expression.ForEach writeElements = new Expression.ForEach(collection, (i, value) -> {
            boolean generateNewMethod = this.useCollectionSerialization(elementType) || this.useMapSerialization(elementType);
            return this.serializeFor((Expression)value, exprHolder.get(BUFFER_NAME), elementType, generateNewMethod);
        });
        return new Expression.ListExpression(writeSize, writeHeader, writeElements);
    }

    protected Expression writeListCodegen(Expression buffer, Expression collection, Expression serializer, TypeToken<?> elementType) {
        Expression.Cast list = new Expression.Cast(collection, TypeUtils.arrayListOf(TypeUtils.getRawType(elementType)), "arrList");
        Expression.Literal start = new Expression.Literal(0, TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Literal step = new Expression.Literal(1, TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke size = new Expression.Invoke(collection, "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke writeSize = new Expression.Invoke(buffer, "writePositiveVarInt", size);
        Expression.Invoke writeHeader = new Expression.Invoke(serializer, "writeHeader", buffer, collection);
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of(BUFFER_NAME, buffer, "list", list);
        Expression.ForLoop writeElements = new Expression.ForLoop(start, size, step, i -> {
            Expression.Invoke elem = new Expression.Invoke(exprHolder.get("list"), "get", TypeUtils.OBJECT_TYPE, false, (Expression)i);
            boolean generateNewMethod = this.useCollectionSerialization(elementType) || this.useMapSerialization(elementType);
            return this.serializeFor(this.tryCastIfPublic(elem, elementType), exprHolder.get(BUFFER_NAME), elementType, generateNewMethod);
        });
        return new Expression.ListExpression(list, writeSize, writeHeader, writeElements);
    }

    protected Expression tryInlineCast(Expression expression, TypeToken targetType) {
        return this.tryCastIfPublic(expression, targetType, true);
    }

    protected Expression tryCastIfPublic(Expression expression, TypeToken targetType) {
        return this.tryCastIfPublic(expression, targetType, false);
    }

    protected Expression tryCastIfPublic(Expression expression, TypeToken targetType, boolean inline) {
        if (TypeUtils.getRawType(targetType) == FinalObjectTypeStub.class) {
            return expression;
        }
        if (inline) {
            if (ReflectionUtils.isPublic(targetType) && !expression.type().wrap().isSubtypeOf(targetType.wrap())) {
                return new Expression.Cast(expression, targetType);
            }
            return expression;
        }
        return this.tryCastIfPublic(expression, targetType, "castedValue");
    }

    protected Expression tryCastIfPublic(Expression expression, TypeToken targetType, String valuePrefix) {
        if (ReflectionUtils.isPublic(targetType) && !expression.type().wrap().isSubtypeOf(targetType.wrap())) {
            return new Expression.Cast(expression, targetType, valuePrefix);
        }
        return expression;
    }

    protected Expression serializeForMap(Expression buffer, Expression map, TypeToken<?> typeToken, boolean generateNewMethod) {
        Expression serializer;
        Tuple2<TypeToken<?>, TypeToken<?>> keyValueType = TypeUtils.getMapKeyValueType(typeToken);
        TypeToken keyType = (TypeToken)keyValueType.f0;
        TypeToken valueType = (TypeToken)keyValueType.f1;
        Expression.ListExpression actions = new Expression.ListExpression(new Expression[0]);
        Class<?> clz = TypeUtils.getRawType(typeToken);
        if (this.isFinal(clz)) {
            serializer = this.getOrCreateSerializer(clz);
        } else {
            Expression.ListExpression writeClassAction = new Expression.ListExpression(new Expression[0]);
            Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
            Expression classInfo = (Expression)classInfoRef.f0;
            Expression.Invoke clsExpr = new Expression.Invoke(map, "getClass", "cls", TypeUtils.CLASS_TYPE);
            writeClassAction.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeToken, clsExpr))));
            writeClassAction.add(this.fury.getClassResolver().writeClassExpr(this.classResolverRef, buffer, classInfo));
            serializer = new Expression.Invoke(classInfo, "getSerializer", "serializer", SERIALIZER_TYPE, false, new Expression[0]);
            serializer = new Expression.Cast(serializer, TypeToken.of(MapSerializers.MapSerializer.class));
            writeClassAction.add(serializer, new Expression.Return(serializer));
            serializer = ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)map), writeClassAction, "writeMapClassInfo", false);
        }
        Expression.Invoke size = new Expression.Invoke(map, "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke writeSize = new Expression.Invoke(buffer, "writePositiveVarInt", size);
        Expression.Invoke writeHeader = new Expression.Invoke(serializer, "writeHeader", buffer, map);
        Expression.Invoke entrySet = new Expression.Invoke(map, "entrySet", "entrySet", TypeUtils.SET_TYPE);
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of(BUFFER_NAME, buffer);
        Expression.ForEach writeKeyValues = new Expression.ForEach(entrySet, (i, entryObj) -> {
            Expression.Cast entry = new Expression.Cast((Expression)entryObj, (TypeToken<?>)TypeToken.of(Map.Entry.class), "entry");
            Expression key = new Expression.Invoke((Expression)entry, "getKey", "keyObj", TypeUtils.OBJECT_TYPE);
            key = this.tryCastIfPublic(key, keyType, "key");
            Expression value = new Expression.Invoke((Expression)entry, "getValue", "valueObj", TypeUtils.OBJECT_TYPE);
            value = this.tryCastIfPublic(value, valueType, "value");
            boolean genMethodForKey = this.useCollectionSerialization(keyType) || this.useMapSerialization(keyType);
            boolean genMethodForValue = this.useCollectionSerialization(valueType) || this.useMapSerialization(valueType);
            return new Expression.ListExpression(this.serializeFor(key, exprHolder.get(BUFFER_NAME), keyType, genMethodForKey), this.serializeFor(value, exprHolder.get(BUFFER_NAME), valueType, genMethodForValue));
        });
        Expression.ListExpression hookWrite = new Expression.ListExpression(writeSize, writeHeader, writeKeyValues);
        Expression.If write = new Expression.If(Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]), hookWrite, new Expression.Invoke(serializer, "write", buffer, map));
        actions.add(write);
        if (generateNewMethod) {
            return ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)map), actions, "writeMap", false);
        }
        return actions;
    }

    protected Expression readRefOrNull(Expression buffer) {
        return new Expression.Invoke((Expression)this.refResolverRef, "readRefOrNull", "tag", TypeUtils.PRIMITIVE_BYTE_TYPE, false, buffer);
    }

    protected Expression tryPreserveRefId(Expression buffer) {
        return new Expression.Invoke((Expression)this.refResolverRef, "tryPreserveRefId", "refId", TypeUtils.PRIMITIVE_INT_TYPE, false, buffer);
    }

    protected Expression deserializeFor(Expression buffer, TypeToken<?> typeToken, Function<Expression, Expression> callback) {
        return this.deserializeFor(buffer, typeToken, callback, false);
    }

    protected Expression deserializeFor(Expression buffer, TypeToken<?> typeToken, Function<Expression, Expression> callback, boolean generateNewMethod) {
        Class<?> rawType = TypeUtils.getRawType(typeToken);
        if (this.visitFury(f -> f.getClassResolver().needToWriteRef(rawType)).booleanValue()) {
            Expression refId = this.tryPreserveRefId(buffer);
            Expression.Comparator needDeserialize = ExpressionUtils.egt(refId, new Expression.Literal((byte)-1, TypeUtils.PRIMITIVE_BYTE_TYPE));
            Expression deserializedValue = this.deserializeForNotNull(buffer, typeToken, generateNewMethod);
            Expression.Invoke setReadObject = new Expression.Invoke((Expression)this.refResolverRef, "setReadObject", refId, deserializedValue);
            Expression.Invoke readValue = Expression.Invoke.inlineInvoke((Expression)this.refResolverRef, "getReadObject", TypeUtils.OBJECT_TYPE, false, new Expression[0]);
            return new Expression.If(needDeserialize, callback.apply(new Expression.ListExpression(refId, deserializedValue, setReadObject, deserializedValue)), callback.apply(readValue), false);
        }
        if (typeToken.isPrimitive()) {
            Expression value = this.deserializeForNotNull(buffer, typeToken, generateNewMethod);
            return new Expression.ListExpression(value, callback.apply(value));
        }
        Expression.Comparator notNull = ExpressionUtils.neq(Expression.Invoke.inlineInvoke(buffer, "readByte", TypeUtils.PRIMITIVE_BYTE_TYPE, new Expression[0]), new Expression.Literal((byte)-3, TypeUtils.PRIMITIVE_BYTE_TYPE));
        Expression value = this.deserializeForNotNull(buffer, typeToken, generateNewMethod);
        return new Expression.If(notNull, callback.apply(value), callback.apply(ExpressionUtils.nullValue(typeToken)), false);
    }

    protected Expression deserializeForNotNull(Expression buffer, TypeToken<?> typeToken, boolean generateNewMethod) {
        Expression obj;
        Class<?> cls = TypeUtils.getRawType(typeToken);
        if (TypeUtils.isPrimitive(cls) || TypeUtils.isBoxed(cls)) {
            if (cls == Byte.TYPE || cls == Byte.class) {
                return new Expression.Invoke(buffer, "readByte", TypeUtils.PRIMITIVE_BYTE_TYPE);
            }
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                return new Expression.Invoke(buffer, "readBoolean", TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
            }
            if (cls == Character.TYPE || cls == Character.class) {
                return new Expression.Invoke(buffer, "readChar", TypeToken.of(Character.TYPE));
            }
            if (cls == Short.TYPE || cls == Short.class) {
                return new Expression.Invoke(buffer, "readShort", TypeUtils.PRIMITIVE_SHORT_TYPE);
            }
            if (cls == Integer.TYPE || cls == Integer.class) {
                String func = this.fury.compressNumber() ? "readVarInt" : "readInt";
                return new Expression.Invoke(buffer, func, TypeUtils.PRIMITIVE_INT_TYPE);
            }
            if (cls == Long.TYPE || cls == Long.class) {
                String func = this.fury.compressNumber() ? "readVarLong" : "readLong";
                return new Expression.Invoke(buffer, func, TypeUtils.PRIMITIVE_LONG_TYPE);
            }
            if (cls == Float.TYPE || cls == Float.class) {
                return new Expression.Invoke(buffer, "readFloat", TypeUtils.PRIMITIVE_FLOAT_TYPE);
            }
            if (cls == Double.TYPE || cls == Double.class) {
                return new Expression.Invoke(buffer, "readDouble", TypeUtils.PRIMITIVE_DOUBLE_TYPE);
            }
            throw new IllegalStateException("impossible");
        }
        if (cls == String.class) {
            return this.fury.getStringSerializer().readStringExpr(this.stringSerializerRef, buffer);
        }
        if (this.useCollectionSerialization(typeToken)) {
            obj = this.deserializeForCollection(buffer, typeToken, generateNewMethod);
        } else if (this.useMapSerialization(typeToken)) {
            obj = this.deserializeForMap(buffer, typeToken, generateNewMethod);
        } else if (this.isFinal(cls)) {
            Expression serializer = this.getOrCreateSerializer(cls);
            Class<?> returnType = ReflectionUtils.getReturnType(TypeUtils.getRawType(serializer.type()), "read");
            obj = new Expression.Invoke(serializer, "read", TypeToken.of(returnType), buffer);
        } else {
            obj = this.readForNotNullNonFinal(buffer, typeToken);
        }
        return obj;
    }

    protected Expression readForNotNullNonFinal(Expression buffer, TypeToken<?> typeToken) {
        Expression classInfo = this.readClassInfo(TypeUtils.getRawType(typeToken), buffer);
        return new Expression.Invoke((Expression)Expression.Invoke.inlineInvoke(classInfo, "getSerializer", SERIALIZER_TYPE, new Expression[0]), "read", TypeUtils.OBJECT_TYPE, buffer);
    }

    protected Expression deserializeForCollection(Expression buffer, TypeToken<?> typeToken, boolean generateNewMethod) {
        Expression serializer;
        TypeToken<?> elementType = TypeUtils.getElementType(typeToken);
        Class<?> cls = TypeUtils.getRawType(typeToken);
        if (this.isFinal(cls)) {
            serializer = this.getOrCreateSerializer(cls);
        } else {
            Expression classInfo = this.readClassInfo(cls, buffer);
            serializer = new Expression.Invoke(classInfo, "getSerializer", "serializer", SERIALIZER_TYPE, false, new Expression[0]);
            serializer = new Expression.Cast(serializer, TypeToken.of(CollectionSerializers.CollectionSerializer.class), "collectionSerializer");
        }
        Expression.Invoke supportHook = Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]);
        Expression.Invoke size = new Expression.Invoke(buffer, "readPositiveVarInt", "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke collection = new Expression.Invoke(serializer, "newCollection", TypeUtils.COLLECTION_TYPE, buffer, size);
        Expression hookRead = this.readCollectionCodegen(buffer, collection, size, elementType);
        Expression.If action = new Expression.If(supportHook, new Expression.ListExpression(collection, hookRead), new Expression.Invoke(serializer, "read", TypeUtils.COLLECTION_TYPE, buffer), false);
        if (generateNewMethod) {
            return ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer), new Expression.ListExpression(action, new Expression.Return(action)), "readCollection", false);
        }
        return action;
    }

    protected Expression readCollectionCodegen(Expression buffer, Expression collection, Expression size, TypeToken<?> elementType) {
        Expression.Literal start = new Expression.Literal(0, TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Literal step = new Expression.Literal(1, TypeUtils.PRIMITIVE_INT_TYPE);
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of("collection", collection, BUFFER_NAME, buffer);
        Expression.ForLoop readElements = new Expression.ForLoop(start, size, step, i -> {
            boolean generateNewMethod = this.useCollectionSerialization(elementType) || this.useMapSerialization(elementType);
            return this.deserializeFor(exprHolder.get(BUFFER_NAME), elementType, v -> new Expression.Invoke(exprHolder.get("collection"), "add", (Expression)v), generateNewMethod);
        });
        return new Expression.ListExpression(size, collection, readElements, collection);
    }

    protected Expression deserializeForMap(Expression buffer, TypeToken<?> typeToken, boolean generateNewMethod) {
        Expression serializer;
        Tuple2<TypeToken<?>, TypeToken<?>> keyValueType = TypeUtils.getMapKeyValueType(typeToken);
        TypeToken keyType = (TypeToken)keyValueType.f0;
        TypeToken valueType = (TypeToken)keyValueType.f1;
        Class<?> cls = TypeUtils.getRawType(typeToken);
        if (this.isFinal(cls)) {
            serializer = this.getOrCreateSerializer(cls);
        } else {
            Expression classInfo = this.readClassInfo(cls, buffer);
            serializer = new Expression.Invoke(classInfo, "getSerializer", SERIALIZER_TYPE);
            serializer = new Expression.Cast(serializer, TypeToken.of(MapSerializers.MapSerializer.class), "mapSerializer");
        }
        Expression.Invoke supportHook = Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]);
        Expression.Invoke size = new Expression.Invoke(buffer, "readPositiveVarInt", "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke newMap = new Expression.Invoke(serializer, "newMap", TypeUtils.MAP_TYPE, buffer, size);
        Expression.Literal start = new Expression.Literal(0, TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Literal step = new Expression.Literal(1, TypeUtils.PRIMITIVE_INT_TYPE);
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of("map", newMap, BUFFER_NAME, buffer);
        Expression.ForLoop readKeyValues = new Expression.ForLoop(start, size, step, i -> {
            boolean genKeyMethod = this.useCollectionSerialization(keyType) || this.useMapSerialization(keyType);
            boolean genValueMethod = this.useCollectionSerialization(valueType) || this.useMapSerialization(valueType);
            return new Expression.Invoke(exprHolder.get("map"), "put", this.deserializeFor(exprHolder.get(BUFFER_NAME), keyType, e -> e, genKeyMethod), this.deserializeFor(exprHolder.get(BUFFER_NAME), valueType, e -> e, genValueMethod));
        });
        Expression.ListExpression hookRead = new Expression.ListExpression(size, newMap, readKeyValues, newMap);
        Expression.If action = new Expression.If(supportHook, hookRead, new Expression.Invoke(serializer, "read", TypeUtils.MAP_TYPE, buffer), false);
        if (generateNewMethod) {
            return ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer), new Expression.ListExpression(action, new Expression.Return(action)), "readMap", false);
        }
        return action;
    }

    @Override
    protected Expression beanClassExpr() {
        return new Expression.Reference("super.type", TypeUtils.CLASS_TYPE);
    }
}

