/*
 * Decompiled with CFR 0.152.
 */
package io.fury;

import io.fury.Fury;
import io.fury.ThreadSafeFury;
import io.fury.memory.MemoryBuffer;
import io.fury.memory.MemoryUtils;
import io.fury.util.LoaderBinding;
import java.nio.ByteBuffer;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThreadLocalFury
implements ThreadSafeFury {
    private final ThreadLocal<MemoryBuffer> bufferLocal = ThreadLocal.withInitial(() -> MemoryUtils.buffer(32));
    private final ThreadLocal<LoaderBinding> bindingThreadLocal = ThreadLocal.withInitial(() -> {
        LoaderBinding binding = new LoaderBinding(furyFactory);
        binding.setClassLoader(Thread.currentThread().getContextClassLoader());
        return binding;
    });

    public ThreadLocalFury(Function<ClassLoader, Fury> furyFactory) {
        this.bindingThreadLocal.get().get();
    }

    @Override
    public <R> R execute(Function<Fury, R> action) {
        Fury fury = this.bindingThreadLocal.get().get();
        return action.apply(fury);
    }

    @Override
    public byte[] serialize(Object obj) {
        MemoryBuffer buffer = this.bufferLocal.get();
        buffer.writerIndex(0);
        this.bindingThreadLocal.get().get().serialize(buffer, obj);
        return buffer.getBytes(0, buffer.writerIndex());
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj) {
        return this.bindingThreadLocal.get().get().serialize(buffer, obj);
    }

    @Override
    public Object deserialize(byte[] bytes) {
        return this.bindingThreadLocal.get().get().deserialize(bytes);
    }

    @Override
    public Object deserialize(long address, int size) {
        return this.bindingThreadLocal.get().get().deserialize(address, size);
    }

    @Override
    public Object deserialize(MemoryBuffer buffer) {
        return this.bindingThreadLocal.get().get().deserialize(buffer);
    }

    @Override
    public Object deserialize(ByteBuffer byteBuffer) {
        return this.bindingThreadLocal.get().get().deserialize(MemoryUtils.wrap(byteBuffer));
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.setClassLoader(classLoader, LoaderBinding.StagingType.SOFT_STAGING);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader, LoaderBinding.StagingType stagingType) {
        this.bindingThreadLocal.get().setClassLoader(classLoader, stagingType);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.bindingThreadLocal.get().getClassLoader();
    }

    @Override
    public void clearClassLoader(ClassLoader loader) {
        this.bindingThreadLocal.get().clearClassLoader(loader);
    }
}

