/*
 * Decompiled with CFR 0.152.
 */
package io.fury.shaded.org.codehaus.janino;

import io.fury.shaded.org.codehaus.commons.compiler.CompileException;
import io.fury.shaded.org.codehaus.commons.compiler.Location;
import io.fury.shaded.org.codehaus.commons.compiler.WarningHandler;
import io.fury.shaded.org.codehaus.commons.nullanalysis.Nullable;
import io.fury.shaded.org.codehaus.janino.Scanner;
import io.fury.shaded.org.codehaus.janino.Token;
import io.fury.shaded.org.codehaus.janino.TokenStream;
import io.fury.shaded.org.codehaus.janino.TokenType;
import java.io.IOException;

public class TokenStreamImpl
implements TokenStream {
    private final Scanner scanner;
    @Nullable
    private String optionalDocComment;
    @Nullable
    private Token nextToken;
    @Nullable
    private Token nextButOneToken;
    @Nullable
    private WarningHandler optionalWarningHandler;

    public TokenStreamImpl(Scanner scanner) {
        this.scanner = scanner;
        this.scanner.setIgnoreWhiteSpace(true);
    }

    private Token produceToken() throws CompileException, IOException {
        Token token;
        block4: while (true) {
            token = this.scanner.produce();
            switch (token.type) {
                case WHITE_SPACE: 
                case C_PLUS_PLUS_STYLE_COMMENT: {
                    continue block4;
                }
                case C_STYLE_COMMENT: {
                    if (!token.value.startsWith("/**") || this.optionalDocComment == null) continue block4;
                    this.warning("MDC", "Misplaced doc comment", this.scanner.location());
                    this.optionalDocComment = null;
                    continue block4;
                }
            }
            break;
        }
        return token;
    }

    @Nullable
    public String doc() {
        String s = this.optionalDocComment;
        this.optionalDocComment = null;
        return s;
    }

    @Override
    public Token peek() throws CompileException, IOException {
        if (this.nextToken == null) {
            this.nextToken = this.produceToken();
        }
        assert (this.nextToken != null);
        return this.nextToken;
    }

    @Override
    public Token peekNextButOne() throws CompileException, IOException {
        if (this.nextToken == null) {
            this.nextToken = this.produceToken();
        }
        if (this.nextButOneToken == null) {
            this.nextButOneToken = this.produceToken();
        }
        assert (this.nextButOneToken != null);
        return this.nextButOneToken;
    }

    @Override
    public boolean peek(String suspected) throws CompileException, IOException {
        return this.peek().value.equals(suspected);
    }

    @Override
    public int peek(String ... suspected) throws CompileException, IOException {
        return TokenStreamImpl.indexOf(suspected, this.peek().value);
    }

    @Override
    public boolean peek(TokenType suspected) throws CompileException, IOException {
        return this.peek().type == suspected;
    }

    @Override
    public int peek(TokenType ... suspected) throws CompileException, IOException {
        return TokenStreamImpl.indexOf(suspected, this.peek().type);
    }

    @Override
    public boolean peekNextButOne(String suspected) throws CompileException, IOException {
        return this.peekNextButOne().value.equals(suspected);
    }

    @Override
    public Token read() throws CompileException, IOException {
        if (this.nextToken == null) {
            return this.produceToken();
        }
        Token result = this.nextToken;
        assert (result != null);
        this.nextToken = this.nextButOneToken;
        this.nextButOneToken = null;
        return result;
    }

    @Override
    public void read(String expected) throws CompileException, IOException {
        String s = this.read().value;
        if (!s.equals(expected)) {
            throw this.compileException("'" + expected + "' expected instead of '" + s + "'");
        }
    }

    @Override
    public int read(String ... expected) throws CompileException, IOException {
        int result;
        Token t = this.read();
        String value = t.value;
        int idx = TokenStreamImpl.indexOf(expected, value);
        if (idx != -1) {
            return idx;
        }
        if (value.startsWith(">") && (result = TokenStreamImpl.indexOf(expected, ">")) != -1) {
            Location loc = t.getLocation();
            this.nextToken = new Token(loc.getFileName(), loc.getLineNumber(), loc.getColumnNumber() + 1, TokenType.OPERATOR, value.substring(1));
            return result;
        }
        throw this.compileException("One of '" + TokenStreamImpl.join(expected, " ") + "' expected instead of '" + value + "'");
    }

    @Override
    public String read(TokenType expected) throws CompileException, IOException {
        Token t = this.read();
        if (t.type != expected) {
            throw new CompileException((Object)((Object)expected) + " expected instead of '" + t.value + "'", t.getLocation());
        }
        return t.value;
    }

    @Override
    public int read(TokenType ... expected) throws CompileException, IOException {
        Token t = this.read();
        TokenType type = t.type;
        int idx = TokenStreamImpl.indexOf(expected, type);
        if (idx != -1) {
            return idx;
        }
        throw this.compileException("One of '" + TokenStreamImpl.join((Object[])expected, " ") + "' expected instead of '" + (Object)((Object)type) + "'");
    }

    @Override
    public boolean peekRead(String suspected) throws CompileException, IOException {
        if (this.nextToken != null) {
            if (!this.nextToken.value.equals(suspected)) {
                return false;
            }
            this.nextToken = this.nextButOneToken;
            this.nextButOneToken = null;
            return true;
        }
        Token t = this.produceToken();
        if (t.value.equals(suspected)) {
            return true;
        }
        this.nextToken = t;
        return false;
    }

    @Override
    public int peekRead(String ... suspected) throws CompileException, IOException {
        if (this.nextToken != null) {
            int idx = TokenStreamImpl.indexOf(suspected, this.nextToken.value);
            if (idx == -1) {
                return -1;
            }
            this.nextToken = this.nextButOneToken;
            this.nextButOneToken = null;
            return idx;
        }
        Token t = this.produceToken();
        int idx = TokenStreamImpl.indexOf(suspected, t.value);
        if (idx != -1) {
            return idx;
        }
        this.nextToken = t;
        return -1;
    }

    @Override
    public boolean peekRead(TokenType suspected) throws CompileException, IOException {
        if (this.nextToken != null) {
            if (this.nextToken.type != suspected) {
                return false;
            }
            this.nextToken = this.nextButOneToken;
            this.nextButOneToken = null;
            return true;
        }
        Token t = this.produceToken();
        if (t.type == suspected) {
            return true;
        }
        this.nextToken = t;
        return false;
    }

    @Override
    public int peekRead(TokenType ... suspected) throws CompileException, IOException {
        if (this.nextToken != null) {
            int idx = TokenStreamImpl.indexOf(suspected, this.nextToken.type);
            if (idx != -1) {
                this.nextToken = this.nextButOneToken;
                this.nextButOneToken = null;
            }
            return idx;
        }
        Token t = this.produceToken();
        int idx = TokenStreamImpl.indexOf(suspected, t.type);
        if (idx != -1) {
            return idx;
        }
        this.nextToken = t;
        return -1;
    }

    private static int indexOf(String[] strings, String subject) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(subject)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(TokenType[] tta, TokenType subject) {
        for (int i = 0; i < tta.length; ++i) {
            if (!tta[i].equals((Object)subject)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    private void warning(String handle, String message, @Nullable Location optionalLocation) throws CompileException {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    protected final CompileException compileException(String message) {
        return new CompileException(message, this.scanner.location());
    }

    private static String join(@Nullable Object[] oa, String glue) {
        if (oa == null) {
            return "(null)";
        }
        if (oa.length == 0) {
            return "(zero length array)";
        }
        StringBuilder sb = new StringBuilder().append(oa[0]);
        for (int i = 1; i < oa.length; ++i) {
            sb.append(glue).append(oa[i]);
        }
        return sb.toString();
    }
}

