/*
 * Decompiled with CFR 0.152.
 */
package io.fury.collection;

import com.google.common.base.Preconditions;
import io.fury.collection.MapEntry;
import io.fury.collection.ObjectArray;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public class FuryObjectMap<K, V> {
    static final Object dummy = new Object();
    public int size;
    K[] keyTable;
    V[] valueTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;

    public FuryObjectMap() {
        this(51, 0.6f);
    }

    public FuryObjectMap(int initialCapacity) {
        this(initialCapacity, 0.6f);
    }

    public FuryObjectMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = FuryObjectMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.valueTable = new Object[tableSize];
    }

    protected int place(K item) {
        return (int)((long)item.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        K other;
        while ((other = keyTable[i]) != null) {
            if (other.equals(key)) {
                return i;
            }
            i = i + 1 & mask;
        }
        return -(i + 1);
    }

    public V put(K key, V value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    private void putResize(K key, V value) {
        K[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & mask;
        }
    }

    public <T extends K> V get(T key) {
        int mask = this.mask;
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while ((other = keyTable[i]) != null) {
            if (other.equals(key)) {
                return this.valueTable[i];
            }
            i = i + 1 & mask;
        }
        return null;
    }

    public V get(K key, V defaultValue) {
        int mask = this.mask;
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while ((other = keyTable[i]) != null) {
            if (other.equals(key)) {
                return this.valueTable[i];
            }
            i = i + 1 & mask;
        }
        return defaultValue;
    }

    public V remove(K key) {
        int i = this.locateKey(key);
        if (i < 0) {
            return null;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != null) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = key;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        valueTable[i] = null;
        --this.size;
        return oldValue;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear(int maximumCapacity) {
        int tableSize = FuryObjectMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        ObjectArray.clearObjectArray(this.keyTable, 0, this.keyTable.length);
        ObjectArray.clearObjectArray(this.valueTable, 0, this.valueTable.length);
    }

    public boolean containsKey(K key) {
        return this.locateKey(key) >= 0;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value);
        V[] tab = this.valueTable;
        for (int i = 1; i < tab.length; i += 2) {
            if (tab[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            K key = keyTable[i];
            if (key == null) continue;
            V value = valueTable[i];
            action.accept(key, value);
        }
    }

    public Iterable<Map.Entry<K, V>> iterable() {
        return () -> new MapIterator();
    }

    final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize];
        this.valueTable = new Object[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                K key = oldKeyTable[i];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public int hashCode() {
        int h = this.size;
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null) continue;
            h += key.hashCode();
            V value = valueTable[i];
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FuryObjectMap)) {
            return false;
        }
        FuryObjectMap other = (FuryObjectMap)obj;
        if (other.size != this.size) {
            return false;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            V value;
            K key = keyTable[i];
            if (key == null || !((value = valueTable[i]) == null ? other.get(key, dummy) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString(String separator) {
        return this.toString(separator, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String separator, boolean braces) {
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            K key = keyTable[i];
            if (key == null) continue;
            buffer.append(separator);
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            V value = valueTable[i];
            buffer.append((Object)(value == this ? "(this)" : value));
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public static int tableSize(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must be >= 0: " + capacity);
        }
        int tableSize = FuryObjectMap.nextPowerOfTwo(Math.max(2, (int)Math.ceil((float)capacity / loadFactor)));
        if (tableSize > 0x40000000) {
            throw new IllegalArgumentException("The required capacity is too large: " + capacity);
        }
        return tableSize;
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    private class MapIterator
    implements Iterator<Map.Entry<K, V>> {
        private int nextIndex;

        private MapIterator() {
        }

        @Override
        public boolean hasNext() {
            for (int i = this.nextIndex; i < FuryObjectMap.this.keyTable.length; ++i) {
                if (FuryObjectMap.this.keyTable[i] == null) continue;
                this.nextIndex = i;
                return true;
            }
            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            return new MapEntry(FuryObjectMap.this.keyTable[this.nextIndex], FuryObjectMap.this.valueTable[this.nextIndex++]);
        }
    }
}

