/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.Language;
import io.fury.collection.IdentityMap;
import io.fury.collection.LazyMap;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfoCache;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.ReplaceResolveSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.type.GenericType;
import io.fury.type.Generics;
import io.fury.type.TypeUtils;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class MapSerializers {
    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(HashMap.class, new HashMapSerializer(fury));
        fury.getClassResolver().registerSerializer(LinkedHashMap.class, new LinkedHashMapSerializer(fury));
        fury.registerSerializer(TreeMap.class, new SortedMapSerializer<TreeMap>(fury, TreeMap.class));
        fury.registerSerializer(Collections.EMPTY_MAP.getClass(), new EmptyMapSerializer(fury, Collections.EMPTY_MAP.getClass()));
        fury.registerSerializer(Collections.emptySortedMap().getClass(), new EmptySortedMapSerializer(fury, Collections.emptySortedMap().getClass()));
        fury.registerSerializer(Collections.singletonMap(null, null).getClass(), new SingletonMapSerializer(fury, Collections.singletonMap(null, null).getClass()));
        fury.registerSerializer(ConcurrentHashMap.class, new ConcurrentHashMapSerializer(fury, ConcurrentHashMap.class));
        fury.registerSerializer(ConcurrentSkipListMap.class, new ConcurrentSkipListMapSerializer(fury, ConcurrentSkipListMap.class));
        fury.registerSerializer(EnumMap.class, new EnumMapSerializer(fury, EnumMap.class));
        fury.registerSerializer(LazyMap.class, new LazyMapSerializer(fury));
    }

    public static final class HashMapSerializer
    extends MapSerializer<HashMap> {
        public HashMapSerializer(Fury fury) {
            super(fury, HashMap.class, true, false);
        }

        @Override
        public short getXtypeId() {
            return io.fury.type.Type.MAP.getId();
        }

        @Override
        public HashMap newMap(MemoryBuffer buffer, int size) {
            HashMap hashMap = new HashMap(size);
            this.fury.getRefResolver().reference(hashMap);
            return hashMap;
        }
    }

    public static final class LinkedHashMapSerializer
    extends MapSerializer<LinkedHashMap> {
        public LinkedHashMapSerializer(Fury fury) {
            super(fury, LinkedHashMap.class, true, false);
        }

        @Override
        public short getXtypeId() {
            return io.fury.type.Type.MAP.getId();
        }

        @Override
        public LinkedHashMap newMap(MemoryBuffer buffer, int size) {
            LinkedHashMap hashMap = new LinkedHashMap(size);
            this.fury.getRefResolver().reference(hashMap);
            return hashMap;
        }
    }

    public static class SortedMapSerializer<T extends SortedMap>
    extends MapSerializer<T> {
        private Constructor<?> constructor;

        public SortedMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, true, false);
            if (cls != TreeMap.class) {
                try {
                    this.constructor = cls.getConstructor(Comparator.class);
                    if (!this.constructor.isAccessible()) {
                        this.constructor.setAccessible(true);
                    }
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(e);
                }
            }
        }

        @Override
        public void writeHeader(MemoryBuffer buffer, T value) {
            this.fury.writeRef(buffer, value.comparator());
        }

        @Override
        public T newMap(MemoryBuffer buffer, int numElements) {
            SortedMap map;
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            if (this.type == TreeMap.class) {
                map = new TreeMap(comparator);
            } else {
                try {
                    map = (SortedMap)this.constructor.newInstance(comparator);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            this.fury.getRefResolver().reference(map);
            return (T)map;
        }
    }

    public static final class EmptyMapSerializer
    extends MapSerializer<Map<?, ?>> {
        public EmptyMapSerializer(Fury fury, Class<Map<?, ?>> cls) {
            super(fury, cls, false, false);
        }

        @Override
        public void write(MemoryBuffer buffer, Map<?, ?> value) {
        }

        @Override
        public short getXtypeId() {
            return -io.fury.type.Type.MAP.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Map<?, ?> value) {
            buffer.writePositiveVarInt(0);
        }

        @Override
        public Map<?, ?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_MAP;
        }

        @Override
        public Map<?, ?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            return Collections.EMPTY_MAP;
        }
    }

    public static final class EmptySortedMapSerializer
    extends MapSerializer<SortedMap<?, ?>> {
        public EmptySortedMapSerializer(Fury fury, Class<SortedMap<?, ?>> cls) {
            super(fury, cls, false, false);
        }

        @Override
        public void write(MemoryBuffer buffer, SortedMap<?, ?> value) {
        }

        @Override
        public SortedMap<?, ?> read(MemoryBuffer buffer) {
            return Collections.emptySortedMap();
        }
    }

    public static final class SingletonMapSerializer
    extends MapSerializer<Map<?, ?>> {
        public SingletonMapSerializer(Fury fury, Class<Map<?, ?>> cls) {
            super(fury, cls, false, false);
        }

        @Override
        public void write(MemoryBuffer buffer, Map<?, ?> value) {
            Map.Entry<?, ?> entry = value.entrySet().iterator().next();
            this.fury.writeRef(buffer, entry.getKey());
            this.fury.writeRef(buffer, entry.getValue());
        }

        @Override
        public short getXtypeId() {
            return -io.fury.type.Type.MAP.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Map<?, ?> value) {
            buffer.writePositiveVarInt(1);
            Map.Entry<?, ?> entry = value.entrySet().iterator().next();
            this.fury.xwriteRef(buffer, entry.getKey());
            this.fury.xwriteRef(buffer, entry.getValue());
        }

        @Override
        public Map<?, ?> read(MemoryBuffer buffer) {
            Object key = this.fury.readRef(buffer);
            Object value = this.fury.readRef(buffer);
            return Collections.singletonMap(key, value);
        }

        @Override
        public Map<?, ?> xread(MemoryBuffer buffer) {
            buffer.readPositiveVarInt();
            Object key = this.fury.xreadRef(buffer);
            Object value = this.fury.xreadRef(buffer);
            return Collections.singletonMap(key, value);
        }
    }

    public static final class ConcurrentHashMapSerializer
    extends MapSerializer<ConcurrentHashMap> {
        public ConcurrentHashMapSerializer(Fury fury, Class<ConcurrentHashMap> type) {
            super(fury, type, true, false);
        }

        @Override
        public ConcurrentHashMap newMap(MemoryBuffer buffer, int size) {
            ConcurrentHashMap map = new ConcurrentHashMap(size);
            this.fury.getRefResolver().reference(map);
            return map;
        }

        @Override
        public short getXtypeId() {
            return 0;
        }
    }

    public static final class ConcurrentSkipListMapSerializer
    extends SortedMapSerializer<ConcurrentSkipListMap> {
        public ConcurrentSkipListMapSerializer(Fury fury, Class<ConcurrentSkipListMap> cls) {
            super(fury, cls);
        }

        @Override
        public ConcurrentSkipListMap newMap(MemoryBuffer buffer, int numElements) {
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            ConcurrentSkipListMap map = new ConcurrentSkipListMap(comparator);
            this.fury.getRefResolver().reference(map);
            return map;
        }

        @Override
        public short getXtypeId() {
            return 0;
        }
    }

    public static class EnumMapSerializer
    extends MapSerializer<EnumMap> {
        private final long keyTypeFieldOffset;

        public EnumMapSerializer(Fury fury, Class<EnumMap> cls) {
            super(fury, cls, true, false);
            Field field = ReflectionUtils.getDeclaredField(EnumMap.class, "keyType");
            this.keyTypeFieldOffset = ReflectionUtils.getFieldOffset(field);
        }

        @Override
        public void writeHeader(MemoryBuffer buffer, EnumMap value) {
            Class keyType = (Class)Platform.getObject(value, this.keyTypeFieldOffset);
            this.fury.getClassResolver().writeClassAndUpdateCache(buffer, keyType);
        }

        @Override
        public EnumMap newMap(MemoryBuffer buffer, int numElements) {
            Class<?> keyType = this.fury.getClassResolver().readClassAndUpdateCache(buffer);
            return new EnumMap(keyType);
        }
    }

    public static final class LazyMapSerializer
    extends MapSerializer<LazyMap> {
        public LazyMapSerializer(Fury fury) {
            super(fury, LazyMap.class, true, false);
        }

        @Override
        public short getXtypeId() {
            return io.fury.type.Type.MAP.getId();
        }

        @Override
        public LazyMap newMap(MemoryBuffer buffer, int size) {
            LazyMap map = new LazyMap(size);
            this.fury.getRefResolver().reference((Object)map);
            return map;
        }
    }

    public static class JDKCompatibleMapSerializer<T extends Map>
    extends MapSerializer<T> {
        private final Serializer serializer;

        public JDKCompatibleMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false, false);
            Class serializerType = ClassResolver.useReplaceResolveSerializer(cls) ? ReplaceResolveSerializer.class : fury.getDefaultJDKStreamSerializerType();
            this.serializer = Serializers.newSerializer(fury, cls, serializerType);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)((Map)this.serializer.read(buffer));
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.serializer.write(buffer, value);
        }
    }

    public static final class DefaultJavaMapSerializer<T extends Map>
    extends MapSerializer<T> {
        private Serializer<T> dataSerializer;

        public DefaultJavaMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false, false);
            Preconditions.checkArgument((fury.getLanguage() == Language.JAVA ? 1 : 0) != 0, (Object)("Python default map serializer should use " + MapSerializer.class));
            fury.getClassResolver().setSerializer(cls, this);
            Class<? extends Serializer> serializerClass = fury.getClassResolver().getObjectSerializerClass(cls, sc -> {
                this.dataSerializer = Serializers.newSerializer(fury, cls, sc);
            });
            this.dataSerializer = Serializers.newSerializer(fury, cls, serializerClass);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.dataSerializer.write(buffer, value);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)((Map)this.dataSerializer.read(buffer));
        }
    }

    public static class MapSerializer<T extends Map>
    extends Serializer<T> {
        protected Constructor<?> constructor;
        protected final boolean supportCodegenHook;
        private Serializer keySerializer;
        private Serializer valueSerializer;
        protected final ClassInfoCache keyClassInfoWriteCache;
        protected final ClassInfoCache keyClassInfoReadCache;
        protected final ClassInfoCache valueClassInfoWriteCache;
        protected final ClassInfoCache valueClassInfoReadCache;
        private final IdentityMap<GenericType, Tuple2<GenericType, GenericType>> partialGenericKVTypeMap;
        private final GenericType mapGenericType;
        private final GenericType objType;

        public MapSerializer(Fury fury, Class<T> cls) {
            this(fury, cls, !ReflectionUtils.isDynamicGeneratedCLass(cls), true);
        }

        public MapSerializer(Fury fury, Class<T> cls, boolean supportCodegenHook, boolean inferGenerics) {
            super(fury, cls);
            this.objType = this.fury.getClassResolver().buildGenericType((Type)((Object)Object.class));
            this.supportCodegenHook = supportCodegenHook;
            this.keyClassInfoWriteCache = fury.getClassResolver().nilClassInfoCache();
            this.keyClassInfoReadCache = fury.getClassResolver().nilClassInfoCache();
            this.valueClassInfoWriteCache = fury.getClassResolver().nilClassInfoCache();
            this.valueClassInfoReadCache = fury.getClassResolver().nilClassInfoCache();
            this.partialGenericKVTypeMap = new IdentityMap();
            if (inferGenerics) {
                Tuple2<TypeToken<?>, TypeToken<?>> kvTypes = TypeUtils.getMapKeyValueType(TypeToken.of(cls));
                this.mapGenericType = TypeUtils.getRawType((TypeToken)kvTypes.f0) != Object.class || TypeUtils.getRawType((TypeToken)kvTypes.f1) != Object.class ? fury.getClassResolver().buildGenericType(TypeUtils.mapOf((TypeToken)kvTypes.f0, (TypeToken)kvTypes.f1).getType()) : null;
            } else {
                this.mapGenericType = null;
            }
        }

        public void setKeySerializer(Serializer keySerializer) {
            this.keySerializer = keySerializer;
        }

        public void setValueSerializer(Serializer valueSerializer) {
            this.valueSerializer = valueSerializer;
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            buffer.writePositiveVarInt(value.size());
            this.writeHeader(buffer, value);
            this.writeElements(this.fury, buffer, value);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            buffer.writePositiveVarInt(value.size());
            MapSerializer.xwriteElements(this.fury, buffer, value);
        }

        protected final void writeElements(Fury fury, MemoryBuffer buffer, T map) {
            Serializer keySerializer = this.keySerializer;
            Serializer valueSerializer = this.valueSerializer;
            this.keySerializer = null;
            this.valueSerializer = null;
            if (keySerializer != null && valueSerializer != null) {
                this.javaWriteWithKVSerializers(fury, buffer, map, keySerializer, valueSerializer);
            } else if (keySerializer != null) {
                ClassResolver classResolver = fury.getClassResolver();
                RefResolver refResolver = fury.getRefResolver();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    fury.writeRef(buffer, entry.getKey(), keySerializer);
                    Object value = entry.getValue();
                    this.writeJavaRefOptimized(fury, classResolver, refResolver, buffer, value, this.valueClassInfoWriteCache);
                }
            } else if (valueSerializer != null) {
                ClassResolver classResolver = fury.getClassResolver();
                RefResolver refResolver = fury.getRefResolver();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    Object key = entry.getKey();
                    this.writeJavaRefOptimized(fury, classResolver, refResolver, buffer, key, this.keyClassInfoWriteCache);
                    fury.writeRef(buffer, entry.getValue(), valueSerializer);
                }
            } else {
                this.genericJavaWrite(fury, buffer, map);
            }
        }

        protected final void simpleWriteElements(Fury fury, MemoryBuffer buffer, T map) {
            ClassInfoCache keyClassInfoWriteCache = this.keyClassInfoWriteCache;
            ClassInfoCache valueClassInfoWriteCache = this.valueClassInfoWriteCache;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                fury.writeRef(buffer, entry.getKey(), keyClassInfoWriteCache);
                fury.writeRef(buffer, entry.getValue(), valueClassInfoWriteCache);
            }
        }

        private void javaWriteWithKVSerializers(Fury fury, MemoryBuffer buffer, T map, Serializer keySerializer, Serializer valueSerializer) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                fury.writeRef(buffer, key, keySerializer);
                fury.writeRef(buffer, value, valueSerializer);
            }
        }

        private void genericJavaWrite(Fury fury, MemoryBuffer buffer, T map) {
            Generics generics = fury.getGenerics();
            GenericType genericType = generics.nextGenericType();
            if (genericType == null) {
                genericType = this.mapGenericType;
            }
            if (genericType == null) {
                this.generalJavaWrite(fury, buffer, map);
            } else {
                GenericType keyGenericType = genericType.getTypeParameter0();
                GenericType valueGenericType = genericType.getTypeParameter1();
                if (genericType.getTypeParametersCount() < 2) {
                    Tuple2<GenericType, GenericType> kvGenericType = this.getKVGenericType(genericType);
                    if (keyGenericType == this.objType && valueGenericType == this.objType) {
                        this.generalJavaWrite(fury, buffer, map);
                        return;
                    }
                    keyGenericType = (GenericType)kvGenericType.f0;
                    valueGenericType = (GenericType)kvGenericType.f1;
                }
                boolean keyGenericTypeFinal = keyGenericType.isFinal();
                boolean valueGenericTypeFinal = valueGenericType.isFinal();
                if (keyGenericTypeFinal && valueGenericTypeFinal) {
                    this.javaKVTypesFinalWrite(fury, buffer, map, keyGenericType, valueGenericType, generics);
                } else if (keyGenericTypeFinal) {
                    this.javaKeyTypeFinalWrite(fury, buffer, map, keyGenericType, valueGenericType, generics);
                } else if (valueGenericTypeFinal) {
                    this.javaValueTypeFinalWrite(fury, buffer, map, keyGenericType, valueGenericType, generics);
                } else {
                    this.javaKVTypesNonFinalWrite(fury, buffer, map, keyGenericType, valueGenericType, generics);
                }
            }
        }

        private void javaKVTypesFinalWrite(Fury fury, MemoryBuffer buffer, T map, GenericType keyGenericType, GenericType valueGenericType, Generics generics) {
            Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
            Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                generics.pushGenericType(keyGenericType);
                fury.writeRef(buffer, entry.getKey(), keySerializer);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                fury.writeRef(buffer, entry.getValue(), valueSerializer);
                generics.popGenericType();
            }
        }

        private void javaKeyTypeFinalWrite(Fury fury, MemoryBuffer buffer, T map, GenericType keyGenericType, GenericType valueGenericType, Generics generics) {
            ClassResolver classResolver = fury.getClassResolver();
            RefResolver refResolver = fury.getRefResolver();
            boolean trackingValueRef = fury.getClassResolver().needToWriteRef(valueGenericType.getCls());
            Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                generics.pushGenericType(keyGenericType);
                fury.writeRef(buffer, entry.getKey(), keySerializer);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                this.writeJavaRefOptimized(fury, classResolver, refResolver, trackingValueRef, buffer, entry.getValue(), this.valueClassInfoWriteCache);
                generics.popGenericType();
            }
        }

        private void javaValueTypeFinalWrite(Fury fury, MemoryBuffer buffer, T map, GenericType keyGenericType, GenericType valueGenericType, Generics generics) {
            ClassResolver classResolver = fury.getClassResolver();
            RefResolver refResolver = fury.getRefResolver();
            boolean trackingKeyRef = fury.getClassResolver().needToWriteRef(keyGenericType.getCls());
            Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                generics.pushGenericType(keyGenericType);
                this.writeJavaRefOptimized(fury, classResolver, refResolver, trackingKeyRef, buffer, entry.getKey(), this.keyClassInfoWriteCache);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                fury.writeRef(buffer, entry.getValue(), valueSerializer);
                generics.popGenericType();
            }
        }

        private void javaKVTypesNonFinalWrite(Fury fury, MemoryBuffer buffer, T map, GenericType keyGenericType, GenericType valueGenericType, Generics generics) {
            ClassResolver classResolver = fury.getClassResolver();
            RefResolver refResolver = fury.getRefResolver();
            boolean trackingKeyRef = fury.getClassResolver().needToWriteRef(keyGenericType.getCls());
            boolean trackingValueRef = fury.getClassResolver().needToWriteRef(valueGenericType.getCls());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                generics.pushGenericType(keyGenericType);
                this.writeJavaRefOptimized(fury, classResolver, refResolver, trackingKeyRef, buffer, entry.getKey(), this.keyClassInfoWriteCache);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                this.writeJavaRefOptimized(fury, classResolver, refResolver, trackingValueRef, buffer, entry.getValue(), this.valueClassInfoWriteCache);
                generics.popGenericType();
            }
        }

        private void generalJavaWrite(Fury fury, MemoryBuffer buffer, T map) {
            ClassResolver classResolver = fury.getClassResolver();
            RefResolver refResolver = fury.getRefResolver();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                this.writeJavaRefOptimized(fury, classResolver, refResolver, buffer, entry.getKey(), this.keyClassInfoWriteCache);
                this.writeJavaRefOptimized(fury, classResolver, refResolver, buffer, entry.getValue(), this.valueClassInfoWriteCache);
            }
        }

        public static void xwriteElements(Fury fury, MemoryBuffer buffer, Map value) {
            Generics generics = fury.getGenerics();
            GenericType genericType = generics.nextGenericType();
            if (genericType == null || genericType.getTypeParametersCount() != 2) {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    fury.xwriteRef(buffer, entry.getKey());
                    fury.xwriteRef(buffer, entry.getValue());
                }
            } else {
                GenericType keyGenericType = genericType.getTypeParameter0();
                GenericType valueGenericType = genericType.getTypeParameter1();
                Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
                Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
                if (!keyGenericType.hasGenericParameters() && !valueGenericType.hasGenericParameters()) {
                    Iterator iterator = value.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry object;
                        Map.Entry entry = object = iterator.next();
                        fury.xwriteRefByNullableSerializer(buffer, entry.getKey(), keySerializer);
                        fury.xwriteRefByNullableSerializer(buffer, entry.getValue(), valueSerializer);
                    }
                } else if (valueGenericType.hasGenericParameters()) {
                    Iterator iterator = value.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry object;
                        Map.Entry entry = object = iterator.next();
                        fury.xwriteRefByNullableSerializer(buffer, entry.getKey(), keySerializer);
                        generics.pushGenericType(valueGenericType);
                        fury.xwriteRefByNullableSerializer(buffer, entry.getValue(), valueSerializer);
                        generics.popGenericType();
                    }
                } else if (keyGenericType.hasGenericParameters()) {
                    Iterator iterator = value.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry object;
                        Map.Entry entry = object = iterator.next();
                        generics.pushGenericType(keyGenericType);
                        fury.xwriteRefByNullableSerializer(buffer, entry.getKey(), keySerializer);
                        generics.popGenericType();
                        fury.xwriteRefByNullableSerializer(buffer, entry.getValue(), valueSerializer);
                    }
                } else {
                    Iterator iterator = value.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry object;
                        Map.Entry entry = object = iterator.next();
                        generics.pushGenericType(keyGenericType);
                        fury.xwriteRefByNullableSerializer(buffer, entry.getKey(), keySerializer);
                        generics.pushGenericType(valueGenericType);
                        fury.xwriteRefByNullableSerializer(buffer, entry.getValue(), valueSerializer);
                    }
                }
                generics.popGenericType();
            }
        }

        private Tuple2<GenericType, GenericType> getKVGenericType(GenericType genericType) {
            Tuple2<GenericType, GenericType> genericTypes = this.partialGenericKVTypeMap.get(genericType);
            if (genericTypes == null) {
                TypeToken<?> typeToken = genericType.getTypeToken();
                if (!TypeUtils.MAP_TYPE.isSupertypeOf(typeToken)) {
                    Tuple2<GenericType, GenericType> typeTuple = Tuple2.of(this.objType, this.objType);
                    this.partialGenericKVTypeMap.put(genericType, typeTuple);
                    return typeTuple;
                }
                Tuple2<TypeToken<?>, TypeToken<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeToken);
                genericTypes = Tuple2.of(this.fury.getClassResolver().buildGenericType(((TypeToken)mapKeyValueType.f0).getType()), this.fury.getClassResolver().buildGenericType(((TypeToken)mapKeyValueType.f1).getType()));
                this.partialGenericKVTypeMap.put(genericType, genericTypes);
            }
            return genericTypes;
        }

        @Override
        public T read(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            T map = this.newMap(buffer, size);
            this.readElements(buffer, size, map);
            return map;
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            int size = buffer.readPositiveVarInt();
            T map = this.newMap(buffer, size);
            MapSerializer.xreadElements(this.fury, buffer, map, size);
            return map;
        }

        protected final void readElements(MemoryBuffer buffer, int size, T map) {
            Serializer keySerializer = this.keySerializer;
            Serializer valueSerializer = this.valueSerializer;
            this.keySerializer = null;
            this.valueSerializer = null;
            if (keySerializer != null && valueSerializer != null) {
                for (int i = 0; i < size; ++i) {
                    Object key = this.fury.readRef(buffer, keySerializer);
                    Object value = this.fury.readRef(buffer, valueSerializer);
                    map.put(key, value);
                }
            } else if (keySerializer != null) {
                for (int i = 0; i < size; ++i) {
                    Object key = this.fury.readRef(buffer, keySerializer);
                    map.put(key, (Object)this.fury.readRef(buffer, this.keyClassInfoReadCache));
                }
            } else if (valueSerializer != null) {
                for (int i = 0; i < size; ++i) {
                    Object key = this.fury.readRef(buffer);
                    Object value = this.fury.readRef(buffer, valueSerializer);
                    map.put((Object)key, value);
                }
            } else {
                this.genericJavaRead(this.fury, buffer, map, size);
            }
        }

        private void genericJavaRead(Fury fury, MemoryBuffer buffer, T map, int size) {
            Generics generics = fury.getGenerics();
            GenericType genericType = generics.nextGenericType();
            if (genericType == null) {
                genericType = this.mapGenericType;
            }
            if (genericType == null) {
                this.generalJavaRead(fury, buffer, map, size);
            } else {
                GenericType keyGenericType = genericType.getTypeParameter0();
                GenericType valueGenericType = genericType.getTypeParameter1();
                if (genericType.getTypeParametersCount() < 2) {
                    Tuple2<GenericType, GenericType> kvGenericType = this.getKVGenericType(genericType);
                    if (keyGenericType == this.objType && valueGenericType == this.objType) {
                        this.generalJavaRead(fury, buffer, map, size);
                        return;
                    }
                    keyGenericType = (GenericType)kvGenericType.f0;
                    valueGenericType = (GenericType)kvGenericType.f1;
                }
                boolean keyGenericTypeFinal = keyGenericType.isFinal();
                boolean valueGenericTypeFinal = valueGenericType.isFinal();
                if (keyGenericTypeFinal && valueGenericTypeFinal) {
                    this.javaKVTypesFinalRead(fury, buffer, map, keyGenericType, valueGenericType, generics, size);
                } else if (keyGenericTypeFinal) {
                    this.javaKeyTypeFinalRead(fury, buffer, map, keyGenericType, valueGenericType, generics, size);
                } else if (valueGenericTypeFinal) {
                    this.javaValueTypeFinalRead(fury, buffer, map, keyGenericType, valueGenericType, generics, size);
                } else {
                    this.javaKVTypesNonFinalRead(fury, buffer, map, keyGenericType, valueGenericType, generics, size);
                }
                generics.popGenericType();
            }
        }

        private void javaKVTypesFinalRead(Fury fury, MemoryBuffer buffer, T map, GenericType keyGenericType, GenericType valueGenericType, Generics generics, int size) {
            Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
            Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
            for (int i = 0; i < size; ++i) {
                generics.pushGenericType(keyGenericType);
                Object key = fury.readRef(buffer, keySerializer);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                Object value = fury.readRef(buffer, valueSerializer);
                generics.popGenericType();
                map.put(key, value);
            }
        }

        private void javaKeyTypeFinalRead(Fury fury, MemoryBuffer buffer, T map, GenericType keyGenericType, GenericType valueGenericType, Generics generics, int size) {
            RefResolver refResolver = fury.getRefResolver();
            boolean trackingValueRef = fury.getClassResolver().needToWriteRef(valueGenericType.getCls());
            Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
            for (int i = 0; i < size; ++i) {
                generics.pushGenericType(keyGenericType);
                Object key = fury.readRef(buffer, keySerializer);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                Object value = this.readJavaRefOptimized(fury, refResolver, trackingValueRef, buffer, this.valueClassInfoWriteCache);
                generics.popGenericType();
                map.put(key, (Object)value);
            }
        }

        private void javaValueTypeFinalRead(Fury fury, MemoryBuffer buffer, T map, GenericType keyGenericType, GenericType valueGenericType, Generics generics, int size) {
            boolean trackingKeyRef = fury.getClassResolver().needToWriteRef(keyGenericType.getCls());
            Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
            RefResolver refResolver = fury.getRefResolver();
            for (int i = 0; i < size; ++i) {
                generics.pushGenericType(keyGenericType);
                Object key = this.readJavaRefOptimized(fury, refResolver, trackingKeyRef, buffer, this.keyClassInfoWriteCache);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                Object value = fury.readRef(buffer, valueSerializer);
                generics.popGenericType();
                map.put((Object)key, value);
            }
        }

        private void javaKVTypesNonFinalRead(Fury fury, MemoryBuffer buffer, T map, GenericType keyGenericType, GenericType valueGenericType, Generics generics, int size) {
            ClassResolver classResolver = fury.getClassResolver();
            RefResolver refResolver = fury.getRefResolver();
            boolean trackingKeyRef = classResolver.needToWriteRef(keyGenericType.getCls());
            boolean trackingValueRef = classResolver.needToWriteRef(valueGenericType.getCls());
            for (int i = 0; i < size; ++i) {
                generics.pushGenericType(keyGenericType);
                Object key = this.readJavaRefOptimized(fury, refResolver, trackingKeyRef, buffer, this.keyClassInfoWriteCache);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                Object value = this.readJavaRefOptimized(fury, refResolver, trackingValueRef, buffer, this.valueClassInfoWriteCache);
                generics.popGenericType();
                map.put((Object)key, (Object)value);
            }
        }

        private void generalJavaRead(Fury fury, MemoryBuffer buffer, T map, int size) {
            for (int i = 0; i < size; ++i) {
                Object key = fury.readRef(buffer, this.keyClassInfoReadCache);
                Object value = fury.readRef(buffer, this.valueClassInfoReadCache);
                map.put((Object)key, (Object)value);
            }
        }

        public static void xreadElements(Fury fury, MemoryBuffer buffer, Map map, int size) {
            Generics generics = fury.getGenerics();
            GenericType genericType = generics.nextGenericType();
            if (genericType == null || genericType.getTypeParametersCount() != 2) {
                for (int i = 0; i < size; ++i) {
                    Object key = fury.xreadRef(buffer);
                    Object value = fury.xreadRef(buffer);
                    map.put(key, value);
                }
            } else {
                GenericType keyGenericType = genericType.getTypeParameter0();
                GenericType valueGenericType = genericType.getTypeParameter1();
                Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
                Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
                if (!keyGenericType.hasGenericParameters() && !valueGenericType.hasGenericParameters()) {
                    for (int i = 0; i < size; ++i) {
                        Object key = fury.xreadRefByNullableSerializer(buffer, keySerializer);
                        Object value = fury.xreadRefByNullableSerializer(buffer, valueSerializer);
                        map.put(key, value);
                    }
                } else if (valueGenericType.hasGenericParameters()) {
                    for (int i = 0; i < size; ++i) {
                        Object key = fury.xreadRefByNullableSerializer(buffer, keySerializer);
                        generics.pushGenericType(valueGenericType);
                        Object value = fury.xreadRefByNullableSerializer(buffer, valueSerializer);
                        generics.popGenericType();
                        map.put(key, value);
                    }
                } else if (keyGenericType.hasGenericParameters()) {
                    for (int i = 0; i < size; ++i) {
                        generics.pushGenericType(keyGenericType);
                        Object key = fury.xreadRefByNullableSerializer(buffer, keySerializer);
                        generics.popGenericType();
                        Object value = fury.xreadRefByNullableSerializer(buffer, valueSerializer);
                        map.put(key, value);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        generics.pushGenericType(keyGenericType);
                        Object key = fury.xreadRefByNullableSerializer(buffer, keySerializer);
                        generics.pushGenericType(valueGenericType);
                        Object value = fury.xreadRefByNullableSerializer(buffer, valueSerializer);
                        map.put(key, value);
                    }
                }
                generics.popGenericType();
            }
        }

        public final boolean supportCodegenHook() {
            return this.supportCodegenHook;
        }

        public void writeHeader(MemoryBuffer buffer, T value) {
        }

        public T newMap(MemoryBuffer buffer, int numElements) {
            if (this.constructor == null) {
                this.constructor = ReflectionUtils.newAccessibleNoArgConstructor(this.type);
            }
            try {
                Map instance = (Map)this.constructor.newInstance(new Object[0]);
                this.fury.getRefResolver().reference(instance);
                return (T)instance;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
            }
        }

        private void writeJavaRefOptimized(Fury fury, ClassResolver classResolver, RefResolver refResolver, MemoryBuffer buffer, Object obj, ClassInfoCache classInfoCache) {
            if (!refResolver.writeNullFlag(buffer, obj)) {
                fury.writeRef(buffer, obj, classResolver.getClassInfo(obj.getClass(), classInfoCache));
            }
        }

        private void writeJavaRefOptimized(Fury fury, ClassResolver classResolver, RefResolver refResolver, boolean trackingRef, MemoryBuffer buffer, Object obj, ClassInfoCache classInfoCache) {
            if (trackingRef) {
                if (!refResolver.writeNullFlag(buffer, obj)) {
                    fury.writeRef(buffer, obj, classResolver.getClassInfo(obj.getClass(), classInfoCache));
                }
            } else if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                fury.writeNonRef(buffer, obj, classResolver.getClassInfo(obj.getClass(), classInfoCache));
            }
        }

        private Object readJavaRefOptimized(Fury fury, RefResolver refResolver, boolean trackingRef, MemoryBuffer buffer, ClassInfoCache classInfoCache) {
            if (trackingRef) {
                int nextReadRefId = refResolver.tryPreserveRefId(buffer);
                if (nextReadRefId >= -1) {
                    Object obj = fury.readNonRef(buffer, classInfoCache);
                    refResolver.setReadObject(nextReadRefId, obj);
                    return obj;
                }
                return refResolver.getReadObject();
            }
            byte headFlag = buffer.readByte();
            if (headFlag == -3) {
                return null;
            }
            return fury.readNonRef(buffer, classInfoCache);
        }
    }
}

