/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.base.Preconditions;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.CompileUnit;
import io.fury.codegen.JaninoUtils;
import io.fury.type.Descriptor;
import io.fury.util.ClassLoaderUtils;
import io.fury.util.LoggerFactory;
import io.fury.util.ReflectionUtils;
import io.fury.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;

public class AccessorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AccessorHelper.class);
    private static final WeakHashMap<Class<?>, Boolean> defineAccessorStatus = new WeakHashMap();
    private static final WeakHashMap<Class<?>, Object> defineAccessorLock = new WeakHashMap();
    private static final Object defineLock = new Object();
    private static final String OBJ_NAME = "obj";
    private static final String FIELD_VALUE = "fieldValue";

    public static String accessorClassName(Class<?> beanClass) {
        String name = ReflectionUtils.getClassNameWithoutPackage(beanClass) + "FuryAccessor_" + CodeGenerator.getClassUniqueId(beanClass);
        return name.replace("$", "_");
    }

    public static String qualifiedAccessorClassName(Class<?> beanClass) {
        String pkgName = CodeGenerator.getPackage(beanClass);
        if (StringUtils.isNotBlank(pkgName)) {
            return pkgName + "." + AccessorHelper.accessorClassName(beanClass);
        }
        return AccessorHelper.accessorClassName(beanClass);
    }

    public static String genCode(Class<?> beanClass) {
        CodegenContext ctx = new CodegenContext();
        ctx.setPackage(CodeGenerator.getPackage(beanClass));
        String className = AccessorHelper.accessorClassName(beanClass);
        ctx.setClassName(className);
        Collection<Descriptor> descriptors = Descriptor.getAllDescriptorsMap(beanClass, false).values();
        for (Descriptor descriptor : descriptors) {
            if (Modifier.isPrivate(descriptor.getModifiers())) continue;
            String methodName = descriptor.getName();
            String codeBody = StringUtils.format("return ${obj}.${fieldName};", OBJ_NAME, OBJ_NAME, "fieldName", descriptor.getName());
            Class<?> returnType = descriptor.getRawType();
            ctx.addStaticMethod(methodName, codeBody, returnType, beanClass, OBJ_NAME);
            methodName = descriptor.getName();
            codeBody = StringUtils.format("${obj}.${fieldName} = ${fieldValue};", OBJ_NAME, OBJ_NAME, "fieldName", descriptor.getName(), FIELD_VALUE, FIELD_VALUE);
            ctx.addStaticMethod(methodName, codeBody, Void.TYPE, beanClass, OBJ_NAME, descriptor.getRawType(), FIELD_VALUE);
        }
        return ctx.genCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean defineAccessorClass(Class<?> beanClass) {
        ClassLoader classLoader = beanClass.getClassLoader();
        if (classLoader == null) {
            return false;
        }
        String qualifiedClassName = AccessorHelper.qualifiedAccessorClassName(beanClass);
        try {
            classLoader.loadClass(qualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            Object lock;
            Object object = defineLock;
            synchronized (object) {
                if (defineAccessorStatus.containsKey(beanClass)) {
                    return defineAccessorStatus.get(beanClass);
                }
                lock = AccessorHelper.getDefineLock(beanClass);
            }
            object = lock;
            synchronized (object) {
                if (defineAccessorStatus.containsKey(beanClass)) {
                    return defineAccessorStatus.get(beanClass);
                }
                long startTime = System.nanoTime();
                String code = AccessorHelper.genCode(beanClass);
                long durationMs = (System.nanoTime() - startTime) / 1000000L;
                startTime = System.nanoTime();
                LOG.info("Generate code {} take {} ms", (Object)qualifiedClassName, (Object)durationMs);
                String pkg = CodeGenerator.getPackage(beanClass);
                CompileUnit compileUnit = new CompileUnit(pkg, AccessorHelper.accessorClassName(beanClass), code);
                Map<String, byte[]> classByteCodes = JaninoUtils.toBytecode(classLoader, compileUnit);
                durationMs = (System.nanoTime() - startTime) / 1000000L;
                LOG.info("Compile {} take {} ms", (Object)qualifiedClassName, (Object)durationMs);
                boolean succeed = ClassLoaderUtils.tryDefineClassesInClassLoader(qualifiedClassName, beanClass, classLoader, classByteCodes.values().iterator().next()) != null;
                defineAccessorStatus.put(beanClass, succeed);
                if (!succeed) {
                    LOG.info("Define accessor {} in classloader {} failed.", (Object)qualifiedClassName, (Object)classLoader);
                }
                return succeed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getDefineLock(Class<?> clazz) {
        Object object = defineLock;
        synchronized (object) {
            return defineAccessorLock.computeIfAbsent(clazz, k -> new Object());
        }
    }

    public static Class<?> getAccessorClass(Class<?> beanClass) {
        Preconditions.checkArgument((boolean)AccessorHelper.defineAccessorClass(beanClass));
        ClassLoader classLoader = beanClass.getClassLoader();
        String qualifiedClassName = AccessorHelper.qualifiedAccessorClassName(beanClass);
        try {
            return classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("unreachable code", e);
        }
    }

    public static Class<?> getAccessorClass(Field field) {
        Class<?> beanClass = field.getDeclaringClass();
        return AccessorHelper.getAccessorClass(beanClass);
    }

    public static Class<?> getAccessorClass(Method method) {
        Class<?> beanClass = method.getDeclaringClass();
        return AccessorHelper.getAccessorClass(beanClass);
    }

    public static boolean defineAccessor(Field field) {
        Class<?> beanClass = field.getDeclaringClass();
        return AccessorHelper.defineAccessorClass(beanClass);
    }

    public static boolean defineAccessor(Method method) {
        Class<?> beanClass = method.getDeclaringClass();
        return AccessorHelper.defineAccessorClass(beanClass);
    }
}

