/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util.unsafe;

import io.fury.util.Platform;
import io.fury.util.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class _Collections {
    private static final long ARRAY_LIST_SIZE_OFFSET;
    private static final long ARRAY_LIST_ARRAY_OFFSET;

    public static void setArrayListElements(ArrayList list, Object[] elements) {
        if (ARRAY_LIST_SIZE_OFFSET != -1L) {
            Platform.putInt(list, ARRAY_LIST_SIZE_OFFSET, elements.length);
            Platform.putObject(list, ARRAY_LIST_ARRAY_OFFSET, elements);
        } else {
            for (Object element : elements) {
                list.add(element);
            }
        }
    }

    static {
        Field arrayListSizeField = null;
        Field arrayListArrayField = null;
        try {
            arrayListSizeField = ArrayList.class.getDeclaredField("size");
            arrayListArrayField = ArrayList.class.getDeclaredField("elementData");
        }
        catch (NoSuchFieldException e) {
            Utils.ignore(e);
        }
        if (arrayListSizeField != null && arrayListArrayField != null) {
            ARRAY_LIST_SIZE_OFFSET = Platform.objectFieldOffset(arrayListSizeField);
            ARRAY_LIST_ARRAY_OFFSET = Platform.objectFieldOffset(arrayListArrayField);
        } else {
            ARRAY_LIST_SIZE_OFFSET = -1L;
            ARRAY_LIST_ARRAY_OFFSET = -1L;
        }
    }
}

