/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.JavaSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import io.fury.util.unsafe._JDKAccess;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;

public class ReplaceResolveSerializer
extends Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceResolveSerializer.class);
    private static final byte ORIGINAL = 0;
    private static final byte REPLACED_NEW_TYPE = 1;
    private static final byte REPLACED_SAME_TYPE = 2;
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final JDKReplaceResolveMethodInfoCache jdkMethodInfoWriteCache;
    private final ClassInfo writeClassInfo;
    private final Map<Class<?>, JDKReplaceResolveMethodInfoCache> classClassInfoCacheMap = new HashMap();

    static JDKReplaceResolveMethodInfoCache newJDKMethodInfoCache(Class<?> cls, Fury fury) {
        Method readObjectMethod;
        Method writeObjectMethod;
        Method readResolveMethod;
        Method writeReplaceMethod;
        if (Serializable.class.isAssignableFrom(cls)) {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(cls);
            writeReplaceMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "writeReplaceMethod");
            readResolveMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "readResolveMethod");
            writeObjectMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "writeObjectMethod");
            readObjectMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "readObjectMethod");
        } else {
            writeReplaceMethod = JavaSerializer.getWriteReplaceMethod(cls);
            readResolveMethod = JavaSerializer.getReadResolveMethod(cls);
            writeObjectMethod = JavaSerializer.getWriteObjectMethod(cls);
            readObjectMethod = JavaSerializer.getReadObjectMethod(cls);
            if (writeReplaceMethod != null) {
                LOG.warn("{} doesn't implement {}, but defined writeReplace method {}", new Object[]{cls, Serializable.class, writeReplaceMethod});
            }
            if (readResolveMethod != null) {
                LOG.warn("{} doesn't implement {}, but defined readResolve method {}", new Object[]{cls, Serializable.class, readResolveMethod});
            }
        }
        JDKReplaceResolveMethodInfoCache methodInfoCache = new JDKReplaceResolveMethodInfoCache(writeReplaceMethod, readResolveMethod, null);
        boolean hasJDKWriteObjectMethod = writeObjectMethod != null;
        boolean hasJDKReadObjectMethod = readObjectMethod != null;
        Class<? extends Serializer> serializerClass = !hasJDKWriteObjectMethod && !hasJDKReadObjectMethod ? fury.getClassResolver().getObjectSerializerClass(cls, sc -> methodInfoCache.setObjectSerializer(ReplaceResolveSerializer.createDataSerializer(fury, cls, sc))) : fury.getDefaultJDKStreamSerializerType();
        methodInfoCache.setObjectSerializer(ReplaceResolveSerializer.createDataSerializer(fury, cls, serializerClass));
        return methodInfoCache;
    }

    private static Serializer createDataSerializer(Fury fury, Class<?> cls, Class<? extends Serializer> sc) {
        Serializer<?> prev = fury.getClassResolver().getSerializer(cls, false);
        Serializer serializer = Serializers.newSerializer(fury, cls, sc);
        fury.getClassResolver().resetSerializer(cls, prev);
        return serializer;
    }

    public ReplaceResolveSerializer(Fury fury, Class type) {
        super(fury, type);
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.classResolver.setSerializerIfAbsent(type, this);
        if (type != ReplaceStub.class) {
            this.jdkMethodInfoWriteCache = ReplaceResolveSerializer.newJDKMethodInfoCache(type, fury);
            this.classClassInfoCacheMap.put(type, this.jdkMethodInfoWriteCache);
            this.writeClassInfo = this.classResolver.newClassInfo(type, this, (short)0);
        } else {
            this.jdkMethodInfoWriteCache = null;
            this.writeClassInfo = null;
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        JDKReplaceResolveMethodInfoCache jdkMethodInfoCache = this.jdkMethodInfoWriteCache;
        Method writeReplaceMethod = jdkMethodInfoCache.writeReplaceMethod;
        if (writeReplaceMethod != null) {
            Object original = value;
            if ((value = jdkMethodInfoCache.writeReplace(value)) == null || value.getClass() != this.type) {
                buffer.writeByte((byte)1);
                if (!this.refResolver.writeRefOrNull(buffer, value)) {
                    this.refResolver.replaceRef(original, value);
                    this.fury.writeNonRef(buffer, value);
                }
            } else if (value != original) {
                buffer.writeByte((byte)2);
                if (!this.refResolver.writeRefOrNull(buffer, value)) {
                    this.refResolver.replaceRef(original, value);
                    this.writeObject(buffer, value, jdkMethodInfoCache);
                }
            } else {
                buffer.writeByte((byte)0);
                this.writeObject(buffer, value, jdkMethodInfoCache);
            }
        } else {
            buffer.writeByte((byte)0);
            this.writeObject(buffer, value, jdkMethodInfoCache);
        }
    }

    private void writeObject(MemoryBuffer buffer, Object value, JDKReplaceResolveMethodInfoCache jdkMethodInfoCache) {
        this.classResolver.writeClass(buffer, this.writeClassInfo);
        jdkMethodInfoCache.objectSerializer.write(buffer, value);
    }

    public Object read(MemoryBuffer buffer) {
        byte flag = buffer.readByte();
        RefResolver refResolver = this.refResolver;
        if (flag == 1) {
            int outerRefId = refResolver.lastPreservedRefId();
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.fury.readData(buffer, this.classResolver.readAndUpdateClassInfoCache(buffer));
                refResolver.setReadObject(nextReadRefId, o);
                refResolver.setReadObject(outerRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        if (flag == 2) {
            int outerRefId = refResolver.lastPreservedRefId();
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.readObject(buffer);
                refResolver.setReadObject(nextReadRefId, o);
                refResolver.setReadObject(outerRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        Preconditions.checkArgument((flag == 0 ? 1 : 0) != 0);
        return this.readObject(buffer);
    }

    private Object readObject(MemoryBuffer buffer) {
        Class<?> cls = this.classResolver.readClassInternal(buffer);
        JDKReplaceResolveMethodInfoCache jdkMethodInfoCache = this.classClassInfoCacheMap.get(cls);
        if (jdkMethodInfoCache == null) {
            jdkMethodInfoCache = ReplaceResolveSerializer.newJDKMethodInfoCache(cls, this.fury);
            this.classClassInfoCacheMap.put(cls, jdkMethodInfoCache);
        }
        Object o = jdkMethodInfoCache.objectSerializer.read(buffer);
        Method readResolveMethod = jdkMethodInfoCache.readResolveMethod;
        if (readResolveMethod != null) {
            if (jdkMethodInfoCache.readResolveFunc != null) {
                return jdkMethodInfoCache.readResolveFunc.apply(o);
            }
            try {
                return readResolveMethod.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                Platform.throwException(e);
                throw new IllegalStateException("unreachable");
            }
        }
        return o;
    }

    static class JDKReplaceResolveMethodInfoCache {
        private final Method writeReplaceMethod;
        private final Method readResolveMethod;
        private final Function writeReplaceFunc;
        private final Function readResolveFunc;
        private Serializer objectSerializer;

        private JDKReplaceResolveMethodInfoCache(Method writeReplaceMethod, Method readResolveMethod, Serializer objectSerializer) {
            Function readResolveFunc;
            Function writeReplaceFunc;
            block6: {
                this.writeReplaceMethod = writeReplaceMethod;
                this.readResolveMethod = readResolveMethod;
                Class<?> declaringClass = writeReplaceMethod != null ? writeReplaceMethod.getDeclaringClass() : (readResolveMethod != null ? readResolveMethod.getDeclaringClass() : null);
                writeReplaceFunc = null;
                readResolveFunc = null;
                if (declaringClass != null) {
                    MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(declaringClass);
                    try {
                        if (writeReplaceMethod != null) {
                            writeReplaceFunc = _JDKAccess.makeJDKFunction(lookup, lookup.unreflect(writeReplaceMethod));
                        }
                        if (readResolveMethod != null) {
                            readResolveFunc = _JDKAccess.makeJDKFunction(lookup, lookup.unreflect(readResolveMethod));
                        }
                    }
                    catch (Exception e) {
                        if (writeReplaceMethod != null && !writeReplaceMethod.isAccessible()) {
                            writeReplaceMethod.setAccessible(true);
                        }
                        if (readResolveMethod == null || readResolveMethod.isAccessible()) break block6;
                        readResolveMethod.setAccessible(true);
                    }
                }
            }
            this.writeReplaceFunc = writeReplaceFunc;
            this.readResolveFunc = readResolveFunc;
            this.objectSerializer = objectSerializer;
        }

        Object writeReplace(Object o) {
            if (this.writeReplaceFunc != null) {
                return this.writeReplaceFunc.apply(o);
            }
            try {
                return this.writeReplaceMethod.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                Platform.throwException(e);
                throw new IllegalStateException(e);
            }
        }

        public void setObjectSerializer(Serializer objectSerializer) {
            this.objectSerializer = objectSerializer;
        }
    }

    public static class ReplaceStub {
    }
}

