/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util;

import com.google.common.base.Preconditions;
import io.fury.type.TypeUtils;
import io.fury.util.UnsafeFieldAccessor;
import java.lang.reflect.Field;

public abstract class FieldAccessor {
    protected final Field field;
    protected final UnsafeFieldAccessor unsafeFieldAccessor;

    public FieldAccessor(Field field) {
        this.field = field;
        this.unsafeFieldAccessor = new UnsafeFieldAccessor(field);
    }

    public abstract Object get(Object var1);

    public abstract void set(Object var1, Object var2);

    public Field getField() {
        return this.field;
    }

    void checkObj(Object obj) {
        if (!this.field.getDeclaringClass().isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Illegal class " + obj.getClass());
        }
    }

    public static FieldAccessor createAccessor(Field field) {
        if (field.getType() == Boolean.TYPE) {
            return new BooleanAccessor(field);
        }
        if (field.getType() == Byte.TYPE) {
            return new ByteAccessor(field);
        }
        if (field.getType() == Character.TYPE) {
            return new CharAccessor(field);
        }
        if (field.getType() == Short.TYPE) {
            return new ShortAccessor(field);
        }
        if (field.getType() == Integer.TYPE) {
            return new IntAccessor(field);
        }
        if (field.getType() == Long.TYPE) {
            return new LongAccessor(field);
        }
        if (field.getType() == Float.TYPE) {
            return new FloatAccessor(field);
        }
        if (field.getType() == Double.TYPE) {
            return new DoubleAccessor(field);
        }
        return new ObjectAccessor(field);
    }

    public static class BooleanAccessor
    extends FieldAccessor {
        public BooleanAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((field.getType() == Boolean.TYPE ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return this.unsafeFieldAccessor.getBoolean(obj);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putBoolean(obj, (Boolean)value);
        }
    }

    public static class ByteAccessor
    extends FieldAccessor {
        public ByteAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((field.getType() == Byte.TYPE ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return this.unsafeFieldAccessor.getByte(obj);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putByte(obj, (Byte)value);
        }
    }

    public static class CharAccessor
    extends FieldAccessor {
        public CharAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((field.getType() == Character.TYPE ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return Character.valueOf(this.unsafeFieldAccessor.getChar(obj));
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putChar(obj, ((Character)value).charValue());
        }
    }

    public static class ShortAccessor
    extends FieldAccessor {
        public ShortAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((field.getType() == Short.TYPE ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return this.unsafeFieldAccessor.getShort(obj);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putShort(obj, (Short)value);
        }
    }

    public static class IntAccessor
    extends FieldAccessor {
        public IntAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((field.getType() == Integer.TYPE ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return this.unsafeFieldAccessor.getInt(obj);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putInt(obj, (Integer)value);
        }
    }

    public static class LongAccessor
    extends FieldAccessor {
        public LongAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((field.getType() == Long.TYPE ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return this.unsafeFieldAccessor.getLong(obj);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putLong(obj, (Long)value);
        }
    }

    public static class FloatAccessor
    extends FieldAccessor {
        public FloatAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((field.getType() == Float.TYPE ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return Float.valueOf(this.unsafeFieldAccessor.getFloat(obj));
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putFloat(obj, ((Float)value).floatValue());
        }
    }

    public static class DoubleAccessor
    extends FieldAccessor {
        public DoubleAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((field.getType() == Double.TYPE ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return this.unsafeFieldAccessor.getDouble(obj);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putDouble(obj, (Double)value);
        }
    }

    public static class ObjectAccessor
    extends FieldAccessor {
        public ObjectAccessor(Field field) {
            super(field);
            Preconditions.checkArgument((!TypeUtils.isPrimitive(field.getType()) ? 1 : 0) != 0);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return this.unsafeFieldAccessor.getObject(obj);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            this.unsafeFieldAccessor.putObject(obj, value);
        }
    }
}

