/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.fury.Fury;
import io.fury.annotation.Internal;
import io.fury.codegen.CodeGenerator;
import io.fury.util.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JITContext {
    private final Fury fury;
    private final boolean asyncCompilationEnabled;
    private final ReentrantLock jitLock;
    private int furyVisitState;
    private int numRunningTask;
    private final Map<Object, List<NotifyCallback>> hasJITResult;

    public JITContext(Fury fury) {
        this.fury = fury;
        this.asyncCompilationEnabled = fury.getConfig().isAsyncCompilationEnabled();
        this.jitLock = new ReentrantLock(true);
        this.hasJITResult = new HashMap<Object, List<NotifyCallback>>();
    }

    @Internal
    public <T> T registerSerializerJITCallback(Callable<T> interpreterModeAction, Callable<T> jitAction, final SerializerJITCallback<T> callback) {
        try {
            this.lock();
            if (this.fury.getConfig().isCodeGenEnabled()) {
                if (this.fury.getConfig().isAsyncCompilationEnabled() && !this.isAsyncVisitingFury()) {
                    ListeningExecutorService compilationService = CodeGenerator.getCompilationService();
                    this.hasJITResult.put(callback.id(), new ArrayList());
                    ++this.numRunningTask;
                    ListenableFuture future = compilationService.submit(jitAction);
                    Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<T>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onSuccess(@Nullable T result) {
                            try {
                                JITContext.this.lock();
                                callback.onSuccess(result);
                                for (NotifyCallback notifyCallback : (List)JITContext.this.hasJITResult.get(callback.id())) {
                                    notifyCallback.onNotifyResult(result);
                                }
                            }
                            finally {
                                JITContext.this.numRunningTask--;
                                if (JITContext.this.numRunningTask == 0) {
                                    JITContext.this.hasJITResult.clear();
                                }
                                JITContext.this.unlock();
                            }
                        }

                        public void onFailure(Throwable t) {
                            try {
                                JITContext.this.lock();
                                callback.onFailure(t);
                            }
                            finally {
                                JITContext.this.numRunningTask--;
                                if (JITContext.this.numRunningTask == 0) {
                                    JITContext.this.hasJITResult.clear();
                                }
                                JITContext.this.unlock();
                            }
                        }
                    }, (Executor)compilationService);
                    T t = interpreterModeAction.call();
                    return t;
                }
                T compilationService = jitAction.call();
                return compilationService;
            }
            T compilationService = interpreterModeAction.call();
            return compilationService;
        }
        catch (Exception e) {
            Platform.throwException(e);
            throw new IllegalStateException("unreachable");
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJITNotifyCallback(Object id, NotifyCallback notifyCallback) {
        Preconditions.checkNotNull((Object)id);
        try {
            this.lock();
            List<NotifyCallback> notifyCallbacks = this.hasJITResult.get(id);
            if (notifyCallbacks == null) {
                notifyCallback.onNotifyMissed();
            } else {
                notifyCallbacks.add(notifyCallback);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Internal
    public <T> T asyncVisitFury(Function<Fury, T> function) {
        try {
            this.lock();
            ++this.furyVisitState;
            T t = function.apply(this.fury);
            return t;
        }
        finally {
            --this.furyVisitState;
            this.unlock();
        }
    }

    private boolean isAsyncVisitingFury() {
        if (this.asyncCompilationEnabled) {
            try {
                this.lock();
                boolean bl = this.furyVisitState != 0;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    public boolean hasJITResult(Object key) {
        try {
            this.lock();
            boolean bl = this.hasJITResult.get(key) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Internal
    public void lock() {
        if (this.asyncCompilationEnabled) {
            this.jitLock.lock();
        }
    }

    @Internal
    public boolean lockedByCurrentThread() {
        return !this.asyncCompilationEnabled || this.jitLock.isHeldByCurrentThread();
    }

    @Internal
    public void unlock() {
        if (this.asyncCompilationEnabled) {
            this.jitLock.unlock();
        }
    }

    @Internal
    public static interface SerializerJITCallback<T> {
        public void onSuccess(T var1);

        default public void onFailure(Throwable e) {
            e.printStackTrace();
            Platform.throwException(e);
        }

        default public Object id() {
            return null;
        }
    }

    @Internal
    public static interface NotifyCallback {
        default public void onNotifyResult(Object result) {
            this.onNotifyMissed();
        }

        public void onNotifyMissed();
    }
}

