/*
 * Decompiled with CFR 0.152.
 */
package io.fury.type;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import io.fury.type.Descriptor;
import io.fury.type.TypeUtils;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;

public class DescriptorGrouper {
    public static final Comparator<Descriptor> PRIMITIVE_COMPARATOR = (d1, d2) -> {
        int c = TypeUtils.getSizeOfPrimitiveType(Primitives.unwrap(d2.getRawType())) - TypeUtils.getSizeOfPrimitiveType(Primitives.unwrap(d1.getRawType()));
        if (c == 0) {
            c = COMPARATOR_BY_TYPE_AND_NAME.compare((Descriptor)d1, (Descriptor)d2);
        }
        return c;
    };
    private static final Set<Class<?>> COMPRESS_TYPES = ImmutableSet.of(Integer.TYPE, Integer.class, Long.TYPE, Long.class);
    public static final Comparator<Descriptor> PRIMITIVE_COMPRESSED_COMPARATOR = (d1, d2) -> {
        Class t1 = Primitives.unwrap(d1.getRawType());
        Class t2 = Primitives.unwrap(d2.getRawType());
        boolean t1Compress = COMPRESS_TYPES.contains(t1);
        boolean t2Compress = COMPRESS_TYPES.contains(t2);
        if (t1Compress && t2Compress || !t1Compress && !t2Compress) {
            int c = TypeUtils.getSizeOfPrimitiveType(t2) - TypeUtils.getSizeOfPrimitiveType(t1);
            if (c == 0) {
                c = COMPARATOR_BY_TYPE_AND_NAME.compare((Descriptor)d1, (Descriptor)d2);
            }
            return c;
        }
        if (t1Compress) {
            return 1;
        }
        return -1;
    };
    public static final Comparator<Descriptor> COMPARATOR_BY_TYPE_AND_NAME = (d1, d2) -> {
        int c = d1.getRawType().getName().compareTo(d2.getRawType().getName());
        if (c == 0 && (c = d1.getName().compareTo(d2.getName())) == 0) {
            c = d1.getDeclaringClass().compareTo(d2.getDeclaringClass());
        }
        return c;
    };
    private final Collection<Descriptor> primitiveDescriptors;
    private final Collection<Descriptor> boxedDescriptors;
    private final Collection<Descriptor> collectionDescriptors;
    private final Collection<Descriptor> mapDescriptors;
    private final Collection<Descriptor> finalDescriptors;
    private final Collection<Descriptor> otherDescriptors;

    public DescriptorGrouper(Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered, Function<Descriptor, Descriptor> descriptorUpdator, Comparator<Descriptor> primitiveComparator, Comparator<Descriptor> comparator) {
        this.primitiveDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(primitiveComparator);
        this.boxedDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(primitiveComparator);
        this.collectionDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.mapDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.finalDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.otherDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        for (Descriptor descriptor : descriptors) {
            if (descriptor.getRawType().isPrimitive()) {
                this.primitiveDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            if (TypeUtils.isBoxed(descriptor.getRawType())) {
                this.boxedDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            if (TypeUtils.isCollection(descriptor.getRawType())) {
                this.collectionDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            if (TypeUtils.isMap(descriptor.getRawType())) {
                this.mapDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            if (Modifier.isFinal(descriptor.getRawType().getModifiers())) {
                this.finalDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            this.otherDescriptors.add(descriptorUpdator.apply(descriptor));
        }
    }

    public Collection<Descriptor> getPrimitiveDescriptors() {
        return this.primitiveDescriptors;
    }

    public Collection<Descriptor> getBoxedDescriptors() {
        return this.boxedDescriptors;
    }

    public Collection<Descriptor> getCollectionDescriptors() {
        return this.collectionDescriptors;
    }

    public Collection<Descriptor> getMapDescriptors() {
        return this.mapDescriptors;
    }

    public Collection<Descriptor> getFinalDescriptors() {
        return this.finalDescriptors;
    }

    public Collection<Descriptor> getOtherDescriptors() {
        return this.otherDescriptors;
    }

    private static Descriptor createDescriptor(Descriptor d) {
        if (!Modifier.isPublic(d.getRawType().getModifiers())) {
            TypeToken publicSuperType = ReflectionUtils.getPublicSuperType(d.getTypeToken());
            return d.copy(publicSuperType, null, null);
        }
        if (d.getReadMethod() == null && d.getWriteMethod() == null) {
            return d;
        }
        return d.copy(d.getTypeToken(), null, null);
    }

    public static DescriptorGrouper createDescriptorGrouper(Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered, boolean compressNumber) {
        Comparator<Descriptor> comparator = compressNumber ? PRIMITIVE_COMPRESSED_COMPARATOR : PRIMITIVE_COMPARATOR;
        return new DescriptorGrouper(descriptors, descriptorsGroupedOrdered, DescriptorGrouper::createDescriptor, comparator, COMPARATOR_BY_TYPE_AND_NAME);
    }
}

