/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.MapSerializers;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;

public class UnmodifiableSerializers {
    private static final Logger LOG = LoggerFactory.getLogger(UnmodifiableSerializers.class);
    private static Field SOURCE_COLLECTION_FIELD;
    private static Field SOURCE_MAP_FIELD;
    private static final long SOURCE_COLLECTION_FIELD_OFFSET;
    private static final long SOURCE_MAP_FIELD_OFFSET;

    public static void registerSerializers(Fury fury) {
        if (SOURCE_COLLECTION_FIELD != null && SOURCE_MAP_FIELD != null) {
            for (UnmodifiableFactory factory : UnmodifiableFactory.values()) {
                if (factory.isCollection()) {
                    fury.registerSerializer(factory.type, new UnmodifiableCollectionSerializer(fury, factory.type, factory));
                    continue;
                }
                fury.registerSerializer(factory.type, new UnmodifiableMapSerializer(fury, factory.type, factory));
            }
        }
    }

    static /* synthetic */ long access$100() {
        return SOURCE_COLLECTION_FIELD_OFFSET;
    }

    static /* synthetic */ long access$300() {
        return SOURCE_MAP_FIELD_OFFSET;
    }

    static {
        try {
            SOURCE_COLLECTION_FIELD = Collections.unmodifiableCollection(new ArrayList()).getClass().getDeclaredField("c");
            SOURCE_MAP_FIELD = Collections.unmodifiableMap(new HashMap()).getClass().getDeclaredField("m");
        }
        catch (Exception e) {
            LOG.warn("Could not access source collection field in java.util.Collections$UnmodifiableCollection: {}.", (Object)e.toString());
        }
        SOURCE_COLLECTION_FIELD_OFFSET = ReflectionUtils.getFieldOffset(SOURCE_COLLECTION_FIELD);
        SOURCE_MAP_FIELD_OFFSET = ReflectionUtils.getFieldOffset(SOURCE_MAP_FIELD);
    }

    static enum UnmodifiableFactory {
        COLLECTION((Class)Collections.unmodifiableCollection(Collections.singletonList("")).getClass(), UnmodifiableSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableCollection((Collection)sourceCollection);
            }
        }
        ,
        RANDOM_ACCESS_LIST((Class)Collections.unmodifiableList(new ArrayList<E>()).getClass(), UnmodifiableSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableList((List)sourceCollection);
            }
        }
        ,
        LIST((Class)Collections.unmodifiableList(new LinkedList<E>()).getClass(), UnmodifiableSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableList((List)sourceCollection);
            }
        }
        ,
        SET((Class)Collections.unmodifiableSet(new HashSet<E>()).getClass(), UnmodifiableSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSet((Set)sourceCollection);
            }
        }
        ,
        SORTED_SET((Class)Collections.unmodifiableSortedSet(new TreeSet<E>()).getClass(), UnmodifiableSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSortedSet((SortedSet)sourceCollection);
            }
        }
        ,
        MAP((Class)Collections.unmodifiableMap(new HashMap<K, V>()).getClass(), UnmodifiableSerializers.access$300()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableMap((Map)sourceCollection);
            }
        }
        ,
        SORTED_MAP((Class)Collections.unmodifiableSortedMap(new TreeMap<K, V>()).getClass(), UnmodifiableSerializers.access$300()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSortedMap((SortedMap)sourceCollection);
            }
        };

        private final Class<?> type;
        private final long sourceFieldOffset;

        private UnmodifiableFactory(Class<?> type, long sourceFieldOffset) {
            this.type = type;
            this.sourceFieldOffset = sourceFieldOffset;
        }

        public abstract Object create(Object var1);

        public boolean isCollection() {
            return Collection.class.isAssignableFrom(this.type);
        }

        static UnmodifiableFactory valueOfType(Class<?> type) {
            for (UnmodifiableFactory item : UnmodifiableFactory.values()) {
                if (item.type != type) continue;
                return item;
            }
            throw new IllegalArgumentException("The type " + type + " is not supported.");
        }
    }

    public static final class UnmodifiableMapSerializer
    extends MapSerializers.MapSerializer<Map> {
        private final UnmodifiableFactory unmodifiableFactory;

        public UnmodifiableMapSerializer(Fury fury, Class<Map> cls, UnmodifiableFactory unmodifiableFactory) {
            super(fury, cls, false, false);
            this.unmodifiableFactory = unmodifiableFactory;
        }

        @Override
        public void write(MemoryBuffer buffer, Map value) {
            Preconditions.checkArgument((value.getClass() == this.type ? 1 : 0) != 0);
            Object fieldValue = Platform.getObject(value, this.unmodifiableFactory.sourceFieldOffset);
            this.fury.writeRef(buffer, fieldValue);
        }

        @Override
        public Map read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Map)this.unmodifiableFactory.create(sourceCollection);
        }
    }

    public static final class UnmodifiableCollectionSerializer
    extends CollectionSerializers.CollectionSerializer<Collection> {
        private final UnmodifiableFactory unmodifiableFactory;

        public UnmodifiableCollectionSerializer(Fury fury, Class<Collection> cls, UnmodifiableFactory unmodifiableFactory) {
            super(fury, cls, false, false);
            this.unmodifiableFactory = unmodifiableFactory;
        }

        @Override
        public void write(MemoryBuffer buffer, Collection value) {
            Preconditions.checkArgument((value.getClass() == this.type ? 1 : 0) != 0);
            Object fieldValue = Platform.getObject(value, this.unmodifiableFactory.sourceFieldOffset);
            this.fury.writeRef(buffer, fieldValue);
        }

        @Override
        public Collection read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Collection)this.unmodifiableFactory.create(sourceCollection);
        }
    }
}

