/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.exception.FuryException;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CollectionSerializers;
import io.fury.serializer.MapSerializers;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class SynchronizedSerializers {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronizedSerializers.class);
    private static Field SOURCE_COLLECTION_FIELD;
    private static Field SOURCE_MAP_FIELD;
    private static final long SOURCE_COLLECTION_FIELD_OFFSET;
    private static final long SOURCE_MAP_FIELD_OFFSET;

    public static void registerSerializers(Fury fury) {
        if (SOURCE_COLLECTION_FIELD != null && SOURCE_MAP_FIELD != null) {
            Set classSet = Arrays.stream(SynchronizedFactory.values()).map(c -> ((SynchronizedFactory)c).type).collect(Collectors.toSet());
            if (classSet.size() != SynchronizedFactory.values().length) {
                throw new FuryException(String.format("Enum types %s duplicate.", Arrays.toString((Object[])SynchronizedFactory.values())));
            }
            for (SynchronizedFactory factory : SynchronizedFactory.values()) {
                if (factory.isCollection()) {
                    fury.registerSerializer(factory.type, new SynchronizedCollectionSerializer(fury, factory.type, factory));
                    continue;
                }
                fury.registerSerializer(factory.type, new SynchronizedMapSerializer(fury, factory.type, factory));
            }
        }
    }

    static /* synthetic */ long access$100() {
        return SOURCE_COLLECTION_FIELD_OFFSET;
    }

    static /* synthetic */ long access$300() {
        return SOURCE_MAP_FIELD_OFFSET;
    }

    static {
        try {
            SOURCE_COLLECTION_FIELD = Collections.synchronizedCollection(Collections.emptyList()).getClass().getDeclaredField("c");
            SOURCE_MAP_FIELD = Collections.synchronizedMap(Collections.emptyMap()).getClass().getDeclaredField("m");
        }
        catch (Exception e) {
            LOG.warn("Could not access source collection field in java.util.Collections$SynchronizedCollection/SynchronizedMap {}.", (Object)e.toString());
        }
        SOURCE_COLLECTION_FIELD_OFFSET = ReflectionUtils.getFieldOffset(SOURCE_COLLECTION_FIELD);
        SOURCE_MAP_FIELD_OFFSET = ReflectionUtils.getFieldOffset(SOURCE_MAP_FIELD);
    }

    static enum SynchronizedFactory {
        COLLECTION((Class)Collections.synchronizedCollection(Arrays.asList("")).getClass(), SynchronizedSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedCollection((Collection)sourceCollection);
            }
        }
        ,
        RANDOM_ACCESS_LIST((Class)Collections.synchronizedList(new ArrayList<E>()).getClass(), SynchronizedSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedList((List)sourceCollection);
            }
        }
        ,
        LIST((Class)Collections.synchronizedList(new LinkedList<E>()).getClass(), SynchronizedSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedList((List)sourceCollection);
            }
        }
        ,
        SET((Class)Collections.synchronizedSet(new HashSet<E>()).getClass(), SynchronizedSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSet((Set)sourceCollection);
            }
        }
        ,
        SORTED_SET((Class)Collections.synchronizedSortedSet(new TreeSet<E>()).getClass(), SynchronizedSerializers.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSortedSet((SortedSet)sourceCollection);
            }
        }
        ,
        MAP((Class)Collections.synchronizedMap(new HashMap<K, V>()).getClass(), SynchronizedSerializers.access$300()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedMap((Map)sourceCollection);
            }
        }
        ,
        SORTED_MAP((Class)Collections.synchronizedSortedMap(new TreeMap<K, V>()).getClass(), SynchronizedSerializers.access$300()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSortedMap((SortedMap)sourceCollection);
            }
        };

        private final Class<?> type;
        private final long sourceFieldOffset;

        private SynchronizedFactory(Class<?> type, long sourceFieldOffset) {
            this.type = type;
            this.sourceFieldOffset = sourceFieldOffset;
        }

        public boolean isCollection() {
            return Collection.class.isAssignableFrom(this.type);
        }

        public abstract Object create(Object var1);

        static SynchronizedFactory valueOfType(Class<?> type) {
            for (SynchronizedFactory item : SynchronizedFactory.values()) {
                if (!item.type.equals(type)) continue;
                return item;
            }
            throw new IllegalArgumentException("The type " + type + " is not supported.");
        }
    }

    public static final class SynchronizedMapSerializer
    extends MapSerializers.MapSerializer<Map> {
        private final SynchronizedFactory synchronizedFactory;

        public SynchronizedMapSerializer(Fury fury, Class cls, SynchronizedFactory synchronizedFactory) {
            super(fury, cls, false, false);
            this.synchronizedFactory = synchronizedFactory;
        }

        @Override
        public void write(MemoryBuffer buffer, Map object) {
            Object unwrapped = Platform.getObject(object, this.synchronizedFactory.sourceFieldOffset);
            this.fury.writeRef(buffer, unwrapped);
        }

        @Override
        public Map read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Map)this.synchronizedFactory.create(sourceCollection);
        }
    }

    public static final class SynchronizedCollectionSerializer
    extends CollectionSerializers.CollectionSerializer<Collection> {
        private final SynchronizedFactory synchronizedFactory;

        public SynchronizedCollectionSerializer(Fury fury, Class cls, SynchronizedFactory synchronizedFactory) {
            super(fury, cls, false, false);
            this.synchronizedFactory = synchronizedFactory;
        }

        @Override
        public void write(MemoryBuffer buffer, Collection object) {
            Object unwrapped = Platform.getObject(object, this.synchronizedFactory.sourceFieldOffset);
            this.fury.writeRef(buffer, unwrapped);
        }

        @Override
        public Collection read(MemoryBuffer buffer) {
            Object sourceCollection = this.fury.readRef(buffer);
            return (Collection)this.synchronizedFactory.create(sourceCollection);
        }
    }
}

