/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CompatibleSerializer;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.StringSerializer;
import io.fury.type.Type;
import io.fury.util.Platform;
import io.fury.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.IdentityHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class Serializers {
    public static <T> Serializer<T> newSerializer(Fury fury, Class type, Class<? extends Serializer> serializerClass) {
        Serializer serializer = fury.getClassResolver().getSerializer(type, false);
        try {
            if (serializerClass == ObjectSerializer.class) {
                return new ObjectSerializer(fury, type);
            }
            if (serializerClass == CompatibleSerializer.class) {
                return new CompatibleSerializer(fury, type);
            }
            try {
                try {
                    Constructor<? extends Serializer> ctr = serializerClass.getConstructor(Fury.class, Class.class);
                    ctr.setAccessible(true);
                    return ctr.newInstance(fury, type);
                }
                catch (NoSuchMethodException e) {
                    Utils.ignore(e);
                    try {
                        Constructor<? extends Serializer> ctr = serializerClass.getConstructor(Fury.class);
                        ctr.setAccessible(true);
                        return ctr.newInstance(fury);
                    }
                    catch (NoSuchMethodException e2) {
                        Utils.ignore(e2);
                        try {
                            Constructor<? extends Serializer> ctr = serializerClass.getConstructor(Class.class);
                            ctr.setAccessible(true);
                            return ctr.newInstance(type);
                        }
                        catch (NoSuchMethodException e3) {
                            Utils.ignore(e3);
                            return serializerClass.newInstance();
                        }
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Platform.throwException(e);
            }
        }
        catch (Throwable t) {
            fury.getClassResolver().resetSerializer(type, serializer);
            Platform.throwException(t);
        }
        throw new IllegalStateException("unreachable");
    }

    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(Boolean.TYPE, new BooleanSerializer(fury, (Class<?>)Boolean.TYPE));
        fury.registerSerializer(Byte.TYPE, new ByteSerializer(fury, (Class<?>)Byte.TYPE));
        fury.registerSerializer(Short.TYPE, new ShortSerializer(fury, (Class<?>)Short.TYPE));
        fury.registerSerializer(Character.TYPE, new CharSerializer(fury, (Class<?>)Character.TYPE));
        fury.registerSerializer(Integer.TYPE, new IntSerializer(fury, (Class<?>)Integer.TYPE));
        fury.registerSerializer(Long.TYPE, new LongSerializer(fury, (Class<?>)Long.TYPE));
        fury.registerSerializer(Float.TYPE, new FloatSerializer(fury, (Class<?>)Float.TYPE));
        fury.registerSerializer(Double.TYPE, new DoubleSerializer(fury, (Class<?>)Double.TYPE));
        fury.registerSerializer(Boolean.class, new BooleanSerializer(fury, Boolean.class));
        fury.registerSerializer(Byte.class, new ByteSerializer(fury, Byte.class));
        fury.registerSerializer(Short.class, new ShortSerializer(fury, Short.class));
        fury.registerSerializer(Character.class, new CharSerializer(fury, Character.class));
        fury.registerSerializer(Integer.class, new IntSerializer(fury, Integer.class));
        fury.registerSerializer(Long.class, new LongSerializer(fury, Long.class));
        fury.registerSerializer(Float.class, new FloatSerializer(fury, Float.class));
        fury.registerSerializer(Double.class, new DoubleSerializer(fury, Double.class));
        fury.registerSerializer(Class.class, new ClassSerializer(fury));
        fury.registerSerializer(StringBuilder.class, new StringBuilderSerializer(fury));
        fury.registerSerializer(StringBuffer.class, new StringBufferSerializer(fury));
        fury.registerSerializer(BigInteger.class, new BigIntegerSerializer(fury));
        fury.registerSerializer(BigDecimal.class, new BigDecimalSerializer(fury));
        fury.registerSerializer(AtomicBoolean.class, new AtomicBooleanSerializer(fury));
        fury.registerSerializer(AtomicInteger.class, new AtomicIntegerSerializer(fury));
        fury.registerSerializer(AtomicLong.class, new AtomicLongSerializer(fury));
        fury.registerSerializer(AtomicReference.class, new AtomicReferenceSerializer(fury));
        fury.registerSerializer(Currency.class, new CurrencySerializer(fury));
        fury.registerSerializer(URI.class, new URISerializer(fury));
        fury.registerSerializer(Pattern.class, new RegexSerializer(fury));
        fury.registerSerializer(UUID.class, new UUIDSerializer(fury));
    }

    public static final class ClassSerializer
    extends Serializer<Class> {
        private static final byte USE_CLASS_ID = 0;
        private static final byte USE_CLASSNAME = 1;
        private static final byte PRIMITIVE_FLAG = 2;
        private final IdentityHashMap<Class<?>, Byte> primitivesMap = new IdentityHashMap();
        private final Class<?>[] id2PrimitiveClasses = new Class[Primitives.allPrimitiveTypes().size()];

        public ClassSerializer(Fury fury) {
            super(fury, Class.class);
            byte count = 0;
            for (Class primitiveType : Primitives.allPrimitiveTypes()) {
                this.primitivesMap.put(primitiveType, count);
                this.id2PrimitiveClasses[count] = primitiveType;
                count = (byte)(count + 1);
            }
        }

        @Override
        public void write(MemoryBuffer buffer, Class value) {
            this.fury.getClassResolver().writeClassInternal(buffer, value);
        }

        @Override
        public Class read(MemoryBuffer buffer) {
            return this.fury.getClassResolver().readClassInternal(buffer);
        }
    }

    public static final class UUIDSerializer
    extends Serializer<UUID> {
        public UUIDSerializer(Fury fury) {
            super(fury, UUID.class);
        }

        @Override
        public void write(MemoryBuffer buffer, UUID uuid) {
            buffer.writeLong(uuid.getMostSignificantBits());
            buffer.writeLong(uuid.getLeastSignificantBits());
        }

        @Override
        public UUID read(MemoryBuffer buffer) {
            return new UUID(buffer.readLong(), buffer.readLong());
        }
    }

    public static final class RegexSerializer
    extends Serializer<Pattern> {
        public RegexSerializer(Fury fury) {
            super(fury, Pattern.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Pattern pattern) {
            this.fury.writeJavaString(buffer, pattern.pattern());
            buffer.writeInt(pattern.flags());
        }

        @Override
        public Pattern read(MemoryBuffer buffer) {
            String regex = this.fury.readJavaString(buffer);
            int flags = buffer.readInt();
            return Pattern.compile(regex, flags);
        }
    }

    public static final class URISerializer
    extends Serializer<URI> {
        public URISerializer(Fury fury) {
            super(fury, URI.class);
        }

        @Override
        public void write(MemoryBuffer buffer, URI uri) {
            this.fury.writeString(buffer, uri.toString());
        }

        @Override
        public URI read(MemoryBuffer buffer) {
            return URI.create(this.fury.readString(buffer));
        }
    }

    public static final class CharsetSerializer<T extends Charset>
    extends Serializer<T> {
        public CharsetSerializer(Fury fury, Class<T> type) {
            super(fury, type);
        }

        @Override
        public void write(MemoryBuffer buffer, T object) {
            this.fury.writeJavaString(buffer, ((Charset)object).name());
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)Charset.forName(this.fury.readJavaString(buffer));
        }
    }

    public static final class CurrencySerializer
    extends Serializer<Currency> {
        public CurrencySerializer(Fury fury) {
            super(fury, Currency.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Currency object) {
            this.fury.writeJavaString(buffer, object.getCurrencyCode());
        }

        @Override
        public Currency read(MemoryBuffer buffer) {
            String currencyCode = this.fury.readJavaString(buffer);
            return Currency.getInstance(currencyCode);
        }
    }

    public static final class AtomicReferenceSerializer
    extends Serializer<AtomicReference> {
        public AtomicReferenceSerializer(Fury fury) {
            super(fury, AtomicReference.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicReference value) {
            this.fury.writeRef(buffer, value.get());
        }

        @Override
        public AtomicReference read(MemoryBuffer buffer) {
            return new AtomicReference<Object>(this.fury.readRef(buffer));
        }
    }

    public static final class AtomicLongSerializer
    extends Serializer<AtomicLong> {
        public AtomicLongSerializer(Fury fury) {
            super(fury, AtomicLong.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicLong value) {
            buffer.writeLong(value.get());
        }

        @Override
        public AtomicLong read(MemoryBuffer buffer) {
            return new AtomicLong(buffer.readLong());
        }
    }

    public static final class AtomicIntegerSerializer
    extends Serializer<AtomicInteger> {
        public AtomicIntegerSerializer(Fury fury) {
            super(fury, AtomicInteger.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicInteger value) {
            buffer.writeInt(value.get());
        }

        @Override
        public AtomicInteger read(MemoryBuffer buffer) {
            return new AtomicInteger(buffer.readInt());
        }
    }

    public static final class AtomicBooleanSerializer
    extends Serializer<AtomicBoolean> {
        public AtomicBooleanSerializer(Fury fury) {
            super(fury, AtomicBoolean.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicBoolean value) {
            buffer.writeBoolean(value.get());
        }

        @Override
        public AtomicBoolean read(MemoryBuffer buffer) {
            return new AtomicBoolean(buffer.readBoolean());
        }
    }

    public static final class BigIntegerSerializer
    extends Serializer<BigInteger> {
        public BigIntegerSerializer(Fury fury) {
            super(fury, BigInteger.class);
        }

        @Override
        public void write(MemoryBuffer buffer, BigInteger value) {
            byte[] bytes = value.toByteArray();
            Preconditions.checkArgument((bytes.length <= 16 ? 1 : 0) != 0);
            buffer.writeByte((byte)bytes.length);
            buffer.writeBytes(bytes);
        }

        @Override
        public BigInteger read(MemoryBuffer buffer) {
            byte len = buffer.readByte();
            byte[] bytes = buffer.readBytes(len);
            return new BigInteger(bytes);
        }
    }

    public static final class BigDecimalSerializer
    extends Serializer<BigDecimal> {
        public BigDecimalSerializer(Fury fury) {
            super(fury, BigDecimal.class);
        }

        @Override
        public void write(MemoryBuffer buffer, BigDecimal value) {
            byte[] bytes = value.unscaledValue().toByteArray();
            Preconditions.checkArgument((bytes.length <= 16 ? 1 : 0) != 0);
            buffer.writeByte((byte)value.scale());
            buffer.writeByte((byte)bytes.length);
            buffer.writeBytes(bytes);
        }

        @Override
        public BigDecimal read(MemoryBuffer buffer) {
            byte scale = buffer.readByte();
            byte len = buffer.readByte();
            byte[] bytes = buffer.readBytes(len);
            BigInteger bigInteger = new BigInteger(bytes);
            return new BigDecimal(bigInteger, scale);
        }
    }

    public static final class EnumSerializer
    extends Serializer<Enum> {
        private final Enum[] enumConstants;

        public EnumSerializer(Fury fury, Class<Enum> cls) {
            super(fury, cls, false);
            if (cls.isEnum()) {
                this.enumConstants = cls.getEnumConstants();
            } else {
                Preconditions.checkArgument((Enum.class.isAssignableFrom(cls) && cls != Enum.class ? 1 : 0) != 0);
                Class<?> enclosingClass = cls.getEnclosingClass();
                Preconditions.checkNotNull(enclosingClass);
                Preconditions.checkArgument((boolean)enclosingClass.isEnum());
                this.enumConstants = (Enum[])enclosingClass.getEnumConstants();
            }
        }

        @Override
        public void write(MemoryBuffer buffer, Enum value) {
            buffer.writePositiveVarInt(value.ordinal());
        }

        @Override
        public Enum read(MemoryBuffer buffer) {
            return this.enumConstants[buffer.readPositiveVarInt()];
        }
    }

    public static final class StringBufferSerializer
    extends Serializer<StringBuffer> {
        private final StringSerializer stringSerializer;

        public StringBufferSerializer(Fury fury) {
            super(fury, StringBuffer.class);
            this.stringSerializer = new StringSerializer(fury);
        }

        @Override
        public short getXtypeId() {
            return -Type.STRING.getId();
        }

        @Override
        public void write(MemoryBuffer buffer, StringBuffer value) {
            this.stringSerializer.writeJavaString(buffer, value.toString());
        }

        @Override
        public void xwrite(MemoryBuffer buffer, StringBuffer value) {
            this.stringSerializer.writeUTF8String(buffer, value.toString());
        }

        @Override
        public StringBuffer read(MemoryBuffer buffer) {
            return new StringBuffer(this.stringSerializer.readJavaString(buffer));
        }

        @Override
        public StringBuffer xread(MemoryBuffer buffer) {
            return new StringBuffer(this.stringSerializer.readUTF8String(buffer));
        }
    }

    public static final class StringBuilderSerializer
    extends Serializer<StringBuilder> {
        private final StringSerializer stringSerializer;

        public StringBuilderSerializer(Fury fury) {
            super(fury, StringBuilder.class);
            this.stringSerializer = new StringSerializer(fury);
        }

        @Override
        public void write(MemoryBuffer buffer, StringBuilder value) {
            this.stringSerializer.writeJavaString(buffer, value.toString());
        }

        @Override
        public StringBuilder read(MemoryBuffer buffer) {
            return new StringBuilder(this.stringSerializer.readJavaString(buffer));
        }
    }

    public static final class DoubleSerializer
    extends CrossLanguageCompatibleSerializer<Double> {
        public DoubleSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.DOUBLE.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Double value) {
            buffer.writeDouble(value);
        }

        @Override
        public Double read(MemoryBuffer buffer) {
            return buffer.readDouble();
        }
    }

    public static final class FloatSerializer
    extends CrossLanguageCompatibleSerializer<Float> {
        public FloatSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.FLOAT.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Float value) {
            buffer.writeFloat(value.floatValue());
        }

        @Override
        public Float read(MemoryBuffer buffer) {
            return Float.valueOf(buffer.readFloat());
        }
    }

    public static final class LongSerializer
    extends CrossLanguageCompatibleSerializer<Long> {
        private final boolean compressNumber;

        public LongSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.INT64.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
            this.compressNumber = fury.compressNumber();
        }

        @Override
        public void write(MemoryBuffer buffer, Long value) {
            if (this.compressNumber) {
                buffer.writeVarLong(value);
            } else {
                buffer.writeLong(value);
            }
        }

        @Override
        public Long read(MemoryBuffer buffer) {
            if (this.compressNumber) {
                return buffer.readVarLong();
            }
            return buffer.readLong();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Long value) {
            buffer.writeLong(value);
        }

        @Override
        public Long xread(MemoryBuffer buffer) {
            return buffer.readLong();
        }
    }

    public static final class IntSerializer
    extends CrossLanguageCompatibleSerializer<Integer> {
        private final boolean compressNumber;

        public IntSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.INT32.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
            this.compressNumber = fury.compressNumber();
        }

        @Override
        public void write(MemoryBuffer buffer, Integer value) {
            if (this.compressNumber) {
                buffer.writeVarInt(value);
            } else {
                buffer.writeInt(value);
            }
        }

        @Override
        public Integer read(MemoryBuffer buffer) {
            if (this.compressNumber) {
                return buffer.readVarInt();
            }
            return buffer.readInt();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            buffer.writeInt(value);
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            return buffer.readInt();
        }
    }

    public static final class ShortSerializer
    extends CrossLanguageCompatibleSerializer<Short> {
        public ShortSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.INT16.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Short value) {
            buffer.writeShort(value);
        }

        @Override
        public Short read(MemoryBuffer buffer) {
            return buffer.readShort();
        }
    }

    public static final class CharSerializer
    extends Serializer<Character> {
        public CharSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Character value) {
            buffer.writeChar(value.charValue());
        }

        @Override
        public Character read(MemoryBuffer buffer) {
            return Character.valueOf(buffer.readChar());
        }
    }

    public static final class Uint16Serializer
    extends Serializer<Integer> {
        public Uint16Serializer(Fury fury) {
            super(fury, Integer.class);
        }

        @Override
        public short getXtypeId() {
            return Type.UINT16.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            Preconditions.checkArgument((value >= 0 && value <= 65535 ? 1 : 0) != 0);
            buffer.writeByte(value.byteValue());
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            byte b = buffer.readByte();
            return b >>> 16;
        }
    }

    public static final class Uint8Serializer
    extends Serializer<Integer> {
        public Uint8Serializer(Fury fury) {
            super(fury, Integer.class);
        }

        @Override
        public short getXtypeId() {
            return Type.UINT8.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            Preconditions.checkArgument((value >= 0 && value <= 255 ? 1 : 0) != 0);
            buffer.writeByte(value.byteValue());
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            byte b = buffer.readByte();
            return b >>> 24;
        }
    }

    public static final class ByteSerializer
    extends CrossLanguageCompatibleSerializer<Byte> {
        public ByteSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.INT8.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Byte value) {
            buffer.writeByte(value);
        }

        @Override
        public Byte read(MemoryBuffer buffer) {
            return buffer.readByte();
        }
    }

    public static final class BooleanSerializer
    extends CrossLanguageCompatibleSerializer<Boolean> {
        public BooleanSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.BOOL.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Boolean value) {
            buffer.writeBoolean(value);
        }

        @Override
        public Boolean read(MemoryBuffer buffer) {
            return buffer.readBoolean();
        }
    }

    public static abstract class CrossLanguageCompatibleSerializer<T>
    extends Serializer<T> {
        private final short typeId;

        public CrossLanguageCompatibleSerializer(Fury fury, Class<T> cls, short typeId) {
            super(fury, cls);
            this.typeId = typeId;
        }

        public CrossLanguageCompatibleSerializer(Fury fury, Class<T> cls, short typeId, boolean needToWriteRef) {
            super(fury, cls, needToWriteRef);
            this.typeId = typeId;
        }

        @Override
        public short getXtypeId() {
            return this.typeId;
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.write(buffer, value);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            return this.read(buffer);
        }
    }
}

