/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.JavaSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.ReflectionUtils;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class ReplaceResolveSerializer
extends Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceResolveSerializer.class);
    private static final byte ORIGINAL = 0;
    private static final byte REPLACED_NEW_TYPE = 1;
    private static final byte REPLACED_SAME_TYPE = 2;
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final JDKReplaceResolveMethodInfoCache jdkMethodInfoWriteCache;
    private final ClassInfo writeClassInfo;
    private final Map<Class<?>, JDKReplaceResolveMethodInfoCache> classClassInfoCacheMap = new HashMap();

    private JDKReplaceResolveMethodInfoCache newJDKMethodInfoCache(Class<?> cls, Fury fury) {
        Method readObjectMethod;
        Method writeObjectMethod;
        Method readResolveMethod;
        Method writeReplaceMethod;
        if (Serializable.class.isAssignableFrom(cls)) {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(cls);
            writeReplaceMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "writeReplaceMethod");
            readResolveMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "readResolveMethod");
            writeObjectMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "writeObjectMethod");
            readObjectMethod = (Method)ReflectionUtils.getObjectFieldValue(objectStreamClass, "readObjectMethod");
        } else {
            writeReplaceMethod = JavaSerializer.getWriteReplaceMethod(cls);
            if (writeReplaceMethod != null) {
                writeReplaceMethod.setAccessible(true);
            }
            if ((readResolveMethod = JavaSerializer.getReadResolveMethod(cls)) != null) {
                readResolveMethod.setAccessible(true);
            }
            writeObjectMethod = JavaSerializer.getWriteObjectMethod(cls);
            readObjectMethod = JavaSerializer.getReadObjectMethod(cls);
            if (writeReplaceMethod != null) {
                LOG.warn("{} doesn't implement {}, but defined writeReplace method {}", new Object[]{cls, Serializable.class, writeReplaceMethod});
            }
            if (readResolveMethod != null) {
                LOG.warn("{} doesn't implement {}, but defined readResolve method {}", new Object[]{cls, Serializable.class, readResolveMethod});
            }
        }
        JDKReplaceResolveMethodInfoCache methodInfoCache = new JDKReplaceResolveMethodInfoCache(writeReplaceMethod, readResolveMethod, null);
        boolean hasJDKWriteObjectMethod = writeObjectMethod != null;
        boolean hasJDKReadObjectMethod = readObjectMethod != null;
        Class<? extends Serializer> serializerClass = !hasJDKWriteObjectMethod && !hasJDKReadObjectMethod ? fury.getClassResolver().getObjectSerializerClass(cls, sc -> methodInfoCache.setObjectSerializer(this.createDataSerializer(cls, (Class<? extends Serializer>)sc))) : fury.getDefaultJDKStreamSerializerType();
        methodInfoCache.setObjectSerializer(this.createDataSerializer(cls, serializerClass));
        return methodInfoCache;
    }

    private Serializer createDataSerializer(Class<?> cls, Class<? extends Serializer> sc) {
        Serializer<?> prev = this.classResolver.getSerializer(cls, false);
        Serializer serializer = Serializers.newSerializer(this.fury, cls, sc);
        this.classResolver.resetSerializer(cls, prev);
        return serializer;
    }

    public ReplaceResolveSerializer(Fury fury, Class type) {
        super(fury, type);
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.classResolver.setSerializerIfAbsent(type, this);
        if (type != ReplaceStub.class) {
            this.jdkMethodInfoWriteCache = this.newJDKMethodInfoCache(type, fury);
            this.classClassInfoCacheMap.put(type, this.jdkMethodInfoWriteCache);
            this.writeClassInfo = this.classResolver.newClassInfo(type, this, (short)0);
        } else {
            this.jdkMethodInfoWriteCache = null;
            this.writeClassInfo = null;
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        JDKReplaceResolveMethodInfoCache jdkMethodInfoCache = this.jdkMethodInfoWriteCache;
        Method writeReplaceMethod = jdkMethodInfoCache.writeReplaceMethod;
        if (writeReplaceMethod != null) {
            Object original = value;
            try {
                value = writeReplaceMethod.invoke(value, new Object[0]);
            }
            catch (Exception e) {
                Platform.throwException(e);
            }
            if (value == null || value.getClass() != this.type) {
                buffer.writeByte((byte)1);
                if (!this.refResolver.writeRefOrNull(buffer, value)) {
                    this.refResolver.replaceRef(original, value);
                    this.fury.writeNonRefT(buffer, value);
                }
            } else if (value != original) {
                buffer.writeByte((byte)2);
                if (!this.refResolver.writeRefOrNull(buffer, value)) {
                    this.refResolver.replaceRef(original, value);
                    this.writeObject(buffer, value, jdkMethodInfoCache);
                }
            } else {
                buffer.writeByte((byte)0);
                this.writeObject(buffer, value, jdkMethodInfoCache);
            }
        } else {
            buffer.writeByte((byte)0);
            this.writeObject(buffer, value, jdkMethodInfoCache);
        }
    }

    private void writeObject(MemoryBuffer buffer, Object value, JDKReplaceResolveMethodInfoCache jdkMethodInfoCache) {
        this.classResolver.writeClass(buffer, this.writeClassInfo);
        jdkMethodInfoCache.objectSerializer.write(buffer, value);
    }

    public Object read(MemoryBuffer buffer) {
        byte flag = buffer.readByte();
        RefResolver refResolver = this.refResolver;
        if (flag == 1) {
            int outerRefId = refResolver.lastPreservedRefId();
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.fury.readData(buffer, this.classResolver.readAndUpdateClassInfoCache(buffer));
                refResolver.setReadObject(nextReadRefId, o);
                refResolver.setReadObject(outerRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        if (flag == 2) {
            int outerRefId = refResolver.lastPreservedRefId();
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.readObject(buffer);
                refResolver.setReadObject(nextReadRefId, o);
                refResolver.setReadObject(outerRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        Preconditions.checkArgument((flag == 0 ? 1 : 0) != 0);
        return this.readObject(buffer);
    }

    private Object readObject(MemoryBuffer buffer) {
        Class<?> cls = this.classResolver.readClassInternal(buffer);
        JDKReplaceResolveMethodInfoCache jdkMethodInfoCache = this.classClassInfoCacheMap.get(cls);
        if (jdkMethodInfoCache == null) {
            jdkMethodInfoCache = this.newJDKMethodInfoCache(cls, this.fury);
            this.classClassInfoCacheMap.put(cls, jdkMethodInfoCache);
        }
        Object o = jdkMethodInfoCache.objectSerializer.read(buffer);
        Method readResolveMethod = jdkMethodInfoCache.readResolveMethod;
        if (readResolveMethod != null) {
            try {
                return readResolveMethod.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                Platform.throwException(e);
                throw new IllegalStateException("unreachable");
            }
        }
        return o;
    }

    private static class JDKReplaceResolveMethodInfoCache {
        private final Method writeReplaceMethod;
        private final Method readResolveMethod;
        private Serializer objectSerializer;

        private JDKReplaceResolveMethodInfoCache(Method writeReplaceMethod, Method readResolveMethod, Serializer objectSerializer) {
            this.writeReplaceMethod = writeReplaceMethod;
            this.readResolveMethod = readResolveMethod;
            this.objectSerializer = objectSerializer;
        }

        public void setObjectSerializer(Serializer objectSerializer) {
            this.objectSerializer = objectSerializer;
        }
    }

    public static class ReplaceStub {
    }
}

