/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.base.Preconditions;
import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CodegenSerializer;
import io.fury.serializer.JavaSerializer;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.util.ReflectionUtils;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Objects;

public class LambdaSerializer
extends Serializer {
    private static final Class<SerializedLambda> SERIALIZED_LAMBDA = SerializedLambda.class;
    private static final Method READ_RESOLVE_METHOD = (Method)Objects.requireNonNull(ReflectionUtils.getObjectFieldValue(ObjectStreamClass.lookup(SERIALIZED_LAMBDA), "readResolveMethod"));
    private static final boolean SERIALIZED_LAMBDA_HAS_JDK_WRITE = JavaSerializer.getWriteObjectMethod(SERIALIZED_LAMBDA) != null;
    private static final boolean SERIALIZED_LAMBDA_HAS_JDK_READ = JavaSerializer.getReadObjectMethod(SERIALIZED_LAMBDA) != null;
    private final Method writeReplaceMethod;
    private Serializer dataSerializer;

    public LambdaSerializer(Fury fury, Class cls) {
        super(fury, cls);
        if (cls != ReplaceStub.class) {
            if (!Serializable.class.isAssignableFrom(cls)) {
                String msg = String.format("Lambda needs to implement %s for serialization", Serializable.class);
                throw new UnsupportedOperationException(msg);
            }
            this.writeReplaceMethod = (Method)ReflectionUtils.getObjectFieldValue(ObjectStreamClass.lookup(cls), "writeReplaceMethod");
        } else {
            this.writeReplaceMethod = null;
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        assert (value.getClass() != ReplaceStub.class);
        try {
            Object replacement = this.writeReplaceMethod.invoke(value, new Object[0]);
            Preconditions.checkArgument((boolean)SERIALIZED_LAMBDA.isInstance(replacement));
            this.getDataSerializer().write(buffer, replacement);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't serialize lambda " + value, e);
        }
    }

    public Object read(MemoryBuffer buffer) {
        try {
            Object replacement = this.getDataSerializer().read(buffer);
            return READ_RESOLVE_METHOD.invoke(replacement, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't deserialize lambda", e);
        }
    }

    private Serializer getDataSerializer() {
        Serializer dataSerializer = this.dataSerializer;
        if (dataSerializer == null) {
            Class sc = SERIALIZED_LAMBDA_HAS_JDK_WRITE || SERIALIZED_LAMBDA_HAS_JDK_READ ? this.fury.getDefaultJDKStreamSerializerType() : this.fury.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(this.fury, SERIALIZED_LAMBDA), c -> {
                this.dataSerializer = Serializers.newSerializer(this.fury, SERIALIZED_LAMBDA, c);
                this.fury.getClassResolver().clearSerializer(SERIALIZED_LAMBDA);
            });
            this.dataSerializer = dataSerializer = Serializers.newSerializer(this.fury, SERIALIZED_LAMBDA, sc);
            this.fury.getClassResolver().clearSerializer(SERIALIZED_LAMBDA);
        }
        return dataSerializer;
    }

    public static class ReplaceStub {
    }
}

