/*
 * Decompiled with CFR 0.152.
 */
package fj.data.optic;

import fj.F;
import fj.F3;
import fj.F4;
import fj.F5;
import fj.F6;
import fj.F7;
import fj.Function;
import fj.Monoid;
import fj.P;
import fj.P1;
import fj.Semigroup;
import fj.control.Trampoline;
import fj.control.parallel.Promise;
import fj.data.Either;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Validation;
import fj.data.optic.Fold;
import fj.data.optic.Getter;
import fj.data.optic.PIso;
import fj.data.optic.PLens;
import fj.data.optic.POptional;
import fj.data.optic.PPrism;
import fj.data.optic.PSetter;
import fj.data.vector.V2;

public abstract class PTraversal<S, T, A, B> {
    public abstract <C> F<S, F<C, T>> modifyFunctionF(F<A, F<C, B>> var1);

    public abstract <L> F<S, Either<L, T>> modifyEitherF(F<A, Either<L, B>> var1);

    public abstract F<S, IO<T>> modifyIOF(F<A, IO<B>> var1);

    public abstract F<S, Trampoline<T>> modifyTrampolineF(F<A, Trampoline<B>> var1);

    public abstract F<S, Promise<T>> modifyPromiseF(F<A, Promise<B>> var1);

    public abstract F<S, List<T>> modifyListF(F<A, List<B>> var1);

    public abstract F<S, Option<T>> modifyOptionF(F<A, Option<B>> var1);

    public abstract F<S, Stream<T>> modifyStreamF(F<A, Stream<B>> var1);

    public abstract F<S, P1<T>> modifyP1F(F<A, P1<B>> var1);

    public abstract <E> F<S, Validation<E, T>> modifyValidationF(Semigroup<E> var1, F<A, Validation<E, B>> var2);

    public abstract F<S, V2<T>> modifyV2F(F<A, V2<B>> var1);

    public abstract <M> F<S, M> foldMap(Monoid<M> var1, F<A, M> var2);

    public final F<S, A> fold(Monoid<A> m) {
        return this.foldMap(m, Function.identity());
    }

    public final List<A> getAll(S s) {
        return this.foldMap(Monoid.listMonoid(), List::single).f(s);
    }

    public final F<S, Option<A>> find(F<A, Boolean> p) {
        return this.foldMap(Monoid.firstOptionMonoid(), a -> (Boolean)p.f(a) != false ? Option.some(a) : Option.none());
    }

    public final Option<A> headOption(S s) {
        return this.find(Function.constant(Boolean.TRUE)).f(s);
    }

    public final F<S, Boolean> exist(F<A, Boolean> p) {
        return this.foldMap(Monoid.disjunctionMonoid, p);
    }

    public final F<S, Boolean> all(F<A, Boolean> p) {
        return this.foldMap(Monoid.conjunctionMonoid, p);
    }

    public final F<S, T> modify(F<A, B> f) {
        return s -> this.modifyP1F(a -> P.p(f.f(a))).f(s)._1();
    }

    public final F<S, T> set(B b) {
        return this.modify(Function.constant(b));
    }

    public final <S1, T1> PTraversal<Either<S, S1>, Either<T, T1>, A, B> sum(final PTraversal<S1, T1, A, B> other) {
        final PTraversal self = this;
        return new PTraversal<Either<S, S1>, Either<T, T1>, A, B>(){

            @Override
            public <C> F<Either<S, S1>, F<C, Either<T, T1>>> modifyFunctionF(F<A, F<C, B>> f) {
                return ss1 -> ss1.either(s -> Function.compose(Either.left_(), self.modifyFunctionF(f).f(s)), s1 -> Function.compose(Either.right_(), other.modifyFunctionF(f).f(s1)));
            }

            @Override
            public <L> F<Either<S, S1>, Either<L, Either<T, T1>>> modifyEitherF(F<A, Either<L, B>> f) {
                return ss1 -> ss1.either(s -> self.modifyEitherF(f).f(s).right().map(Either.left_()), s1 -> other.modifyEitherF(f).f(s1).right().map(Either.right_()));
            }

            @Override
            public F<Either<S, S1>, IO<Either<T, T1>>> modifyIOF(F<A, IO<B>> f) {
                return ss1 -> ss1.either(s -> IOFunctions.map(self.modifyIOF(f).f(s), Either.left_()), s1 -> IOFunctions.map(other.modifyIOF(f).f(s1), Either.right_()));
            }

            @Override
            public F<Either<S, S1>, Trampoline<Either<T, T1>>> modifyTrampolineF(F<A, Trampoline<B>> f) {
                return ss1 -> ss1.either(s -> self.modifyTrampolineF(f).f(s).map(Either.left_()), s1 -> other.modifyTrampolineF(f).f(s1).map(Either.right_()));
            }

            @Override
            public F<Either<S, S1>, Promise<Either<T, T1>>> modifyPromiseF(F<A, Promise<B>> f) {
                return ss1 -> ss1.either(s -> self.modifyPromiseF(f).f(s).fmap(Either.left_()), s1 -> other.modifyPromiseF(f).f(s1).fmap(Either.right_()));
            }

            @Override
            public F<Either<S, S1>, List<Either<T, T1>>> modifyListF(F<A, List<B>> f) {
                return ss1 -> ss1.either(s -> self.modifyListF(f).f(s).map(Either.left_()), s1 -> other.modifyListF(f).f(s1).map(Either.right_()));
            }

            @Override
            public F<Either<S, S1>, Option<Either<T, T1>>> modifyOptionF(F<A, Option<B>> f) {
                return ss1 -> ss1.either(s -> self.modifyOptionF(f).f(s).map(Either.left_()), s1 -> other.modifyOptionF(f).f(s1).map(Either.right_()));
            }

            @Override
            public F<Either<S, S1>, Stream<Either<T, T1>>> modifyStreamF(F<A, Stream<B>> f) {
                return ss1 -> ss1.either(s -> self.modifyStreamF(f).f(s).map(Either.left_()), s1 -> other.modifyStreamF(f).f(s1).map(Either.right_()));
            }

            @Override
            public F<Either<S, S1>, P1<Either<T, T1>>> modifyP1F(F<A, P1<B>> f) {
                return ss1 -> ss1.either(s -> self.modifyP1F(f).f(s).map(Either.left_()), s1 -> other.modifyP1F(f).f(s1).map(Either.right_()));
            }

            @Override
            public F<Either<S, S1>, V2<Either<T, T1>>> modifyV2F(F<A, V2<B>> f) {
                return ss1 -> ss1.either(s -> self.modifyV2F(f).f(s).map(Either.left_()), s1 -> other.modifyV2F(f).f(s1).map(Either.right_()));
            }

            @Override
            public <E> F<Either<S, S1>, Validation<E, Either<T, T1>>> modifyValidationF(Semigroup<E> se, F<A, Validation<E, B>> f) {
                return ss1 -> ss1.either(s -> self.modifyValidationF(se, f).f(s).map(Either.left_()), s1 -> other.modifyValidationF(se, f).f(s1).map(Either.right_()));
            }

            @Override
            public <M> F<Either<S, S1>, M> foldMap(Monoid<M> monoid, F<A, M> f) {
                return ss1 -> ss1.either(self.foldMap(monoid, f), other.foldMap(monoid, f));
            }
        };
    }

    public final <C> Fold<S, C> composeFold(Fold<A, C> other) {
        return this.asFold().composeFold(other);
    }

    public final <C> Fold<S, C> composeFold(Getter<A, C> other) {
        return this.asFold().composeGetter(other);
    }

    public final <C, D> PSetter<S, T, C, D> composeSetter(PSetter<A, B, C, D> other) {
        return this.asSetter().composeSetter(other);
    }

    public final <C, D> PTraversal<S, T, C, D> composeTraversal(final PTraversal<A, B, C, D> other) {
        final PTraversal self = this;
        return new PTraversal<S, T, C, D>(){

            @Override
            public <G> F<S, F<G, T>> modifyFunctionF(F<C, F<G, D>> f) {
                return self.modifyFunctionF(other.modifyFunctionF(f));
            }

            @Override
            public <L> F<S, Either<L, T>> modifyEitherF(F<C, Either<L, D>> f) {
                return self.modifyEitherF(other.modifyEitherF(f));
            }

            @Override
            public F<S, IO<T>> modifyIOF(F<C, IO<D>> f) {
                return self.modifyIOF(other.modifyIOF(f));
            }

            @Override
            public F<S, Trampoline<T>> modifyTrampolineF(F<C, Trampoline<D>> f) {
                return self.modifyTrampolineF(other.modifyTrampolineF(f));
            }

            @Override
            public F<S, Promise<T>> modifyPromiseF(F<C, Promise<D>> f) {
                return self.modifyPromiseF(other.modifyPromiseF(f));
            }

            @Override
            public F<S, List<T>> modifyListF(F<C, List<D>> f) {
                return self.modifyListF(other.modifyListF(f));
            }

            @Override
            public F<S, Option<T>> modifyOptionF(F<C, Option<D>> f) {
                return self.modifyOptionF(other.modifyOptionF(f));
            }

            @Override
            public F<S, Stream<T>> modifyStreamF(F<C, Stream<D>> f) {
                return self.modifyStreamF(other.modifyStreamF(f));
            }

            @Override
            public F<S, P1<T>> modifyP1F(F<C, P1<D>> f) {
                return self.modifyP1F(other.modifyP1F(f));
            }

            @Override
            public <E> F<S, Validation<E, T>> modifyValidationF(Semigroup<E> s, F<C, Validation<E, D>> f) {
                return self.modifyValidationF(s, other.modifyValidationF(s, f));
            }

            @Override
            public F<S, V2<T>> modifyV2F(F<C, V2<D>> f) {
                return self.modifyV2F(other.modifyV2F(f));
            }

            @Override
            public <M> F<S, M> foldMap(Monoid<M> monoid, F<C, M> f) {
                return self.foldMap(monoid, other.foldMap(monoid, f));
            }
        };
    }

    public final <C, D> PTraversal<S, T, C, D> composeOptional(POptional<A, B, C, D> other) {
        return this.composeTraversal(other.asTraversal());
    }

    public final <C, D> PTraversal<S, T, C, D> composePrism(PPrism<A, B, C, D> other) {
        return this.composeTraversal(other.asTraversal());
    }

    public final <C, D> PTraversal<S, T, C, D> composeLens(PLens<A, B, C, D> other) {
        return this.composeTraversal(other.asTraversal());
    }

    public final <C, D> PTraversal<S, T, C, D> composeIso(PIso<A, B, C, D> other) {
        return this.composeTraversal(other.asTraversal());
    }

    public final Fold<S, A> asFold() {
        return new Fold<S, A>(){

            @Override
            public <M> F<S, M> foldMap(Monoid<M> monoid, F<A, M> f) {
                return PTraversal.this.foldMap(monoid, f);
            }
        };
    }

    public PSetter<S, T, A, B> asSetter() {
        return PSetter.pSetter(this::modify);
    }

    public static <S, T> PTraversal<S, T, S, T> pId() {
        return PIso.pId().asTraversal();
    }

    public static <S, T> PTraversal<Either<S, S>, Either<T, T>, S, T> pCodiagonal() {
        return new PTraversal<Either<S, S>, Either<T, T>, S, T>(){

            @Override
            public <C> F<Either<S, S>, F<C, Either<T, T>>> modifyFunctionF(F<S, F<C, T>> f) {
                return s -> s.bimap(f, f).either(f1 -> Function.compose(Either.left_(), f1), f1 -> Function.compose(Either.right_(), f1));
            }

            @Override
            public <L> F<Either<S, S>, Either<L, Either<T, T>>> modifyEitherF(F<S, Either<L, T>> f) {
                return s -> s.bimap(f, f).either(e -> e.right().map(Either.left_()), e -> e.right().map(Either.right_()));
            }

            @Override
            public F<Either<S, S>, IO<Either<T, T>>> modifyIOF(F<S, IO<T>> f) {
                return s -> s.bimap(f, f).either(io -> IOFunctions.map(io, Either.left_()), io -> IOFunctions.map(io, Either.right_()));
            }

            @Override
            public F<Either<S, S>, Trampoline<Either<T, T>>> modifyTrampolineF(F<S, Trampoline<T>> f) {
                return s -> s.bimap(f, f).either(t -> t.map(Either.left_()), t -> t.map(Either.right_()));
            }

            @Override
            public F<Either<S, S>, Promise<Either<T, T>>> modifyPromiseF(F<S, Promise<T>> f) {
                return s -> s.bimap(f, f).either(p -> p.fmap(Either.left_()), p -> p.fmap(Either.right_()));
            }

            @Override
            public F<Either<S, S>, List<Either<T, T>>> modifyListF(F<S, List<T>> f) {
                return s -> s.bimap(f, f).either(l -> l.map(Either.left_()), l -> l.map(Either.right_()));
            }

            @Override
            public F<Either<S, S>, Option<Either<T, T>>> modifyOptionF(F<S, Option<T>> f) {
                return s -> s.bimap(f, f).either(o -> o.map(Either.left_()), o -> o.map(Either.right_()));
            }

            @Override
            public F<Either<S, S>, Stream<Either<T, T>>> modifyStreamF(F<S, Stream<T>> f) {
                return s -> s.bimap(f, f).either(stream -> stream.map(Either.left_()), stream -> stream.map(Either.right_()));
            }

            @Override
            public F<Either<S, S>, P1<Either<T, T>>> modifyP1F(F<S, P1<T>> f) {
                return s -> s.bimap(f, f).either(p1 -> p1.map(Either.left_()), p1 -> p1.map(Either.right_()));
            }

            @Override
            public F<Either<S, S>, V2<Either<T, T>>> modifyV2F(F<S, V2<T>> f) {
                return s -> s.bimap(f, f).either(v2 -> v2.map(Either.left_()), v2 -> v2.map(Either.right_()));
            }

            @Override
            public <E> F<Either<S, S>, Validation<E, Either<T, T>>> modifyValidationF(Semigroup<E> se, F<S, Validation<E, T>> f) {
                return s -> s.bimap(f, f).either(v -> v.map(Either.left_()), v -> v.map(Either.right_()));
            }

            @Override
            public <M> F<Either<S, S>, M> foldMap(Monoid<M> monoid, F<S, M> f) {
                return s -> s.either(f, f);
            }
        };
    }

    public static <S, T, A, B> PTraversal<S, T, A, B> pTraversal(final F<S, A> get1, final F<S, A> get2, final F3<B, B, S, T> set) {
        return new PTraversal<S, T, A, B>(){

            @Override
            public <C> F<S, F<C, T>> modifyFunctionF(F<A, F<C, B>> f) {
                return s -> Function.apply(Function.compose(b1 -> b2 -> set.f(b1, b2, s), (F)f.f(get1.f(s))), (F)f.f(get2.f(s)));
            }

            @Override
            public <L> F<S, Either<L, T>> modifyEitherF(F<A, Either<L, B>> f) {
                return s -> ((Either)f.f(get2.f(s))).right().apply(((Either)f.f(get1.f(s))).right().map(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public F<S, IO<T>> modifyIOF(F<A, IO<B>> f) {
                return s -> IOFunctions.apply((IO)f.f(get2.f(s)), IOFunctions.map((IO)f.f(get1.f(s)), b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public F<S, Trampoline<T>> modifyTrampolineF(F<A, Trampoline<B>> f) {
                return s -> ((Trampoline)f.f(get2.f(s))).apply(((Trampoline)f.f(get1.f(s))).map(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public F<S, Promise<T>> modifyPromiseF(F<A, Promise<B>> f) {
                return s -> ((Promise)f.f(get2.f(s))).apply(((Promise)f.f(get1.f(s))).fmap(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public F<S, List<T>> modifyListF(F<A, List<B>> f) {
                return s -> ((List)f.f(get2.f(s))).apply(((List)f.f(get1.f(s))).map(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public F<S, Option<T>> modifyOptionF(F<A, Option<B>> f) {
                return s -> ((Option)f.f(get2.f(s))).apply(((Option)f.f(get1.f(s))).map(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public F<S, Stream<T>> modifyStreamF(F<A, Stream<B>> f) {
                return s -> ((Stream)f.f(get2.f(s))).apply(((Stream)f.f(get1.f(s))).map(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public F<S, P1<T>> modifyP1F(F<A, P1<B>> f) {
                return s -> ((P1)f.f(get2.f(s))).apply(((P1)f.f(get1.f(s))).map(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public F<S, V2<T>> modifyV2F(F<A, V2<B>> f) {
                return s -> ((V2)f.f(get2.f(s))).apply(((V2)f.f(get1.f(s))).map(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public <E> F<S, Validation<E, T>> modifyValidationF(Semigroup<E> se, F<A, Validation<E, B>> f) {
                return s -> ((Validation)f.f(get2.f(s))).accumapply(se, ((Validation)f.f(get1.f(s))).map(b1 -> b2 -> set.f(b1, b2, s)));
            }

            @Override
            public <M> F<S, M> foldMap(Monoid<M> monoid, F<A, M> f) {
                return s -> monoid.sum(f.f(get1.f(s)), f.f(get2.f(s)));
            }
        };
    }

    public static <S, T, A, B> PTraversal<S, T, A, B> pTraversal(F<S, A> get1, F<S, A> get2, F<S, A> get3, F4<B, B, B, S, T> set) {
        return PTraversal.fromCurried(PTraversal.pTraversal(get1, get2, (b1, b2, s) -> b3 -> set.f(b1, b2, b3, s)), get3);
    }

    public static <S, T, A, B> PTraversal<S, T, A, B> pTraversal(F<S, A> get1, F<S, A> get2, F<S, A> get3, F<S, A> get4, F5<B, B, B, B, S, T> set) {
        return PTraversal.fromCurried(PTraversal.pTraversal(get1, get2, get3, (b1, b2, b3, s) -> b4 -> set.f(b1, b2, b3, b4, s)), get4);
    }

    public static <S, T, A, B> PTraversal<S, T, A, B> pTraversal(F<S, A> get1, F<S, A> get2, F<S, A> get3, F<S, A> get4, F<S, A> get5, F6<B, B, B, B, B, S, T> set) {
        return PTraversal.fromCurried(PTraversal.pTraversal(get1, get2, get3, get4, (b1, b2, b3, b4, s) -> b5 -> set.f(b1, b2, b3, b4, b5, s)), get5);
    }

    public static <S, T, A, B> PTraversal<S, T, A, B> pTraversal(F<S, A> get1, F<S, A> get2, F<S, A> get3, F<S, A> get4, F<S, A> get5, F<S, A> get6, F7<B, B, B, B, B, B, S, T> set) {
        return PTraversal.fromCurried(PTraversal.pTraversal(get1, get2, get3, get4, get5, (b1, b2, b3, b4, b5, s) -> b6 -> set.f(b1, b2, b3, b4, b5, b6, s)), get6);
    }

    private static <S, T, A, B> PTraversal<S, T, A, B> fromCurried(final PTraversal<S, F<B, T>, A, B> curriedTraversal, final F<S, A> lastGet) {
        return new PTraversal<S, T, A, B>(){

            @Override
            public <C> F<S, F<C, T>> modifyFunctionF(F<A, F<C, B>> f) {
                return s -> Function.apply(curriedTraversal.modifyFunctionF(f).f(s), (F)f.f(lastGet.f(s)));
            }

            @Override
            public <L> F<S, Either<L, T>> modifyEitherF(F<A, Either<L, B>> f) {
                return s -> ((Either)f.f(lastGet.f(s))).right().apply(curriedTraversal.modifyEitherF(f).f(s));
            }

            @Override
            public F<S, IO<T>> modifyIOF(F<A, IO<B>> f) {
                return s -> IOFunctions.apply((IO)f.f(lastGet.f(s)), curriedTraversal.modifyIOF(f).f(s));
            }

            @Override
            public F<S, Trampoline<T>> modifyTrampolineF(F<A, Trampoline<B>> f) {
                return s -> ((Trampoline)f.f(lastGet.f(s))).apply(curriedTraversal.modifyTrampolineF(f).f(s));
            }

            @Override
            public F<S, Promise<T>> modifyPromiseF(F<A, Promise<B>> f) {
                return s -> ((Promise)f.f(lastGet.f(s))).apply(curriedTraversal.modifyPromiseF(f).f(s));
            }

            @Override
            public F<S, List<T>> modifyListF(F<A, List<B>> f) {
                return s -> ((List)f.f(lastGet.f(s))).apply(curriedTraversal.modifyListF(f).f(s));
            }

            @Override
            public F<S, Option<T>> modifyOptionF(F<A, Option<B>> f) {
                return s -> ((Option)f.f(lastGet.f(s))).apply(curriedTraversal.modifyOptionF(f).f(s));
            }

            @Override
            public F<S, Stream<T>> modifyStreamF(F<A, Stream<B>> f) {
                return s -> ((Stream)f.f(lastGet.f(s))).apply(curriedTraversal.modifyStreamF(f).f(s));
            }

            @Override
            public F<S, P1<T>> modifyP1F(F<A, P1<B>> f) {
                return s -> ((P1)f.f(lastGet.f(s))).apply(curriedTraversal.modifyP1F(f).f(s));
            }

            @Override
            public F<S, V2<T>> modifyV2F(F<A, V2<B>> f) {
                return s -> ((V2)f.f(lastGet.f(s))).apply(curriedTraversal.modifyV2F(f).f(s));
            }

            @Override
            public <E> F<S, Validation<E, T>> modifyValidationF(Semigroup<E> se, F<A, Validation<E, B>> f) {
                return s -> ((Validation)f.f(lastGet.f(s))).accumapply(se, curriedTraversal.modifyValidationF(se, f).f(s));
            }

            @Override
            public <M> F<S, M> foldMap(Monoid<M> monoid, F<A, M> f) {
                return s -> monoid.sum(curriedTraversal.foldMap(monoid, f).f(s), f.f(lastGet.f(s)));
            }
        };
    }
}

