/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F0;
import fj.F2;
import fj.F2Functions;
import fj.Function;
import fj.Hash;
import fj.Monoid;
import fj.Ord;
import fj.Ordering;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Semigroup;
import fj.Show;
import fj.Unit;
import fj.control.Trampoline;
import fj.control.parallel.Promise;
import fj.control.parallel.Strategy;
import fj.data.Array;
import fj.data.Either;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.data.TreeMap;
import fj.data.Validation;
import fj.data.optic.Optional;
import fj.data.optic.PTraversal;
import fj.data.optic.Prism;
import fj.data.optic.Traversal;
import fj.data.vector.V;
import fj.data.vector.V2;
import fj.function.Booleans;
import fj.function.Effect1;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public abstract class List<A>
implements Iterable<A> {
    private List() {
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A head();

    public abstract List<A> tail();

    public final int length() {
        return this.foldLeft((B i, A a) -> i + 1, Integer.valueOf(0));
    }

    public final boolean isEmpty() {
        return this instanceof Nil;
    }

    public final boolean isNotEmpty() {
        return this instanceof Cons;
    }

    @Deprecated
    public final <B> B list(B nil, F<A, F<List<A>, B>> cons) {
        return this.uncons(Function.uncurryF2(cons), nil);
    }

    public final <B> B uncons(F2<A, List<A>, B> cons, B nil) {
        return this.isEmpty() ? nil : cons.f(this.head(), this.tail());
    }

    public final A orHead(F0<A> a) {
        return this.isEmpty() ? a.f() : this.head();
    }

    public final List<A> orTail(F0<List<A>> as) {
        return this.isEmpty() ? as.f() : this.tail();
    }

    @Deprecated
    public final Option<A> toOption() {
        return this.headOption();
    }

    public final Option<A> headOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    public final <X> Either<X, A> toEither(F0<X> x) {
        return this.isEmpty() ? Either.left(x.f()) : Either.right(this.head());
    }

    public final Stream<A> toStream() {
        return this.isEmpty() ? Stream.nil() : Stream.cons(this.head(), () -> this.tail().toStream());
    }

    public final Array<A> toArray() {
        return Array.mkArray(this.toArrayObject());
    }

    public final Object[] toArrayObject() {
        int length = this.length();
        Object[] a = new Object[length];
        List<A> x = this;
        for (int i = 0; i < length; ++i) {
            a[i] = x.head();
            x = x.tail();
        }
        return a;
    }

    @Deprecated
    public final A[] toJavaArray() {
        return this.toArrayObject();
    }

    public final Array<A> toArray(Class<A[]> c) {
        Object[] a = (Object[])java.lang.reflect.Array.newInstance(c.getComponentType(), this.length());
        List<A> x = this;
        for (int i = 0; i < this.length(); ++i) {
            a[i] = x.head();
            x = x.tail();
        }
        return Array.array(a);
    }

    public final A[] array(Class<A[]> c) {
        return this.toArray(c).array(c);
    }

    public final List<A> cons(A a) {
        return new Cons<A>(a, this);
    }

    public final List<A> conss(A a) {
        return new Cons<A>(a, this);
    }

    public final <B> List<B> map(F<A, B> f) {
        Buffer<B> bs = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            bs.snoc(f.f(xs.head()));
            xs = xs.tail();
        }
        return bs.toList();
    }

    public final Unit foreach(F<A, Unit> f) {
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            f.f(xs.head());
            xs = xs.tail();
        }
        return Unit.unit();
    }

    public final void foreachDoEffect(Effect1<A> f) {
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            f.f(xs.head());
            xs = xs.tail();
        }
    }

    public final List<A> filter(F<A, Boolean> f) {
        Buffer<A> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            A h = xs.head();
            if (f.f(h).booleanValue()) {
                b.snoc(h);
            }
            xs = xs.tail();
        }
        return b.toList();
    }

    public final List<A> removeAll(F<A, Boolean> f) {
        return this.filter(Function.compose(Booleans.not, f));
    }

    public final List<A> delete(A a, Equal<A> e) {
        P2<List<A>, List<A>> p = this.span(Function.compose(Booleans.not, e.eq(a)));
        return p._2().isEmpty() ? p._1() : p._1().append(p._2().tail());
    }

    public final List<A> takeWhile(F<A, Boolean> f) {
        Buffer<A> b = Buffer.empty();
        boolean taking = true;
        List<A> xs = this;
        while (xs.isNotEmpty() && taking) {
            A h = xs.head();
            if (f.f(h).booleanValue()) {
                b.snoc(h);
            } else {
                taking = false;
            }
            xs = xs.tail();
        }
        return b.toList();
    }

    public final List<A> dropWhile(F<A, Boolean> f) {
        List<A> xs = this;
        while (xs.isNotEmpty() && f.f(xs.head()).booleanValue()) {
            xs = xs.tail();
        }
        return xs;
    }

    public final P2<List<A>, List<A>> span(F<A, Boolean> p) {
        Buffer<A> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            if (!p.f(xs.head()).booleanValue()) {
                return P.p(b.toList(), xs);
            }
            b.snoc(xs.head());
            xs = xs.tail();
        }
        return P.p(b.toList(), List.nil());
    }

    public final P2<List<A>, List<A>> breakk(F<A, Boolean> p) {
        return this.span(a -> (Boolean)p.f(a) == false);
    }

    public final List<List<A>> group(Equal<A> e) {
        if (this.isEmpty()) {
            return List.nil();
        }
        P2<List<A>, List<A>> z = this.tail().span(e.eq(this.head()));
        return List.cons(z._1().cons(this.head()), z._2().group(e));
    }

    public final <B> List<B> bind(F<A, List<B>> f) {
        Buffer<B> b = Buffer.empty();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            b.append(f.f(xs.head()));
            xs = xs.tail();
        }
        return b.toList();
    }

    public final <B, C> List<C> bind(List<B> lb, F<A, F<B, C>> f) {
        return lb.apply(this.map(f));
    }

    public final <B, C> List<C> bind(List<B> lb, F2<A, B, C> f) {
        return this.bind(lb, Function.curry(f));
    }

    public static <A, B, C> F<List<A>, F<List<B>, List<C>>> liftM2(F<A, F<B, C>> f) {
        return Function.curry((as, bs) -> as.bind((List)bs, f));
    }

    public final <B, C, D> List<D> bind(List<B> lb, List<C> lc, F<A, F<B, F<C, D>>> f) {
        return lc.apply(this.bind(lb, f));
    }

    public final <B, C, D, E> List<E> bind(List<B> lb, List<C> lc, List<D> ld, F<A, F<B, F<C, F<D, E>>>> f) {
        return ld.apply(this.bind(lb, lc, f));
    }

    public final <B, C, D, E, F$> List<F$> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return le.apply(this.bind(lb, lc, ld, f));
    }

    public final <B, C, D, E, F$, G> List<G> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return lf.apply(this.bind(lb, lc, ld, le, f));
    }

    public final <B, C, D, E, F$, G, H> List<H> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, List<G> lg, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return lg.apply(this.bind(lb, lc, ld, le, lf, f));
    }

    public final <B, C, D, E, F$, G, H, I> List<I> bind(List<B> lb, List<C> lc, List<D> ld, List<E> le, List<F$> lf, List<G> lg, List<H> lh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return lh.apply(this.bind(lb, lc, ld, le, lf, lg, f));
    }

    public final <B> List<B> sequence(List<B> bs) {
        F c = Function.constant(bs);
        return this.bind(c);
    }

    public final <B> Option<List<B>> traverseOption(F<A, Option<B>> f) {
        return this.foldRight((A a, B obs) -> ((Option)f.f(a)).bind((A o) -> obs.map(os -> os.cons(o))), Option.some(List.nil()));
    }

    public final <B, E> Either<E, List<B>> traverseEither(F<A, Either<E, B>> f) {
        return this.foldRight((A a, B acc) -> ((Either)f.f(a)).right().bind((B e) -> acc.right().map((B es) -> es.cons(e))), Either.right(List.nil()));
    }

    public final <B> Stream<List<B>> traverseStream(F<A, Stream<B>> f) {
        return this.foldRight((A a, B acc) -> ((Stream)f.f(a)).bind((A s) -> acc.map(ss -> ss.cons(s))), Stream.nil());
    }

    public final <B> P1<List<B>> traverseP1(F<A, P1<B>> f) {
        return this.foldRight((A a, B acc) -> ((P1)f.f(a)).bind((A b) -> acc.map(bs -> bs.cons(b))), P.p(List.nil()));
    }

    public final <B> IO<List<B>> traverseIO(F<A, IO<B>> f) {
        return this.foldRight((A a, B acc) -> IOFunctions.bind((IO)f.f(a), b -> IOFunctions.map(acc, bs -> bs.cons(b))), IOFunctions.unit(List.nil()));
    }

    public final <C, B> F<C, List<B>> traverseF(F<A, F<C, B>> f) {
        return this.foldRight((A a, B acc) -> Function.bind(acc, bs -> Function.compose(bs::cons, (F)f.f(a))), Function.constant(List.nil()));
    }

    public final <B> Trampoline<List<B>> traverseTrampoline(F<A, Trampoline<B>> f) {
        return this.foldRight((A a, B acc) -> ((Trampoline)f.f(a)).bind((A b) -> acc.map(bs -> bs.cons(b))), Trampoline.pure(List.nil()));
    }

    public final <B> Promise<List<B>> traversePromise(F<A, Promise<B>> f) {
        return this.foldRight((A a, B acc) -> ((Promise)f.f(a)).bind((A b) -> acc.fmap(bs -> bs.cons(b))), Promise.promise(Strategy.idStrategy(), P.p(List.nil())));
    }

    public final <B> List<List<B>> traverseList(F<A, List<B>> f) {
        return this.foldRight((A a, B acc) -> ((List)f.f(a)).bind(b -> acc.map(bs -> bs.cons(b))), List.single(List.nil()));
    }

    public final <E, B> Validation<E, List<B>> traverseValidation(Semigroup<E> s, F<A, Validation<E, B>> f) {
        return Validation.sequence(s, this.map(f));
    }

    public final <B> V2<List<B>> traverseV2(F<A, V2<B>> f) {
        return this.foldRight((A a, B acc) -> acc.apply(((V2)f.f(a)).map(e -> es -> es.cons(e))), V.v(List.nil(), List.nil()));
    }

    public final <B> List<B> apply(List<F<A, B>> lf) {
        return lf.bind(this::map);
    }

    public final List<A> append(List<A> as) {
        return Buffer.fromList(this).prependToList(as);
    }

    public final <B> B foldRight(F<A, F<B, B>> f, B b) {
        return this.foldRight(Function.uncurryF2(f), b);
    }

    public final <B> B foldRight(F2<A, B, B> f, B b) {
        return this.reverse().foldLeft(Function.flip(f), b);
    }

    public final <B> Trampoline<B> foldRightC(F2<A, B, B> f, B b) {
        return Trampoline.suspend(() -> this.isEmpty() ? Trampoline.pure(b) : this.tail().foldRightC(f, b).map(F2Functions.f(f, this.head())));
    }

    public final <B> B foldLeft(F<B, F<A, B>> f, B b) {
        return this.foldLeft(Function.uncurryF2(f), b);
    }

    public final <B> B foldLeft(F2<B, A, B> f, B b) {
        B x = b;
        List<A> xs = this;
        while (!xs.isEmpty()) {
            x = f.f(x, xs.head());
            xs = xs.tail();
        }
        return x;
    }

    public final A foldLeft1(F2<A, A, A> f) {
        if (this.isEmpty()) {
            throw Bottom.error("Undefined: foldLeft1 on empty list");
        }
        return this.tail().foldLeft(f, this.head());
    }

    public final A foldLeft1(F<A, F<A, A>> f) {
        return this.foldLeft1(Function.uncurryF2(f));
    }

    public final List<A> reverse() {
        return this.foldLeft((B as, A a) -> List.cons(a, as), List.nil());
    }

    public final A index(int i) {
        if (i < 0 || i > this.length() - 1) {
            throw Bottom.error("index " + i + " out of range on list with length " + this.length());
        }
        List<A> xs = this;
        for (int c = 0; c < i; ++c) {
            xs = xs.tail();
        }
        return xs.head();
    }

    public final List<A> take(int i) {
        Buffer<A> result = Buffer.empty();
        List<A> list = this;
        for (int index = i; index > 0 && list.isNotEmpty(); --index) {
            result.snoc(list.head());
            list = list.tail();
        }
        return result.toList();
    }

    public final List<A> drop(int i) {
        List<A> xs = this;
        int c = 0;
        while (xs.isNotEmpty() && c < i) {
            ++c;
            xs = xs.tail();
        }
        return xs;
    }

    public final P2<List<A>, List<A>> splitAt(int i) {
        int c = 0;
        List<A> first = List.nil();
        List<A> second = List.nil();
        List<A> xs = this;
        while (xs.isNotEmpty()) {
            A h = xs.head();
            if (c < i) {
                first = first.cons(h);
            } else {
                second = second.cons(h);
            }
            ++c;
            xs = xs.tail();
        }
        return P.p(first.reverse(), second.reverse());
    }

    public final List<List<A>> partition(int n) {
        if (n < 1) {
            throw Bottom.error("Can't create list partitions shorter than 1 element long.");
        }
        if (this.isEmpty()) {
            throw Bottom.error("Partition on empty list.");
        }
        return List.unfold(as -> as.isEmpty() ? Option.none() : Option.some(as.splitAt(n)), this);
    }

    public final P2<List<A>, List<A>> partition(F<A, Boolean> f) {
        P2<List<A>, List<A>> p2 = this.foldLeft((B acc, A a) -> (Boolean)f.f(a) != false ? P.p(((List)acc._1()).cons(a), acc._2()) : P.p(acc._1(), ((List)acc._2()).cons(a)), P.p(List.nil(), List.nil()));
        return P.p(p2._1().reverse(), p2._2().reverse());
    }

    public final List<List<A>> inits() {
        List<List<List<A>>> s = List.single(List.nil());
        if (this.isNotEmpty()) {
            s = s.append(this.tail().inits().map(List.cons().f(this.head())));
        }
        return s;
    }

    public final List<List<A>> tails() {
        return this.isEmpty() ? List.single(List.nil()) : List.cons(this, this.tail().tails());
    }

    public final List<A> sort(Ord<A> o) {
        if (this.isEmpty()) {
            return List.nil();
        }
        if (this.tail().isEmpty()) {
            return this;
        }
        P2<List<A>, List<A>> s = this.splitAt(this.length() / 2);
        final class Merge {
            Merge() {
            }

            List<A> merge(List<A> xs, List<A> ys, Ord<A> o) {
                Buffer buf = Buffer.empty();
                while (true) {
                    Object y;
                    if (xs.isEmpty()) {
                        buf.append(ys);
                        break;
                    }
                    if (ys.isEmpty()) {
                        buf.append(xs);
                        break;
                    }
                    Object x = xs.head();
                    if (o.isLessThanOrEqualTo(x, y = ys.head())) {
                        buf.snoc(x);
                        xs = xs.tail();
                        continue;
                    }
                    buf.snoc(y);
                    ys = ys.tail();
                }
                return buf.toList();
            }
        }
        return new Merge().merge(s._1().sort(o), s._2().sort(o), o);
    }

    public final <B, C> List<C> zipWith(List<B> bs, F<A, F<B, C>> f) {
        Buffer<C> buf = Buffer.empty();
        List<A> as = this;
        while (as.isNotEmpty() && bs.isNotEmpty()) {
            buf.snoc(f.f(as.head()).f(bs.head()));
            as = as.tail();
            bs = bs.tail();
        }
        return buf.toList();
    }

    public final <B, C> List<C> zipWith(List<B> bs, F2<A, B, C> f) {
        return this.zipWith(bs, Function.curry(f));
    }

    public static <A, B, C> F<List<A>, F<List<B>, F<F<A, F<B, C>>, List<C>>>> zipWith() {
        return Function.curry((as, bs, f) -> as.zipWith((List)bs, (F)f));
    }

    public final <B> List<P2<A, B>> zip(List<B> bs) {
        F __2 = P.p2();
        return this.zipWith(bs, __2);
    }

    public static <A, B> F<List<A>, F<List<B>, List<P2<A, B>>>> zip() {
        return Function.curry(List::zip);
    }

    public final List<P2<A, Integer>> zipIndex() {
        return this.zipWith(List.range(0, this.length()), (A a) -> i -> P.p(a, i));
    }

    public final List<A> snoc(A a) {
        return Buffer.fromList(this).snoc(a).toList();
    }

    public final boolean forall(F<A, Boolean> f) {
        return this.isEmpty() || f.f(this.head()) != false && this.tail().forall(f);
    }

    public final boolean exists(F<A, Boolean> f) {
        return this.find(f).isSome();
    }

    public final Option<A> find(F<A, Boolean> f) {
        List<A> as = this;
        while (as.isNotEmpty()) {
            if (f.f(as.head()).booleanValue()) {
                return Option.some(as.head());
            }
            as = as.tail();
        }
        return Option.none();
    }

    public final List<A> intersperse(A a) {
        return this.isEmpty() || this.tail().isEmpty() ? this : List.cons(this.head(), this.tail().bind(a2 -> List.list(a, a2)));
    }

    public final List<A> intercalate(List<List<A>> as) {
        return List.join(as.intersperse(this));
    }

    public final List<A> nub() {
        return this.nub(Equal.anyEqual());
    }

    public final List<A> nub(Equal<A> eq) {
        return this.isEmpty() ? this : List.cons(this.head(), this.tail().filter(a -> !eq.eq(a, this.head())).nub(eq));
    }

    public final List<A> nub(Ord<A> o) {
        return this.sort(o).group(o.equal()).map(List.head_());
    }

    public static <A> F<List<A>, A> head_() {
        return List::head;
    }

    public final Option<List<A>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    public static <A> F<List<A>, List<A>> tail_() {
        return List::tail;
    }

    public final List<A> minus(Equal<A> eq, List<A> xs) {
        return this.removeAll(Function.compose(Monoid.disjunctionMonoid.sumLeft(), xs.mapM(Function.curry(eq.eq()))));
    }

    public final <B, C> F<B, List<C>> mapM(F<A, F<B, C>> f) {
        return List.sequence_(this.map(f));
    }

    public final <B> Option<List<B>> mapMOption(F<A, Option<B>> f) {
        return this.traverseOption(f);
    }

    public final <B> Trampoline<List<B>> mapMTrampoline(F<A, Trampoline<B>> f) {
        return this.foldRight((A a, B bs) -> ((Trampoline)f.f(a)).bind((A b) -> bs.map(bbs -> bbs.cons(b))), Trampoline.pure(List.nil()));
    }

    public final Option<Integer> elementIndex(Equal<A> e, A a) {
        return List.lookup(e, this.zipIndex(), a);
    }

    public final A last() {
        A a = this.head();
        List<A> xs = this.tail();
        while (xs.isNotEmpty()) {
            a = xs.head();
            xs = xs.tail();
        }
        return a;
    }

    public final List<A> init() {
        List<A> ys = this;
        Buffer<A> a = Buffer.empty();
        while (ys.isNotEmpty() && ys.tail().isNotEmpty()) {
            a.snoc(ys.head());
            ys = ys.tail();
        }
        return a.toList();
    }

    public final List<A> insertBy(F<A, F<A, Ordering>> f, A x) {
        List<A> ys = this;
        Buffer<A> xs = Buffer.empty();
        while (ys.isNotEmpty() && f.f(x).f(ys.head()) == Ordering.GT) {
            xs = xs.snoc(ys.head());
            ys = ys.tail();
        }
        return xs.append(ys.cons(x)).toList();
    }

    public final A mode(Ord<A> o) {
        return this.sort(o).group(o.equal()).maximum(Ord.intOrd.contramap(List.length_())).head();
    }

    @Deprecated
    public final <B> TreeMap<B, List<A>> groupBy(F<A, B> keyFunction) {
        return this.groupBy(keyFunction, Ord.hashOrd());
    }

    public final <B> TreeMap<B, List<A>> groupBy(F<A, B> keyFunction, Ord<B> keyOrd) {
        return this.groupBy(keyFunction, Function.identity(), keyOrd);
    }

    @Deprecated
    public final <B, C> TreeMap<B, List<C>> groupBy(F<A, B> keyFunction, F<A, C> valueFunction) {
        return this.groupBy(keyFunction, valueFunction, Ord.hashOrd());
    }

    public final <B, C> TreeMap<B, List<C>> groupBy(F<A, B> keyFunction, F<A, C> valueFunction, Ord<B> keyOrd) {
        return this.groupBy(keyFunction, valueFunction, List.nil(), List::cons, keyOrd);
    }

    public final <B, C> TreeMap<B, C> groupBy(F<A, B> keyFunction, F<A, C> valueFunction, Monoid<C> monoid, Ord<B> keyOrd) {
        return this.groupBy(keyFunction, valueFunction, monoid.zero(), Function.uncurryF2(monoid.sum()), keyOrd);
    }

    public final <B, C, D> TreeMap<B, D> groupBy(F<A, B> keyFunction, F<A, C> valueFunction, D groupingIdentity, F2<C, D, D> groupingAcc, Ord<B> keyOrd) {
        java.util.TreeMap buffer = new java.util.TreeMap(keyOrd.toComparator());
        this.foreachDoEffect(element -> {
            Object key = keyFunction.f(element);
            Object value = valueFunction.f(element);
            buffer.put(key, buffer.containsKey(key) ? groupingAcc.f(value, buffer.get(key)) : groupingAcc.f(value, groupingIdentity));
        });
        return TreeMap.fromMutableMap(keyOrd, buffer);
    }

    public final boolean allEqual(Equal<A> eq) {
        return this.isEmpty() || this.tail().isEmpty() || eq.eq(this.head(), this.tail().head()) && this.tail().allEqual(eq);
    }

    public final boolean isPrefixOf(Equal<A> eq, List<A> xs) {
        Iterator<A> i = this.iterator();
        Iterator<A> j = xs.iterator();
        while (i.hasNext() && j.hasNext()) {
            if (eq.eq(i.next(), j.next())) continue;
            return false;
        }
        return !i.hasNext();
    }

    public final boolean isSuffixOf(Equal<A> eq, List<A> xs) {
        Iterator<A> i = this.iterator();
        Iterator<A> j = xs.drop(xs.length() - this.length()).iterator();
        while (i.hasNext() && j.hasNext()) {
            if (eq.eq(i.next(), j.next())) continue;
            return false;
        }
        return !i.hasNext();
    }

    public static <A> F<List<A>, Integer> length_() {
        return List::length;
    }

    public final A maximum(Ord<A> o) {
        return (A)this.foldLeft1(o::max);
    }

    public final Option<A> maximumOption(Ord<A> o) {
        return NonEmptyList.fromList(this).map(nel -> nel.maximum(o));
    }

    public final A minimum(Ord<A> o) {
        return (A)this.foldLeft1(o::min);
    }

    public final Option<A> minimumOption(Ord<A> o) {
        return NonEmptyList.fromList(this).map(nel -> nel.minimum(o));
    }

    public final java.util.List<A> toJavaList() {
        return new LinkedList<A>(this.toCollection());
    }

    public final Collection<A> toCollection() {
        return new AbstractCollection<A>(){

            @Override
            public Iterator<A> iterator() {
                return new Iterator<A>(){
                    private List<A> xs;
                    {
                        this.xs = List.this;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.xs.isNotEmpty();
                    }

                    @Override
                    public A next() {
                        if (this.xs.isEmpty()) {
                            throw new NoSuchElementException();
                        }
                        Object a = this.xs.head();
                        this.xs = this.xs.tail();
                        return a;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return List.this.length();
            }
        };
    }

    @SafeVarargs
    public static <A> List<A> list(A ... as) {
        return List.arrayList(as);
    }

    @SafeVarargs
    public static <A> List<A> arrayList(A ... as) {
        return Array.array(as).toList();
    }

    @Deprecated
    public static <A> List<A> list(Iterable<A> i) {
        return List.iterableList(i);
    }

    @Deprecated
    public static <A> List<A> list(Iterator<A> it) {
        return List.iteratorList(it);
    }

    public static <A> List<A> fromIterator(Iterator<A> it) {
        return List.iterableList(() -> it);
    }

    public static <A> List<A> nil() {
        return Nil.INSTANCE;
    }

    public static <A> F<A, F<List<A>, List<A>>> cons() {
        return a -> tail -> List.cons(a, tail);
    }

    public static <A> F2<A, List<A>, List<A>> cons_() {
        return List::cons;
    }

    public static <A> F<A, List<A>> cons(List<A> tail) {
        return tail::cons;
    }

    public static <A> F<List<A>, List<A>> cons_(A a) {
        return as -> as.cons(a);
    }

    public static <A> List<A> cons(A head, List<A> tail) {
        return new Cons<A>(head, tail);
    }

    public static <A> F<List<A>, Boolean> isEmpty_() {
        return List::isEmpty;
    }

    public static <A> F<List<A>, Boolean> isNotEmpty_() {
        return List::isNotEmpty;
    }

    public static <A> List<A> join(List<List<A>> o) {
        F id = Function.identity();
        return o.bind(id);
    }

    public static <A> F<List<List<A>>, List<A>> join() {
        return List::join;
    }

    public static <A, B> List<A> unfold(F<B, Option<P2<A, B>>> f, B b) {
        Buffer<A> buf = Buffer.empty();
        Option<P2<A, B>> o = f.f(b);
        while (o.isSome()) {
            buf = buf.snoc(o.some()._1());
            o = f.f(o.some()._2());
        }
        return buf.toList();
    }

    public static <A, B> P2<List<A>, List<B>> unzip(List<P2<A, B>> xs) {
        Buffer<A> ba = Buffer.empty();
        Buffer<B> bb = Buffer.empty();
        for (P2<A, B> p : xs) {
            ba = ba.snoc(p._1());
            bb = bb.snoc(p._2());
        }
        return P.p(ba.toList(), bb.toList());
    }

    public static <A> List<A> replicate(int n, A a) {
        List<A> list = List.nil();
        for (int i = 0; i < n; ++i) {
            list = list.cons(a);
        }
        return list;
    }

    public static List<Integer> range(int from, int to) {
        Buffer<Integer> buf = Buffer.empty();
        for (int i = from; i < to; ++i) {
            buf.snoc(i);
        }
        return buf.toList();
    }

    public static List<Character> fromString(String s) {
        List<Character> cs = List.nil();
        for (int i = s.length() - 1; i >= 0; --i) {
            cs = List.cons(Character.valueOf(s.charAt(i)), cs);
        }
        return cs;
    }

    public static F<String, List<Character>> fromString() {
        return List::fromString;
    }

    public static String asString(List<Character> cs) {
        StringBuilder sb = new StringBuilder();
        cs.foreach(c -> {
            sb.append(c);
            return Unit.unit();
        });
        return sb.toString();
    }

    public static F<List<Character>, String> asString() {
        return List::asString;
    }

    public static <A> List<A> single(A a) {
        return List.cons(a, List.nil());
    }

    public static <A> List<A> iterateWhile(F<A, A> f, F<A, Boolean> p, A a) {
        return List.unfold(o -> Option.iif(p2 -> (Boolean)p.f(o), P.p(o, f.f(o))), a);
    }

    public static <A, B> Option<B> lookup(Equal<A> e, List<P2<A, B>> x, A a) {
        return x.find(p -> e.eq(p._1(), a)).map(P2.__2());
    }

    public static <A, B> F2<List<P2<A, B>>, A, Option<B>> lookup(Equal<A> e) {
        return (x, a) -> List.lookup(e, x, a);
    }

    public static <A, B> F<F<A, List<B>>, F<List<A>, List<B>>> bind_() {
        return Function.curry((f, as) -> as.bind((F)f));
    }

    public static <A, B> F<F<A, B>, F<List<A>, List<B>>> map_() {
        return Function.curry((f, as) -> as.map((F)f));
    }

    public static <A, B> F<B, List<A>> sequence_(List<F<B, A>> fs) {
        return fs.foldRight(Function.lift(List.cons()), Function.constant(List.nil()));
    }

    public static <A, B> F<F<B, F<A, B>>, F<B, F<List<A>, B>>> foldLeft() {
        return Function.curry((f, b, as) -> as.foldLeft((F)f, (Object)b));
    }

    public static <A> F<Integer, F<List<A>, List<A>>> take() {
        return Function.curry((n, as) -> as.take((int)n));
    }

    public static <A> List<A> iterableList(Iterable<A> i) {
        Buffer<A> bs = Buffer.empty();
        for (A a : i) {
            bs.snoc(a);
        }
        return bs.toList();
    }

    public static <A> List<A> iteratorList(Iterator<A> it) {
        return List.iterableList(() -> it);
    }

    public final boolean equals(Object obj) {
        return Equal.equals0(List.class, this, obj, () -> Equal.listEqual(Equal.anyEqual()));
    }

    public final int hashCode() {
        return Hash.listHash(Hash.anyHash()).hash(this);
    }

    public final String toString() {
        return Show.listShow(Show.anyShow()).showS(this);
    }

    public final boolean isSingle() {
        return this.isNotEmpty() && this.tail().isEmpty();
    }

    public static final class Unsafe {
    }

    public static final class Optic {
        private Optic() {
            throw new UnsupportedOperationException();
        }

        public static <A, B> PTraversal<List<A>, List<B>, A, B> pTraversal() {
            return new PTraversal<List<A>, List<B>, A, B>(){

                @Override
                public <C> F<List<A>, F<C, List<B>>> modifyFunctionF(F<A, F<C, B>> f) {
                    return l -> l.traverseF(f);
                }

                @Override
                public <L> F<List<A>, Either<L, List<B>>> modifyEitherF(F<A, Either<L, B>> f) {
                    return l -> l.traverseEither(f);
                }

                @Override
                public F<List<A>, IO<List<B>>> modifyIOF(F<A, IO<B>> f) {
                    return l -> l.traverseIO(f);
                }

                @Override
                public F<List<A>, Trampoline<List<B>>> modifyTrampolineF(F<A, Trampoline<B>> f) {
                    return l -> l.traverseTrampoline(f);
                }

                @Override
                public F<List<A>, Promise<List<B>>> modifyPromiseF(F<A, Promise<B>> f) {
                    return l -> l.traversePromise(f);
                }

                @Override
                public F<List<A>, List<List<B>>> modifyListF(F<A, List<B>> f) {
                    return l -> l.traverseList(f);
                }

                @Override
                public F<List<A>, Option<List<B>>> modifyOptionF(F<A, Option<B>> f) {
                    return l -> l.traverseOption(f);
                }

                @Override
                public F<List<A>, Stream<List<B>>> modifyStreamF(F<A, Stream<B>> f) {
                    return l -> l.traverseStream(f);
                }

                @Override
                public F<List<A>, P1<List<B>>> modifyP1F(F<A, P1<B>> f) {
                    return l -> l.traverseP1(f);
                }

                @Override
                public <E> F<List<A>, Validation<E, List<B>>> modifyValidationF(Semigroup<E> s, F<A, Validation<E, B>> f) {
                    return l -> l.traverseValidation(s, f);
                }

                @Override
                public F<List<A>, V2<List<B>>> modifyV2F(F<A, V2<B>> f) {
                    return l -> l.traverseV2(f);
                }

                @Override
                public <M> F<List<A>, M> foldMap(Monoid<M> monoid, F<A, M> f) {
                    return l -> monoid.sumLeft(l.map(f));
                }
            };
        }

        public static <A> Traversal<List<A>, A> traversal() {
            return new Traversal(Optic.pTraversal());
        }

        public static <A> Optional<List<A>, A> head() {
            return Optional.optional(List::headOption, a -> l -> l.uncons((__, as) -> as.cons(a), l));
        }

        public static <A> Optional<List<A>, List<A>> tail() {
            return Optional.optional(l -> l.uncons((__, tail) -> Option.some(tail), Option.none()), tail -> l -> l.uncons((h, __) -> List.cons(h, tail), l));
        }

        public static <A> Prism<List<A>, Unit> nil() {
            return Prism.prism(l -> l.isEmpty() ? Option.some(Unit.unit()) : Option.none(), Function.constant(List.nil()));
        }

        public static <A> Prism<List<A>, P2<A, List<A>>> cons() {
            return Prism.prism(l -> l.uncons((h, tail) -> Option.some(P.p(h, tail)), Option.none()), c -> List.cons(c._1(), (List)c._2()));
        }
    }

    public static final class Buffer<A>
    implements Iterable<A> {
        private List<A> start = List.nil();
        private Cons<A> tail;
        private boolean exported;

        @Override
        public Iterator<A> iterator() {
            return this.start.iterator();
        }

        public Buffer<A> snoc(A a) {
            if (this.exported) {
                this.copy();
            }
            Cons<A> t = new Cons<A>(a, List.nil());
            if (this.tail == null) {
                this.start = t;
            } else {
                ((Cons)this.tail).tail(t);
            }
            this.tail = t;
            return this;
        }

        public Buffer<A> append(List<A> as) {
            List<A> xs = as;
            while (xs.isNotEmpty()) {
                this.snoc(xs.head());
                xs = xs.tail();
            }
            return this;
        }

        public List<A> prependToList(List<A> as) {
            if (this.isEmpty()) {
                return as;
            }
            if (this.exported) {
                this.copy();
            }
            ((Cons)this.tail).tail(as);
            return this.toList();
        }

        public boolean isEmpty() {
            return this.start.isEmpty();
        }

        public List<A> toList() {
            this.exported = !this.start.isEmpty();
            return this.start;
        }

        public Collection<A> toCollection() {
            return this.start.toCollection();
        }

        public static <A> Buffer<A> empty() {
            return new Buffer<A>();
        }

        public static <A> Buffer<A> fromList(List<A> as) {
            Buffer<A> b = new Buffer<A>();
            List<A> xs = as;
            while (xs.isNotEmpty()) {
                b.snoc(xs.head());
                xs = xs.tail();
            }
            return b;
        }

        public static <A> Buffer<A> iterableBuffer(Iterable<A> i) {
            Buffer<A> b = Buffer.empty();
            for (A a : i) {
                b.snoc(a);
            }
            return b;
        }

        private void copy() {
            Cons<A> t = this.tail;
            this.start = List.nil();
            this.tail = null;
            this.exported = false;
            for (List<A> s = this.start; s != t; s = s.tail()) {
                this.snoc(s.head());
            }
            if (t != null) {
                this.snoc(t.head());
            }
        }
    }

    private static final class Cons<A>
    extends List<A> {
        private final A head;
        private List<A> tail;

        Cons(A head, List<A> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public A head() {
            return this.head;
        }

        @Override
        public List<A> tail() {
            return this.tail;
        }

        private void tail(List<A> tail) {
            this.tail = tail;
        }
    }

    private static final class Nil<A>
    extends List<A> {
        public static final Nil<Object> INSTANCE = new Nil();

        private Nil() {
        }

        @Override
        public A head() {
            throw Bottom.error("head on empty list");
        }

        @Override
        public List<A> tail() {
            throw Bottom.error("tail on empty list");
        }
    }
}

