/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.fuin.utils4j.Utils4J;
import org.jboss.jandex.Indexer;

public final class JandexUtils {
    private JandexUtils() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static boolean indexClassFile(Indexer indexer, List<File> knownFiles, File classFile) {
        if (knownFiles.contains(classFile)) {
            return false;
        }
        knownFiles.add(classFile);
        try (InputStream in = classFile.toURI().toURL().openStream();){
            indexer.index(in);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error indexing file: " + classFile, ex);
        }
        return true;
    }

    public static void indexDir(Indexer indexer, List<File> knownFiles, File dir) {
        List<File> classes = Utils4J.pathsFiles(dir.getPath(), Utils4J::classFile);
        for (File file : classes) {
            JandexUtils.indexClassFile(indexer, knownFiles, file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean indexJar(Indexer indexer, List<File> knownFiles, File jarFile) {
        if (knownFiles.contains(jarFile)) {
            return false;
        }
        knownFiles.add(jarFile);
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                try {
                    InputStream stream = jar.getInputStream(entry);
                    try {
                        indexer.index(stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error indexing " + entry.getName() + " in " + jarFile, ex);
                    return true;
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error indexing " + jarFile, ex);
        }
    }

    public static void indexClasspath(Indexer indexer, List<File> knownFiles) {
        JandexUtils.indexFiles(Utils4J.classpathFiles(), indexer, knownFiles);
    }

    public static void indexFiles(List<File> files, Indexer indexer, List<File> knownFiles) {
        for (File file : files) {
            if (Utils4J.nonJreJarFile(file)) {
                JandexUtils.indexJar(indexer, knownFiles, file);
                continue;
            }
            if (!file.isDirectory() || file.getName().startsWith(".")) continue;
            JandexUtils.indexDir(indexer, knownFiles, file);
        }
        for (File file : Utils4J.classpathFiles(Utils4J::nonJreJarFile)) {
            JandexUtils.indexJar(indexer, knownFiles, file);
        }
        for (File file : Utils4J.classpathFiles(Utils4J::classFile)) {
            JandexUtils.indexClassFile(indexer, knownFiles, file);
        }
    }
}

