/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.fuin.utils4j.Taggable;
import org.fuin.utils4j.Utils4J;

public class ChangeTrackingUniqueList<T>
implements List<T>,
Taggable {
    private final List<T> list;
    private final List<T> added;
    private final List<T> deleted;
    private boolean tagged;

    public ChangeTrackingUniqueList(List<T> list) {
        Utils4J.checkNotNull("list", list);
        this.list = list;
        this.added = new ArrayList<T>();
        this.deleted = new ArrayList<T>();
        this.tagged = true;
    }

    public final boolean isChanged() {
        return this.added.size() > 0 || this.deleted.size() > 0;
    }

    public final List<T> getDeleted() {
        return Collections.unmodifiableList(this.deleted);
    }

    public final List<T> getAdded() {
        return Collections.unmodifiableList(this.added);
    }

    public final void revert() {
        if (this.tagged) {
            Iterator<T> addedIt = this.added.iterator();
            while (addedIt.hasNext()) {
                T entry = addedIt.next();
                this.list.remove(entry);
                addedIt.remove();
            }
            Iterator<T> removedIt = this.deleted.iterator();
            while (removedIt.hasNext()) {
                T entry = removedIt.next();
                this.list.add(entry);
                removedIt.remove();
            }
        }
    }

    private void addIntern(T o) {
        if (this.tagged) {
            int idx = this.deleted.indexOf(o);
            if (idx == -1) {
                this.added.add(o);
            } else {
                this.deleted.remove(idx);
            }
        }
    }

    @Override
    public final boolean add(T o) {
        if (this.list.contains(o)) {
            throw new IllegalArgumentException("The argument is already in the list: " + o);
        }
        boolean b = this.list.add(o);
        if (b) {
            this.addIntern(o);
        }
        return b;
    }

    @Override
    public final void add(int index, T o) {
        if (this.list.contains(o)) {
            throw new IllegalArgumentException("The argument is already in the list: " + o);
        }
        this.list.add(index, o);
        this.addIntern(o);
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        int count = 0;
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            if (!this.add(it.next())) continue;
            ++count;
        }
        return count > 0;
    }

    @Override
    public final boolean addAll(int index, Collection<? extends T> c) {
        int count = 0;
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            this.add(index + count, it.next());
            ++count;
        }
        return count > 0;
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.list.size(); ++i) {
            T o = this.list.get(i);
            if (!this.tagged || this.added.contains(o)) continue;
            this.deleted.add(o);
        }
        if (this.tagged) {
            this.added.clear();
        }
        this.list.clear();
    }

    @Override
    public final boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public final T get(int index) {
        return this.list.get(index);
    }

    @Override
    public final int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public final Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public final int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public final ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public final ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    private void removeIntern(T o) {
        if (this.tagged) {
            int idx = this.added.indexOf(o);
            if (idx == -1) {
                this.deleted.add(o);
            } else {
                this.added.remove(idx);
            }
        }
    }

    @Override
    public final boolean remove(Object o) {
        boolean b = this.list.remove(o);
        if (b) {
            this.removeIntern(o);
        }
        return b;
    }

    @Override
    public final T remove(int index) {
        T o = this.list.remove(index);
        if (o != null) {
            this.removeIntern(o);
        }
        return o;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (int i = this.list.size() - 1; i >= 0; --i) {
            T o = this.list.get(i);
            if (c.contains(o)) continue;
            this.remove(i);
            changed = true;
        }
        return changed;
    }

    @Override
    public final T set(int index, T o) {
        T removed = this.list.set(index, o);
        this.addIntern(o);
        this.removeIntern(removed);
        return removed;
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    @Override
    public final List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public final Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public final <E> E[] toArray(E[] a) {
        return this.list.toArray(a);
    }

    public final String toString() {
        return this.list.toString();
    }

    @Override
    public final boolean hasChangedSinceTagging() {
        return this.isChanged();
    }

    @Override
    public final boolean isTagged() {
        return this.tagged;
    }

    @Override
    public final void revertToTag() {
        this.revert();
    }

    @Override
    public final void tag() {
        if (!this.tagged) {
            this.tagged = true;
        }
    }

    @Override
    public final void untag() {
        if (this.tagged) {
            this.tagged = false;
            this.added.clear();
            this.deleted.clear();
        }
    }
}

