/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.fuin.utils4j.Taggable;
import org.fuin.utils4j.Utils4J;

public class ChangeTrackingMap<K, V>
implements Map<K, V>,
Taggable {
    private final Map<K, V> map;
    private final Map<K, V> added;
    private final Map<K, V> changed;
    private final Map<K, V> removed;
    private boolean tagged;

    public ChangeTrackingMap(Map<K, V> map) {
        Utils4J.checkNotNull("map", map);
        this.map = map;
        this.added = new HashMap();
        this.changed = new HashMap();
        this.removed = new HashMap();
        this.tagged = true;
    }

    public final boolean isChanged() {
        return this.added.size() > 0 || this.changed.size() > 0 || this.removed.size() > 0;
    }

    public final Map<K, V> getRemoved() {
        return Collections.unmodifiableMap(this.removed);
    }

    public final Map<K, V> getChanged() {
        return Collections.unmodifiableMap(this.changed);
    }

    public final void revert() {
        if (this.tagged) {
            Iterator<K> addedIt = this.added.keySet().iterator();
            while (addedIt.hasNext()) {
                K key = addedIt.next();
                this.map.remove(key);
                addedIt.remove();
            }
            Iterator<K> changedIt = this.changed.keySet().iterator();
            while (changedIt.hasNext()) {
                K key = changedIt.next();
                V value = this.changed.get(key);
                this.map.put(key, value);
                changedIt.remove();
            }
            Iterator<K> removedIt = this.removed.keySet().iterator();
            while (removedIt.hasNext()) {
                K key = removedIt.next();
                V value = this.removed.get(key);
                this.map.put(key, value);
                removedIt.remove();
            }
        }
    }

    public final Map<K, V> getAdded() {
        return Collections.unmodifiableMap(this.added);
    }

    private void changeIntern(K key, V oldValue, V newValue) {
        if (this.tagged) {
            V addedValue = this.added.get(key);
            if (addedValue == null) {
                V changedValue = this.changed.get(key);
                if (changedValue == null) {
                    V removedValue = this.removed.get(key);
                    if (removedValue == null) {
                        if (oldValue == null) {
                            this.added.put(key, newValue);
                        } else {
                            this.changed.put(key, oldValue);
                        }
                    } else {
                        this.removed.remove(key);
                        if (!removedValue.equals(newValue)) {
                            this.changed.put(key, removedValue);
                        }
                    }
                } else if (changedValue.equals(newValue)) {
                    this.changed.remove(key);
                }
            } else if (!addedValue.equals(newValue) && newValue != null) {
                this.added.put(key, newValue);
            }
        }
    }

    private void removeIntern(K key, V value) {
        if (this.tagged) {
            if (this.added.get(key) == null) {
                V changedValue = this.changed.get(key);
                if (changedValue == null) {
                    if (this.removed.get(key) == null && value != null) {
                        this.removed.put(key, value);
                    }
                } else {
                    this.changed.remove(key);
                    this.removed.put(key, changedValue);
                }
            } else {
                this.added.remove(key);
            }
        }
    }

    @Override
    public final void clear() {
        for (K key : this.map.keySet()) {
            V value = this.map.get(key);
            this.removeIntern(key, value);
        }
        if (this.tagged) {
            this.added.clear();
        }
        this.map.clear();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public final V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public final V put(K key, V newValue) {
        V oldValue = this.map.put(key, newValue);
        this.changeIntern(key, oldValue, newValue);
        return oldValue;
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> newMap) {
        for (K key : newMap.keySet()) {
            V newValue = newMap.get(key);
            V oldValue = this.map.put(key, newValue);
            this.changeIntern(key, oldValue, newValue);
        }
    }

    @Override
    public final V remove(Object key) {
        V oldValue = this.map.remove(key);
        this.removeIntern(key, oldValue);
        return oldValue;
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    public final String toString() {
        return this.map.toString();
    }

    @Override
    public final boolean hasChangedSinceTagging() {
        return this.isChanged();
    }

    @Override
    public final boolean isTagged() {
        return this.tagged;
    }

    @Override
    public final void revertToTag() {
        this.revert();
    }

    @Override
    public final void tag() {
        if (!this.tagged) {
            this.tagged = true;
        }
    }

    @Override
    public final void untag() {
        if (this.tagged) {
            this.tagged = false;
            this.added.clear();
            this.changed.clear();
            this.removed.clear();
        }
    }
}

