/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.mod.poi;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.model.DocCell;
import org.fugerit.java.doc.base.xml.DocModelUtils;
import org.fugerit.java.doc.mod.poi.WorkbookHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiUtils {
    private static final Logger log = LoggerFactory.getLogger(PoiUtils.class);

    private PoiUtils() {
    }

    public static void resizeSheet(Sheet s) {
        Row row = s.getRow(0);
        Iterator cells = row.cellIterator();
        while (cells.hasNext()) {
            Cell c = (Cell)cells.next();
            s.autoSizeColumn(c.getColumnIndex());
        }
    }

    public static void autoSizeColumns(Workbook workbook) {
        int numberOfSheets = workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            PoiUtils.resizeSheet(sheet);
        }
    }

    public static void xlsxFormatStyle(WorkbookHelper helper, CellStyle style, DocCell cell) {
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle realStyle = (XSSFCellStyle)style;
            if (cell != null && StringUtils.isNotEmpty((String)cell.getBackColor())) {
                Color c = DocModelUtils.parseHtmlColor((String)cell.getBackColor());
                realStyle.setFillForegroundColor(new XSSFColor(c, helper.getIndexedColorMap()));
                realStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
        }
    }

    public static void xlsxFontStyle(WorkbookHelper helper, Font font, DocCell cell) {
        if (font instanceof XSSFFont) {
            XSSFFont realFont = (XSSFFont)font;
            if (StringUtils.isNotEmpty((String)cell.getForeColor())) {
                Color c = DocModelUtils.parseHtmlColor((String)cell.getForeColor());
                realFont.setColor(new XSSFColor(c, helper.getIndexedColorMap()));
            }
        }
    }

    public static short findClosestColorIndex(HSSFWorkbook workbook, String color) {
        Color c = DocModelUtils.parseHtmlColor((String)color);
        HSSFPalette palette = workbook.getCustomPalette();
        HSSFColor current = palette.findSimilarColor(c.getRed(), c.getGreen(), c.getBlue());
        return current.getIndex();
    }

    public static void xlsFormatStyle(WorkbookHelper helper, CellStyle style, DocCell cell) {
        Workbook workbook = helper.getWorkbook();
        if (style instanceof HSSFCellStyle && workbook instanceof HSSFWorkbook) {
            HSSFCellStyle realStyle = (HSSFCellStyle)style;
            if (cell != null && StringUtils.isNotEmpty((String)cell.getBackColor())) {
                short index = PoiUtils.findClosestColorIndex((HSSFWorkbook)workbook, cell.getBackColor());
                realStyle.setFillForegroundColor(index);
                realStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
        }
    }

    public static void xlsFontStyle(WorkbookHelper helper, Font font, DocCell cell) {
        Workbook workbook = helper.getWorkbook();
        if (workbook instanceof HSSFWorkbook && StringUtils.isNotEmpty((String)cell.getForeColor())) {
            font.setColor(PoiUtils.findClosestColorIndex((HSSFWorkbook)workbook, cell.getForeColor()));
        }
    }

    public static void closeWorkbook(Workbook workbook, DocOutput docOutput) throws IOException {
        workbook.write(docOutput.getOs());
        workbook.close();
    }

    public static WorkbookHelper newHelper(boolean xlsx, InputStream is) throws IOException {
        Object workbook = null;
        workbook = xlsx ? (is == null ? new XSSFWorkbook() : new XSSFWorkbook(is)) : (is == null ? new HSSFWorkbook() : new HSSFWorkbook(is));
        return new WorkbookHelper((Workbook)workbook, (IndexedColorMap)new DefaultIndexedColorMap());
    }

    public static Consumer<Exception> autoresizeFailHandler(boolean failOnAutoResizeError) {
        return e -> {
            String message = "Exception on excel autoresize " + e;
            if (failOnAutoResizeError) {
                throw new ConfigRuntimeException(message, (Throwable)e);
            }
            log.warn(message, (Throwable)e);
        };
    }
}

