/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.mod.fop.config;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.fop.apps.EnvironmentalProfileFactory;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.doc.mod.fop.FopConfig;
import org.fugerit.java.doc.mod.fop.config.ClassLoaderResourceResolverWrapper;

public class FopConfigClassLoaderWrapper
implements FopConfig,
Serializable {
    public static final ResourceResolver DEFAULT_RESOURCE_RESOLVER = new ClassLoaderResourceResolverWrapper();
    private static final long serialVersionUID = 188843074194800812L;
    private String fopConfigPath;
    private ResourceResolver customResourceResolver;

    public String getFopConfigPath() {
        return this.fopConfigPath;
    }

    public ResourceResolver getCustomResourceResolver() {
        return this.customResourceResolver;
    }

    public FopConfigClassLoaderWrapper(String fopConfigPath) {
        this(fopConfigPath, DEFAULT_RESOURCE_RESOLVER);
    }

    public FopConfigClassLoaderWrapper(String fopConfigPath, ResourceResolver customResourceResolver) {
        this.fopConfigPath = fopConfigPath;
        this.customResourceResolver = customResourceResolver;
    }

    @Override
    public FopFactory newFactory() throws Exception {
        FopFactory fopFactory = null;
        try (InputStream fopConfigStream = ClassHelper.loadFromDefaultClassLoader((String)this.getFopConfigPath());){
            FopConfParser confParser = new FopConfParser(fopConfigStream, EnvironmentalProfileFactory.createRestrictedIO((URI)new URI("."), (ResourceResolver)this.customResourceResolver));
            FopFactoryBuilder confBuilder = confParser.getFopFactoryBuilder();
            fopFactory = confBuilder.build();
        }
        return fopFactory;
    }
}

