/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.lib.simpletable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.doc.lib.simpletable.model.SimpleCell;
import org.fugerit.java.doc.lib.simpletable.model.SimpleRow;
import org.fugerit.java.doc.lib.simpletable.model.SimpleTable;

public class SimpleTableHelper {
    private Integer defaultBorderWidth;

    public SimpleTableHelper withDefaultBorderWidth(int defaultBorderWidth) {
        this.defaultBorderWidth = defaultBorderWidth;
        return this;
    }

    public Integer getDefaultBorderWidth() {
        return this.defaultBorderWidth;
    }

    public SimpleTable newTable(Integer ... colWidths) {
        if (colWidths == null || colWidths.length == 0) {
            throw new ConfigRuntimeException("Minimum one colunm must be provided");
        }
        return this.newTable(Arrays.asList(colWidths));
    }

    public SimpleTable newTable(List<Integer> colWidths) {
        if (colWidths == null || colWidths.isEmpty()) {
            throw new ConfigRuntimeException("Minimum one colunm must be provided");
        }
        int sum = 0;
        for (int v : colWidths) {
            sum += v;
        }
        if (sum != 100) {
            throw new ConfigRuntimeException("Column width sum must be 100, while is : " + sum);
        }
        return new SimpleTable(StringUtils.concat((String)";", (Collection)colWidths.stream().map(Object::toString).collect(Collectors.toList())));
    }

    public SimpleTable newTableSingleColumn() {
        return this.newTable(100);
    }

    public SimpleCell newCell(String content) {
        SimpleCell simpleCell = new SimpleCell(content);
        if (this.getDefaultBorderWidth() != null) {
            simpleCell.setBorderWidth(this.getDefaultBorderWidth());
        }
        return simpleCell;
    }

    public SimpleRow newHeaderWorker(String isHeader, String ... cells) {
        SimpleRow row = new SimpleRow(isHeader);
        if (cells != null) {
            for (int k = 0; k < cells.length; ++k) {
                row.addCell(this.newCell(cells[k]));
            }
        }
        return row;
    }

    public SimpleRow newHeaderRow(String ... cells) {
        return this.newHeaderWorker("true", cells);
    }

    public SimpleRow newNormalRow(String ... cells) {
        return this.newHeaderWorker("false", cells);
    }

    public List<Integer> newFixedColumns(int columnsNumber) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int length = 100 / columnsNumber;
        int offset = 100 - length * columnsNumber;
        for (int k = 0; k < columnsNumber; ++k) {
            if (offset > 0) {
                list.add(length + 1);
                --offset;
                continue;
            }
            list.add(length);
        }
        return list;
    }
}

