/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.freemarker.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import org.fugerit.java.core.io.StreamIO;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.doc.base.process.DocProcessContext;
import org.fugerit.java.doc.base.process.DocProcessData;
import org.fugerit.java.doc.freemarker.helper.FreeMarkerDocProcess;
import org.fugerit.java.doc.freemarker.tool.LegacyConfigRead;
import org.fugerit.java.doc.freemarker.tool.model.ConfigModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateStub {
    private static final Logger log = LoggerFactory.getLogger(GenerateStub.class);
    public static final String ATT_CONFIG_MODEL = "configModel";
    public static final String CONFIG_STUB_CHAIN_ID = "freemarker-doc-process-config-stub";
    public static final String ATT_STUB_PARAMS = "stubParams";
    public static final String PARAM_STUB_HANDLER = "stub-handler";
    public static final String PARAM_STUB_CHAIN = "stub-chain";
    public static final String PARAM_ENABLE_FOP_BASE = "enable-fop-base";
    public static final String PARAM_ENABLE_FOP_FULL = "enable-fop-full";
    public static final String PARAM_ENABLE_POI = "enable-poi";
    public static final String PARAM_ENABLE_OPENCSV = "enable-opencsv";
    public static final String PARAM_CONFIG_ID = "config-id";
    public static final String PARAM_FM_VERSION = "fm-version";
    public static final String PARAM_FM_TEMPLATE_PATH = "fm-template-path";
    public static final String ARG_INPUT_FILE = "input";

    private GenerateStub() {
    }

    public static void generate(Writer out, Properties params) throws Exception {
        String input = params.getProperty(ARG_INPUT_FILE);
        if (StringUtils.isNotEmpty((String)input)) {
            try (FileInputStream is = new FileInputStream(new File(input));){
                GenerateStub.generate(out, params, is);
            }
        } else {
            GenerateStub.generate(out, params, null);
        }
    }

    public static void generate(Writer out, Properties params, InputStream is) throws Exception {
        ConfigModel configModel = null;
        DocProcessData data = new DocProcessData();
        DocProcessContext context = DocProcessContext.newContext((String)ATT_STUB_PARAMS, (Object)params);
        if (is != null) {
            log.info("read legacy config model");
            configModel = LegacyConfigRead.readConfig(is);
            context = context.withAtt(ATT_CONFIG_MODEL, (Object)configModel);
        }
        FreeMarkerDocProcess.getInstance().process(CONFIG_STUB_CHAIN_ID, context, data);
        StreamIO.pipeChar((Reader)data.getCurrentXmlReader(), (Writer)out, (int)1);
    }
}

