/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.freemarker.process;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.io.StreamIO;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.core.lang.helpers.Result;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.core.xml.XMLException;
import org.fugerit.java.core.xml.config.XMLSchemaCatalogConfig;
import org.fugerit.java.core.xml.sax.SAXParseResult;
import org.fugerit.java.core.xml.sax.eh.ResultErrorHandler;
import org.fugerit.java.doc.base.parser.DocParserContext;
import org.fugerit.java.doc.base.xml.DocContentHandler;
import org.fugerit.java.doc.base.xml.SAXUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FreemarkerDocProcessConfigValidator {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerDocProcessConfigValidator.class);
    private static final String CURRENT = "current";
    private static final XMLSchemaCatalogConfig SCHEMA_CATALOG = FreemarkerDocProcessConfigValidator.init();

    private FreemarkerDocProcessConfigValidator() {
    }

    private static XMLSchemaCatalogConfig init() {
        XMLSchemaCatalogConfig catalog = null;
        try (InputStream is = ClassHelper.loadFromDefaultClassLoader((String)"config_fm_xsd/schema-validator-config-freemarker.xml");){
            catalog = XMLSchemaCatalogConfig.loadConfigSchema((InputStream)is);
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Exception on init : " + e, (Throwable)e);
        }
        return catalog;
    }

    public static SAXParseResult validateVersion(Reader xmlData) throws XMLException {
        SAXParseResult result = new SAXParseResult();
        try {
            String buffer = StreamIO.readString((Reader)xmlData);
            String xsdVersion = FreemarkerDocProcessConfigValidator.getXsdVersion(new StringReader(buffer));
            log.info("xsdVersion -> '{}'", (Object)xsdVersion);
            String validateVersion = CURRENT;
            if (StringUtils.isNotEmpty((String)xsdVersion)) {
                validateVersion = "version-" + xsdVersion;
            }
            log.info("validateVersion -> '{}'", (Object)validateVersion);
            SCHEMA_CATALOG.validateCacheSchema((ErrorHandler)new ResultErrorHandler((Result)result), new SAXSource(new InputSource(new StringReader(buffer))), validateVersion);
        }
        catch (Exception e) {
            throw new XMLException((Throwable)e);
        }
        return result;
    }

    public static String getXsdVersion(Reader xmlReader) throws XMLException {
        String version = null;
        try {
            SAXParserFactory spf = SAXUtils.newSafeFactory();
            spf.setNamespaceAware(true);
            final Properties infos = new Properties();
            SAXParser parser = spf.newSAXParser();
            DefaultHandler versionHandler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("doc".equalsIgnoreCase(qName) || "doc".equalsIgnoreCase(localName)) {
                        Properties props = DocContentHandler.attsToProperties((Attributes)attributes);
                        String xsdVersion = DocParserContext.findXsdVersion((Properties)props);
                        infos.setProperty("xsdVersion", xsdVersion);
                    }
                }
            };
            parser.parse(new InputSource(xmlReader), versionHandler);
            version = infos.getProperty("xsdVersion");
        }
        catch (Exception e) {
            throw new XMLException((Throwable)e);
        }
        return version;
    }

    public static SAXParseResult validate(Reader xmlData) throws XMLException {
        SAXParseResult result = new SAXParseResult();
        try {
            SCHEMA_CATALOG.validateCacheSchema((ErrorHandler)new ResultErrorHandler((Result)result), new SAXSource(new InputSource(xmlData)), CURRENT);
        }
        catch (Exception e) {
            throw new XMLException((Throwable)e);
        }
        return result;
    }

    public static void logResult(SAXParseResult result) throws XMLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(baos);){
            result.printErrorReport(ps);
            log.info("Validation issues : \n{}", (Object)String.valueOf(baos.toByteArray()));
        }
    }

    public static boolean logValidation(Reader xmlData) throws XMLException {
        SAXParseResult result = new SAXParseResult();
        try {
            SCHEMA_CATALOG.validateCacheSchema((ErrorHandler)new ResultErrorHandler((Result)result), new SAXSource(new InputSource(xmlData)), CURRENT);
        }
        catch (Exception e) {
            throw new XMLException((Throwable)e);
        }
        if (result.isTotalSuccess()) {
            log.info("Validation completed without errors or warning");
        } else {
            FreemarkerDocProcessConfigValidator.logResult(result);
        }
        return result.isPartialSuccess();
    }
}

