/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.freemarker.process;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.cfg.ConfigurableObject;
import org.fugerit.java.core.cfg.helpers.UnsafeHelper;
import org.fugerit.java.core.cfg.xml.XmlBeanHelper;
import org.fugerit.java.core.io.helper.StreamHelper;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.core.util.filterchain.MiniFilterBase;
import org.fugerit.java.core.util.filterchain.MiniFilterChain;
import org.fugerit.java.core.xml.dom.DOMUtils;
import org.fugerit.java.doc.base.config.DocException;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.freemarker.config.FreeMarkerComplexProcessStep;
import org.fugerit.java.doc.freemarker.config.FreeMarkerConfigStep;
import org.fugerit.java.doc.freemarker.config.FreeMarkerFunctionStep;
import org.fugerit.java.doc.freemarker.config.FreeMarkerMapStep;
import org.fugerit.java.doc.freemarker.process.ChainStepModel;
import org.fugerit.java.doc.freemarker.process.DefaultChainProvider;
import org.fugerit.java.doc.freemarker.process.DocChainModel;
import org.fugerit.java.doc.freemarker.process.FreemarkerDocProcessConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FreemarkerDocProcessConfigFacade {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerDocProcessConfigFacade.class);
    public static final String ATT_DOC_HANDLER_CONFIG = "docHandlerConfig";
    public static final String ATT_DOC_CHAIN = "docChain";
    public static final String ATT_CHAIN_STEP = "chainStep";
    public static final String ATT_STEP_TYPE = "stepType";
    public static final String STEP_TYPE_CONFIG = "config";
    public static final String STEP_TYPE_FUNCTION = "function";
    public static final String STEP_TYPE_COMPLEX = "complex";
    public static final String STEP_TYPE_MAP = "map";
    private static final Properties BUILT_IN_STEPS = new Properties();
    public static final Properties BUILT_IN_STEPS_REVERSE = new Properties();

    private FreemarkerDocProcessConfigFacade() {
    }

    public static FreemarkerDocProcessConfig newSimpleConfig(final String id, final String templatePath, final String version) throws ConfigException {
        FreemarkerDocProcessConfig config = new FreemarkerDocProcessConfig();
        config.setDefaultChain(new DefaultChainProvider(){

            @Override
            public MiniFilterChain newDefaultChain(String idChain) {
                MiniFilterChain defaultChain = new MiniFilterChain("DEFAULT_CHAIN_" + idChain + "_" + System.currentTimeMillis(), 1);
                defaultChain.setChainId(defaultChain.getKey());
                FreeMarkerConfigStep configStep = new FreeMarkerConfigStep();
                Properties configParams = new Properties();
                configParams.setProperty("path", templatePath);
                if (version != null) {
                    configParams.setProperty("version", version);
                }
                configStep.setParam01(id);
                configStep.setCustomConfig(FreemarkerDocProcessConfigFacade.convertConfiguration(configParams));
                defaultChain.getFilterChain().add(configStep);
                FreeMarkerComplexProcessStep processStep = new FreeMarkerComplexProcessStep();
                Properties processAtts = new Properties();
                processAtts.setProperty("template-path", "${chainId}.ftl");
                processAtts.setProperty("map-atts", "simpleTableModel");
                processStep.setCustomConfig(processAtts);
                processStep.setChainId(idChain);
                defaultChain.getFilterChain().add(processStep);
                return defaultChain;
            }
        });
        return config;
    }

    public static FreemarkerDocProcessConfig newSimpleConfig(String id, String templatePath) throws ConfigException {
        return FreemarkerDocProcessConfigFacade.newSimpleConfig(id, templatePath, null);
    }

    private static DocTypeHandler createHelper(Element docHandlerConfig) throws ConfigException {
        String type = docHandlerConfig.getAttribute("type");
        log.info("factoryType : {} , resultType : {}", (Object)docHandlerConfig, (Object)type);
        DocTypeHandler res = null;
        try {
            res = (DocTypeHandler)ClassHelper.newInstance((String)type);
            if (res instanceof ConfigurableObject) {
                log.info("ConfigurableObject -> try configure()");
                ((ConfigurableObject)res).configure(docHandlerConfig);
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            UnsafeHelper.handleUnsafe((Exception)new ConfigException("Type cannot be loaded : " + e, e), (String)docHandlerConfig.getAttribute("unsafe"), (String)docHandlerConfig.getAttribute("unsafeMode"));
        }
        return res;
    }

    public static FreemarkerDocProcessConfig loadConfigSafe(String configPath) {
        log.info("loadConfigSafe config path : {}", (Object)configPath);
        FreemarkerDocProcessConfig config = null;
        try (InputStreamReader xmlReader = new InputStreamReader(StreamHelper.resolveStream((String)configPath));){
            config = FreemarkerDocProcessConfigFacade.loadConfig(xmlReader);
        }
        catch (Exception e) {
            throw new ConfigRuntimeException((Throwable)e);
        }
        return config;
    }

    private static void handleNodeList(FreemarkerDocProcessConfig config, Document doc) throws Exception {
        NodeList docHandlerConfigList = doc.getElementsByTagName(ATT_DOC_HANDLER_CONFIG);
        if (docHandlerConfigList.getLength() == 1) {
            Element docHandlerConfigTag = (Element)docHandlerConfigList.item(0);
            boolean registerById = BooleanUtils.isTrue((String)docHandlerConfigTag.getAttribute("registerById"));
            boolean allowDuplicatedId = BooleanUtils.isTrue((String)docHandlerConfigTag.getAttribute("allowDuplicatedId"));
            NodeList docHandlerList = docHandlerConfigTag.getElementsByTagName("docHandler");
            log.info("docHandlerList -> {}", (Object)docHandlerList.getLength());
            for (int k = 0; k < docHandlerList.getLength(); ++k) {
                Element currentHandlerTag = (Element)docHandlerList.item(k);
                DocTypeHandler handler = FreemarkerDocProcessConfigFacade.createHelper(currentHandlerTag);
                if (handler == null) continue;
                String id = currentHandlerTag.getAttribute("id");
                log.info("register handler id {}, handler {}", (Object)id, (Object)handler);
                if (registerById) {
                    config.getFacade().registerHandlerAndId(id, handler, allowDuplicatedId);
                    continue;
                }
                config.getFacade().registerHandler(handler);
            }
        }
    }

    private static void handleChainStepList(DocChainModel model, Element currentTag) throws Exception {
        NodeList chainStepList = currentTag.getElementsByTagName(ATT_CHAIN_STEP);
        for (int i = 0; i < chainStepList.getLength(); ++i) {
            Element currentChainStepTag = (Element)chainStepList.item(i);
            ChainStepModel chainStepModel = new ChainStepModel();
            Properties atts = DOMUtils.attributesToProperties((Element)currentChainStepTag);
            chainStepModel.setStepType(atts.getProperty(ATT_STEP_TYPE));
            atts.remove(ATT_STEP_TYPE);
            chainStepModel.setAttributes(atts);
            if (STEP_TYPE_CONFIG.equalsIgnoreCase(chainStepModel.getStepType())) {
                NodeList configList = currentChainStepTag.getElementsByTagName(STEP_TYPE_CONFIG);
                if (configList.getLength() != 1) {
                    throw new ConfigException("Expcted only one config tag : " + configList.getLength());
                }
                Element configTag = (Element)configList.item(0);
                atts.putAll((Map<?, ?>)DOMUtils.attributesToProperties((Element)configTag));
            } else if (STEP_TYPE_FUNCTION.equalsIgnoreCase(chainStepModel.getStepType()) || STEP_TYPE_MAP.equalsIgnoreCase(chainStepModel.getStepType())) {
                NodeList subList = currentChainStepTag.getElementsByTagName(chainStepModel.getStepType());
                for (int j = 0; j < subList.getLength(); ++j) {
                    Element currentFunctionTag = (Element)subList.item(j);
                    String key = currentFunctionTag.getAttribute("name");
                    String value = currentFunctionTag.getAttribute("value");
                    atts.setProperty(key, value);
                }
            }
            model.getChainStepList().add(chainStepModel);
        }
    }

    private static void handleStepList(FreemarkerDocProcessConfig config, Document doc) throws Exception {
        NodeList docChainLisgt = doc.getElementsByTagName(ATT_DOC_CHAIN);
        for (int k = 0; k < docChainLisgt.getLength(); ++k) {
            Element currentTag = (Element)docChainLisgt.item(k);
            DocChainModel model = new DocChainModel();
            XmlBeanHelper.setFromElement((Object)model, (Element)currentTag);
            if (StringUtils.isNotEmpty((String)model.getParent())) {
                String[] parentList = model.getParent().split(",");
                for (int p = 0; p < parentList.length; ++p) {
                    DocChainModel parent = (DocChainModel)config.getDocChainList().get((Object)parentList[p]);
                    if (parent == null) {
                        throw new DocException("No parent found : " + model.getParent());
                    }
                    model.getChainStepList().addAll(parent.getChainStepList());
                }
            }
            FreemarkerDocProcessConfigFacade.handleChainStepList(model, currentTag);
            config.getDocChainList().add((Object)model);
        }
    }

    private static void handleMiniFilter(FreemarkerDocProcessConfig config) throws Exception {
        for (DocChainModel docChainModel : config.getDocChainList()) {
            MiniFilterChain chain = new MiniFilterChain(docChainModel.getId(), 1);
            chain.setChainId(docChainModel.getId());
            for (ChainStepModel chainStepModel : docChainModel.getChainStepList()) {
                String type = BUILT_IN_STEPS.getProperty(chainStepModel.getStepType(), chainStepModel.getStepType());
                MiniFilterBase step = (MiniFilterBase)ClassHelper.newInstance((String)type);
                step.setCustomConfig(chainStepModel.getAttributes());
                if (FreeMarkerConfigStep.class.getName().equalsIgnoreCase(type)) {
                    step.setParam01(chainStepModel.getAttributes().getProperty("id"));
                    Properties configProps = FreemarkerDocProcessConfigFacade.convertConfiguration(chainStepModel.getAttributes());
                    step.setCustomConfig(configProps);
                }
                step.setChainId(chain.getChainId());
                chain.getFilterChain().add(step);
            }
            config.setChain(chain.getChainId(), chain);
        }
    }

    public static FreemarkerDocProcessConfig loadConfig(Reader xmlReader) throws ConfigException {
        FreemarkerDocProcessConfig result = null;
        try {
            FreemarkerDocProcessConfig config = new FreemarkerDocProcessConfig();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(xmlReader));
            FreemarkerDocProcessConfigFacade.handleNodeList(config, doc);
            FreemarkerDocProcessConfigFacade.handleStepList(config, doc);
            result = config;
            log.info("loadConfig ok : {}", (Object)result);
            FreemarkerDocProcessConfigFacade.handleMiniFilter(config);
        }
        catch (Exception e) {
            throw new ConfigException("Error configuring FreemarkerDocProcessConfig : " + e, (Throwable)e);
        }
        return result;
    }

    private static Properties convertConfiguration(Properties props) {
        Properties params = new Properties();
        params.setProperty("version", props.getProperty("version", "2.3.32"));
        params.setProperty("mode", props.getProperty("mode", "class"));
        params.setProperty("path", props.getProperty("path"));
        params.setProperty("class", props.getProperty("class", DocChainModel.class.getName()));
        params.setProperty("exception-handler", props.getProperty("exception-handler", "RETHROW_HANDLER"));
        params.setProperty("log-exception", props.getProperty("log-exception", "false"));
        params.setProperty("wrap-unchecked-exceptions", props.getProperty("wrap-unchecked-exceptions", "true"));
        params.setProperty("fallback-on-null-loop-variable", props.getProperty("fallback-on-null-loop-variable", "false"));
        return params;
    }

    static {
        BUILT_IN_STEPS.setProperty(STEP_TYPE_CONFIG, FreeMarkerConfigStep.class.getName());
        BUILT_IN_STEPS.setProperty(STEP_TYPE_FUNCTION, FreeMarkerFunctionStep.class.getName());
        BUILT_IN_STEPS.setProperty(STEP_TYPE_COMPLEX, FreeMarkerComplexProcessStep.class.getName());
        BUILT_IN_STEPS.setProperty(STEP_TYPE_MAP, FreeMarkerMapStep.class.getName());
        BUILT_IN_STEPS.keySet().stream().forEach(k -> BUILT_IN_STEPS_REVERSE.put(BUILT_IN_STEPS.get(k), k));
    }
}

