/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.freemarker.process;

import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.Set;
import org.fugerit.java.core.cfg.xml.ListMapConfig;
import org.fugerit.java.core.util.filterchain.MiniFilterChain;
import org.fugerit.java.core.util.filterchain.MiniFilterContext;
import org.fugerit.java.core.util.filterchain.MiniFilterData;
import org.fugerit.java.core.util.filterchain.MiniFilterMap;
import org.fugerit.java.core.xml.sax.SAXParseResult;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.base.facade.DocFacade;
import org.fugerit.java.doc.base.facade.DocHandlerFacade;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.process.DocProcessConfig;
import org.fugerit.java.doc.base.process.DocProcessContext;
import org.fugerit.java.doc.base.process.DocProcessData;
import org.fugerit.java.doc.base.xml.DocValidator;
import org.fugerit.java.doc.freemarker.process.DefaultChainProvider;
import org.fugerit.java.doc.freemarker.process.DocChainModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerDocProcessConfig
implements Serializable,
MiniFilterMap {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerDocProcessConfig.class);
    private static final long serialVersionUID = -6761081877582850120L;
    private ListMapConfig<DocChainModel> docChainList = new ListMapConfig();
    private DocHandlerFacade facade = new DocHandlerFacade();
    private DocProcessConfig docProcessConfig = new DocProcessConfig();
    private DefaultChainProvider defaultChain;

    protected FreemarkerDocProcessConfig() {
    }

    protected void setDefaultChain(DefaultChainProvider defaultChain) {
        this.defaultChain = defaultChain;
    }

    protected DefaultChainProvider getDefaultChain() {
        return this.defaultChain;
    }

    public void process(String chainId, DocProcessContext context, DocProcessData data) throws Exception {
        MiniFilterChain chain = this.getChainCache(chainId);
        log.info("chain list {}", (Object)this.docProcessConfig.getIdSet());
        chain.apply((MiniFilterContext)context, (MiniFilterData)data);
    }

    public void process(String chainId, DocProcessContext context, DocProcessData data, DocTypeHandler handler, DocOutput docOutput) throws Exception {
        this.process(chainId, context, data);
        handler.handle(DocInput.newInput((String)handler.getType(), (Reader)data.getCurrentXmlReader()), docOutput);
    }

    public SAXParseResult process(String chainId, String type, DocProcessContext context, OutputStream os, boolean validate) throws Exception {
        SAXParseResult result = null;
        MiniFilterChain chain = this.getChainCache(chainId);
        DocProcessData data = new DocProcessData();
        chain.apply((MiniFilterContext)context, (MiniFilterData)data);
        if (validate && !(result = DocValidator.validate((Reader)data.getCurrentXmlReader())).isPartialSuccess()) {
            DocValidator.logResult((SAXParseResult)result, (Logger)log);
        }
        DocBase docBase = null;
        try (Reader reader = data.getCurrentXmlReader();){
            docBase = DocFacade.parse((Reader)reader);
        }
        DocInput input = DocInput.newInput((String)type, (DocBase)docBase, (Reader)data.getCurrentXmlReader());
        DocOutput output = DocOutput.newOutput((OutputStream)os);
        this.getFacade().handle(input, output);
        return result;
    }

    public MiniFilterChain getChain(String id) throws Exception {
        return this.docProcessConfig.getChain(id);
    }

    public MiniFilterChain getChainCache(String id) throws Exception {
        MiniFilterChain chain = null;
        if (this.docProcessConfig.getKeys().contains(id)) {
            chain = this.docProcessConfig.getChain(id);
        } else if (this.defaultChain != null) {
            chain = this.defaultChain.newDefaultChain(id);
            this.setChain(id, chain);
        }
        return chain;
    }

    public Set<String> getKeys() {
        return this.docProcessConfig.getKeys();
    }

    public void setChain(String id, MiniFilterChain chain) {
        this.docProcessConfig.setChain(id, chain);
    }

    public ListMapConfig<DocChainModel> getDocChainList() {
        return this.docChainList;
    }

    public DocHandlerFacade getFacade() {
        return this.facade;
    }
}

