/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.freemarker.config;

import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.doc.base.process.DocProcessContext;
import org.fugerit.java.doc.base.process.DocProcessData;
import org.fugerit.java.doc.base.process.DocProcessorBasic;

public class FreeMarkerConfigStep
extends DocProcessorBasic {
    public static final String ATT_DEFAULT = "FreeMarkerConfigStep.DEFAULT";
    public static final String ATT_FREEMARKER_CONFIG_KEY_VERSION = "version";
    public static final String ATT_FREEMARKER_CONFIG_KEY_VERSION_2_3_32 = "2.3.32";
    public static final String ATT_FREEMARKER_CONFIG_KEY_VERSION_2_3_31 = "2.3.31";
    public static final String ATT_FREEMARKER_CONFIG_KEY_VERSION_2_3_30 = "2.3.30";
    public static final String ATT_FREEMARKER_CONFIG_KEY_VERSION_2_3_29 = "2.3.29";
    public static final String ATT_FREEMARKER_CONFIG_KEY_VERSION_DEFAULT = "2.3.32";
    public static final String ATT_FREEMARKER_CONFIG_KEY_MODE = "mode";
    public static final String ATT_FREEMARKER_CONFIG_KEY_MODE_CLASS = "class";
    public static final String ATT_FREEMARKER_CONFIG_KEY_MODE_FOLDER = "folder";
    public static final String ATT_FREEMARKER_CONFIG_KEY_PATH = "path";
    public static final String ATT_FREEMARKER_CONFIG_KEY_CLASS = "class";
    public static final String ATT_FREEMARKER_CONFIG_KEY_ENCODING = "encoding";
    public static final String ATT_FREEMARKER_CONFIG_KEY_ENCODING_UTF8 = "UTF-8";
    public static final String ATT_FREEMARKER_CONFIG_KEY_ENCODING_DEFAULT = "UTF-8";
    public static final String ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER = "exception-handler";
    public static final String ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER_RETHROW = "RETHROW_HANDLER";
    public static final String ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER_IGNORE = "IGNORE_HANDLER";
    public static final String ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER_DEBUG = "DEBUG_HANDLER";
    public static final String ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER_HTML_DEBUG = "HTML_DEBUG_HANDLER";
    public static final String ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER_DEFAULT = "RETHROW_HANDLER";
    public static final String ATT_FREEMARKER_CONFIG_KEY_LOG_EXCEPTION = "log-exception";
    public static final String ATT_FREEMARKER_CONFIG_KEY_LOG_EXCEPTION_DEFAULT = "false";
    public static final String ATT_FREEMARKER_CONFIG_KEY_WRAP_UNCHECKED_EXCEPTION = "wrap-unchecked-exceptions";
    public static final String ATT_FREEMARKER_CONFIG_KEY_WRAP_UNCHECKED_EXCEPTION_DEFAULT = "true";
    public static final String ATT_FREEMARKER_CONFIG_KEY_FALLBACK_ON_NULL_LOOP_VARIABLE = "fallback-on-null-loop-variable";
    public static final String ATT_FREEMARKER_CONFIG_KEY_FALLBACK_ON_NULL_LOOP_VARIABLE_DEFAULT = "false";
    private static final long serialVersionUID = -2313658506839366841L;
    private static Map<String, Configuration> mapConfig = new HashMap<String, Configuration>();
    private static final HashMap<String, TemplateExceptionHandler> DEF_TEH = new HashMap();

    protected static Configuration getConfig(String key, Properties config) throws Exception {
        Configuration freeMarkerConfigInstance;
        if (key == null) {
            key = ATT_DEFAULT;
        }
        if ((freeMarkerConfigInstance = mapConfig.get(key)) == null) {
            logger.info(FreeMarkerConfigStep.class.getSimpleName() + " INIT - config = " + config);
            String versionString = config.getProperty(ATT_FREEMARKER_CONFIG_KEY_VERSION, "2.3.32");
            Version version = new Version(versionString);
            Configuration freeMarkerConfig = new Configuration(version);
            String path = config.getProperty(ATT_FREEMARKER_CONFIG_KEY_PATH);
            if (path == null) {
                throw new ConfigException("provide valid value for parameter path");
            }
            String mode = config.getProperty(ATT_FREEMARKER_CONFIG_KEY_MODE);
            if ("class".equalsIgnoreCase(mode)) {
                String configClass = config.getProperty("class");
                Class c = null;
                c = configClass == null ? FreeMarkerConfigStep.class : ClassHelper.newInstance((String)configClass).getClass();
                freeMarkerConfig.setClassForTemplateLoading(c, path);
            } else if (ATT_FREEMARKER_CONFIG_KEY_MODE_FOLDER.equalsIgnoreCase(mode)) {
                freeMarkerConfig.setDirectoryForTemplateLoading(new File(path));
            } else {
                throw new ConfigException("provide valid value for parameter mode(used:" + mode + ")");
            }
            freeMarkerConfig.setDefaultEncoding(config.getProperty(ATT_FREEMARKER_CONFIG_KEY_ENCODING, "UTF-8"));
            String exceptionHandler = config.getProperty(ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER, "RETHROW_HANDLER");
            TemplateExceptionHandler templateExceptionHandler = DEF_TEH.get(exceptionHandler);
            freeMarkerConfig.setTemplateExceptionHandler(templateExceptionHandler);
            freeMarkerConfig.setLogTemplateExceptions(BooleanUtils.isTrue((String)config.getProperty(ATT_FREEMARKER_CONFIG_KEY_LOG_EXCEPTION, "false")));
            freeMarkerConfig.setWrapUncheckedExceptions(BooleanUtils.isTrue((String)config.getProperty(ATT_FREEMARKER_CONFIG_KEY_WRAP_UNCHECKED_EXCEPTION, ATT_FREEMARKER_CONFIG_KEY_WRAP_UNCHECKED_EXCEPTION_DEFAULT)));
            freeMarkerConfig.setFallbackOnNullLoopVariable(BooleanUtils.isTrue((String)config.getProperty(ATT_FREEMARKER_CONFIG_KEY_FALLBACK_ON_NULL_LOOP_VARIABLE, "false")));
            freeMarkerConfigInstance = freeMarkerConfig;
            mapConfig.put(key, freeMarkerConfig);
        }
        return freeMarkerConfigInstance;
    }

    public int process(DocProcessContext context, DocProcessData data) throws Exception {
        int res = super.process(context, data);
        Configuration cfg = FreeMarkerConfigStep.getConfig(this.getParam01(), this.getCustomConfig());
        context.setAttribute("FreeMarkerConfig", (Object)cfg);
        return res;
    }

    static {
        DEF_TEH.put("RETHROW_HANDLER", TemplateExceptionHandler.RETHROW_HANDLER);
        DEF_TEH.put(ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER_IGNORE, TemplateExceptionHandler.IGNORE_HANDLER);
        DEF_TEH.put(ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER_DEBUG, TemplateExceptionHandler.DEBUG_HANDLER);
        DEF_TEH.put(ATT_FREEMARKER_CONFIG_KEY_EXCEPTION_HANDLER_HTML_DEBUG, TemplateExceptionHandler.HTML_DEBUG_HANDLER);
    }
}

