/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.freemarker.config;

import java.util.Map;
import java.util.Properties;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.core.util.regex.ParamFinder;
import org.fugerit.java.doc.base.process.DocProcessContext;
import org.fugerit.java.doc.base.process.DocProcessData;
import org.fugerit.java.doc.freemarker.config.FreeMarkerConstants;
import org.fugerit.java.doc.freemarker.config.FreeMarkerProcessStep;
import org.fugerit.java.doc.freemarker.config.FreemarkerApplyHelper;

public class FreeMarkerComplexProcessStep
extends FreeMarkerProcessStep {
    private static final long serialVersionUID = -7009153804877056158L;
    public static final String ATT_TEMPLATE_PATH = "template-path";
    public static final String CHAIN_ID_PARAM = "chainId";
    public static final String ATT_MAP_ALL = "map-all";
    public static final String ATT_MAP_ATTS = "map-atts";

    @Override
    public int process(DocProcessContext context, DocProcessData data) throws Exception {
        Properties atts = this.getCustomConfig();
        if (StringUtils.isEmpty((String)this.getParam01())) {
            String templatePath = atts.getProperty(ATT_TEMPLATE_PATH);
            if (StringUtils.isEmpty((String)templatePath)) {
                throw new ConfigException("Template must be provided");
            }
            ParamFinder finder = ParamFinder.newFinder();
            Properties params = new Properties();
            params.setProperty(CHAIN_ID_PARAM, this.getChainId());
            templatePath = finder.substitute((CharSequence)templatePath, params);
            this.setParam01(templatePath);
        }
        Map<String, Object> map = FreeMarkerConstants.getFreeMarkerMap(context);
        boolean mapAll = BooleanUtils.isTrue((String)atts.getProperty(ATT_MAP_ALL));
        if (mapAll) {
            map.putAll(context.toMap());
        } else {
            String mapAtts = atts.getProperty(ATT_MAP_ATTS);
            if (StringUtils.isNotEmpty((String)mapAtts)) {
                String[] keys = mapAtts.split(",");
                for (int k = 0; k < keys.length; ++k) {
                    String key = keys[k];
                    Object value = context.getAttribute(key);
                    if (value == null) continue;
                    map.put(key, value);
                }
            }
        }
        FreemarkerApplyHelper.setupFreemarkerMap(context, map);
        return super.process(context, data);
    }
}

