/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.typehandler.markdown;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.fugerit.java.doc.base.config.DocInput;
import org.fugerit.java.doc.base.config.DocOutput;
import org.fugerit.java.doc.base.config.DocTypeHandler;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.typehandler.markdown.AbstractCustomMarkdownTypeHandler;
import org.fugerit.java.doc.base.typehandler.markdown.MarkdownBasicDocFacade;

public class SimpleMarkdownBasicTypeHandler
extends AbstractCustomMarkdownTypeHandler {
    public static final DocTypeHandler HANDLER = new SimpleMarkdownBasicTypeHandler();
    public static final DocTypeHandler HANDLER_NOCOMMENTS = new SimpleMarkdownBasicTypeHandler(false);
    public static final DocTypeHandler HANDLER_UTF8 = new SimpleMarkdownBasicTypeHandler(StandardCharsets.UTF_8);
    public static final DocTypeHandler HANDLER_NOCOMMENTS_UTF8 = new SimpleMarkdownBasicTypeHandler(StandardCharsets.UTF_8, false);
    private static final long serialVersionUID = -73945133608L;

    public SimpleMarkdownBasicTypeHandler() {
    }

    public SimpleMarkdownBasicTypeHandler(boolean printComments) {
        super(printComments);
    }

    public SimpleMarkdownBasicTypeHandler(Charset charset, boolean printComments) {
        super(charset, printComments);
    }

    public SimpleMarkdownBasicTypeHandler(Charset charset) {
        super(charset);
    }

    @Override
    public void handle(DocInput docInput, DocOutput docOutput) throws Exception {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(docOutput.getOs(), this.getCharset()));
        DocBase docBase = docInput.getDoc();
        MarkdownBasicDocFacade facade = new MarkdownBasicDocFacade(writer, this.isPrintComments());
        facade.handleDoc(docBase);
    }
}

