/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.base.facade;

import java.io.Reader;
import java.util.Properties;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.doc.base.config.DocException;
import org.fugerit.java.doc.base.facade.DocFacadeSourceConfig;
import org.fugerit.java.doc.base.model.DocBase;
import org.fugerit.java.doc.base.parser.DocParser;
import org.fugerit.java.doc.base.xml.DocXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocFacadeSource {
    private DocFacadeSourceConfig docFacadeSourceConfig;
    public static final int SOURCE_TYPE_XML = 1;
    public static final int SOURCE_TYPE_JSON = 2;
    public static final int SOURCE_TYPE_YAML = 3;
    public static final int SOURCE_TYPE_DEFAULT = 1;
    private static final Logger logger = LoggerFactory.getLogger(DocFacadeSource.class);
    private static final DocFacadeSource DEFAULT_INSTANCE = new DocFacadeSource();
    private static final String TYPE_SOURCE_XML = DocXmlParser.class.getName();
    private static final String TYPE_SOURCE_JSON = "org.fugerit.java.doc.json.parse.DocJsonParser";
    private static final String TYPE_SOURCE_YAML = "org.fugerit.java.doc.yaml.parse.DocYamlParser";
    private static final Properties PARSERS = new Properties();

    public DocFacadeSource(DocFacadeSourceConfig docFacadeSourceConfig) {
        this.docFacadeSourceConfig = docFacadeSourceConfig;
    }

    public DocFacadeSource() {
        this(DocFacadeSourceConfig.DEFAULT_CONFIG);
    }

    public static DocFacadeSource getInstance() {
        return DEFAULT_INSTANCE;
    }

    public DocParser getParserForSource(int sourceType) {
        DocParser parser = null;
        try {
            String type = PARSERS.getProperty(String.valueOf(sourceType));
            if (type != null) {
                parser = (DocParser)ClassHelper.newInstance((String)type);
            }
        }
        catch (Exception e) {
            if (this.docFacadeSourceConfig.isFailOnSourceModuleNotFound()) {
                throw new ConfigRuntimeException("Exception getting parser for sourceType : " + sourceType + " - " + e, (Throwable)e);
            }
            logger.warn("Failed to load parser for source type : {} ({})", (Object)sourceType, (Object)e.toString());
        }
        return parser;
    }

    public boolean isSourceSupported(int sourceType) {
        return this.getParserForSource(sourceType) != null;
    }

    public DocBase parseRE(Reader reader, int sourceType) {
        DocBase docBase = null;
        try {
            docBase = this.parse(reader, sourceType);
        }
        catch (DocException e) {
            throw new ConfigRuntimeException((Throwable)e);
        }
        return docBase;
    }

    public DocBase parse(Reader reader, int sourceType) throws DocException {
        DocBase docBase = null;
        DocParser parser = this.getParserForSource(sourceType);
        if (parser == null) {
            throw new DocException("No parser found for source type : " + sourceType);
        }
        docBase = parser.parse(reader);
        return docBase;
    }

    public DocFacadeSourceConfig getDocFacadeSourceConfig() {
        return this.docFacadeSourceConfig;
    }

    static {
        PARSERS.setProperty(String.valueOf(1), TYPE_SOURCE_XML);
        PARSERS.setProperty(String.valueOf(2), TYPE_SOURCE_JSON);
        PARSERS.setProperty(String.valueOf(3), TYPE_SOURCE_YAML);
    }
}

