/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.ErrorDetails;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.ValidateOutput;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.extensibility.CachingVerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.core.internal.util.ValidatePatternUtils;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.nc.preparation.PreparationContext;
import org.flywaydb.nc.utils.VerbUtils;

public class ValidateVerbExtension
extends CachingVerbExtension {
    private static final Log LOG = LogFactory.getLog(ValidateVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "validate".equals(verb);
    }

    public Object executeVerb(Configuration configuration) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        PreparationContext context = PreparationContext.get((Configuration)configuration, (boolean)this.cached);
        NativeConnectorsDatabase database = context.getDatabase();
        CallbackManager callbackManager = new CallbackManager(configuration, context.getResources());
        callbackManager.handleEvent(Event.BEFORE_VALIDATE, database, configuration, context.getParsingContext());
        MigrationInfo[] migrations = context.getMigrations();
        if (!database.schemaHistoryTableExists(configuration.getTable())) {
            LOG.info("Schema history table " + database.quote(new String[]{database.getCurrentSchema(), configuration.getTable()}) + " does not exist yet");
        }
        if (!database.isSchemaExists(database.getCurrentSchema()) && migrations.length != 0 && !ValidatePatternUtils.isPendingIgnored((ValidatePattern[])configuration.getIgnoreMigrationPatterns())) {
            String validationErrorMessage = "Schema " + database.doQuote(database.getCurrentSchema()) + " doesn't exist yet";
            ErrorDetails validationError = new ErrorDetails((ErrorCode)CoreErrorCode.SCHEMA_DOES_NOT_EXIST, validationErrorMessage);
            return new ValidateResult(VersionPrinter.getVersion(), database.getDatabaseMetaData().databaseName(), validationError, false, 0, new ArrayList(), new ArrayList());
        }
        stopWatch.stop();
        List notIgnoredMigrations = VerbUtils.removeIgnoredMigrations((Configuration)configuration, (MigrationInfo[])migrations);
        List<ValidateOutput> invalidMigrations = this.getInvalidMigrations(notIgnoredMigrations, configuration);
        if (invalidMigrations.isEmpty()) {
            int count = migrations.length;
            LOG.info(String.format("Successfully validated %d migration%s (execution time %s)", count, count == 1 ? "" : "s", TimeFormat.format((long)stopWatch.getTotalTimeMillis())));
            callbackManager.handleEvent(Event.AFTER_VALIDATE, database, configuration, context.getParsingContext());
            if (migrations.length == 0) {
                ArrayList<String> warnings = new ArrayList<String>();
                String noMigrationsWarning = "No migrations found. Are your locations set up correctly?";
                warnings.add("No migrations found. Are your locations set up correctly?");
                LOG.warn("No migrations found. Are your locations set up correctly?");
                return new ValidateResult(VersionPrinter.getVersion(), database.getDatabaseMetaData().databaseName(), null, true, migrations.length, new ArrayList(), warnings);
            }
            return new ValidateResult(VersionPrinter.getVersion(), database.getDatabaseMetaData().databaseName(), null, true, migrations.length, invalidMigrations, new ArrayList());
        }
        callbackManager.handleEvent(Event.AFTER_VALIDATE_ERROR, database, configuration, context.getParsingContext());
        return new ValidateResult(VersionPrinter.getVersion(), database.getDatabaseMetaData().databaseName(), new ErrorDetails((ErrorCode)CoreErrorCode.VALIDATE_ERROR, "Migrations have failed validation"), false, 0, invalidMigrations, new ArrayList());
    }

    private List<ValidateOutput> getInvalidMigrations(List<MigrationInfo> migrations, Configuration configuration) {
        boolean pendingIgnored = ValidatePatternUtils.isPendingIgnored((ValidatePattern[])configuration.getIgnoreMigrationPatterns());
        boolean futureIgnored = ValidatePatternUtils.isFutureIgnored((ValidatePattern[])configuration.getIgnoreMigrationPatterns());
        MigrationVersion appliedBaselineVersion = ValidateVerbExtension.getAppliedBaselineVersion(migrations);
        ArrayList<ValidateOutput> result = new ArrayList<ValidateOutput>();
        result.addAll(ValidateVerbExtension.getTypeMismatch(migrations, appliedBaselineVersion));
        result.addAll(ValidateVerbExtension.getChecksumChanged(migrations, pendingIgnored, appliedBaselineVersion));
        result.addAll(ValidateVerbExtension.getDescriptionChanged(migrations, appliedBaselineVersion));
        result.addAll(ValidateVerbExtension.getOutdatedRepeatables(migrations, pendingIgnored));
        result.addAll(ValidateVerbExtension.getMissingAndFutureSuccessMigrations(migrations, futureIgnored));
        result.addAll(ValidateVerbExtension.getMissingSuccessRepeatables(migrations));
        result.addAll(ValidateVerbExtension.getFailedVersionedMigrations(migrations, futureIgnored));
        result.addAll(ValidateVerbExtension.getFailedRepeatableMigrations(migrations));
        result.addAll(ValidateVerbExtension.getNotIgnoredIgnored(migrations, configuration, result));
        result.addAll(ValidateVerbExtension.getPendingVersionedMigrations(migrations, pendingIgnored));
        result.addAll(ValidateVerbExtension.getPendingRepeatableMigrations(migrations, pendingIgnored));
        return result;
    }

    private static MigrationVersion getAppliedBaselineVersion(List<MigrationInfo> migrations) {
        return migrations.stream().filter(x -> x.getType().isBaseline()).map(MigrationInfo::getVersion).max(MigrationVersion::compareTo).orElse(null);
    }

    private static List<ValidateOutput> getOutdatedRepeatables(List<MigrationInfo> migrations, boolean pendingIgnored) {
        return migrations.stream().filter(x -> !pendingIgnored).filter(x -> x.getState() == MigrationState.OUTDATED).map(x -> new ValidateOutput("", x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.OUTDATED_REPEATABLE_MIGRATION, "Detected outdated resolved repeatable migration that should be re-applied to database: " + x.getDescription()))).toList();
    }

    private static List<ValidateOutput> getTypeMismatch(List<MigrationInfo> migrations, MigrationVersion appliedBaselineVersion) {
        return migrations.stream().filter(x -> !x.isTypeMatching()).filter(x -> x.isRepeatable() || x.getVersion().isNewerThan(appliedBaselineVersion)).map(ValidateVerbExtension::typeMismatchesToValidateOutput).toList();
    }

    private static ValidateOutput typeMismatchesToValidateOutput(MigrationInfo mismatch) {
        StringBuilder errorMessage = new StringBuilder();
        MigrationVersion version = mismatch.getVersion();
        errorMessage.append("Detected type mismatch for migration version ");
        errorMessage.append(version.getVersion());
        errorMessage.append("\n-> ");
        errorMessage.append("Applied to database on ");
        errorMessage.append(mismatch.getInstalledOn());
        errorMessage.append(" (");
        errorMessage.append(mismatch.getAppliedType().name());
        errorMessage.append(")");
        errorMessage.append("Resolved locally at: ");
        errorMessage.append(mismatch.getPhysicalLocation());
        errorMessage.append(" (");
        errorMessage.append(mismatch.getResolvedType().name());
        errorMessage.append(")");
        errorMessage.append("\nEither revert the changes to the migration, or run repair to update the schema history.");
        return new ValidateOutput(version.getVersion(), mismatch.getDescription(), mismatch.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.TYPE_MISMATCH, errorMessage.toString()));
    }

    private static List<ValidateOutput> getChecksumChanged(List<MigrationInfo> migrations, boolean pendingIgnored, MigrationVersion appliedBaselineVersion) {
        return migrations.stream().filter(x -> x.isVersioned() || x.getState() != MigrationState.OUTDATED && pendingIgnored).filter(x -> x.isVersioned() || x.getState() != MigrationState.SUPERSEDED && pendingIgnored).filter(x -> x.isRepeatable() || x.getVersion().compareTo(appliedBaselineVersion) > 0).filter(migrationInfo -> !migrationInfo.isChecksumMatching()).map(x -> {
            String migrationIdentifier = x.isVersioned() ? "version " + x.getVersion().getVersion() : x.getScript();
            return new ValidateOutput(x.isVersioned() ? x.getVersion().getVersion() : "", x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.CHECKSUM_MISMATCH, "Migration checksum mismatch for migration " + migrationIdentifier + "\n-> Applied to database : " + x.getAppliedChecksum() + "\n-> Resolved locally    : " + x.getResolvedChecksum() + "\nEither revert the changes to the migration, or run repair to update the schema history."));
        }).toList();
    }

    private static List<ValidateOutput> getDescriptionChanged(List<MigrationInfo> migrations, MigrationVersion appliedBaselineVersion) {
        return migrations.stream().filter(MigrationInfo::isVersioned).filter(x -> x.getVersion().compareTo(appliedBaselineVersion) > 0).filter(migrationInfo -> !migrationInfo.isDescriptionMatching()).map(x -> new ValidateOutput(x.getVersion().getVersion(), x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.DESCRIPTION_MISMATCH, "Migration description mismatch for migration version " + x.getVersion().getVersion() + "\n-> Applied to database : " + x.getAppliedDescription() + "\n-> Resolved locally    : " + x.getResolvedDescription() + "\nEither revert the changes to the migration, or run repair to update the schema history."))).toList();
    }

    private static List<ValidateOutput> getMissingAndFutureSuccessMigrations(List<MigrationInfo> migrations, boolean futureIgnored) {
        return migrations.stream().filter(x -> x.getState() == MigrationState.MISSING_SUCCESS || !futureIgnored && x.getState() == MigrationState.FUTURE_SUCCESS).filter(x -> !x.getState().isResolved()).filter(MigrationInfo::isVersioned).map(x -> new ValidateOutput(x.getVersion().getVersion(), x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.APPLIED_VERSIONED_MIGRATION_NOT_RESOLVED, "Detected applied migration not resolved locally: " + x.getVersion().getVersion()))).toList();
    }

    private static List<ValidateOutput> getMissingSuccessRepeatables(List<MigrationInfo> migrations) {
        return migrations.stream().filter(x -> x.getState() == MigrationState.MISSING_SUCCESS).filter(MigrationInfo::isRepeatable).map(x -> new ValidateOutput("", x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.APPLIED_REPEATABLE_MIGRATION_NOT_RESOLVED, "Detected applied migration not resolved locally: " + x.getDescription() + "."))).toList();
    }

    private static List<ValidateOutput> getNotIgnoredIgnored(List<MigrationInfo> migrations, Configuration configuration, List<ValidateOutput> result) {
        boolean isIgnoredIgnored;
        boolean bl = isIgnoredIgnored = configuration.getCherryPick() != null || ValidatePatternUtils.isIgnoredIgnored((ValidatePattern[])configuration.getIgnoreMigrationPatterns());
        if (isIgnoredIgnored) {
            return List.of();
        }
        Set errored = result.stream().map(x -> x.version == null ? x.description : x.version).collect(Collectors.toSet());
        return migrations.stream().filter(x -> x.getState() == MigrationState.IGNORED).filter(x -> !x.getType().isBaseline()).filter(x -> !x.getType().isUndo()).filter(x -> !errored.contains(x.isRepeatable() ? x.getDescription() : x.getVersion().getVersion())).filter(MigrationInfo::isShouldExecute).map(x -> {
            if (x.isVersioned()) {
                String errorMessage = "Detected resolved migration not applied to database: " + x.getVersion().getVersion() + ".\nTo ignore this migration, set -ignoreMigrationPatterns='*:ignored'. To allow executing this migration, set -outOfOrder=true.";
                return Pair.of((Object)x, (Object)new ErrorDetails((ErrorCode)CoreErrorCode.RESOLVED_VERSIONED_MIGRATION_NOT_APPLIED, errorMessage));
            }
            String errorMessage = "Detected resolved repeatable migration not applied to database: " + x.getDescription() + ".\nTo ignore this migration, set -ignoreMigrationPatterns='*:ignored'.";
            return Pair.of((Object)x, (Object)new ErrorDetails((ErrorCode)CoreErrorCode.RESOLVED_REPEATABLE_MIGRATION_NOT_APPLIED, errorMessage));
        }).map(x -> new ValidateOutput(((MigrationInfo)x.getLeft()).getVersion().getVersion(), ((MigrationInfo)x.getLeft()).getDescription(), ((MigrationInfo)x.getLeft()).getPhysicalLocation(), (ErrorDetails)x.getRight())).toList();
    }

    private static List<ValidateOutput> getPendingVersionedMigrations(List<MigrationInfo> migrations, boolean pendingIgnored) {
        return migrations.stream().filter(x -> !pendingIgnored).filter(x -> x.getState() == MigrationState.PENDING).filter(MigrationInfo::isVersioned).map(x -> new ValidateOutput(x.getVersion().getVersion(), x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.RESOLVED_VERSIONED_MIGRATION_NOT_APPLIED, "Detected resolved migration not applied to database: " + x.getVersion().getVersion()))).toList();
    }

    private static List<ValidateOutput> getPendingRepeatableMigrations(List<MigrationInfo> migrations, boolean pendingIgnored) {
        return migrations.stream().filter(x -> !pendingIgnored).filter(x -> x.getState() == MigrationState.PENDING).filter(MigrationInfo::isRepeatable).filter(MigrationInfo::isShouldExecute).map(x -> new ValidateOutput("", x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.RESOLVED_REPEATABLE_MIGRATION_NOT_APPLIED, "Detected resolved repeatable migration not applied to database: " + x.getDescription() + "."))).toList();
    }

    private static List<ValidateOutput> getFailedVersionedMigrations(List<MigrationInfo> migrations, boolean futureIgnored) {
        return migrations.stream().filter(x -> x.getState() == MigrationState.FAILED || x.getState() == MigrationState.MISSING_FAILED || !futureIgnored && x.getState() == MigrationState.FUTURE_FAILED).filter(MigrationInfo::isVersioned).map(x -> new ValidateOutput(x.getVersion().getVersion(), x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.FAILED_VERSIONED_MIGRATION, "Detected failed migration to version " + x.getVersion().getVersion()))).toList();
    }

    private static List<ValidateOutput> getFailedRepeatableMigrations(List<MigrationInfo> migrations) {
        return migrations.stream().filter(x -> x.getState() == MigrationState.FAILED || x.getState() == MigrationState.MISSING_FAILED).filter(MigrationInfo::isRepeatable).map(x -> new ValidateOutput("", x.getDescription(), x.getPhysicalLocation(), new ErrorDetails((ErrorCode)CoreErrorCode.FAILED_REPEATABLE_MIGRATION, "Detected failed repeatable migration: " + x.getDescription()))).toList();
    }
}

