/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.test.junit5;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.test.FlywayTestExecutionListener;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;

public class FlywayTestExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class});

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.logger.debug((Object)("afterAll " + extensionContext));
        this.getTestExecutionListener().afterTestClass(FlywayTestExtension.getTestContextManager(extensionContext).getTestContext());
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.logger.debug((Object)("afterEach " + extensionContext));
        this.getTestExecutionListener().afterTestMethod(FlywayTestExtension.getTestContextManager(extensionContext).getTestContext());
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        this.logger.debug((Object)("afterTestExecution " + extensionContext));
        this.getTestExecutionListener().afterTestExecution(FlywayTestExtension.getTestContextManager(extensionContext).getTestContext());
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.logger.debug((Object)("beforeAll " + extensionContext));
        this.getTestExecutionListener().beforeTestClass(FlywayTestExtension.getTestContextManager(extensionContext).getTestContext());
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.logger.debug((Object)("beforeEach " + extensionContext));
        this.getTestExecutionListener().beforeTestMethod(FlywayTestExtension.getTestContextManager(extensionContext).getTestContext());
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        this.logger.debug((Object)("beforeTestExecution " + extensionContext));
        this.getTestExecutionListener().beforeTestExecution(FlywayTestExtension.getTestContextManager(extensionContext).getTestContext());
    }

    private FlywayTestExecutionListener getTestExecutionListener() {
        return new FlywayTestExecutionListener();
    }

    private static TestContextManager getTestContextManager(ExtensionContext context) {
        Assert.notNull((Object)context, (String)"ExtensionContext must not be null");
        Class testClass = context.getRequiredTestClass();
        ExtensionContext.Store store = FlywayTestExtension.getStore(context);
        return (TestContextManager)store.getOrComputeIfAbsent((Object)testClass, TestContextManager::new, TestContextManager.class);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

