/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.singlestore;

import java.sql.Connection;
import java.util.Properties;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.database.singlestore.SingleStoreDatabase;
import org.flywaydb.database.singlestore.SingleStoreParser;

public class SingleStoreDatabaseType
extends BaseDatabaseType {
    public String getName() {
        return "SingleStoreDB";
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:singlestore:") || url.startsWith("jdbc:p6spy:singlestore:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:singlestore:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "com.singlestore.jdbc.Driver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.contains("SingleStore");
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("connectionAttributes", String.format("_connector_name:%s,_connector_version:%s,_product_version:%s,program_name:%s,program_version:%s,program_vendor:%s", "SingleStoreDB Flyway connector", VersionPrinter.getVersion(), VersionPrinter.getVersion(), "Redgate_Flyway", VersionPrinter.getVersion(), "Redgate"));
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SingleStoreDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new SingleStoreParser(configuration, parsingContext);
    }

    public String instantiateClassExtendedErrorMessage() {
        return "Failure probably due to inability to load dependencies. Please ensure you have downloaded 'https://mvnrepository.com/artifact/com.singlestore/singlestore-jdbc-client' and extracted to 'flyway/drivers' folder";
    }
}

