/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.singlestore;

import java.sql.SQLException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.singlestore.SingleStoreDatabase;
import org.flywaydb.database.singlestore.SingleStoreSchema;

public class SingleStoreTable
extends Table<SingleStoreDatabase, SingleStoreSchema> {
    private static final Log LOG = LogFactory.getLog(SingleStoreTable.class);

    SingleStoreTable(JdbcTemplate jdbcTemplate, SingleStoreDatabase database, SingleStoreSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((SingleStoreDatabase)this.database).quote(new String[]{((SingleStoreSchema)this.schema).getName(), this.name}), new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        return this.exists(this.schema, null, this.name, new String[0]);
    }

    protected void doLock() throws SQLException {
        if (this.jdbcTemplate.queryForString("select storage_type from information_schema.tables where table_schema=? and table_name=?", new String[]{((SingleStoreSchema)this.schema).getName(), this.name}).equals("COLUMNSTORE")) {
            LOG.warn("Taking lock on columnstore table is not supported by SingleStoreDB");
        } else {
            this.jdbcTemplate.execute("SELECT * FROM " + this + " FOR UPDATE", new Object[0]);
        }
    }
}

