/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.singlestore;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.singlestore.SingleStoreDatabase;
import org.flywaydb.database.singlestore.SingleStoreTable;

public class SingleStoreSchema
extends Schema<SingleStoreDatabase, SingleStoreTable> {
    SingleStoreSchema(JdbcTemplate jdbcTemplate, SingleStoreDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(1) FROM information_schema.schemata WHERE schema_name=? LIMIT 1", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT SUM(found) FROM ((SELECT 1 as found FROM information_schema.tables WHERE table_schema=? LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.views WHERE table_schema=? LIMIT 1) UNION ALL (SELECT 1 as found FROM information_schema.routines WHERE routine_schema=? LIMIT 1)) as all_found", new String[]{this.name, this.name, this.name}) == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((SingleStoreDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((SingleStoreDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (String statement : this.cleanRoutines()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (SingleStoreTable table : (SingleStoreTable[])this.allTables()) {
            table.drop();
        }
    }

    private List<String> cleanRoutines() throws SQLException {
        List routineNames = this.jdbcTemplate.queryForList("SELECT routine_name as 'N', routine_type as 'T' FROM information_schema.routines WHERE routine_schema=?", new Object[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (Map row : routineNames) {
            String routineName = (String)row.get("N");
            String routineType = (String)row.get("T");
            statements.add("DROP " + routineType + " " + ((SingleStoreDatabase)this.database).quote(new String[]{this.name, routineName}));
        }
        return statements;
    }

    private List<String> cleanViews() throws SQLException {
        List viewNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM information_schema.views WHERE table_schema=?", new String[]{this.name});
        ArrayList<String> statements = new ArrayList<String>();
        for (String viewName : viewNames) {
            statements.add("DROP VIEW " + ((SingleStoreDatabase)this.database).quote(new String[]{this.name, viewName}));
        }
        return statements;
    }

    protected SingleStoreTable[] doAllTables() throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM information_schema.tables WHERE table_schema=?", new String[]{this.name});
        SingleStoreTable[] tables = new SingleStoreTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new SingleStoreTable(this.jdbcTemplate, (SingleStoreDatabase)this.database, this, (String)tableNames.get(i));
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return new SingleStoreTable(this.jdbcTemplate, (SingleStoreDatabase)this.database, this, tableName);
    }
}

