/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.reports.utils;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.reports.json.HtmlResultDeserializer;

class ReportsDeserializer
extends JsonDeserializer {
    private final PluginRegister pluginRegister;

    public ReportsDeserializer(PluginRegister pluginRegister) {
        this.pluginRegister = pluginRegister;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonNode reportElement = ctxt.readTree(p);
        if (reportElement.has("operation")) {
            String operation = reportElement.get("operation").asText();
            List deserializers = this.pluginRegister.getInstancesOf(HtmlResultDeserializer.class);
            HtmlResultDeserializer matchedDeserializer = deserializers.stream().filter(x -> x.operationKey().equals(operation)).findFirst().orElseThrow(() -> new FlywayException("Unable to find matching deserializer for " + operation));
            return ctxt.readTreeAsValue(reportElement, matchedDeserializer.getDeserializingClass());
        }
        throw new FlywayException("Unable to deserialize report. Corrupt json report file");
    }
}

