/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mysql;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class MySQLNamedLockTemplate {
    private static final Log LOG = LogFactory.getLog(MySQLNamedLockTemplate.class);
    private final JdbcTemplate jdbcTemplate;
    private final String lockName;

    MySQLNamedLockTemplate(JdbcTemplate jdbcTemplate, int discriminator) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockName = "Flyway-" + discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        try {
            this.lock();
            T t = callable.call();
            return t;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to acquire MySQL named lock: " + this.lockName, e);
        }
        catch (Exception e) {
            RuntimeException rethrow = e instanceof RuntimeException ? (RuntimeException)e : new FlywayException((Throwable)e);
            throw rethrow;
        }
        finally {
            try {
                this.jdbcTemplate.execute("SELECT RELEASE_LOCK('" + this.lockName + "')", new Object[0]);
            }
            catch (SQLException e) {
                LOG.error("Unable to release MySQL named lock: " + this.lockName, (Exception)e);
            }
        }
    }

    private void lock() throws SQLException {
        while (!this.tryLock()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new FlywayException("Interrupted while attempting to acquire MySQL named lock: " + this.lockName, (Throwable)e);
            }
        }
    }

    private boolean tryLock() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT GET_LOCK(?,10)", new String[]{this.lockName}) == 1;
    }
}

