/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.maven.MavenLogCreator;

abstract class AbstractFlywayMojo
extends AbstractMojo {
    private static final String CONFIG_WORKING_DIRECTORY = "flyway.workingDirectory";
    private static final String CONFIG_SERVER_ID = "flyway.serverId";
    private static final String CONFIG_VERSION = "flyway.version";
    private static final String CONFIG_SKIP = "flyway.skip";
    private static final String CONFIG_CURRENT = "flyway.current";
    Log log;
    @Parameter(property="flyway.skip")
    protected boolean skip;
    @Parameter(property="flyway.driver")
    protected String driver;
    @Parameter(property="flyway.url")
    protected String url;
    @Parameter(property="flyway.user")
    protected String user;
    @Parameter(property="flyway.password")
    private String password;
    @Parameter(property="flyway.connectRetries")
    private int connectRetries;
    @Parameter(property="flyway.initSql")
    private String initSql;
    @Parameter
    private String defaultSchema;
    @Parameter
    private String[] schemas;
    @Parameter(property="flyway.table")
    private String table;
    @Parameter(property="flyway.tablespace")
    private String tablespace;
    @Parameter(property="flyway.baselineVersion")
    private String baselineVersion;
    @Parameter(property="flyway.baselineDescription")
    private String baselineDescription;
    @Parameter
    private String[] locations;
    @Parameter
    private String[] resolvers;
    @Parameter(property="flyway.skipDefaultResolvers")
    private Boolean skipDefaultResolvers;
    @Parameter(property="flyway.encoding")
    private String encoding;
    @Parameter
    private Boolean detectEncoding;
    @Parameter(property="flyway.lockRetryCount")
    private Integer lockRetryCount;
    @Parameter(property="flyway.sqlMigrationPrefix")
    private String sqlMigrationPrefix;
    @Parameter(property="flyway.undoSqlMigrationPrefix")
    private String undoSqlMigrationPrefix;
    @Parameter(property="flyway.repeatableSqlMigrationPrefix")
    private String repeatableSqlMigrationPrefix;
    @Parameter(property="flyway.sqlMigrationSeparator")
    private String sqlMigrationSeparator;
    @Parameter
    private String[] sqlMigrationSuffixes;
    @Parameter(property="flyway.cleanOnValidationError")
    private Boolean cleanOnValidationError;
    @Parameter(property="flyway.cleanDisabled")
    private Boolean cleanDisabled;
    @Parameter(property="flyway.target")
    private String target;
    @Parameter
    private String[] cherryPick;
    @Parameter(property="flyway.outOfOrder")
    private Boolean outOfOrder;
    @Parameter(property="flyway.skipExecutingMigrations")
    private Boolean skipExecutingMigrations;
    @Parameter(property="flyway.outputQueryResults")
    private Boolean outputQueryResults;
    @Parameter(property="flyway.ignoreMissingMigrations")
    private Boolean ignoreMissingMigrations;
    @Parameter(property="flyway.ignoreIgnoredMigrations")
    private Boolean ignoreIgnoredMigrations;
    @Parameter(property="flyway.ignorePendingMigrations")
    private Boolean ignorePendingMigrations;
    @Parameter(property="flyway.ignoreFutureMigrations")
    private Boolean ignoreFutureMigrations;
    @Parameter
    private String[] ignoreMigrationPatterns;
    @Parameter(property="flyway.validateMigrationNaming")
    private Boolean validateMigrationNaming;
    @Parameter(property="flyway.placeholderReplacement")
    private Boolean placeholderReplacement;
    @Parameter
    private Map<String, String> placeholders;
    @Parameter
    private Map<String, String> jdbcProperties;
    @Parameter(property="flyway.placeholderPrefix")
    private String placeholderPrefix;
    @Parameter(property="flyway.placeholderSuffix")
    private String placeholderSuffix;
    @Parameter
    private String[] callbacks;
    @Parameter(property="flyway.skipDefaultCallbacks")
    private Boolean skipDefaultCallbacks;
    @Parameter(property="flyway.baselineOnMigrate")
    private Boolean baselineOnMigrate;
    @Parameter(property="flyway.validateOnMigrate")
    private Boolean validateOnMigrate;
    @Parameter(property="flyway.mixed")
    private Boolean mixed;
    @Parameter(property="flyway.group")
    private Boolean group;
    @Parameter(property="flyway.installedBy")
    private String installedBy;
    @Parameter
    private String[] errorOverrides;
    @Parameter(property="flyway.dryRunOutput")
    private String dryRunOutput;
    @Parameter(property="flyway.stream")
    private Boolean stream;
    @Parameter(property="flyway.batch")
    private Boolean batch;
    @Parameter(property="flyway.oracle.sqlplus")
    private Boolean oracleSqlplus;
    @Parameter(property="flyway.oracle.sqlplusWarn")
    private Boolean oracleSqlplusWarn;
    @Parameter(property="flyway.licenseKey")
    private String licenseKey;
    @Parameter(property="flyway.configFileEncoding")
    private String configFileEncoding;
    @Parameter(property="flyway.configFiles")
    private String[] configFiles;
    @Parameter(property="flyway.createSchemas")
    private Boolean createSchemas;
    @Parameter(property="flyway.workingDirectory")
    private String workingDirectory;
    @Parameter(property="flyway.vault.url")
    public String vaultUrl;
    @Parameter(property="flyway.vault.token")
    public String vaultToken;
    @Parameter
    public String[] vaultSecrets;
    @Parameter(property="flyway.failOnMissingLocations")
    public Boolean failOnMissingLocations;
    @Parameter(property="flyway.serverId")
    private String serverId = "flyway-db";
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mavenProject;
    @Component
    private SettingsDecrypter settingsDecrypter;

    AbstractFlywayMojo() {
    }

    private void loadCredentialsFromSettings() throws FlywayException {
        Server server = this.settings.getServer(this.serverId);
        if (this.user == null) {
            if (server != null) {
                this.user = server.getUsername();
                SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
                for (SettingsProblem problem : result.getProblems()) {
                    if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
                    throw new FlywayException("Unable to decrypt password: " + problem, (Throwable)problem.getException());
                }
                this.password = result.getServer().getPassword();
            }
        } else if (server != null) {
            throw new FlywayException("You specified credentials both in the Flyway config and settings.xml. Use either one or the other");
        }
    }

    protected boolean getBooleanProperty(String systemPropertyName, boolean mavenPropertyValue) {
        String systemPropertyValue = System.getProperty(systemPropertyName);
        if (systemPropertyValue != null) {
            return Boolean.parseBoolean(systemPropertyValue);
        }
        return mavenPropertyValue;
    }

    public final void execute() throws MojoExecutionException {
        LogFactory.setLogCreator((LogCreator)new MavenLogCreator(this));
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        if (this.getBooleanProperty(CONFIG_SKIP, this.skip)) {
            this.log.info("Skipping Flyway execution");
            return;
        }
        try {
            String value;
            File workDir;
            HashSet classpathElements = new HashSet();
            classpathElements.addAll(this.mavenProject.getCompileClasspathElements());
            classpathElements.addAll(this.mavenProject.getRuntimeClasspathElements());
            ClassRealm classLoader = (ClassRealm)Thread.currentThread().getContextClassLoader();
            for (String classpathElement : classpathElements) {
                classLoader.addURL(new File(classpathElement).toURI().toURL());
            }
            File file = workDir = StringUtils.hasText((String)this.workingDirectory) ? this.toFile(this.mavenProject.getBasedir(), this.workingDirectory) : this.mavenProject.getBasedir();
            if (this.locations != null) {
                for (int i = 0; i < this.locations.length; ++i) {
                    if (!this.locations[i].startsWith("filesystem:")) continue;
                    String newLocation = this.locations[i].substring("filesystem:".length());
                    Iterator<String> file2 = this.toFile(workDir, newLocation);
                    this.locations[i] = "filesystem:" + ((File)((Object)file2)).getAbsolutePath();
                }
            } else {
                this.locations = new String[]{"filesystem:" + workDir.getAbsolutePath() + "/src/main/resources/db/migration"};
            }
            Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
            HashMap<String, String> conf = new HashMap<String, String>(this.loadConfigurationFromDefaultConfigFiles(envVars));
            this.loadCredentialsFromSettings();
            ConfigUtils.putIfSet(conf, (String)"flyway.driver", (Object[])new Object[]{this.driver});
            ConfigUtils.putIfSet(conf, (String)"flyway.url", (Object[])new Object[]{this.url});
            ConfigUtils.putIfSet(conf, (String)"flyway.user", (Object[])new Object[]{this.user});
            ConfigUtils.putIfSet(conf, (String)"flyway.password", (Object[])new Object[]{this.password});
            ConfigUtils.putIfSet(conf, (String)"flyway.connectRetries", (Object[])new Object[]{this.connectRetries});
            ConfigUtils.putIfSet(conf, (String)"flyway.initSql", (Object[])new Object[]{this.initSql});
            ConfigUtils.putIfSet(conf, (String)"flyway.defaultSchema", (Object[])new Object[]{this.defaultSchema});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.schemas", (String[][])new String[][]{this.schemas});
            ConfigUtils.putIfSet(conf, (String)"flyway.table", (Object[])new Object[]{this.table});
            ConfigUtils.putIfSet(conf, (String)"flyway.tablespace", (Object[])new Object[]{this.tablespace});
            ConfigUtils.putIfSet(conf, (String)"flyway.baselineVersion", (Object[])new Object[]{this.baselineVersion});
            ConfigUtils.putIfSet(conf, (String)"flyway.baselineDescription", (Object[])new Object[]{this.baselineDescription});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.locations", (String[][])new String[][]{this.locations});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.resolvers", (String[][])new String[][]{this.resolvers});
            ConfigUtils.putIfSet(conf, (String)"flyway.skipDefaultResolvers", (Object[])new Object[]{this.skipDefaultResolvers});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.callbacks", (String[][])new String[][]{this.callbacks});
            ConfigUtils.putIfSet(conf, (String)"flyway.skipDefaultCallbacks", (Object[])new Object[]{this.skipDefaultCallbacks});
            ConfigUtils.putIfSet(conf, (String)"flyway.encoding", (Object[])new Object[]{this.encoding});
            ConfigUtils.putIfSet(conf, (String)"flyway.detectEncoding", (Object[])new Object[]{this.detectEncoding});
            ConfigUtils.putIfSet(conf, (String)"flyway.lockRetryCount", (Object[])new Object[]{this.lockRetryCount});
            ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationPrefix", (Object[])new Object[]{this.sqlMigrationPrefix});
            ConfigUtils.putIfSet(conf, (String)"flyway.undoSqlMigrationPrefix", (Object[])new Object[]{this.undoSqlMigrationPrefix});
            ConfigUtils.putIfSet(conf, (String)"flyway.repeatableSqlMigrationPrefix", (Object[])new Object[]{this.repeatableSqlMigrationPrefix});
            ConfigUtils.putIfSet(conf, (String)"flyway.sqlMigrationSeparator", (Object[])new Object[]{this.sqlMigrationSeparator});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.sqlMigrationSuffixes", (String[][])new String[][]{this.sqlMigrationSuffixes});
            ConfigUtils.putIfSet(conf, (String)"flyway.mixed", (Object[])new Object[]{this.mixed});
            ConfigUtils.putIfSet(conf, (String)"flyway.group", (Object[])new Object[]{this.group});
            ConfigUtils.putIfSet(conf, (String)"flyway.installedBy", (Object[])new Object[]{this.installedBy});
            ConfigUtils.putIfSet(conf, (String)"flyway.cleanOnValidationError", (Object[])new Object[]{this.cleanOnValidationError});
            ConfigUtils.putIfSet(conf, (String)"flyway.cleanDisabled", (Object[])new Object[]{this.cleanDisabled});
            ConfigUtils.putIfSet(conf, (String)"flyway.outOfOrder", (Object[])new Object[]{this.outOfOrder});
            ConfigUtils.putIfSet(conf, (String)"flyway.skipExecutingMigrations", (Object[])new Object[]{this.skipExecutingMigrations});
            ConfigUtils.putIfSet(conf, (String)"flyway.outputQueryResults", (Object[])new Object[]{this.outputQueryResults});
            ConfigUtils.putIfSet(conf, (String)"flyway.target", (Object[])new Object[]{this.target});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.cherryPick", (String[][])new String[][]{this.cherryPick});
            ConfigUtils.putIfSet(conf, (String)"flyway.ignoreMissingMigrations", (Object[])new Object[]{this.ignoreMissingMigrations});
            ConfigUtils.putIfSet(conf, (String)"flyway.ignoreIgnoredMigrations", (Object[])new Object[]{this.ignoreIgnoredMigrations});
            ConfigUtils.putIfSet(conf, (String)"flyway.ignorePendingMigrations", (Object[])new Object[]{this.ignorePendingMigrations});
            ConfigUtils.putIfSet(conf, (String)"flyway.ignoreFutureMigrations", (Object[])new Object[]{this.ignoreFutureMigrations});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.ignoreMigrationPatterns", (String[][])new String[][]{this.ignoreMigrationPatterns});
            ConfigUtils.putIfSet(conf, (String)"flyway.validateMigrationNaming", (Object[])new Object[]{this.validateMigrationNaming});
            ConfigUtils.putIfSet(conf, (String)"flyway.placeholderReplacement", (Object[])new Object[]{this.placeholderReplacement});
            ConfigUtils.putIfSet(conf, (String)"flyway.placeholderPrefix", (Object[])new Object[]{this.placeholderPrefix});
            ConfigUtils.putIfSet(conf, (String)"flyway.placeholderSuffix", (Object[])new Object[]{this.placeholderSuffix});
            ConfigUtils.putIfSet(conf, (String)"flyway.baselineOnMigrate", (Object[])new Object[]{this.baselineOnMigrate});
            ConfigUtils.putIfSet(conf, (String)"flyway.validateOnMigrate", (Object[])new Object[]{this.validateOnMigrate});
            ConfigUtils.putIfSet(conf, (String)"flyway.driver", (Object[])new Object[]{this.driver});
            ConfigUtils.putIfSet(conf, (String)"flyway.createSchemas", (Object[])new Object[]{this.createSchemas});
            ConfigUtils.putIfSet(conf, (String)"flyway.failOnMissingLocations", (Object[])new Object[]{this.failOnMissingLocations});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.errorOverrides", (String[][])new String[][]{this.errorOverrides});
            ConfigUtils.putIfSet(conf, (String)"flyway.dryRunOutput", (Object[])new Object[]{this.dryRunOutput});
            ConfigUtils.putIfSet(conf, (String)"flyway.stream", (Object[])new Object[]{this.stream});
            ConfigUtils.putIfSet(conf, (String)"flyway.batch", (Object[])new Object[]{this.batch});
            ConfigUtils.putIfSet(conf, (String)"flyway.oracle.sqlplus", (Object[])new Object[]{this.oracleSqlplus});
            ConfigUtils.putIfSet(conf, (String)"flyway.oracle.sqlplusWarn", (Object[])new Object[]{this.oracleSqlplusWarn});
            ConfigUtils.putIfSet(conf, (String)"flyway.vault.url", (Object[])new Object[]{this.vaultUrl});
            ConfigUtils.putIfSet(conf, (String)"flyway.vault.token", (Object[])new Object[]{this.vaultToken});
            ConfigUtils.putArrayIfSet(conf, (String)"flyway.vault.secrets", (String[][])new String[][]{this.vaultSecrets});
            ConfigUtils.putIfSet(conf, (String)"flyway.licenseKey", (Object[])new Object[]{this.licenseKey});
            if (this.placeholders != null) {
                for (String placeholder : this.placeholders.keySet()) {
                    value = this.placeholders.get(placeholder);
                    conf.put("flyway.placeholders." + placeholder, value == null ? "" : value);
                }
            }
            if (this.jdbcProperties != null) {
                for (String property : this.jdbcProperties.keySet()) {
                    value = this.jdbcProperties.get(property);
                    conf.put("flyway.jdbcProperties." + property, value == null ? "" : value);
                }
            }
            conf.putAll(ConfigUtils.propertiesToMap((Properties)this.mavenProject.getProperties()));
            conf.putAll(this.loadConfigurationFromConfigFiles(workDir, envVars));
            conf.putAll(envVars);
            conf.putAll(ConfigUtils.propertiesToMap((Properties)System.getProperties()));
            AbstractFlywayMojo.removeMavenPluginSpecificPropertiesToAvoidWarnings(conf);
            Flyway flyway = Flyway.configure((ClassLoader)classLoader).configuration(conf).load();
            this.doExecute(flyway);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), ExceptionUtils.getRootCause((Throwable)e));
        }
    }

    private List<File> determineConfigFiles(File workDir, Map<String, String> envVars) {
        ArrayList<File> configFiles;
        block7: {
            block6: {
                configFiles = new ArrayList<File>();
                if (envVars.containsKey("flyway.configFiles")) {
                    for (String file : StringUtils.tokenizeToStringArray((String)envVars.get("flyway.configFiles"), (String)",")) {
                        configFiles.add(this.toFile(workDir, file));
                    }
                    return configFiles;
                }
                if (System.getProperties().containsKey("flyway.configFiles")) {
                    for (String file : StringUtils.tokenizeToStringArray((String)System.getProperties().getProperty("flyway.configFiles"), (String)",")) {
                        configFiles.add(this.toFile(workDir, file));
                    }
                    return configFiles;
                }
                if (!this.mavenProject.getProperties().containsKey("flyway.configFiles")) break block6;
                for (String file : StringUtils.tokenizeToStringArray((String)this.mavenProject.getProperties().getProperty("flyway.configFiles"), (String)",")) {
                    configFiles.add(this.toFile(workDir, file));
                }
                break block7;
            }
            if (this.configFiles == null) break block7;
            for (String configFile : this.configFiles) {
                configFiles.add(this.toFile(workDir, configFile));
            }
        }
        return configFiles;
    }

    private File toFile(File workDir, String fileName) {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(workDir, fileName);
    }

    private String determineConfigurationFileEncoding(Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        if (System.getProperties().containsKey("flyway.configFileEncoding")) {
            return System.getProperties().getProperty("flyway.configFileEncoding");
        }
        if (this.configFileEncoding != null) {
            return this.configFileEncoding;
        }
        return "UTF-8";
    }

    private static void removeMavenPluginSpecificPropertiesToAvoidWarnings(Map<String, String> conf) {
        conf.remove("flyway.configFiles");
        conf.remove("flyway.configFileEncoding");
        conf.remove(CONFIG_CURRENT);
        conf.remove(CONFIG_SKIP);
        conf.remove(CONFIG_VERSION);
        conf.remove(CONFIG_SERVER_ID);
        conf.remove(CONFIG_WORKING_DIRECTORY);
    }

    private Map<String, String> loadConfigurationFromConfigFiles(File workDir, Map<String, String> envVars) {
        String encoding = this.determineConfigurationFileEncoding(envVars);
        HashMap<String, String> conf = new HashMap<String, String>();
        for (File configFile : this.determineConfigFiles(workDir, envVars)) {
            conf.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
        return conf;
    }

    private Map<String, String> loadConfigurationFromDefaultConfigFiles(Map<String, String> envVars) {
        String encoding = this.determineConfigurationFileEncoding(envVars);
        File configFile = new File(System.getProperty("user.home") + "/" + "flyway.conf");
        return new HashMap<String, String>(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)false));
    }

    protected String getProperty(String name) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        return this.mavenProject.getProperties().getProperty(name);
    }

    protected abstract void doExecute(Flyway var1) throws Exception;
}

