/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogCreator;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.maven.MavenLogCreator;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

abstract class AbstractFlywayMojo
extends AbstractMojo {
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    protected Log log;
    protected Flyway flyway = new Flyway();
    boolean skip;
    String driver;
    String url;
    String user;
    private String password;
    private String[] schemas;
    private String table = this.flyway.getTable();
    @Deprecated
    private String initVersion;
    @Deprecated
    private String initDescription;
    private String baselineVersion = this.flyway.getBaselineVersion().getVersion();
    private String baselineDescription = this.flyway.getBaselineDescription();
    private String[] locations = this.flyway.getLocations();
    private String[] resolvers = new String[0];
    private String encoding = this.flyway.getEncoding();
    private String sqlMigrationPrefix = this.flyway.getSqlMigrationPrefix();
    private String sqlMigrationSeparator = this.flyway.getSqlMigrationSeparator();
    private String sqlMigrationSuffix = this.flyway.getSqlMigrationSuffix();
    private boolean cleanOnValidationError = this.flyway.isCleanOnValidationError();
    private String target = this.flyway.getTarget().getVersion();
    private boolean outOfOrder = this.flyway.isOutOfOrder();
    private boolean ignoreFailedFutureMigration = this.flyway.isIgnoreFailedFutureMigration();
    private Map<String, String> placeholders = this.flyway.getPlaceholders();
    private String placeholderPrefix = this.flyway.getPlaceholderPrefix();
    private String placeholderSuffix = this.flyway.getPlaceholderSuffix();
    private String[] callbacks = new String[0];
    @Deprecated
    private Boolean initOnMigrate;
    private boolean baselineOnMigrate = this.flyway.isBaselineOnMigrate();
    private boolean validateOnMigrate = this.flyway.isValidateOnMigrate();
    private File configFile;
    private String serverId = "flyway-db";
    private Settings settings;
    protected MavenProject mavenProject;

    AbstractFlywayMojo() {
    }

    private void loadCredentialsFromSettings() throws FlywayException {
        Server server;
        if (this.user == null && (server = this.settings.getServer(this.serverId)) != null) {
            this.user = server.getUsername();
            try {
                DefaultSecDispatcher secDispatcher = new DefaultSecDispatcher(){
                    {
                        this._cipher = new DefaultPlexusCipher();
                    }
                };
                this.password = secDispatcher.decrypt(server.getPassword());
            }
            catch (SecDispatcherException e) {
                throw new FlywayException("Unable to decrypt password", (Throwable)e);
            }
            catch (PlexusCipherException e) {
                throw new FlywayException("Unable to initialized password decryption", (Throwable)e);
            }
        }
    }

    boolean getBooleanProperty(String systemPropertyName, boolean mavenPropertyValue) {
        String systemPropertyValue = System.getProperty(systemPropertyName);
        if (systemPropertyValue != null) {
            return Boolean.getBoolean(systemPropertyName);
        }
        return mavenPropertyValue;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        LogFactory.setLogCreator((LogCreator)new MavenLogCreator(this));
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        if (this.getBooleanProperty("flyway.skip", this.skip)) {
            this.log.info("Skipping Flyway execution");
            return;
        }
        try {
            this.loadCredentialsFromSettings();
            this.flyway.setClassLoader(Thread.currentThread().getContextClassLoader());
            this.flyway.setSchemas(this.schemas);
            this.flyway.setTable(this.table);
            if (this.initVersion != null) {
                this.log.warn("flyway.initVersion is deprecated. Use baselineVersion instead. Will be removed in Flyway 4.0.");
                this.flyway.setBaselineVersion(this.initVersion);
            }
            if (this.initDescription != null) {
                this.log.warn("flyway.initDescription is deprecated. Use baselineDescription instead. Will be removed in Flyway 4.0.");
                this.flyway.setBaselineDescription(this.initDescription);
            }
            this.flyway.setBaselineVersion(this.baselineVersion);
            this.flyway.setBaselineDescription(this.baselineDescription);
            if (this.locations != null) {
                for (int i = 0; i < this.locations.length; ++i) {
                    if (!this.locations[i].startsWith("filesystem:")) continue;
                    String newLocation = this.locations[i].substring("filesystem:".length());
                    File file = new File(newLocation);
                    if (!file.isAbsolute()) {
                        file = new File(this.mavenProject.getBasedir(), newLocation);
                    }
                    this.locations[i] = "filesystem:" + file.getAbsolutePath();
                }
                this.flyway.setLocations(this.locations);
            }
            this.flyway.setResolvers(this.resolvers);
            this.flyway.setCallbacks(this.callbacks);
            this.flyway.setEncoding(this.encoding);
            this.flyway.setSqlMigrationPrefix(this.sqlMigrationPrefix);
            this.flyway.setSqlMigrationSeparator(this.sqlMigrationSeparator);
            this.flyway.setSqlMigrationSuffix(this.sqlMigrationSuffix);
            this.flyway.setCleanOnValidationError(this.cleanOnValidationError);
            this.flyway.setOutOfOrder(this.outOfOrder);
            this.flyway.setTarget(this.target);
            this.flyway.setIgnoreFailedFutureMigration(this.ignoreFailedFutureMigration);
            this.flyway.setPlaceholderPrefix(this.placeholderPrefix);
            if (this.initOnMigrate != null) {
                this.log.warn("flyway.initOnMigrate is deprecated. Use baselineOnMigrate instead. Will be removed in Flyway 4.0.");
                this.flyway.setBaselineOnMigrate(this.initOnMigrate.booleanValue());
            }
            this.flyway.setBaselineOnMigrate(this.baselineOnMigrate);
            this.flyway.setValidateOnMigrate(this.validateOnMigrate);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.mavenProject.getProperties());
            if (this.driver != null) {
                properties.setProperty("flyway.driver", this.driver);
            }
            if (this.url != null) {
                properties.setProperty("flyway.url", this.url);
            }
            if (this.user != null) {
                properties.setProperty("flyway.user", this.user);
            }
            if (this.password != null) {
                properties.setProperty("flyway.password", this.password);
            }
            for (String placeholer : this.placeholders.keySet()) {
                String value = this.placeholders.get(placeholer);
                properties.setProperty(PLACEHOLDERS_PROPERTY_PREFIX + placeholer, value == null ? "" : value);
            }
            properties.putAll((Map<?, ?>)this.getConfigFileProperties());
            properties.putAll((Map<?, ?>)System.getProperties());
            this.flyway.configure(properties);
            this.doExecute(this.flyway);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), ExceptionUtils.getRootCause((Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Properties getConfigFileProperties() throws IOException {
        Properties properties;
        block6: {
            properties = new Properties();
            String configFileProp = System.getProperty("flyway.configFile");
            if (configFileProp != null) {
                this.configFile = new File(configFileProp);
                if (!this.configFile.isAbsolute()) {
                    this.configFile = new File(this.mavenProject.getBasedir(), configFileProp);
                }
            }
            if (this.configFile == null) {
                File file = new File(this.mavenProject.getBasedir(), "flyway.properties");
                if (file.isFile() && file.canRead()) {
                    this.configFile = file;
                    break block6;
                } else {
                    this.log.debug("flyway.properties not found. Skipping.");
                    return properties;
                }
            }
            if (!this.configFile.canRead() || !this.configFile.isFile()) {
                throw new FlywayException("Unable to read config file: " + this.configFile.getAbsolutePath());
            }
        }
        properties.load(new InputStreamReader((InputStream)new FileInputStream(this.configFile), this.encoding));
        return properties;
    }

    protected String getProperty(String name) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        return this.mavenProject.getProperties().getProperty(name);
    }

    protected abstract void doExecute(Flyway var1) throws Exception;
}

