/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.gradle.task;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.UrlUtils;
import org.flywaydb.gradle.FlywayExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

abstract class AbstractFlywayTask
extends DefaultTask {
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    protected FlywayExtension extension;
    public String driver;
    public String url;
    public String user;
    public String password;
    public String table;
    public String[] schemas;
    public String baselineVersion;
    public String baselineDescription;
    public String[] locations;
    public String[] resolvers;
    public Boolean skipDefaultResolvers;
    public String sqlMigrationPrefix;
    public String repeatableSqlMigrationPrefix;
    public String sqlMigrationSeparator;
    public String sqlMigrationSuffix;
    public String encoding;
    public Map<Object, Object> placeholders;
    public Boolean placeholderReplacement;
    public String placeholderPrefix;
    public String placeholderSuffix;
    public String target;
    public String[] callbacks;
    public Boolean skipDefaultCallbacks;
    public Boolean outOfOrder;
    public Boolean validateOnMigrate;
    public Boolean cleanOnValidationError;
    public Boolean ignoreMissingMigrations;
    public Boolean ignoreFutureMigrations;
    public Boolean cleanDisabled;
    public Boolean baselineOnMigrate;
    public Boolean allowMixedMigrations;
    public String installedBy;

    public AbstractFlywayTask() {
        this.setGroup("Flyway");
        this.extension = (FlywayExtension)this.getProject().getExtensions().getByName("flyway");
    }

    @TaskAction
    public Object runTask() {
        try {
            if (this.isJavaProject()) {
                JavaPluginConvention plugin = (JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class);
                for (SourceSet sourceSet : plugin.getSourceSets()) {
                    URL classesUrl = sourceSet.getOutput().getClassesDir().toURI().toURL();
                    this.getLogger().debug("Adding directory to Classpath: " + classesUrl);
                    ClassUtils.addJarOrDirectoryToClasspath((String)UrlUtils.toFilePath((URL)classesUrl));
                    URL resourcesUrl = sourceSet.getOutput().getResourcesDir().toURI().toURL();
                    this.getLogger().debug("Adding directory to Classpath: " + resourcesUrl);
                    ClassUtils.addJarOrDirectoryToClasspath((String)UrlUtils.toFilePath((URL)resourcesUrl));
                }
                for (ResolvedArtifact artifact : this.getProject().getConfigurations().getByName("testRuntime").getResolvedConfiguration().getResolvedArtifacts()) {
                    URL artifactUrl = artifact.getFile().toURI().toURL();
                    this.getLogger().debug("Adding Dependency to Classpath: " + artifactUrl);
                    ClassUtils.addJarOrDirectoryToClasspath((String)UrlUtils.toFilePath((URL)artifactUrl));
                }
            }
            return this.run(this.createFlyway());
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected abstract Object run(Flyway var1);

    private Flyway createFlyway() {
        HashMap<String, String> conf = new HashMap<String, String>();
        this.putIfSet(conf, "driver", this.driver, this.extension.driver);
        this.putIfSet(conf, "url", this.url, this.extension.url);
        this.putIfSet(conf, "user", this.user, this.extension.user);
        this.putIfSet(conf, "password", this.password, this.extension.password);
        this.putIfSet(conf, "table", this.table, this.extension.table);
        this.putIfSet(conf, "baselineVersion", this.baselineVersion, this.extension.baselineVersion);
        this.putIfSet(conf, "baselineDescription", this.baselineDescription, this.extension.baselineDescription);
        this.putIfSet(conf, "sqlMigrationPrefix", this.sqlMigrationPrefix, this.extension.sqlMigrationPrefix);
        this.putIfSet(conf, "repeatableSqlMigrationPrefix", this.repeatableSqlMigrationPrefix, this.extension.repeatableSqlMigrationPrefix);
        this.putIfSet(conf, "sqlMigrationSeparator", this.sqlMigrationSeparator, this.extension.sqlMigrationSeparator);
        this.putIfSet(conf, "sqlMigrationSuffix", this.sqlMigrationSuffix, this.extension.sqlMigrationSuffix);
        this.putIfSet(conf, "allowMixedMigrations", this.allowMixedMigrations, this.extension.allowMixedMigrations);
        this.putIfSet(conf, "installedBy", this.installedBy, this.extension.installedBy);
        this.putIfSet(conf, "encoding", this.encoding, this.extension.encoding);
        this.putIfSet(conf, "placeholderReplacement", this.placeholderReplacement, this.extension.placeholderReplacement);
        this.putIfSet(conf, "placeholderPrefix", this.placeholderPrefix, this.extension.placeholderPrefix);
        this.putIfSet(conf, "placeholderSuffix", this.placeholderSuffix, this.extension.placeholderSuffix);
        this.putIfSet(conf, "target", this.target, this.extension.target);
        this.putIfSet(conf, "outOfOrder", this.outOfOrder, this.extension.outOfOrder);
        this.putIfSet(conf, "validateOnMigrate", this.validateOnMigrate, this.extension.validateOnMigrate);
        this.putIfSet(conf, "cleanOnValidationError", this.cleanOnValidationError, this.extension.cleanOnValidationError);
        this.putIfSet(conf, "ignoreMissingMigrations", this.ignoreMissingMigrations, this.extension.ignoreMissingMigrations);
        this.putIfSet(conf, "ignoreFutureMigrations", this.ignoreFutureMigrations, this.extension.ignoreFutureMigrations);
        this.putIfSet(conf, "cleanDisabled", this.cleanDisabled, this.extension.cleanDisabled);
        this.putIfSet(conf, "baselineOnMigrate", this.baselineOnMigrate, this.extension.baselineOnMigrate);
        this.putIfSet(conf, "skipDefaultResolvers", this.skipDefaultResolvers, this.extension.skipDefaultResolvers);
        this.putIfSet(conf, "skipDefaultCallbacks", this.skipDefaultCallbacks, this.extension.skipDefaultCallbacks);
        this.putIfSet(conf, "schemas", StringUtils.arrayToCommaDelimitedString((Object[])this.schemas), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.schemas));
        conf.put("flyway.locations", "filesystem:" + this.getProject().getProjectDir().getAbsolutePath() + "/src/main/resources/db/migration");
        this.putIfSet(conf, "locations", StringUtils.arrayToCommaDelimitedString((Object[])this.locations), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.locations));
        this.putIfSet(conf, "resolvers", StringUtils.arrayToCommaDelimitedString((Object[])this.resolvers), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.resolvers));
        this.putIfSet(conf, "callbacks", StringUtils.arrayToCommaDelimitedString((Object[])this.callbacks), StringUtils.arrayToCommaDelimitedString((Object[])this.extension.callbacks));
        if (this.placeholders != null) {
            for (Map.Entry<Object, Object> entry : this.placeholders.entrySet()) {
                conf.put(PLACEHOLDERS_PROPERTY_PREFIX + entry.getKey().toString(), entry.getValue().toString());
            }
        }
        if (this.extension.placeholders != null) {
            for (Map.Entry<Object, Object> entry : this.extension.placeholders.entrySet()) {
                conf.put(PLACEHOLDERS_PROPERTY_PREFIX + entry.getKey().toString(), entry.getValue().toString());
            }
        }
        AbstractFlywayTask.addConfigFromProperties(conf, this.getProject().getProperties());
        AbstractFlywayTask.addConfigFromProperties(conf, System.getProperties());
        Flyway flyway = new Flyway();
        flyway.configure(conf);
        return flyway;
    }

    private static void addConfigFromProperties(Map<String, String> config, Properties properties) {
        for (String prop : properties.stringPropertyNames()) {
            if (!prop.startsWith("flyway.")) continue;
            config.put(prop, properties.getProperty(prop));
        }
    }

    private static void addConfigFromProperties(Map<String, String> config, Map<String, ?> properties) {
        for (String prop : properties.keySet()) {
            if (!prop.startsWith("flyway.")) continue;
            config.put(prop, properties.get(prop).toString());
        }
    }

    private void handleException(Throwable throwable) {
        String message = "Error occurred while executing " + this.getName();
        throw new FlywayException(this.collectMessages(throwable, message), throwable);
    }

    private String collectMessages(Throwable throwable, String message) {
        if (throwable != null) {
            message = message + "\n" + throwable.getMessage();
            return this.collectMessages(throwable.getCause(), message);
        }
        return message;
    }

    private void putIfSet(Map<String, String> config, String key, Object propValue, Object extensionValue) {
        if (propValue != null) {
            config.put("flyway." + key, propValue.toString());
        } else if (extensionValue != null) {
            config.put("flyway." + key, extensionValue.toString());
        }
    }

    private boolean isJavaProject() {
        return this.getProject().getPluginManager().hasPlugin("java");
    }
}

