/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.spanner;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.util.DataUnits;
import org.flywaydb.database.spanner.SpannerConnection;

public class SpannerDatabase
extends Database<SpannerConnection> {
    private static final Log LOG = LogFactory.getLog(SpannerDatabase.class);
    private static final long TEN_GB_DATABASE_SIZE_LIMIT = DataUnits.GIGABYTE.toBytes(10L);
    private static final long NINE_GB_DATABASE_SIZE = DataUnits.GIGABYTE.toBytes(9L);
    String statsTableName = "spanner_sys.table_sizes_stats_1hour";

    public SpannerDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected SpannerConnection doGetConnection(Connection connection) {
        return new SpannerConnection(this, connection);
    }

    public final void ensureSupported(Configuration configuration) {
        if (!LicenseGuard.isLicensed((Configuration)configuration, (List)Tier.PREMIUM)) {
            long databaseSize = this.getDatabaseSize();
            if (databaseSize > TEN_GB_DATABASE_SIZE_LIMIT) {
                throw new FlywayTeamsUpgradeRequiredException("A GCP Spanner database that exceeds the 10 GB database size limit (Calculated size: " + DataUnits.GIGABYTE.toHumanReadableString(databaseSize) + ")");
            }
            String usageLimitMessage = "GCP Spanner databases have a 10 GB database size limit in " + Tier.COMMUNITY.getDisplayName() + ".\nYou have used " + DataUnits.GIGABYTE.toHumanReadableString(databaseSize) + " / 10 GB\nConsider upgrading to " + Tier.ENTERPRISE.getDisplayName() + " for unlimited usage: https://rd.gt/2ZvELhV";
            if (databaseSize >= NINE_GB_DATABASE_SIZE) {
                LOG.warn(usageLimitMessage);
            } else {
                LOG.info(usageLimitMessage);
            }
        }
    }

    long getDatabaseSize() {
        long totalDatabaseSize = 0L;
        try {
            totalDatabaseSize += this.jdbcTemplate.queryForLong("SELECT SUM(USED_BYTES) FROM " + this.statsTableName + " WHERE INTERVAL_END = (SELECT MAX(INTERVAL_END) FROM " + this.statsTableName + ")", new String[0]);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return totalDatabaseSize;
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    Connection getNewRawConnection() {
        return this.jdbcConnectionFactory.openConnection();
    }

    public String getBooleanTrue() {
        return "true";
    }

    public String getBooleanFalse() {
        return "false";
    }

    public String getOpenQuote() {
        return "`";
    }

    public String getCloseQuote() {
        return "`";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean useSingleConnection() {
        return false;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table.getName() + " (\n    installed_rank INT64 NOT NULL,\n    version STRING(50),\n    description STRING(200) NOT NULL,\n    type STRING(20) NOT NULL,\n    script STRING(1000) NOT NULL,\n    checksum INT64,\n    installed_by STRING(100) NOT NULL,\n    installed_on TIMESTAMP NOT NULL OPTIONS (allow_commit_timestamp=true),\n    execution_time INT64 NOT NULL,\n    success BOOL NOT NULL\n) PRIMARY KEY (installed_rank DESC);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX " + table.getName() + "_s_idx ON " + table.getName() + " (success);";
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, PENDING_COMMIT_TIMESTAMP(), ?, ?)";
    }

    public void setStatsTableName(String statsTableName) {
        this.statsTableName = statsTableName;
    }
}

