/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.bigquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;

public class BigQueryParser
extends Parser {
    private static final String ALTERNATIVE_SINGLE_LINE_COMMENT = "#";
    private static final String TRIPLE_STRING_LITERAL_SINGLE_QUOTE = "'''";
    private static final String TRIPLE_STRING_LITERAL_DOUBLE_QUOTE = "\"\"\"";

    public BigQueryParser(Configuration configuration, ParsingContext parsingContext) {
        super(configuration, parsingContext, 3);
    }

    protected Set<String> getValidKeywords() {
        return new HashSet<String>(Arrays.asList("ALL", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERT_ROWS_MODIFIED", "AT", "BEGIN", "BETWEEN", "BY", "CASE", "CAST", "COLLATE", "CONTAINS", "CREATE", "CROSS", "CUBE", "CURRENT", "DEFAULT", "DEFINE", "DESC", "DISTINCT", "ELSE", "END", "ENUM", "ESCAPE", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FOLLOWING", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "GROUPS", "HASH", "HAVING", "IF", "IGNORE", "IN", "INNER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LIMIT", "LOOKUP", "LOOP", "MERGE", "NATURAL", "NEW", "NO", "NOT", "NULL", "NULLS", "OF", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECEDING", "PROTO", "RANGE", "RECURSIVE", "RESPECT", "RIGHT", "ROLLUP", "ROWS", "SELECT", "SET", "SOME", "STRUCT", "TABLESAMPLE", "THEN", "TO", "TRANSACTION", "TREAT", "TRUE", "UNBOUNDED", "UNION", "UNNEST", "USING", "WHEN", "WHERE", "WHILE", "WINDOW", "WITH", "WITHIN"));
    }

    protected char getIdentifierQuote() {
        return '`';
    }

    protected char getAlternativeStringLiteralQuote() {
        return '\"';
    }

    protected boolean isSingleLineComment(String peek, ParserContext context, int col) {
        return super.isSingleLineComment(peek, context, col) || peek.startsWith(ALTERNATIVE_SINGLE_LINE_COMMENT);
    }

    protected Boolean detectCanExecuteInTransaction(String simplifiedStatement, List<Token> keywords) {
        return false;
    }

    protected Token handleStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        this.handleAmbiguityStringLiteral(reader, '\'', TRIPLE_STRING_LITERAL_SINGLE_QUOTE);
        return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
    }

    protected Token handleAlternativeStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        this.handleAmbiguityStringLiteral(reader, '\"', TRIPLE_STRING_LITERAL_DOUBLE_QUOTE);
        return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
    }

    private void handleAmbiguityStringLiteral(PeekingReader reader, char singleQuote, String tripleQuote) throws IOException {
        if (reader.peek(tripleQuote)) {
            reader.swallow(tripleQuote.length());
            reader.swallowUntilExcluding(tripleQuote);
            reader.swallow(tripleQuote.length());
        } else {
            reader.swallow();
            reader.swallowUntilIncludingWithEscape(singleQuote, false, '\\');
        }
    }

    protected boolean shouldAdjustBlockDepth(ParserContext context, List<Token> tokens, Token token) {
        TokenType tokenType = token.getType();
        if (TokenType.EOF.equals((Object)tokenType) || TokenType.DELIMITER.equals((Object)tokenType) || ";".equals(token.getText())) {
            return true;
        }
        Token lastToken = BigQueryParser.getPreviousToken(tokens, (int)context.getParensDepth());
        if (lastToken != null && lastToken.getType() == TokenType.KEYWORD) {
            return true;
        }
        return super.shouldAdjustBlockDepth(context, tokens, token);
    }

    protected void adjustBlockDepth(ParserContext context, List<Token> tokens, Token keyword, PeekingReader reader) {
        String keywordText = keyword.getText();
        int parensDepth = keyword.getParensDepth();
        if ("BEGIN".equalsIgnoreCase(keywordText)) {
            context.increaseBlockDepth(keywordText);
        }
        if (BigQueryParser.lastTokenIs(tokens, (int)parensDepth, (String)"BEGIN") && ("TRANSACTION".equalsIgnoreCase(keywordText) || ";".equalsIgnoreCase(keywordText)) && context.getBlockDepth() > 0) {
            context.decreaseBlockDepth();
        }
        if (!(!BigQueryParser.lastTokenIs(tokens, (int)parensDepth, (String)"END") || "IF".equalsIgnoreCase(keywordText) || "WHILE".equalsIgnoreCase(keywordText) || "LOOP".equalsIgnoreCase(keywordText) || "AS".equalsIgnoreCase(keywordText) || context.getBlockDepth() <= 0)) {
            context.decreaseBlockDepth();
        }
    }
}

